/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.views.internal.DrawStrategy;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Rectangle;

public abstract class StdDrawStrategy
implements DrawStrategy,
KeyListener,
MouseListener,
MouseMoveListener,
DisposeListener {
    protected float fWidth = 0.0f;
    protected float fHeight = 0.0f;
    protected boolean _mousePressed = false;
    protected float _origx;
    protected float _origy;
    protected float _lastx;
    protected float _lasty;
    protected boolean _controlDown = false;
    protected boolean _shiftDown = false;
    protected boolean _dragScrolling = false;
    protected JCanvas _canvas;
    private boolean _dirty = true;
    protected boolean _nonpropzoom = false;

    protected void constrainAspect() {
        Rectangle visible = this._canvas.getSize();
        float dx = this._origx - this._lastx;
        float dy = this._origy - this._lasty;
        float scalingRatio = this._canvas.xscale() / this._canvas.yscale();
        float aspect = (float)visible.width / (float)visible.height / scalingRatio;
        if (Math.abs(dx / dy) < aspect) {
            dx = dx < 0.0f ? -Math.abs(dy) * aspect : Math.abs(dy) * aspect;
        } else {
            dy = dy < 0.0f ? -Math.abs(dx) / aspect : Math.abs(dx) / aspect;
        }
        this._lastx = this._origx - dx;
        this._lasty = this._origy - dy;
    }

    protected boolean dragZoomed() {
        return Math.abs(this._lastx - this._origx) * this._canvas.xscale() > 6.0f || Math.abs(this._lasty - this._origy) * this._canvas.yscale() > 6.0f;
    }

    protected void drawZoomRect() {
        this._canvas.drawRectXor(Math.min(this._origx, this._lastx), Math.min(this._origy, this._lasty), Math.abs(this._origx - this._lastx), Math.abs(this._origy - this._lasty));
    }

    public abstract void fillContextMenu(IMenuManager var1);

    public float getHeight() {
        return this.fHeight;
    }

    public float getWidth() {
        return this.fWidth;
    }

    public synchronized boolean isDirty() {
        return this._dirty;
    }

    public synchronized boolean isDirtyAndReset() {
        boolean currentstate = this._dirty;
        this._dirty = false;
        return currentstate;
    }

    public boolean isNonPropZoom() {
        return this._nonpropzoom;
    }

    public JCanvas jcanvas() {
        return this._canvas;
    }

    public void jcanvas(JCanvas c) {
        if (c != this._canvas) {
            if (this._canvas != null) {
                this._canvas.canvas().removeDisposeListener((DisposeListener)this);
            }
            this._canvas = c;
            if (this._canvas != null) {
                this._canvas.canvas().addDisposeListener((DisposeListener)this);
                this.resetArea();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 262144) {
            this._controlDown = true;
        } else if (e.keyCode == 131072) {
            this._shiftDown = true;
        } else if (e.keyCode == 0x1000007) {
            JCanvas canvas = this.jcanvas();
            if (canvas == null) {
                return;
            }
            canvas.home();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 262144) {
            this._controlDown = false;
        } else if (e.keyCode == 131072) {
            this._shiftDown = false;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public float left() {
        return 0.0f;
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent e) {
        if (this._canvas.isZoom()) {
            this._canvas.zoom(e.x, e.y);
            return;
        }
        if (this._dragScrolling || this._mousePressed) {
            return;
        }
        if (this._controlDown) {
            this._dragScrolling = true;
            this._lastx = e.x;
            this._lasty = e.y;
        } else {
            this._mousePressed = true;
            this._origx = this._lastx = this._canvas.normX(e.x);
            this._origy = this._lasty = this._canvas.normY(e.y);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this._canvas == null) {
            return;
        }
        float newx = this._canvas.normX(e.x);
        float newy = this._canvas.normY(e.y);
        if (this._mousePressed) {
            if (this._dragScrolling) {
                int dx = (int)this._lastx - e.x;
                int dy = (int)this._lasty - e.y;
                this._lastx = e.x;
                this._lasty = e.y;
                this._canvas.scrollBy(dx, dy);
                this._canvas.redraw();
            } else {
                this.drawZoomRect();
                this._lastx = newx;
                this._lasty = newy;
                if (!this._nonpropzoom) {
                    this.constrainAspect();
                }
                this.drawZoomRect();
            }
        } else {
            float nx = this._canvas.normX(e.x);
            float ny = this._canvas.normY(e.y);
            this.moved(nx, ny);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this._canvas.isZoom()) {
            return;
        }
        if (this._dragScrolling) {
            this._dragScrolling = false;
        } else if (this._mousePressed) {
            this._mousePressed = false;
            this.drawZoomRect();
            this._lastx = this._canvas.normX(e.x);
            this._lasty = this._canvas.normY(e.y);
            if (this.dragZoomed()) {
                if (!this._nonpropzoom) {
                    this.constrainAspect();
                }
                float x = Math.min(this._origx, this._lastx);
                float y = Math.min(this._origy, this._lasty);
                float w = Math.abs(this._origx - this._lastx);
                float h = Math.abs(this._origy - this._lasty);
                this._canvas.zoomRect(x, y, w, h);
                this._canvas.redraw();
            } else {
                this.selected(this._lastx, this._lasty, this._shiftDown, this._controlDown, false);
                this._canvas.redraw();
            }
        }
    }

    public void resetArea() {
        JCanvas canvas = this.jcanvas();
        if (canvas == null) {
            return;
        }
        canvas.left(this.left());
        canvas.top(this.top());
        canvas.setArea(this.width(), this.height());
    }

    public synchronized void setDirty() {
        this._dirty = true;
    }

    public void setHeight(float height) {
        this.fHeight = height;
    }

    public void setNonPropZoom(boolean nonpropzoom) {
        this._nonpropzoom = nonpropzoom;
    }

    public void setWidth(float width) {
        this.fWidth = width;
    }

    public float top() {
        return 0.0f;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._canvas != null && e.widget == this._canvas.canvas()) {
            this._canvas.dispose();
        }
        this._canvas = null;
    }
}

