/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;

public class LinearPattern {
    private ArrayList _repet;
    private ArrayList _length = new ArrayList();
    private ArrayList _series;

    public LinearPattern() {
        this._repet = new ArrayList();
        this._series = new ArrayList();
    }

    public void add(Object a) {
        this._series.add(a);
        this._length.add(new Integer(1));
        this._repet.add(new Integer(1));
    }

    public void compute() {
        int start = 0;
        boolean cursym = false;
        int cnt = this.size();
        block0: for (int curpos = 1; curpos < cnt; ++curpos) {
            for (int samestart = start; samestart < curpos; ++samestart) {
                int len = curpos - samestart;
                if (!this.wordCompare(curpos, samestart, len) || !this.wordCompare(curpos, curpos + len, len)) continue;
                int oldrepet = (Integer)this._repet.get(samestart);
                this._repet.set(samestart, new Integer(oldrepet + 1));
                this._length.set(samestart, new Integer(len));
                start = curpos += len;
                while (this.wordCompare(samestart, start, len)) {
                    oldrepet = (Integer)this._repet.get(samestart);
                    this._repet.set(samestart, new Integer(oldrepet + 1));
                    start = curpos += len;
                }
                for (int i = samestart + 1; i < start; ++i) {
                    this._repet.set(i, new Integer(0));
                    this._length.set(i, new Integer(0));
                }
                continue block0;
            }
        }
    }

    public boolean hasRepetition() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if ((Integer)this._repet.get(i) <= 1) continue;
            return true;
        }
        return false;
    }

    public int length(int position) {
        return (Integer)this._length.get(position);
    }

    public int repetition(int position) {
        return (Integer)this._repet.get(position);
    }

    public int size() {
        return this._series.size();
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("[ i, element, length, repetition \n");
        for (int i = 0; i <= max; ++i) {
            String s = this._series.get(i).toString();
            buf.append(i + " ");
            buf.append(s);
            buf.append(", ");
            buf.append(Integer.toString(this.length(i)));
            buf.append(", ");
            buf.append(Integer.toString(this.repetition(i)));
            if (i < max) {
                buf.append(", ");
            }
            buf.append("\n");
        }
        buf.append("]");
        return buf.toString();
    }

    protected boolean wordCompare(int pos1, int pos2, int length) {
        if (pos1 < 0 || pos2 < 0 || length < 0) {
            return false;
        }
        if (pos1 + length > this.size() || pos2 + length > this.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this._series.get(pos1 + i).equals(this._series.get(pos2 + i))) continue;
            return false;
        }
        return true;
    }
}

