/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ColumnPrinter;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTable;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTableEditorListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ExportTimeDialog;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableEditor;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableEditorListener;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphCanvas;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorLineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.MessagePanel;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.ReferenceLineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.ThicknessHighlighter;
import org.eclipse.hyades.statistical.ui.widgets.spinner.internal.DateDialog;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarsCollection;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class GraphWindow
extends Composite
implements PaintListener,
GraphTableEditorListener,
ControlTableEditorListener,
SelectionListener {
    public static final int TAB_GRAPHS = 0;
    public static final int TAB_CONTROLS = 1;
    public static final int TAB_LOG = 2;
    private static final boolean RIGHT_DRAG_RELEASES_BUTTON = false;
    public static final double YSLIDER_DEFMAX = 1.0E8;
    public static final double YSLIDER_DEFMIN = -1.0E8;
    private static final int XSLIDER_HEIGHT = 35;
    private static final int YSLIDER_WIDTH = 50;
    ArrayList disposables = new ArrayList();
    SashForm sash;
    Composite topsash;
    Composite bottomsash;
    Composite graph_panel;
    Composite nw_panel;
    GraphCanvas ne_panel;
    Composite sw_panel;
    Composite se_panel;
    ReferenceLineGraph ref_min_graph;
    ReferenceLineGraph ref_maj_graph;
    IndicatorLineGraph indicator_graph;
    boolean ref_min_on = true;
    boolean ref_maj_on = true;
    boolean sliders_match_graph = false;
    Composite modify_panel;
    Button add_vert;
    Button del_vert;
    Button add_horz;
    Button del_horz;
    TabFolder config_panel;
    TabItem config_tab;
    GraphTableEditor config_editor;
    TabItem control_tab;
    ControlTable control_editor;
    TabItem cbe_tab;
    MessagePanel cbe_text;
    ArrayList colours = new ArrayList();
    ArrayList ysliders = new ArrayList();
    ArrayList xsliders = new ArrayList();
    HashMap button_map = new HashMap();
    HashMap menu_map = new HashMap();
    GraphPopupListener graph_popup;
    final int GRAPH_COLUMNS = 10;
    Object[][] graph_values = new Object[0][10];
    final int CONTROL_COLUMNS = 7;
    Object[][] control_values = new Object[0][7];
    boolean constant_update = false;
    long constant_update_ms = 1000L;
    UpdateThread update_thread = null;
    ArrayList update_runnables = new ArrayList();
    Dirtiable dirtiable = null;
    protected ArrayList hslider_actions = new ArrayList();
    protected ArrayList vslider_actions = new ArrayList();
    ZoomSlider selected_slider;
    double selected_slider_value;

    public static void disposeObject(Object o) throws Throwable {
        Throwable error = null;
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            try {
                Method o_dispose = c.getDeclaredMethod("dispose", new Class[0]);
                o_dispose.setAccessible(true);
                o_dispose.invoke(o, new Object[0]);
                error = null;
                break;
            }
            catch (Throwable e) {
                EditorPlugin.DBG.warning("failed to dispose object " + o.getClass() + " / " + o);
                error = e;
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public void addUpdateRunnable(Runnable r) {
        this.update_runnables.add(r);
    }

    public void removeUpdateRunnables(Runnable r) {
        this.update_runnables.remove(r);
    }

    public void showTab(int t) {
        this.config_panel.setSelection(t);
    }

    public void setCBEText(String txt) {
        this.cbe_text.setMsgText(txt);
    }

    public void appendCBEText(String txt) {
        this.cbe_text.appendMsgText(txt);
    }

    public boolean getSlidersMatchGraph() {
        return this.sliders_match_graph;
    }

    public void setSlidersMatchGraph(boolean b) {
        this.sliders_match_graph = b;
        this.updateSliderColors();
        this.setDirty(true);
    }

    private void updateSliderColors() {
        if (this.sliders_match_graph) {
            ZoomSlider slider;
            int i;
            Color newcolor = this.ne_panel.getBackground();
            RGB rgb = newcolor.getRGB();
            int r = rgb.red;
            int g = rgb.green;
            int b = rgb.blue;
            int avg = (r + g + b) / 3;
            RGB slidercol = new RGB(avg > 100 ? 0 : 255, avg > 100 ? 0 : 255, avg > 100 ? 0 : 255);
            Color tmp = ((ZoomSlider)((Object)this.ysliders.get(0))).getForeground();
            Color newslidercolor = new Color((Device)this.getDisplay(), slidercol);
            this.disposables.add(newslidercolor);
            if (this.disposables.remove(tmp)) {
                tmp.dispose();
            }
            for (i = 0; i < this.xsliders.size(); ++i) {
                slider = (ZoomSlider)((Object)this.xsliders.get(i));
                slider.setBackground(newcolor);
                slider.setForeground(newslidercolor);
                slider.setTitleColor(newslidercolor);
                slider.updateScale();
            }
            for (i = 0; i < this.ysliders.size(); ++i) {
                slider = (ZoomSlider)((Object)this.ysliders.get(i));
                slider.setBackground(newcolor);
                slider.setForeground(newslidercolor);
                slider.setTitleColor(newslidercolor);
                slider.updateScale();
            }
            this.sw_panel.setBackground(newcolor);
        } else {
            ZoomSlider slider;
            int i;
            Color newcolor = this.getDisplay().getSystemColor(22);
            Color newslidercolor = this.getDisplay().getSystemColor(21);
            for (i = 0; i < this.xsliders.size(); ++i) {
                slider = (ZoomSlider)((Object)this.xsliders.get(i));
                slider.setBackground(newcolor);
                slider.setForeground(newslidercolor);
                slider.setTitleColor(newslidercolor);
                slider.updateScale();
            }
            for (i = 0; i < this.ysliders.size(); ++i) {
                slider = (ZoomSlider)((Object)this.ysliders.get(i));
                slider.setBackground(newcolor);
                slider.setForeground(newslidercolor);
                slider.setTitleColor(newslidercolor);
                slider.updateScale();
            }
            this.sw_panel.setBackground(newcolor);
        }
    }

    public void setConstantUpdate(boolean on) {
        this.setConstantUpdate(on, this.constant_update_ms);
    }

    public void setConstantUpdate(boolean on, long ms_refresh) {
        EditorPlugin.DBG.info("set constant update " + on + " / " + ms_refresh + "ms");
        if (ms_refresh < 500L) {
            ms_refresh = 500L;
        }
        this.constant_update_ms = ms_refresh;
        EditorPlugin.DBG.info("actual constant update " + on + " / " + ms_refresh + "ms");
        if (on && !this.constant_update) {
            this.constant_update = true;
            this.update_thread = new UpdateThread();
            this.update_thread.start();
        } else if (!on && this.constant_update) {
            this.constant_update = false;
        }
    }

    public void jumpToNow() {
        for (int i = 0; i < this.xsliders.size(); ++i) {
            this.jumpToNow((TimeZoomSlider)((Object)this.xsliders.get(i)));
        }
    }

    public void jumpToNow(TimeZoomSlider slider) {
        this.indicator_graph.setIndicatorLocation(Double.MAX_VALUE);
        double t = System.currentTimeMillis();
        if (t <= slider.getMaxLimit()) {
            try {
                slider.configure(slider.getMinLimit(), slider.getMaxLimit() + 7200000.0, slider.getMinVisible(), slider.getMaxVisible(), slider.getResolution());
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (t <= slider.getMaxLimit()) {
            double diff = t - slider.getMaxVisible();
            try {
                slider.configure(slider.getMinLimit(), slider.getMaxLimit(), slider.getMinVisible() + diff, slider.getMaxVisible() + diff, slider.getResolution());
                this.setDirty(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void setDirty(boolean b) {
        if (this.dirtiable != null) {
            this.dirtiable.setDirty(b);
        }
    }

    public GraphWindow(Composite parent, int style, Dirtiable d) {
        super(parent, style);
        this.dirtiable = d;
        this.initGraphics();
    }

    public GraphWindow(Composite parent, int style) {
        super(parent, style);
        this.initGraphics();
    }

    public Graph getIndicatorLineGraph() {
        return this.indicator_graph;
    }

    public Graph getMinorReferenceLineGraph() {
        return this.ref_min_graph;
    }

    public Graph getMajorReferenceLineGraph() {
        return this.ref_maj_graph;
    }

    public void updateSliders() {
        ZoomSlider slider;
        int i;
        for (i = 0; i < this.ysliders.size(); ++i) {
            slider = (ZoomSlider)((Object)this.ysliders.get(i));
            slider.updateScale();
        }
        for (i = 0; i < this.xsliders.size(); ++i) {
            slider = (ZoomSlider)((Object)this.xsliders.get(i));
            slider.updateScale();
        }
    }

    public void updateTables() {
        this.updateGraphTable();
        this.updateControlTable();
    }

    public void updateGraphs() {
        this.ne_panel.redraw();
    }

    public void updateGraphTable() {
        Object[][] tmp = this.graph_values;
        for (int i = 0; i < tmp.length; ++i) {
            Graph g = (Graph)tmp[i][0];
            tmp[i][3] = g.getForeground().getRGB();
            tmp[i][4] = new Integer(g.getLineWidth());
            tmp[i][5] = new Integer(g.getLineStyle());
            tmp[i][6] = new Integer(this.xsliders.indexOf((Object)g.getXSlider()));
            tmp[i][7] = new Integer(this.ysliders.indexOf((Object)g.getYSlider()));
            tmp[i][8] = new Double(g.getStaticScaling());
        }
        this.config_editor.setValues(this.graph_values);
    }

    public void updateControlTable() {
        Object[][] tmp = this.control_values;
        for (int i = 0; i < tmp.length; ++i) {
            ZoomControlBar bar = (ZoomControlBar)tmp[i][0];
            if (bar == null) continue;
            tmp[i][4] = new Integer(this.ysliders.indexOf((Object)bar.getZoomSlider()));
        }
        this.rebuildSliderChoices();
        this.control_editor.setControlValues(this.control_values);
    }

    public void addGraph(String name, String description, Graph g, SDDescriptor descriptor) {
        try {
            if (name == null) {
                name = "none";
            }
            if (description == null) {
                description = "none";
            }
            g.setIndicatorSource(this.indicator_graph);
            int len = this.graph_values.length + 1;
            int index = this.graph_values.length;
            Object[][] tmp = new Object[len][10];
            for (int i = 0; i < this.graph_values.length; ++i) {
                tmp[i] = this.graph_values[i];
            }
            tmp[index][0] = g;
            tmp[index][1] = name;
            tmp[index][2] = description;
            tmp[index][3] = g.getForeground().getRGB();
            tmp[index][4] = new Integer(g.getLineWidth());
            tmp[index][5] = new Integer(g.getLineStyle());
            tmp[index][6] = new Integer(this.xsliders.indexOf((Object)g.getXSlider()));
            tmp[index][7] = new Integer(this.ysliders.indexOf((Object)g.getYSlider()));
            tmp[index][8] = new Double(g.getStaticScaling());
            tmp[index][9] = descriptor;
            this.graph_values = tmp;
            this.config_editor.setValues(this.graph_values);
            this.ne_panel.addGraph(g);
            this.ne_panel.redraw();
            this.setDirty(true);
        }
        catch (Throwable t) {
            EditorPlugin.DBG.warning("problem adding control to GraphWindow", t);
        }
    }

    public void addControl(String name, String description, Image image, ZoomControlBar bar, SDModifiableVariableRepresentation rep) {
        try {
            if (name == null) {
                name = "none";
            }
            if (description == null) {
                description = "none";
            }
            int len = this.control_values.length + 1;
            int index = this.control_values.length;
            Object[][] tmp = new Object[len][7];
            for (int i = 0; i < this.control_values.length; ++i) {
                tmp[i] = this.control_values[i];
            }
            tmp[index][0] = bar;
            tmp[index][1] = name;
            tmp[index][2] = description;
            tmp[index][3] = image;
            tmp[index][4] = bar == null ? new Integer(0) : new Integer(this.ysliders.indexOf((Object)bar.getZoomSlider()));
            tmp[index][5] = rep;
            this.control_values = tmp;
            this.rebuildSliderChoices();
            this.control_editor.setControlValues(this.control_values);
            this.setDirty(true);
        }
        catch (Throwable t) {
            EditorPlugin.DBG.warning("problem adding control to GraphWindow", t);
        }
    }

    private int getGraphIndex(Object[][] graph_values, Graph graph) {
        int len = graph_values.length;
        for (int i = 0; i < len; ++i) {
            if (graph_values[i][0] != graph) continue;
            return i;
        }
        return -1;
    }

    private int getControlIndex(Object[][] control_values, ZoomControlBar bar) {
        int len = control_values.length;
        for (int i = 0; i < len; ++i) {
            if (control_values[i][0] != bar) continue;
            return i;
        }
        return -1;
    }

    private int getControlIndex(Object[][] control_values, SDModifiableVariableRepresentation rep) {
        int len = control_values.length;
        for (int i = 0; i < len; ++i) {
            if (control_values[i][5] != rep) continue;
            return i;
        }
        return -1;
    }

    public void removeGraph(Graph graph) {
        int i;
        int index = this.getGraphIndex(this.graph_values, graph);
        if (index == -1) {
            EditorPlugin.DBG.warning("attempt to remove non-existent graph (-1)");
            return;
        }
        if (index >= this.graph_values.length) {
            EditorPlugin.DBG.warning("attempt to remove non-existent graph > array length");
            return;
        }
        Object[][] tmp = new Object[this.graph_values.length - 1][10];
        for (i = 0; i < index; ++i) {
            tmp[i] = this.graph_values[i];
        }
        for (i = index + 1; i < this.graph_values.length; ++i) {
            tmp[i - 1] = this.graph_values[i];
        }
        this.graph_values = tmp;
        this.config_editor.setValues(this.graph_values);
        this.ne_panel.removeGraph(graph);
        this.ne_panel.redraw();
        this.setDirty(true);
    }

    public void removeControl(SDModifiableVariableRepresentation rep) {
        int i;
        int index = this.getControlIndex(this.control_values, rep);
        if (index == -1) {
            EditorPlugin.DBG.warning("attempt to remove non-existent control (-1)");
            return;
        }
        if (index >= this.control_values.length) {
            EditorPlugin.DBG.warning("attempt to remove non-existent control > array length");
            return;
        }
        ZoomControlBar bar = (ZoomControlBar)this.control_values[index][0];
        Object[][] tmp = new Object[this.control_values.length - 1][7];
        for (i = 0; i < index; ++i) {
            tmp[i] = this.control_values[i];
        }
        for (i = index + 1; i < this.control_values.length; ++i) {
            tmp[i - 1] = this.control_values[i];
        }
        this.control_values = tmp;
        this.rebuildSliderChoices();
        this.control_editor.setControlValues(this.control_values);
        if (bar != null) {
            try {
                bar.getZoomSlider().removeZoomControlBar(bar);
            }
            catch (Throwable e) {
                EditorPlugin.DBG.warning("problem removing control", e);
            }
        }
        this.setDirty(true);
    }

    public void removeAllGraphs() {
        this.graph_values = new Object[0][10];
        this.config_editor.setValues(this.graph_values);
        this.ne_panel.removeAllGraphs();
        this.ne_panel.addGraph(this.ref_min_graph);
        this.ne_panel.addGraph(this.ref_maj_graph);
        this.ne_panel.addGraph(this.indicator_graph);
        this.setDirty(true);
    }

    public void setGraphBackground(Color col) {
        if (col != null) {
            this.setGraphBackground(col.getRGB());
        }
    }

    public void setGraphBackground(RGB rgb) {
        if (rgb != null) {
            int r = rgb.red;
            int g = rgb.green;
            int b = rgb.blue;
            int avg = (r + g + b) / 3;
            Color tmp = this.ne_panel.getBackground();
            Color newcolor = new Color((Device)this.getDisplay(), rgb);
            this.disposables.add(newcolor);
            if (this.disposables.remove(tmp)) {
                tmp.dispose();
            }
            this.ne_panel.setBackground(newcolor);
            this.updateSliderColors();
            double contrast = 40.0;
            RGB mincol = new RGB((int)(r > 128 ? (double)r - contrast : (double)r + contrast), (int)(g > 128 ? (double)g - contrast : (double)g + contrast), (int)(b > 128 ? (double)b - contrast : (double)b + contrast));
            contrast = 60.0;
            RGB majcol = new RGB((int)(r > 128 ? (double)r - contrast : (double)r + contrast), (int)(g > 128 ? (double)g - contrast : (double)g + contrast), (int)(b > 128 ? (double)b - contrast : (double)b + contrast));
            RGB indcol = new RGB(avg > 100 ? 0 : 255, avg > 100 ? 0 : 255, avg > 100 ? 0 : 255);
            tmp = this.ref_min_graph.getForeground();
            newcolor = new Color((Device)this.getDisplay(), mincol);
            this.disposables.add(newcolor);
            if (this.disposables.remove(tmp)) {
                tmp.dispose();
            }
            this.ref_min_graph.setForeground(newcolor);
            tmp = this.ref_maj_graph.getForeground();
            newcolor = new Color((Device)this.getDisplay(), majcol);
            this.disposables.add(newcolor);
            if (this.disposables.remove(tmp)) {
                tmp.dispose();
            }
            this.ref_maj_graph.setForeground(newcolor);
            tmp = this.indicator_graph.getForeground();
            newcolor = new Color((Device)this.getDisplay(), indcol);
            this.disposables.add(newcolor);
            if (this.disposables.remove(tmp)) {
                tmp.dispose();
            }
            this.indicator_graph.setForeground(newcolor);
            this.setDirty(true);
        }
    }

    public Color getGraphBackground() {
        return this.ne_panel.getBackground();
    }

    public void setYSlidersBackground(Color col) {
        this.nw_panel.setBackground(col);
        this.setDirty(true);
    }

    public void setXSlidersBackground(Color col) {
        this.se_panel.setBackground(col);
        this.setDirty(true);
    }

    public void setDeadSpaceBackground(Color col) {
        this.sw_panel.setBackground(col);
        this.setDirty(true);
    }

    private Color getColor(int r, int g, int b) {
        Color mycol = new Color((Device)this.getShell().getDisplay(), r, g, b);
        this.colours.add(mycol);
        return mycol;
    }

    private void initGraphics() {
        GridLayout glayout = new GridLayout(1, false);
        GridData gdata = null;
        this.sash = new SashForm((Composite)this, 0);
        this.sash.setOrientation(512);
        this.disposables.add(this.sash);
        gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = true;
        this.sash.setLayoutData((Object)gdata);
        this.topsash = new Group((Composite)this.sash, 0);
        this.bottomsash = new Composite((Composite)this.sash, 0);
        this.disposables.add(this.topsash);
        this.disposables.add(this.bottomsash);
        this.topsash.setLayout((Layout)new FillLayout());
        this.bottomsash.setLayout((Layout)new FillLayout());
        this.graph_panel = new Composite(this.topsash, 0);
        WorkbenchHelp.setHelp((Control)this.graph_panel, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        this.config_panel = new TabFolder(this.bottomsash, 128);
        this.disposables.add(this.graph_panel);
        this.disposables.add(this.config_panel);
        this.sash.setWeights(new int[]{75, 25});
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.setLayout((Layout)glayout);
        this.nw_panel = new Composite(this.graph_panel, 0);
        this.ne_panel = new GraphCanvas(this.graph_panel, 0);
        this.sw_panel = new Composite(this.graph_panel, 0);
        this.se_panel = new Composite(this.graph_panel, 0);
        this.sw_panel.setBackground(this.getDisplay().getSystemColor(22));
        this.graph_popup = new GraphPopupListener(this.ne_panel);
        this.ne_panel.addMouseListener(this.graph_popup);
        this.disposables.add(this.nw_panel);
        this.disposables.add(this.ne_panel);
        this.disposables.add(this.sw_panel);
        this.disposables.add(this.se_panel);
        glayout = new GridLayout(2, false);
        gdata = null;
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.graph_panel.setLayout((Layout)glayout);
        gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = false;
        gdata.grabExcessVerticalSpace = true;
        this.nw_panel.setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = true;
        this.ne_panel.setLayoutData(gdata);
        gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = false;
        gdata.grabExcessVerticalSpace = false;
        gdata.heightHint = 30;
        this.sw_panel.setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        gdata.heightHint = 30;
        this.se_panel.setLayoutData((Object)gdata);
        glayout = new GridLayout(4, false);
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        glayout = new GridLayout(1, false);
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.config_panel.setLayout((Layout)glayout);
        gdata = new GridData();
        gdata.horizontalAlignment = 4;
        gdata.verticalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = true;
        this.config_editor = new GraphTableEditor((Composite)this.config_panel, 0, this.graph_values, (Control)this.ne_panel);
        this.config_editor.setLayoutData(gdata);
        this.config_editor.addListener(this);
        this.config_tab = new TabItem(this.config_panel, 0);
        this.config_tab.setControl((Control)this.config_editor);
        this.config_tab.setText(EditorPlugin.getString("TABLE_NAME_GRAPHS"));
        this.config_tab.setToolTipText(EditorPlugin.getString("GRAPHS_TAB_TOOLTIP"));
        this.ne_panel.setGraphHighlighter(new ThicknessHighlighter());
        this.ne_panel.setGraphSelectionSource(this.config_editor);
        this.disposables.add(this.config_editor);
        this.control_editor = new ControlTable((Composite)this.config_panel);
        this.control_editor.setLayoutData(gdata);
        this.control_editor.addListener(this);
        this.control_tab = new TabItem(this.config_panel, 0);
        this.control_tab.setControl((Control)this.control_editor);
        this.control_tab.setText(EditorPlugin.getString("TABLE_NAME_CONTROLS"));
        this.control_tab.setToolTipText(EditorPlugin.getString("CONTROLS_TAB_TOOLTIP"));
        this.disposables.add(this.control_editor);
        this.cbe_text = new MessagePanel((Composite)this.config_panel, 0);
        this.cbe_tab = new TabItem(this.config_panel, 0);
        this.cbe_tab.setControl((Control)this.cbe_text);
        this.cbe_tab.setText(EditorPlugin.getString("TABLE_NAME_CBELOG"));
        this.cbe_tab.setToolTipText(EditorPlugin.getString("MESSAGES_TAB_TOOLTIP"));
        WorkbenchHelp.setHelp((Control)this.config_editor, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_graphtable"));
        WorkbenchHelp.setHelp((Control)this.control_editor, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_controlstable"));
        WorkbenchHelp.setHelp((Control)this.cbe_text, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_cbelog"));
        this.addXSlider();
        this.addYSlider();
        this.ref_min_graph = new ReferenceLineGraph(this.getXSlider(0), this.getYSlider(0), this.getShell().getDisplay().getSystemColor(15), false);
        this.ref_maj_graph = new ReferenceLineGraph(this.getXSlider(0), this.getYSlider(0), this.getShell().getDisplay().getSystemColor(16), true);
        this.indicator_graph = new IndicatorLineGraph(this.getXSlider(0), this.getYSlider(0), this.getShell().getDisplay().getSystemColor(2));
        this.indicator_graph.setSourceType(1);
        this.ne_panel.addGraph(this.ref_min_graph);
        this.ne_panel.addGraph(this.ref_maj_graph);
        this.ne_panel.addGraph(this.indicator_graph);
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.colours);
        this.disposables.addAll(this.xsliders);
        this.disposables.addAll(this.ysliders);
        this.disposables.addAll(this.menu_map.values());
        EditorPlugin.DBG.info(this.getClass() + ":disposed");
        for (int i = 0; i < this.disposables.size(); ++i) {
            try {
                Object o = this.disposables.get(i);
                if (o == null) continue;
                if (o instanceof Widget) {
                    ((Widget)o).dispose();
                    continue;
                }
                if (o instanceof Color) {
                    ((Color)o).dispose();
                    continue;
                }
                if (o instanceof Image) {
                    ((Image)o).dispose();
                    continue;
                }
                try {
                    GraphWindow.disposeObject(o);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.warning("failed to dispose " + o);
                }
                continue;
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("dispose error ", e);
            }
        }
    }

    public int getXSliderCount() {
        return this.xsliders.size();
    }

    public int getYSliderCount() {
        return this.ysliders.size();
    }

    public ZoomSlider getYSlider(int index) {
        return (ZoomSlider)((Object)this.ysliders.get(index));
    }

    public int getYSlider(ZoomSlider slider) {
        return this.ysliders.indexOf((Object)slider);
    }

    public TimeZoomSlider getXSlider(int index) {
        return (TimeZoomSlider)((Object)this.xsliders.get(index));
    }

    public int getXSlider(TimeZoomSlider slider) {
        return this.xsliders.indexOf((Object)slider);
    }

    public void ensureGraphsAreValid() {
        TimeZoomSlider def_xslider = (TimeZoomSlider)((Object)this.xsliders.get(0));
        ZoomSlider def_yslider = (ZoomSlider)((Object)this.ysliders.get(0));
        if (!this.xsliders.contains((Object)this.ref_min_graph.getXSlider())) {
            this.ref_min_graph.setXSlider(def_xslider);
        }
        if (!this.ysliders.contains((Object)this.ref_min_graph.getYSlider())) {
            this.ref_min_graph.setYSlider(def_yslider);
        }
        if (!this.xsliders.contains((Object)this.ref_maj_graph.getXSlider())) {
            this.ref_maj_graph.setXSlider(def_xslider);
        }
        if (!this.ysliders.contains((Object)this.ref_maj_graph.getYSlider())) {
            this.ref_maj_graph.setYSlider(def_yslider);
        }
        if (!this.xsliders.contains((Object)this.indicator_graph.getXSlider())) {
            this.indicator_graph.setXSlider(def_xslider);
        }
        if (!this.ysliders.contains((Object)this.indicator_graph.getYSlider())) {
            this.indicator_graph.setYSlider(def_yslider);
        }
        for (int i = 0; i < this.graph_values.length; ++i) {
            Graph g = (Graph)this.graph_values[i][0];
            TimeZoomSlider xslider = g.getXSlider();
            ZoomSlider yslider = g.getYSlider();
            if (!this.ysliders.contains((Object)yslider)) {
                g.setYSlider(def_yslider);
            }
            if (this.xsliders.contains((Object)xslider)) continue;
            g.setXSlider(def_xslider);
        }
    }

    public void rebuildSliderChoices() {
        ZoomSlider slider;
        int i;
        Integer[] x_indexes = new Integer[this.xsliders.size()];
        String[] x_names = new String[this.xsliders.size()];
        Integer[] y_indexes = new Integer[this.ysliders.size()];
        String[] y_names = new String[this.ysliders.size()];
        for (i = 0; i < this.xsliders.size(); ++i) {
            slider = (ZoomSlider)((Object)this.xsliders.get(i));
            x_indexes[i] = new Integer(i);
            x_names[i] = slider.getTitle();
            if (x_names[i] != null) continue;
            x_names[i] = EditorPlugin.getString("HORIZONTAL_SLIDER_PREFIX") + " " + (i + 1);
            slider.setTitle(x_names[i]);
            slider.redraw();
        }
        for (i = 0; i < this.ysliders.size(); ++i) {
            slider = (ZoomSlider)((Object)this.ysliders.get(i));
            y_indexes[i] = new Integer(i);
            y_names[i] = slider.getTitle();
            if (y_names[i] != null) continue;
            y_names[i] = EditorPlugin.getString("VERTICAL_SLIDER_PREFIX") + " " + (i + 1);
            slider.setTitle(y_names[i]);
            slider.redraw();
        }
        this.config_editor.setXSliderChoices(x_indexes, x_names);
        this.config_editor.setYSliderChoices(y_indexes, y_names);
        this.control_editor.setSliderChoices(y_indexes, y_names);
    }

    public void shiftBars(ZoomSlider from, ZoomSlider to) {
        ZoomControlBarsCollection bars = from.getZoomControlBarsCollection();
        Vector v = bars.getZoomControlBars();
        for (int i = 0; i < v.size(); ++i) {
            ZoomControlBar bar = (ZoomControlBar)v.get(i);
            from.removeZoomControlBar(bar);
            bar.setZoomSlider(to);
            to.addZoomControlBar(bar);
        }
    }

    public void updateSliderLayouts() {
        GridData gdata = (GridData)this.nw_panel.getLayoutData();
        gdata.widthHint = 50 * this.ysliders.size();
        this.nw_panel.setLayoutData((Object)gdata);
        gdata = (GridData)this.se_panel.getLayoutData();
        gdata.heightHint = 35 * this.xsliders.size();
        this.se_panel.setLayoutData((Object)gdata);
        this.se_panel.layout(true);
        this.se_panel.redraw();
        this.nw_panel.layout(true);
        this.nw_panel.redraw();
        this.graph_panel.layout(true);
        this.graph_panel.redraw();
        this.graph_panel.update();
    }

    public void removeYSlider(ZoomSlider slider) {
        this.removeYSlider(this.ysliders.indexOf((Object)slider));
    }

    public void removeYSlider(int index) {
        if (index > -1 && index < this.ysliders.size() && this.ysliders.size() > 1) {
            ZoomSlider slider = (ZoomSlider)((Object)this.ysliders.get(index));
            this.ysliders.remove((Object)slider);
            this.shiftBars(slider, (ZoomSlider)((Object)this.ysliders.get(0)));
            SliderPopupListener popup = (SliderPopupListener)this.menu_map.get((Object)slider);
            if (popup != null) {
                popup.dispose();
            }
            this.ensureGraphsAreValid();
            slider.dispose();
            GridLayout glayout = new GridLayout(this.ysliders.size(), false);
            glayout.marginWidth = 0;
            glayout.marginHeight = 0;
            glayout.horizontalSpacing = 0;
            glayout.verticalSpacing = 0;
            this.nw_panel.setLayout((Layout)glayout);
            this.rebuildSliderChoices();
            this.updateSliderLayouts();
            this.updateTables();
            this.setDirty(true);
        }
    }

    public void removeXSlider(ZoomSlider slider) {
        this.removeXSlider(this.xsliders.indexOf((Object)slider));
    }

    public void removeXSlider(int index) {
        if (index > -1 && index < this.xsliders.size() && this.xsliders.size() > 1) {
            Button button;
            ZoomSlider slider = (ZoomSlider)((Object)this.xsliders.get(index));
            this.xsliders.remove((Object)slider);
            this.shiftBars(slider, (TimeZoomSlider)((Object)this.xsliders.get(0)));
            SliderPopupListener popup = (SliderPopupListener)this.menu_map.get((Object)slider);
            if (popup != null) {
                popup.dispose();
            }
            if ((button = (Button)this.button_map.get((Object)slider)) != null) {
                button.dispose();
            }
            this.ensureGraphsAreValid();
            slider.dispose();
            GridLayout glayout = new GridLayout(2, false);
            glayout.marginWidth = 0;
            glayout.marginHeight = 0;
            glayout.horizontalSpacing = 0;
            glayout.verticalSpacing = 0;
            this.se_panel.setLayout((Layout)glayout);
            this.rebuildSliderChoices();
            this.updateSliderLayouts();
            this.updateTables();
            this.setDirty(true);
        }
    }

    public void addYSlider() {
        GridLayout glayout = new GridLayout(this.ysliders.size() + 1, false);
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.nw_panel.setLayout((Layout)glayout);
        try {
            long t = System.currentTimeMillis();
            ZoomSlider slider = new ZoomSlider(this.nw_panel);
            WorkbenchHelp.setHelp((Control)slider, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
            slider.setOrientation(0);
            slider.configure(0.0, 1.0E8, 0.0, 500.0, 0.01);
            GridData gridData = new GridData();
            gridData.heightHint = 50;
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            slider.setLayoutData(gridData);
            int i = this.ysliders.size();
            this.ysliders.add(slider);
            this.disposables.add(slider);
            SliderPopupListener slider_popup = new SliderPopupListener(slider, false);
            this.menu_map.put(slider, slider_popup);
            this.rebuildSliderChoices();
            this.updateSliderColors();
            this.updateSliderLayouts();
            this.setDirty(true);
            return;
        }
        catch (Throwable e) {
            EditorPlugin.DBG.error("problem adding Y slider ", e);
            this.updateSliderColors();
            this.rebuildSliderChoices();
            return;
        }
    }

    public void addXSlider() {
        GridLayout glayout = new GridLayout(2, false);
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.se_panel.setLayout((Layout)glayout);
        try {
            TimeZoomSlider slider = new TimeZoomSlider(this.se_panel);
            WorkbenchHelp.setHelp((Control)slider, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
            slider.setOrientation(1);
            slider.setDirection(-1);
            slider.configure(0.0, 3600000.0, 0.0, 60000.0, 1000.0);
            slider.setWallTime(true);
            GridData gridData = new GridData();
            gridData.widthHint = 50;
            gridData.heightHint = 30;
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            slider.setLayoutData(gridData);
            Button slider_button = new Button(this.se_panel, 2);
            slider_button.setText(">");
            this.button_map.put(slider, slider_button);
            gridData = new GridData();
            gridData.widthHint = 15;
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = false;
            gridData.grabExcessVerticalSpace = true;
            slider_button.setLayoutData((Object)gridData);
            this.xsliders.add(slider);
            this.disposables.add(slider);
            SliderPopupListener slider_popup = new SliderPopupListener(slider, true);
            this.menu_map.put(slider, slider_popup);
            this.rebuildSliderChoices();
            this.updateSliderColors();
            this.updateSliderLayouts();
            this.setDirty(true);
            return;
        }
        catch (Throwable e) {
            EditorPlugin.DBG.error("problem adding X slider ", e);
            this.updateSliderColors();
            this.rebuildSliderChoices();
            return;
        }
    }

    public void setTimeSliderFollowing(TimeZoomSlider slider, boolean b) {
        Button button = (Button)this.button_map.get((Object)slider);
        if (button != null) {
            button.setSelection(b);
        }
    }

    public boolean getTimeSliderFollowing(TimeZoomSlider slider) {
        Button button = (Button)this.button_map.get((Object)slider);
        if (button != null) {
            return button.getSelection();
        }
        return false;
    }

    public void snapSlider(ZoomSlider slider) {
        double yslider_min = -2.0E9;
        double yslider_max = 2.0E9;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        boolean minset = false;
        boolean maxset = false;
        for (int i = 0; i < this.graph_values.length; ++i) {
            Graph g = (Graph)this.graph_values[i][0];
            if (slider == g.getXSlider()) {
                double xmin = g.getXMin();
                double xmax = g.getXMax();
                if (xmin != Double.NEGATIVE_INFINITY && xmin != Double.POSITIVE_INFINITY && xmin < min) {
                    min = xmin;
                    minset = true;
                }
                if (xmax == Double.NEGATIVE_INFINITY || xmax == Double.POSITIVE_INFINITY || !(xmax > max)) continue;
                max = xmax;
                maxset = true;
                continue;
            }
            if (slider != g.getYSlider()) continue;
            double ymin = g.getYMin();
            double ymax = g.getYMax();
            if (ymin != Double.NEGATIVE_INFINITY && ymin != Double.POSITIVE_INFINITY && ymin < min) {
                min = ymin;
                minset = true;
            }
            if (ymax == Double.NEGATIVE_INFINITY || ymax == Double.POSITIVE_INFINITY || !(ymax > max)) continue;
            max = ymax;
            maxset = true;
        }
        if (max > min && minset && maxset) {
            double fourweeks = 2.4192E9;
            if (max - min > fourweeks) {
                min = max - fourweeks;
            }
            if (max - min < slider.getResolution()) {
                max += slider.getResolution() * 5.0;
                min -= slider.getResolution() * 5.0;
            }
            EditorPlugin.DBG.info("Snapping to " + min + " / " + max);
            try {
                if (slider instanceof TimeZoomSlider) {
                    double twohours = 7200000.0;
                    slider.configure(min, max + twohours, min, max, slider.getResolution());
                    this.setDirty(true);
                } else {
                    double minlim = min;
                    double maxlim = max;
                    minlim = min < 0.0 ? -1.0E8 : 0.0;
                    maxlim = 1.0E8;
                    if (min >= 0.0) {
                        min = 0.0;
                    }
                    slider.configure(minlim, maxlim, min, max, slider.getResolution());
                    this.setDirty(true);
                }
                slider.redraw();
            }
            catch (Throwable x) {
                EditorPlugin.DBG.error("problem snapping slider", x);
            }
        } else {
            EditorPlugin.DBG.info("snap slider request is invalid");
        }
        this.ne_panel.redraw();
    }

    public void paintControl(PaintEvent e) {
        this.ne_panel.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o == this.add_vert) {
            this.addYSlider();
            this.setDirty(true);
        } else if (o == this.del_vert) {
            this.removeYSlider(0);
            this.setDirty(true);
        } else if (o == this.add_horz) {
            this.addXSlider();
            this.setDirty(true);
        } else if (o == this.del_horz) {
            this.removeXSlider(0);
            this.setDirty(true);
        } else {
            return;
        }
        this.layout(true);
        this.redraw();
        this.update();
    }

    public void barMoved(ZoomControlBar bar, int newindex) {
        if (bar == null) {
            EditorPlugin.DBG.error("zoom control bar is null", new Exception("Null bar being moved?"));
            return;
        }
        ZoomSlider old_slider = bar.getZoomSlider();
        ZoomSlider new_slider = null;
        new_slider = newindex >= this.ysliders.size() ? (ZoomSlider)((Object)this.xsliders.get(newindex -= this.ysliders.size() - 1)) : (ZoomSlider)((Object)this.ysliders.get(newindex));
        if (old_slider != new_slider) {
            if (!old_slider.isDisposed()) {
                old_slider.removeZoomControlBar(bar);
            }
            bar.setZoomSlider(new_slider);
            new_slider.addZoomControlBar(bar);
        }
        this.setDirty(true);
    }

    public void barEdited(ZoomControlBar bar) {
        this.control_values = this.control_editor.getControlValues();
        int index = this.getControlIndex(this.control_values, bar);
        Object[] vals = this.control_values[index];
        this.barMoved(bar, (Integer)vals[4]);
        Number num = (Number)((SDModifiableVariableRepresentation)vals[5]).getLastRequestedValue();
        bar.setValue(num.doubleValue());
        bar.getZoomSlider().updateIndicators();
        bar.getZoomSlider().updateScale();
        this.redraw();
    }

    public void graphEdited(Graph g) {
        int ysindex;
        this.graph_values = this.config_editor.getValues();
        int index = this.getGraphIndex(this.graph_values, g);
        Object[] vals = this.graph_values[index];
        Color tmp = g.getForeground();
        Color newcolor = new Color((Device)this.getDisplay(), (RGB)vals[3]);
        this.disposables.add(newcolor);
        this.disposables.remove(tmp);
        g.setForeground(newcolor);
        tmp.dispose();
        Integer nwidth = (Integer)vals[4];
        g.setLineWidth(nwidth);
        Integer nstyle = (Integer)vals[5];
        g.setLineStyle(nstyle);
        int xsindex = (Integer)vals[6];
        if (xsindex >= 0 && xsindex < this.xsliders.size()) {
            g.setXSlider((TimeZoomSlider)((Object)this.xsliders.get(xsindex)));
        }
        if ((ysindex = ((Integer)vals[7]).intValue()) >= 0 && ysindex < this.ysliders.size()) {
            g.setYSlider((ZoomSlider)((Object)this.ysliders.get(ysindex)));
        }
        double multiplier = (Double)vals[8];
        g.setStaticScaling(multiplier);
        this.ne_panel.redraw();
        this.setDirty(true);
    }

    private BasicAction findAction(String id, ArrayList actions) {
        for (int i = 0; i < actions.size(); ++i) {
            BasicAction action = (BasicAction)actions.get(i);
            if (!action.id.equals(id)) continue;
            return action;
        }
        return null;
    }

    public void addSliderAction(String id, String name, Image image, Runnable runnable, boolean horizontal) {
        BasicAction action;
        ArrayList slider_actions = this.hslider_actions;
        if (!horizontal) {
            slider_actions = this.vslider_actions;
        }
        if ((action = this.findAction(id, slider_actions)) == null) {
            action = new BasicAction();
            slider_actions.add(action);
        }
        action.id = id;
        action.name = name;
        action.image = image;
        action.runnable = runnable;
        action.horizontal = horizontal;
    }

    public void removeSliderAction(String id) {
        BasicAction action = this.findAction(id, this.hslider_actions);
        if (action == null) {
            action = this.findAction(id, this.vslider_actions);
        }
        if (action != null) {
            action.dispose();
            this.vslider_actions.remove(action);
            this.hslider_actions.remove(action);
        }
    }

    public ZoomSlider getSelectedSlider() {
        return this.selected_slider;
    }

    public double getSelectedSliderValue() {
        return this.selected_slider_value;
    }

    class SliderTitleValidator
    implements IInputValidator {
        SliderTitleValidator() {
        }

        public String isValid(String s) {
            if (s == null) {
                return EditorPlugin.getString("NULL_ARGUMENT");
            }
            if (s.length() == 0) {
                return EditorPlugin.getString("STRING_TOO_SHORT");
            }
            return null;
        }
    }

    class SliderMaxValidator
    implements IInputValidator {
        ZoomSlider slider;

        public SliderMaxValidator(ZoomSlider slider) {
            this.slider = slider;
        }

        public String isValid(String s) {
            if (s == null) {
                return EditorPlugin.getString("NULL_ARGUMENT");
            }
            if (s.length() == 0) {
                return EditorPlugin.getString("STRING_TOO_SHORT");
            }
            try {
                double d = Double.parseDouble(s);
                if (d <= this.slider.getMinLimit() + this.slider.getIncrement()) {
                    return EditorPlugin.getString("VALUE_TOO_SMALL") + " (" + (this.slider.getMinLimit() + this.slider.getIncrement()) + ")";
                }
            }
            catch (Throwable e) {
                return EditorPlugin.getString("NOT_A_VALID_NUMBER");
            }
            return null;
        }
    }

    class SliderMinValidator
    implements IInputValidator {
        ZoomSlider slider;

        public SliderMinValidator(ZoomSlider slider) {
            this.slider = slider;
        }

        public String isValid(String s) {
            if (s == null) {
                return EditorPlugin.getString("NULL_ARGUMENT");
            }
            if (s.length() == 0) {
                return EditorPlugin.getString("STRING_TOO_SHORT");
            }
            try {
                double d = Double.parseDouble(s);
                if (d >= this.slider.getMaxLimit() - this.slider.getIncrement()) {
                    return EditorPlugin.getString("VALUE_TOO_LARGE") + " (" + (this.slider.getMaxLimit() - this.slider.getIncrement()) + ")";
                }
            }
            catch (Throwable e) {
                return EditorPlugin.getString("NOT_A_VALID_NUMBER");
            }
            return null;
        }
    }

    class SliderPopupListener
    implements MouseListener,
    SelectionListener {
        boolean horizontal;
        ZoomSlider slider;
        Menu menu;
        MenuItem add_slider;
        MenuItem remove_slider;
        MenuItem title_slider;
        MenuItem maxlock_slider;
        MenuItem minlock_slider;
        MenuItem maximum_slider;
        MenuItem minimum_slider;
        MenuItem snap_slider;
        ArrayList menu_disposables = new ArrayList();
        int dx;

        public void dispose() {
            this.menu.dispose();
            this.add_slider.dispose();
            this.remove_slider.dispose();
            this.title_slider.dispose();
            this.maxlock_slider.dispose();
            this.minlock_slider.dispose();
            this.maximum_slider.dispose();
            this.minimum_slider.dispose();
            this.snap_slider.dispose();
        }

        public SliderPopupListener(ZoomSlider slider, boolean horizontal) {
            this.slider = slider;
            this.horizontal = horizontal;
            this.initMenu();
            this.initEventHandling();
        }

        private void initEventHandling() {
            this.slider.addMouseListener(this);
            this.add_slider.addSelectionListener((SelectionListener)this);
            this.remove_slider.addSelectionListener((SelectionListener)this);
            this.title_slider.addSelectionListener((SelectionListener)this);
            this.maxlock_slider.addSelectionListener((SelectionListener)this);
            this.minlock_slider.addSelectionListener((SelectionListener)this);
            this.maximum_slider.addSelectionListener((SelectionListener)this);
            this.minimum_slider.addSelectionListener((SelectionListener)this);
            this.snap_slider.addSelectionListener((SelectionListener)this);
        }

        private void initMenu() {
            this.menu = new Menu((Control)this.slider);
            this.add_slider = new MenuItem(this.menu, 0);
            this.title_slider = new MenuItem(this.menu, 0);
            this.maxlock_slider = new MenuItem(this.menu, 0);
            this.minlock_slider = new MenuItem(this.menu, 0);
            this.maximum_slider = new MenuItem(this.menu, 0);
            this.minimum_slider = new MenuItem(this.menu, 0);
            this.remove_slider = new MenuItem(this.menu, 0);
            this.snap_slider = new MenuItem(this.menu, 0);
            this.initMenuText();
        }

        private void initMenuEnabled() {
            if (this.horizontal) {
                if (GraphWindow.this.getXSliderCount() <= 1) {
                    this.remove_slider.setEnabled(false);
                } else {
                    this.remove_slider.setEnabled(true);
                }
            } else if (GraphWindow.this.getYSliderCount() <= 1) {
                this.remove_slider.setEnabled(false);
            } else {
                this.remove_slider.setEnabled(true);
            }
        }

        private void initMenuText() {
            this.add_slider.setText(EditorPlugin.getString("ADD_SLIDER"));
            SimpleDateFormat sdf = new SimpleDateFormat();
            if (this.horizontal) {
                this.maximum_slider.setText(EditorPlugin.getString("SET_MAXIMUM") + " (" + sdf.format(new Date((long)this.slider.getMaxLimit())) + ") (" + this.slider.getTitle() + ")");
                this.minimum_slider.setText(EditorPlugin.getString("SET_MINIMUM") + " (" + sdf.format(new Date((long)this.slider.getMinLimit())) + ") (" + this.slider.getTitle() + ")");
            } else {
                this.maximum_slider.setText(EditorPlugin.getString("SET_MAXIMUM") + " (" + this.slider.getMaxLimit() + ") (" + this.slider.getTitle() + ")");
                this.minimum_slider.setText(EditorPlugin.getString("SET_MINIMUM") + " (" + this.slider.getMinLimit() + ") (" + this.slider.getTitle() + ")");
            }
            if (this.slider.isLocked(1)) {
                this.maxlock_slider.setText(EditorPlugin.getString("UNLOCK_SLIDER_MAX") + " (" + this.slider.getTitle() + ")");
            } else {
                this.maxlock_slider.setText(EditorPlugin.getString("LOCK_SLIDER_MAX") + " (" + this.slider.getTitle() + ")");
            }
            if (this.slider.isLocked(0)) {
                this.minlock_slider.setText(EditorPlugin.getString("UNLOCK_SLIDER_MIN") + " (" + this.slider.getTitle() + ")");
            } else {
                this.minlock_slider.setText(EditorPlugin.getString("LOCK_SLIDER_MIN") + " (" + this.slider.getTitle() + ")");
            }
            this.remove_slider.setText(EditorPlugin.getString("REMOVE_SLIDER") + " (" + this.slider.getTitle() + ")");
            this.title_slider.setText(EditorPlugin.getString("SET_TITLE") + " (" + this.slider.getTitle() + ")");
            this.snap_slider.setText(EditorPlugin.getString("SNAP_TO_ASSOCIATED_GRAPHS") + " (" + this.slider.getTitle() + ")");
            if (this.menu_disposables != null) {
                for (int i = 0; i < this.menu_disposables.size(); ++i) {
                    MenuItem mitem = (MenuItem)this.menu_disposables.get(i);
                    mitem.dispose();
                }
            }
            ArrayList slider_actions = GraphWindow.this.hslider_actions;
            if (!this.horizontal) {
                slider_actions = GraphWindow.this.vslider_actions;
            }
            if (slider_actions.size() > 0) {
                MenuItem sep = new MenuItem(this.menu, 2);
                this.menu_disposables.add(sep);
                for (int k = 0; k < slider_actions.size(); ++k) {
                    BasicAction action = (BasicAction)slider_actions.get(k);
                    action.menuitem = new MenuItem(this.menu, 0);
                    action.menuitem.setText(action.name);
                    action.menuitem.setImage(action.image);
                    action.menuitem.addSelectionListener((SelectionListener)action);
                    this.menu_disposables.add(action.menuitem);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == this.add_slider) {
                if (this.horizontal) {
                    EditorPlugin.DBG.info("add a horizontal slider");
                    GraphWindow.this.addXSlider();
                } else {
                    EditorPlugin.DBG.info("add a vertical slider");
                    GraphWindow.this.addYSlider();
                }
                GraphWindow.this.setDirty(true);
            } else if (o == this.remove_slider) {
                if (this.horizontal) {
                    EditorPlugin.DBG.info("remove slider " + this.slider.getTitle());
                    GraphWindow.this.removeXSlider(this.slider);
                } else {
                    EditorPlugin.DBG.info("remove slider " + this.slider.getTitle());
                    GraphWindow.this.removeYSlider(this.slider);
                }
                GraphWindow.this.setDirty(true);
            } else if (o == this.snap_slider) {
                EditorPlugin.DBG.info("snap slider " + this.slider.getTitle());
                GraphWindow.this.snapSlider(this.slider);
                GraphWindow.this.setDirty(true);
            } else if (o == this.title_slider) {
                EditorPlugin.DBG.info("set slider " + this.slider.getTitle() + " title");
                InputDialog dialog = new InputDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_SLIDER_TITLE"), EditorPlugin.getString("SLIDER_TITLE_REQUEST") + ":", this.slider.getTitle(), (IInputValidator)new SliderTitleValidator());
                dialog.open();
                String newtitle = dialog.getValue();
                if (newtitle != null) {
                    this.slider.setTitle(newtitle);
                    GraphWindow.this.updateSliders();
                    GraphWindow.this.setDirty(true);
                }
                dialog.close();
                this.slider.redraw();
            } else if (o == this.maxlock_slider) {
                EditorPlugin.DBG.info("(un)lock max of slider " + this.slider.getTitle());
                this.slider.lock(1, !this.slider.isLocked(1));
                GraphWindow.this.setDirty(true);
            } else if (o == this.minlock_slider) {
                EditorPlugin.DBG.info("(un)lock in of slider " + this.slider.getTitle());
                this.slider.lock(0, !this.slider.isLocked(0));
                GraphWindow.this.setDirty(true);
            } else if (o == this.maximum_slider) {
                EditorPlugin.DBG.info("set maximum for slider " + this.slider.getTitle());
                double newlimit = 0.0;
                try {
                    DateDialog dialog;
                    if (this.horizontal) {
                        dialog = new DateDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_TIME_SLIDER_MAX"));
                        dialog.setDate((long)this.slider.getMaxLimit());
                        newlimit = ((Long)dialog.open()).doubleValue();
                    } else {
                        dialog = new InputDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_SLIDER_MAX"), EditorPlugin.getString("NEW_SLIDER_MAXIMUM") + ":", "" + this.slider.getMaxLimit(), (IInputValidator)new SliderMaxValidator(this.slider));
                        dialog.open();
                        newlimit = Double.parseDouble(dialog.getValue());
                    }
                }
                catch (Throwable x) {
                    EditorPlugin.DBG.warning("problem getting slider configuration", x);
                    return;
                }
                try {
                    double limit = newlimit;
                    double min = this.slider.getMinLimit();
                    double max = limit;
                    double minvis = this.slider.getMinVisible();
                    double maxvis = Math.min(limit, this.slider.getMaxVisible());
                    double res = this.slider.getResolution();
                    this.slider.configure(min, max, minvis, maxvis, res);
                    GraphWindow.this.setDirty(true);
                }
                catch (Throwable x) {
                    EditorPlugin.DBG.warning("problem setting slider configuration", x);
                }
                this.slider.redraw();
            } else if (o == this.minimum_slider) {
                EditorPlugin.DBG.info("set minimum for slider " + this.slider.getTitle());
                double newlimit = 0.0;
                try {
                    DateDialog dialog;
                    if (this.horizontal) {
                        dialog = new DateDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_TIME_SLIDER_MIN"));
                        dialog.setDate((long)this.slider.getMinLimit());
                        newlimit = ((Long)dialog.open()).doubleValue();
                    } else {
                        dialog = new InputDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_SLIDER_MIN"), EditorPlugin.getString("NEW_SLIDER_MINIMUM") + ":", "" + this.slider.getMinLimit(), (IInputValidator)new SliderMinValidator(this.slider));
                        dialog.open();
                        newlimit = Double.parseDouble(dialog.getValue());
                    }
                }
                catch (Throwable x) {
                    EditorPlugin.DBG.warning("problem getting slider configuration", x);
                    return;
                }
                try {
                    double limit = newlimit;
                    double min = this.slider.getMinLimit();
                    double max = this.slider.getMaxLimit();
                    double minvis = Math.max(limit, this.slider.getMinVisible());
                    double maxvis = this.slider.getMaxVisible();
                    double res = this.slider.getResolution();
                    double diff = limit - min;
                    this.slider.configure(limit, max, minvis, maxvis, res);
                    GraphWindow.this.setDirty(true);
                }
                catch (Throwable x) {
                    EditorPlugin.DBG.warning("problem setting slider configuration", x);
                }
                this.slider.redraw();
            }
        }

        public void mouseDown(MouseEvent e) {
            GraphWindow.this.setDirty(true);
            this.dx = e.x;
            if (this.horizontal) {
                GraphWindow.this.ref_min_graph.setXSlider((TimeZoomSlider)this.slider);
                GraphWindow.this.ref_maj_graph.setXSlider((TimeZoomSlider)this.slider);
            } else {
                GraphWindow.this.ref_min_graph.setYSlider(this.slider);
                GraphWindow.this.ref_maj_graph.setYSlider(this.slider);
            }
            GraphWindow.this.ne_panel.redraw();
        }

        public void mouseUp(MouseEvent e) {
            GraphWindow.this.setDirty(true);
            if (this.dx < e.x) {
                // empty if block
            }
            if (this.horizontal) {
                GraphWindow.this.ref_min_graph.setXSlider((TimeZoomSlider)this.slider);
                GraphWindow.this.ref_maj_graph.setXSlider((TimeZoomSlider)this.slider);
                if (this.dx == e.x && e.button <= 1) {
                    GraphWindow.this.indicator_graph.setXSlider((TimeZoomSlider)this.slider);
                    Button button = (Button)GraphWindow.this.button_map.get((Object)this.slider);
                    if (button != null && GraphWindow.this.update_thread != null) {
                        if (button.getSelection() && GraphWindow.this.update_thread.isAlive()) {
                            GraphWindow.this.indicator_graph.setIndicatorLocation(Double.MAX_VALUE);
                        } else {
                            GraphWindow.this.indicator_graph.setIndicatorLocation(e.x);
                        }
                    } else {
                        GraphWindow.this.indicator_graph.setIndicatorLocation(e.x);
                    }
                }
            } else {
                GraphWindow.this.ref_min_graph.setYSlider(this.slider);
                GraphWindow.this.ref_maj_graph.setYSlider(this.slider);
            }
            if (e.button > 1 && this.dx == e.x) {
                this.initMenuEnabled();
                this.initMenuText();
                GraphWindow.this.selected_slider = (ZoomSlider)e.widget;
                GraphWindow.this.selected_slider_value = this.horizontal ? GraphWindow.this.selected_slider.pixel2Value(e.x) : GraphWindow.this.selected_slider.pixel2Value(e.y);
                this.menu.setVisible(true);
            }
            GraphWindow.this.ne_panel.redraw();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }

    class BasicAction
    implements SelectionListener {
        String id = "unknown";
        String name;
        Runnable runnable;
        MenuItem menuitem;
        Image image;
        boolean horizontal;

        BasicAction() {
        }

        public void dispose() {
            if (this.menuitem != null) {
                this.menuitem.dispose();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.runnable.run();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.runnable.run();
        }
    }

    class CSVExport
    implements IRunnableWithProgress {
        String file;
        long avg;
        long start;
        long finish;

        public CSVExport(String file, long avg, long start, long finish) {
            this.file = file;
            this.avg = avg;
            this.start = start;
            this.finish = finish;
        }

        public void run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(EditorPlugin.getString("BUILDING_HEADER"), GraphWindow.this.graph_values.length);
                OutputStream fout = new FileOutputStream(this.file);
                fout = new BufferedOutputStream(fout);
                SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
                SimpleDateFormat dformat = new SimpleDateFormat("dd/MMMM/yyyy");
                ColumnPrinter cprinter = new ColumnPrinter();
                cprinter.setCellPrefix("\"");
                cprinter.setCellPostfix("\",");
                int COLUMN_DATE = 0;
                int COLUMN_TIME = 1;
                int COL = 2;
                cprinter.setHeaderText(COLUMN_DATE, 0, "Date");
                cprinter.setHeaderText(COLUMN_TIME, 0, "Time");
                for (int i = 0; i < GraphWindow.this.graph_values.length; ++i) {
                    int ROW = 0;
                    cprinter.setHeaderText(COL, ROW++, "Description: " + GraphWindow.this.graph_values[i][2]);
                    cprinter.setHeaderText(COL, ROW++, (String)GraphWindow.this.graph_values[i][1]);
                    SDDescriptor parent = (SDDescriptor)GraphWindow.this.graph_values[i][9];
                    while (parent != null) {
                        if ((parent = parent.getParent()) == null) continue;
                        cprinter.setHeaderText(COL, ROW++, parent.getName());
                    }
                    ++COL;
                    monitor.worked(1);
                }
                String header = cprinter.toString();
                fout.write(header.getBytes());
                EditorPlugin.DBG.info("Wrote headers OK");
                int delta = (int)(this.finish - this.start);
                int worked = 0;
                monitor.beginTask(EditorPlugin.getString("EXPORTING_DATA"), delta);
                for (long t = this.start; t < this.finish; t += this.avg) {
                    if ((worked = (int)((long)worked + this.avg)) > delta / 500) {
                        monitor.worked(worked);
                        worked = 0;
                    }
                    fout.write("\"".getBytes());
                    fout.write(dformat.format(new Date(t)).getBytes());
                    fout.write("\",".getBytes());
                    fout.write("\"".getBytes());
                    fout.write(tformat.format(new Date(t)).getBytes());
                    fout.write("\",".getBytes());
                    for (int i = 0; i < GraphWindow.this.graph_values.length; ++i) {
                        String val;
                        Graph g = (Graph)GraphWindow.this.graph_values[i][0];
                        BasicGraphSource source = g.getGraphSource();
                        if (source instanceof GraphSource) {
                            GraphSource gsource = (GraphSource)source;
                            val = Double.toString(gsource.getAverageBetween(t, t + this.avg));
                        } else if (source instanceof EnumerationGraphSource) {
                            EnumerationGraphSource esource = (EnumerationGraphSource)source;
                            val = esource.getValueAt(t).toString();
                        } else {
                            val = "error - " + source.getClass();
                        }
                        fout.write("\"".getBytes());
                        fout.write(val.getBytes());
                        fout.write("\",".getBytes());
                    }
                    fout.write(10);
                }
                monitor.done();
                EditorPlugin.DBG.info("Wrote data OK");
                fout.close();
            }
            catch (IOException x) {
                EditorPlugin.DBG.error(EditorPlugin.getString("ERROR_CSV_EXPORT_FILE"), x);
                EditorPlugin.DBG.logVisibleError(x, EditorPlugin.getString("ERROR_CSV_EXPORT_FILE"), true);
            }
        }
    }

    class GraphPopupListener
    implements MouseListener,
    SelectionListener {
        Menu menu;
        MenuItem set_color;
        MenuItem default_color;
        MenuItem match_color;
        MenuItem msep;
        MenuItem export_csv;
        GraphCanvas graph_canvas;

        public void dispose() {
            this.menu.dispose();
            this.set_color.dispose();
            this.default_color.dispose();
            this.export_csv.dispose();
            this.msep.dispose();
            this.match_color.dispose();
        }

        public GraphPopupListener(GraphCanvas graph_canvas) {
            this.graph_canvas = graph_canvas;
            this.initMenu();
            this.initEventHandling();
        }

        private void initEventHandling() {
            this.graph_canvas.addMouseListener(this);
            this.set_color.addSelectionListener((SelectionListener)this);
            this.default_color.addSelectionListener((SelectionListener)this);
            this.export_csv.addSelectionListener((SelectionListener)this);
            this.match_color.addSelectionListener((SelectionListener)this);
        }

        private void initMenu() {
            this.menu = new Menu((Control)this.graph_canvas);
            this.set_color = new MenuItem(this.menu, 0);
            this.default_color = new MenuItem(this.menu, 0);
            this.match_color = new MenuItem(this.menu, 0);
            this.msep = new MenuItem(this.menu, 2);
            this.export_csv = new MenuItem(this.menu, 0);
            this.initMenuText();
        }

        private void initMenuText() {
            this.export_csv.setText(EditorPlugin.getString("EXPORT_GRAPHS_CSV"));
            this.set_color.setText(EditorPlugin.getString("MENUITEM_SET_GRAPH_BACKGROUND_COLOR"));
            this.default_color.setText(EditorPlugin.getString("MENUITEM_DEFAULT_GRAPH_BACKGROUND_COLOR"));
            if (GraphWindow.this.getSlidersMatchGraph()) {
                this.match_color.setText(EditorPlugin.getString("MENUITEM_SEPARATE_SLIDERS_FROM_GRAPH"));
            } else {
                this.match_color.setText(EditorPlugin.getString("MENUITEM_MATCH_SLIDERS_TO_GRAPH"));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == this.set_color) {
                EditorPlugin.DBG.info("set graph background colour");
                ColorDialog dialog = new ColorDialog(this.graph_canvas.getShell());
                dialog.setRGB(this.graph_canvas.getBackground().getRGB());
                RGB rgb = dialog.open();
                if (rgb != null) {
                    GraphWindow.this.setGraphBackground(rgb);
                }
            } else if (o == this.default_color) {
                EditorPlugin.DBG.info("default graph background colour");
                GraphWindow.this.setGraphBackground(GraphWindow.this.getDisplay().getSystemColor(25));
            } else if (o == this.match_color) {
                EditorPlugin.DBG.info("separate / match sliders to graph");
                GraphWindow.this.setSlidersMatchGraph(!GraphWindow.this.getSlidersMatchGraph());
                GraphWindow.this.updateSliderColors();
                GraphWindow.this.setDirty(true);
            } else if (o == this.export_csv) {
                TimeZoomSlider xslider = GraphWindow.this.getXSlider(0);
                ExportTimeDialog etdialog = new ExportTimeDialog(GraphWindow.this.getShell(), (long)xslider.getIncrement(), (long)xslider.getMinVisible(), (long)xslider.getMaxVisible());
                if (etdialog.open() == 0) {
                    long avg = etdialog.getAveragePeriodMS();
                    long start = etdialog.getStartTime();
                    long finish = etdialog.getMaxTime();
                    FileDialog fdialog = new FileDialog(GraphWindow.this.getShell(), 8192);
                    fdialog.setFilterExtensions(new String[]{"*.csv"});
                    fdialog.setFilterNames(new String[]{"Comma Separated Values (*.csv)"});
                    String file = fdialog.open();
                    if (file != null) {
                        File f;
                        if (file.indexOf(46) == -1) {
                            file = file + ".csv";
                        }
                        if ((f = new File(file)) != null && f.exists()) {
                            MessageBox mbox = new MessageBox(GraphWindow.this.getShell(), 200);
                            mbox.setText(EditorPlugin.getString("FILE_EXISTS"));
                            mbox.setMessage(EditorPlugin.getString("FILE_EXISTS_MSG"));
                            if (mbox.open() != 64) {
                                return;
                            }
                        }
                        ProgressMonitorDialog pdialog = new ProgressMonitorDialog(GraphWindow.this.getShell());
                        pdialog.setCancelable(false);
                        try {
                            pdialog.run(true, false, (IRunnableWithProgress)new CSVExport(file, avg, start, finish));
                        }
                        catch (Throwable x) {
                            EditorPlugin.DBG.logVisibleError(x, EditorPlugin.getString("ERROR_CSV_EXPORT_DIALOG"), false);
                        }
                    }
                }
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button > 1) {
                this.initMenuText();
                this.menu.setVisible(true);
            }
            GraphWindow.this.ne_panel.redraw();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }

    public class UpdateThread
    extends Thread {
        public void run() {
            GraphCanvasUpdate update = new GraphCanvasUpdate();
            EditorPlugin.DBG.info("Graph Canvas Update - starting updates");
            while (GraphWindow.this.constant_update) {
                try {
                    Thread.sleep(GraphWindow.this.constant_update_ms);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (!GraphWindow.this.constant_update) break;
                if (!GraphWindow.this.isDisposed() && !GraphWindow.this.getDisplay().isDisposed()) {
                    GraphWindow.this.getDisplay().syncExec((Runnable)update);
                }
                for (int i = 0; i < GraphWindow.this.update_runnables.size(); ++i) {
                    try {
                        Runnable r = (Runnable)GraphWindow.this.update_runnables.get(i);
                        GraphWindow.this.getDisplay().syncExec(r);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            EditorPlugin.DBG.info("Graph Canvas Update - stopping updates");
        }
    }

    public class GraphCanvasUpdate
    extends Thread {
        public void run() {
            try {
                for (int i = 0; i < GraphWindow.this.xsliders.size(); ++i) {
                    TimeZoomSlider slider = (TimeZoomSlider)((Object)GraphWindow.this.xsliders.get(i));
                    Button button = (Button)GraphWindow.this.button_map.get((Object)slider);
                    if (button == null || !button.getSelection()) continue;
                    GraphWindow.this.jumpToNow(slider);
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.warning("Graph Canvas Update - problem updating", e);
            }
            try {
                GraphWindow.this.ne_panel.redraw();
            }
            catch (Throwable e) {
                EditorPlugin.DBG.warning("Graph Canvas Update - problem redrawing", e);
            }
        }
    }
}

