/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.List;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;

public class SDTextObservationGraphSource
implements EnumerationGraphSource {
    SDTextObservation sdc;
    List times;
    List values;

    public SDTextObservationGraphSource(SDTextObservation sdc) {
        this.sdc = sdc;
        this.times = sdc.getCreationTime();
        this.values = sdc.getTextValue();
    }

    public int bchopGetIndex(double t) {
        int lower = 0;
        int higher = this.times.size() - 1;
        double t1 = ((Number)this.times.get(lower)).doubleValue();
        double t2 = ((Number)this.times.get(higher)).doubleValue();
        if (t >= t2) {
            return this.times.size() - 1;
        }
        if (t <= t1) {
            return 0;
        }
        return this.bchopGetIndex(lower, higher, t);
    }

    private int bchopGetIndex(int lower, int higher, double t) {
        while (true) {
            if (higher - lower < 10) {
                for (int i = lower; i <= higher; ++i) {
                    Number T = (Number)this.times.get(i);
                    if (!(T.doubleValue() > t)) continue;
                    if (--i < 0) {
                        return 0;
                    }
                    if (i >= this.times.size()) {
                        return this.times.size() - 1;
                    }
                    return i;
                }
                return higher;
            }
            double t1 = ((Number)this.times.get(lower)).doubleValue();
            double t2 = ((Number)this.times.get(higher)).doubleValue();
            double chop = (t - t1) / (t2 - t1);
            chop *= (double)(higher - lower - 2);
            double chop_t = ((Number)this.times.get((int)(chop = chop + (double)lower + 1.0))).doubleValue();
            if (chop_t == t) {
                return (int)chop;
            }
            if (chop_t > t) {
                higher = (int)chop;
                continue;
            }
            lower = (int)chop;
        }
    }

    public Object getValueAt(double t) {
        if (this.times == null) {
            return null;
        }
        if (this.times.size() == 0) {
            return null;
        }
        int index = this.bchopGetIndex(t);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Text Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        String D = (String)this.values.get(index);
        return D;
    }

    public double getMin() {
        if (this.times == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Number L = (Number)this.times.get(0);
        return L.doubleValue();
    }

    public double getMax() {
        if (this.times == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Number L = (Number)this.times.get(this.times.size() - 1);
        return L.doubleValue();
    }
}

