/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TextGraph;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class IndicatorLineGraph
implements TextGraph,
IndicatorSource {
    int type = 0;
    TimeZoomSlider xslider;
    ZoomSlider yslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    double source_val = Double.MAX_VALUE;

    public double getIndicatorLocation() {
        return this.source_val;
    }

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public IndicatorLineGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
        this.xslider = xslider;
        this.yslider = yslider;
        this.fg_col = col;
    }

    public BasicGraphSource getGraphSource() {
        return null;
    }

    public double getXMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getXMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public void setForeground(Color col) {
        this.fg_col = col;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean b) {
    }

    public int getSourceType() {
        return this.type;
    }

    public void setSourceType(int t) {
        this.type = t;
    }

    public void setIndicatorLocation(double d) {
        this.source_val = d;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        this.paintGraph(gc, x, y, w, h, 0);
    }

    public int paintGraph(GC gc, int x, int y, int w, int h, int yoffset) {
        int fheight = gc.getFontMetrics().getHeight();
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        int xval = (int)this.source_val;
        long t = (long)this.xslider.pixel2Value(xval);
        if (this.type == 0) {
            xval = (int)this.xslider.value2Pixel(this.source_val);
            t = (long)this.source_val;
        }
        if (xval < w) {
            gc.drawLine(xval, y, xval, y + h);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            StringBuffer str = new StringBuffer();
            str.append(sdf.format(new Date(t)));
            gc.setForeground(this.yslider.getDisplay().getSystemColor(15));
            gc.drawString(str.toString(), xval + 2, yoffset + y + 1, true);
            gc.setForeground(this.yslider.getDisplay().getSystemColor(2));
            gc.drawString(str.toString(), xval + 1, yoffset + y, true);
            if ((yoffset += fheight) + fheight > h) {
                yoffset = 0;
            }
        }
        return yoffset;
    }

    public void setStaticScaling(double mult) {
    }

    public double getStaticScaling() {
        return 1.0;
    }
}

