/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class MessagePanel
extends Composite
implements SelectionListener {
    Object msg_lock = new Object();
    StringBuffer buffer = new StringBuffer();
    boolean cleared = false;
    boolean locked = false;
    Button lock;
    Button save;
    Button clear;
    Text msg_text;

    public MessagePanel(Composite parent, int style) {
        super(parent, style);
        this.init();
        this.initEventHandling();
    }

    private void init() {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData();
        this.setLayout((Layout)layout);
        this.lock = new Button((Composite)this, 0x1000002);
        this.lock.setImage(EditorPlugin.img.getImage("lock.gif"));
        this.msg_text = new Text((Composite)this, 2634);
        this.save = new Button((Composite)this, 0x1000008);
        this.save.setImage(EditorPlugin.img.getImage("save.gif"));
        this.lock.setLayoutData((Object)this.getButtonLayout());
        this.lock.setToolTipText(EditorPlugin.getString("LOCK_TOOLTIP"));
        this.save.setLayoutData((Object)this.getButtonLayout());
        this.save.setToolTipText(EditorPlugin.getString("SAVE_TOOLTIP"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.verticalSpan = 4;
        this.msg_text.setLayoutData((Object)data);
    }

    private void initEventHandling() {
        this.lock.addSelectionListener((SelectionListener)this);
        this.save.addSelectionListener((SelectionListener)this);
    }

    private GridData getButtonLayout() {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.widthHint = 21;
        data.heightHint = 21;
        return data;
    }

    public String getMsgText() {
        return this.msg_text.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsgText(String txt) {
        Object object = this.msg_lock;
        synchronized (object) {
            if (this.locked) {
                this.buffer.setLength(0);
                this.buffer.append(txt);
                this.cleared = true;
            } else {
                this.msg_text.setText(txt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMsgText(String txt) {
        Object object = this.msg_lock;
        synchronized (object) {
            if (this.locked) {
                this.buffer.append(txt);
            } else {
                this.msg_text.append(txt);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.lock) {
            Object object = this.msg_lock;
            synchronized (object) {
                this.locked = this.lock.getSelection();
                if (!this.locked) {
                    if (this.cleared) {
                        this.msg_text.setText(this.buffer.toString());
                    } else {
                        this.msg_text.append(this.buffer.toString());
                    }
                    this.cleared = false;
                }
                this.buffer.setLength(0);
            }
        }
        if (e.getSource() == this.save) {
            SaveAsDialog dialog = new SaveAsDialog(this.getShell());
            dialog.setTitle(EditorPlugin.getString("SAVE_LOG_TITLE"));
            dialog.open();
            IPath result = dialog.getResult();
            if (result != null) {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile file = root.getFile(result);
                    ByteArrayInputStream bout = new ByteArrayInputStream(this.msg_text.getText().getBytes());
                    try {
                        file.setContents((InputStream)bout, true, false, null);
                    }
                    catch (Exception xx) {
                        file.create((InputStream)bout, true, null);
                    }
                }
                catch (Throwable x) {
                    MessageBox mbox = new MessageBox(this.getShell(), 32);
                    mbox.setText(EditorPlugin.getString("SAVE_LOG_FAILED_TITLE"));
                    mbox.setMessage(EditorPlugin.getString("SAVE_LOG_FAILED_MSG"));
                    mbox.open();
                    EditorPlugin.DBG.logVisibleError(x, EditorPlugin.getString("ERROR_SAVE_MESSAGE_LOG"), false);
                    EditorPlugin.DBG.error("error saving message log", x);
                }
            }
        }
    }
}

