/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Date;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;

public class TimeZoomSliderTick
extends ZoomSliderTick {
    int hrs;
    int mins;
    int secs;
    String hrs$;
    String mins$;
    String secs$;

    public TimeZoomSliderTick(ZoomSlider slider, double d) {
        this.slider = slider;
        this.value = d;
        this.calculateComponents();
        if (((TimeZoomSlider)slider).isWallTime()) {
            this.representation = this.hrs$ + ":" + this.mins$ + ":" + this.secs$;
        } else {
            this.representation = "";
            if (this.hrs != 0) {
                this.representation = this.representation + this.hrs$ + ":";
            }
            if (this.mins != 0 || this.hrs != 0) {
                this.representation = this.representation + this.mins$ + ":";
            }
            this.representation = this.representation + this.secs$;
        }
        this.pixel = (int)slider.value2Pixel(this.value);
        this.textVisible = this.isTextVisible();
    }

    public void calculateComponents() {
        long millis = (long)this.value;
        if (!((TimeZoomSlider)this.slider).isWallTime()) {
            millis = (long)this.value - (long)this.slider.rawOffset;
        }
        ((TimeZoomSlider)this.slider).calendar.setTime(new Date(millis));
        this.hrs = ((TimeZoomSlider)this.slider).calendar.get(11);
        this.hrs$ = String.valueOf(this.hrs);
        if (this.hrs$.length() == 1) {
            this.hrs$ = "0" + this.hrs$;
        }
        this.mins = ((TimeZoomSlider)this.slider).calendar.get(12);
        this.mins$ = String.valueOf(this.mins);
        if (this.mins$.length() == 1) {
            this.mins$ = "0" + this.mins$;
        }
        this.secs = ((TimeZoomSlider)this.slider).calendar.get(13);
        this.secs$ = String.valueOf(this.secs);
        if (this.secs$.length() == 1) {
            this.secs$ = "0" + this.secs$;
        }
    }

    protected boolean isTextVisible() {
        int inc = (int)((long)this.slider.getIncrement() / 1000L);
        switch (inc) {
            case 1: {
                return this.secs % 5 == 0;
            }
            case 2: {
                return this.secs % 10 == 0;
            }
            case 5: {
                return this.secs % 15 == 0;
            }
            case 10: {
                return this.secs % 30 == 0;
            }
            case 20: {
                return this.secs % 60 == 0;
            }
            case 30: {
                return this.secs % 60 == 0 && this.mins % 2 == 0;
            }
            case 60: {
                return this.mins % 5 == 0;
            }
            case 120: {
                return this.mins % 10 == 0;
            }
            case 300: {
                return this.mins % 20 == 0;
            }
            case 600: {
                return this.mins % 60 == 0;
            }
            case 1200: {
                return this.mins % 60 == 0 && this.hrs % 2 == 0;
            }
            case 1800: {
                return this.mins % 60 == 0 && this.hrs % 2 == 0;
            }
            case 3600: {
                return this.hrs % 3 == 0;
            }
            case 7200: {
                return this.hrs % 6 == 0;
            }
        }
        return true;
    }
}

