/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class ZoomIndicator {
    ZoomSlider slider = null;
    double value;
    double oldValue;
    Color color;
    Color xorColor;

    public ZoomIndicator(ZoomSlider slider) {
        this.slider = slider;
        this.setColor(slider.getDisplay().getSystemColor(22));
        this.setValue(slider.getMinLimit());
        slider.addZoomIndicator(this);
    }

    public ZoomIndicator(ZoomSlider slider, double value) {
        this(slider);
        this.setValue(value);
        slider.redraw();
    }

    public ZoomIndicator(ZoomSlider slider, Color color) {
        this(slider);
        this.setColor(color);
        slider.redraw();
    }

    public ZoomIndicator(ZoomSlider slider, double value, Color color) {
        this(slider, value);
        this.setColor(color);
        slider.redraw();
    }

    public void setZoomSlider(ZoomSlider slider) {
        this.slider = slider;
    }

    public ZoomSlider getZoomSlider() {
        return this.slider;
    }

    public void setValue(double value) {
        this.oldValue = this.value;
        if (value > this.slider.getMaxLimit()) {
            value = this.slider.getMaxLimit();
        }
        if (value < this.slider.getMinLimit()) {
            value = this.slider.getMinLimit();
        }
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setXORColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(GC g, Image backBuffer, int pos, int w) {
        int pix = 0;
        int oldPix = 0;
        pix = (int)this.slider.value2Pixel(this.value);
        oldPix = (int)this.slider.value2Pixel(0.0);
        int orientation = this.slider.getOrientation();
        int direction = this.slider.getDirection();
        int size_height = this.slider.getBounds().height;
        int size_width = this.slider.getBounds().width;
        if (backBuffer == null) {
            if (g == null) {
                EditorPlugin.DBG.warning("indicator - graphics null");
            }
            g.setBackground(this.xorColor);
            g.setXORMode(true);
            if (orientation == 0) {
                if (direction == 1) {
                    g.fillRectangle(pos, pix, w, Math.abs(pix - oldPix));
                } else {
                    g.fillRectangle(pos, oldPix, w, Math.abs(pix - oldPix));
                }
            } else if (direction == 1) {
                g.fillRectangle(pix, pos, Math.abs(pix - oldPix), w);
            } else {
                g.fillRectangle(oldPix, pos, Math.abs(pix - oldPix), w);
            }
            g.setXORMode(false);
        } else if (this.value != this.oldValue) {
            if (orientation == 0) {
                g.setClipping(pos, 0, w, size_height);
            } else {
                g.setClipping(0, pos, size_width, w);
            }
            g.drawImage(backBuffer, 0, 0);
            g.setClipping(0, 0, size_width, size_height);
            g.setBackground(this.xorColor);
            g.setXORMode(true);
            if (orientation == 0) {
                if (direction == 1) {
                    g.fillRectangle(pos, pix, w, Math.abs(pix - oldPix));
                } else {
                    g.fillRectangle(pos, oldPix, w, Math.abs(pix - oldPix));
                }
            } else if (direction == 1) {
                g.fillRectangle(pix, pos, Math.abs(pix - oldPix), w);
            } else {
                g.fillRectangle(oldPix, pos, Math.abs(pix - oldPix), w);
            }
            g.setXORMode(false);
        }
    }

    public void setXORColor() {
        int i;
        RGB rgb1 = this.color.getRGB();
        RGB rgb2 = this.slider.getBackground().getRGB();
        String[] color1BinaryString = new String[]{Integer.toBinaryString(rgb1.red), Integer.toBinaryString(rgb1.green), Integer.toBinaryString(rgb1.blue)};
        String[] color2BinaryString = new String[]{Integer.toBinaryString(rgb2.red), Integer.toBinaryString(rgb2.green), Integer.toBinaryString(rgb2.blue)};
        for (i = 0; i < 3; ++i) {
            while (color1BinaryString[i].length() < 8) {
                color1BinaryString[i] = "0" + color1BinaryString[i];
            }
        }
        for (i = 0; i < 3; ++i) {
            while (color2BinaryString[i].length() < 8) {
                color2BinaryString[i] = "0" + color2BinaryString[i];
            }
        }
        StringBuffer[] color3BinaryStringBuffer = new StringBuffer[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            color3BinaryStringBuffer[i2] = new StringBuffer();
            char[] color1CharArray = color1BinaryString[i2].toCharArray();
            char[] color2CharArray = color2BinaryString[i2].toCharArray();
            for (int j = 0; j < color1BinaryString[i2].length(); ++j) {
                int color3BitValue = 0;
                if (color1CharArray[j] != color2CharArray[j]) {
                    color3BitValue = 1;
                }
                color3BinaryStringBuffer[i2].append(String.valueOf(color3BitValue));
            }
        }
        this.xorColor = new Color((Device)this.slider.getDisplay(), new RGB(Integer.parseInt(color3BinaryStringBuffer[0].toString(), 2), Integer.parseInt(color3BinaryStringBuffer[1].toString(), 2), Integer.parseInt(color3BinaryStringBuffer[2].toString(), 2)));
    }

    public void dispose() {
        if (this.xorColor != null) {
            this.xorColor.dispose();
        }
    }
}

