/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBESortUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerSortPrefPage
implements SelectionListener {
    private CBESortUI _options;
    private IPreferenceStore _preferenceStore;
    private boolean sortHasChanged = false;

    public LogAnalyzerSortPrefPage(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        composite.setLayoutData((Object)data);
        this._options = new CBESortUI();
        this._options.createControl(composite);
        this._options.addListener(this);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACTLOG_PREF_SORT_RECORDS);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LogUIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this._options.initializeValues(true);
    }

    private void initializeValues() {
        this._options.initializeValues(false);
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        this._options.removeListener(this);
        LogUIPlugin.getDefault().savePluginPreferences();
        if (this.sortHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(4, this));
        }
        this.sortHasChanged = false;
        return true;
    }

    public void performApply() {
        this._options.applyValues(this._preferenceStore);
        LogUIPlugin.getDefault().savePluginPreferences();
        if (this.sortHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(4, this));
        }
        this.sortHasChanged = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.data != null && e.data instanceof Integer && (Integer)e.data == 4) {
            this.sortHasChanged = true;
        }
    }

    private void storeValues() {
        this._options.storeValues(this._preferenceStore);
    }
}

