/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.Splitter;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.log.ui.internal.views.LogAnalysisPageBook;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPaneTreeViewer;
import org.eclipse.hyades.log.ui.internal.views.LogRecordPageBook;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogViewerUI
implements SelectionListener,
ControlListener,
IViewSelectionChangedListener {
    private TraceViewerPage fPage;
    private LogPaneTreeViewer fTreeViewer;
    private Composite fParent;
    private ViewForm logPane;
    private ViewForm analPane;
    private LogRecordPageBook genRecPage;
    private LogAnalysisPageBook genAnalPage;
    private Splitter hSplitter;
    private ViewForm recPane;
    static final int SASH_WIDTH = 2;
    private Composite viewContainer;
    private Sash vSash;
    private String _viewerRole;
    private double viewerProp = 0.4;

    public LogViewerUI(Composite parent, TraceViewerPage page, String role) {
        this.fPage = page;
        this._viewerRole = role;
        this.fParent = parent;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent event) {
        this.resizeContent();
    }

    private Control createTreeControl(Composite parent) {
        this.fTreeViewer = new LogPaneTreeViewer(this, parent, this._viewerRole);
        this.fTreeViewer.setMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                LogViewerUI.this.fillTreeContextMenu(menu);
            }
        });
        this.fTreeViewer.setContentProvider((IContentProvider)new LogContentProvider(this.logPane, (LogViewer)this.fPage.getTraceViewer()));
        LogLabelProvider labelProvider = new LogLabelProvider();
        DecoratingLabelProvider decLabel = new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)decLabel);
        MenuManager menuMgr = new MenuManager("TreeViewContextMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                LogViewerUI.this.fillTreeContextMenu(menu);
            }
        });
        Menu fContextMenu = menuMgr.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(fContextMenu);
        IWorkbenchPartSite site = this.fPage.getTraceViewer().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fTreeViewer);
        site.setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this.fTreeViewer.getControl();
    }

    private void fillTreeContextMenu(IMenuManager menu) {
        this.fTreeViewer.fillContextMenu(menu);
    }

    public Control getControl() {
        return this.viewContainer;
    }

    void layout() {
        Rectangle viewBounds = this.viewContainer.getClientArea();
        Rectangle vSashBounds = this.vSash.getBounds();
        this.logPane.setBounds(0, 0, vSashBounds.x, viewBounds.height);
        this.hSplitter.setBounds(vSashBounds.x + vSashBounds.width, 0, viewBounds.width - (vSashBounds.x + vSashBounds.width), viewBounds.height);
    }

    public void initialize() {
        this.viewContainer = new Composite(this.fParent, 0);
        this.viewContainer.setLayoutData((Object)GridUtil.createFill());
        this.logPane = new ViewForm(this.viewContainer, 0);
        Control viewerControl = this.createTreeControl((Composite)this.logPane);
        this.logPane.setContent(viewerControl);
        this.hSplitter = new Splitter(this.viewContainer, 512, true);
        this.vSash = new Sash(this.viewContainer, 512);
        this.vSash.addSelectionListener((SelectionListener)this);
        this.viewContainer.addControlListener((ControlListener)this);
        ViewForm recPane = new ViewForm((Composite)this.hSplitter, 0);
        recPane.setLayoutData((Object)new Splitter.Weight(500));
        this.genRecPage = new LogRecordPageBook((Composite)recPane, 0);
        recPane.setContent((Control)this.genRecPage);
        this.hSplitter.addSash();
        ViewForm analPane = new ViewForm((Composite)this.hSplitter, 0);
        analPane.setLayoutData((Object)new Splitter.Weight(500));
        this.genAnalPage = new LogAnalysisPageBook((Composite)analPane, 0);
        analPane.setContent((Control)this.genAnalPage);
        this.genRecPage.setAnalysisPageBook(this.genAnalPage);
        this.genRecPage.addSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.addSelectionChangedListener(this.genRecPage);
        this.fTreeViewer.addSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.addSelectionListener(this);
        WorkbenchHelp.setHelp((Control)this.logPane, (String)ContextIds.ACTLOG_VIEW_PANE_LOG);
        WorkbenchHelp.setHelp((Control)recPane, (String)ContextIds.ACTLOG_VIEW_PANE_RECORD);
        WorkbenchHelp.setHelp((Control)analPane, (String)ContextIds.ACTLOG_VIEW_PANE_ANALYSIS);
        CLabel label = new CLabel((Composite)this.logPane, 0);
        this.logPane.setTopLeft((Control)label);
        label.setText(LogUIPlugin.getResourceString("STR_LOG_PANE_TITLE"));
        this.fTreeViewer.setInput(this.fPage.getMOFObject());
        Object sel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
        if (sel != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(sel));
        }
    }

    public void resizeContent() {
        Rectangle viewBounds = this.viewContainer.getClientArea();
        if (viewBounds.height == 0) {
            return;
        }
        Rectangle treeBounds = new Rectangle(0, 0, (int)Math.round((double)(viewBounds.width - 2) * this.viewerProp), viewBounds.height);
        this.logPane.setBounds(treeBounds.x, treeBounds.y, treeBounds.width, treeBounds.height);
        Rectangle analBounds = new Rectangle(treeBounds.width + 2, 0, viewBounds.width - (treeBounds.width + 2), treeBounds.height);
        this.hSplitter.setBounds(analBounds);
        this.vSash.setBounds(treeBounds.width, 0, 2, treeBounds.height);
        this.genRecPage.getTableControl().getControl().redraw();
        this.fTreeViewer.getControl().redraw();
    }

    public void update() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        EObject sel;
        Object data = e.item.getData();
        if (e.item instanceof TreeItem && data instanceof TerminalNode && (sel = ((TerminalNode)data).getParent()) != null) {
            this.revealObject(sel);
            LogUtil.notifyViewSelectionChanged(this, sel);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.vSash && e.detail != 1) {
            this.vSash.setBounds(e.x, e.y, e.width, e.height);
            this.layout();
            Rectangle viewBounds = this.viewContainer.getClientArea();
            Rectangle vSashBounds = this.vSash.getBounds();
            this.viewerProp = 1.0 - (double)(viewBounds.width - vSashBounds.x) / (double)viewBounds.width;
        }
        if (e.item instanceof TreeItem && e.item.getData() != null) {
            LogUtil.notifyViewSelectionChanged(this, e.item.getData());
        }
    }

    private void refreshSelection() {
        if (this.genRecPage != null && this.genRecPage.getTableControl() != null) {
            Object sel = null;
            ISelection selection = this.fTreeViewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                sel = ((IStructuredSelection)selection).getFirstElement();
            }
            this.genRecPage.getTableControl().getControl().setRedraw(false);
            this.genRecPage.getTableControl().setInput(sel);
            this.genRecPage.getTableControl().getControl().setRedraw(true);
            if (this.genAnalPage != null && sel == null) {
                this.genAnalPage.setRedraw(false);
                this.genAnalPage.setInputNull();
                this.genAnalPage.setRedraw(true);
            }
        }
    }

    public void dispose() {
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this.genRecPage.removeSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.removeSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.removeSelectionChangedListener(this.genRecPage);
        this.fTreeViewer.dispose();
        if (this.genRecPage != null) {
            this.genRecPage.dispose();
        }
        this.genRecPage = null;
        if (this.genAnalPage != null) {
            this.genAnalPage.dispose();
        }
        this.genAnalPage = null;
        if (this.logPane != null) {
            this.logPane.dispose();
        }
        this.logPane = null;
        if (this.recPane != null) {
            this.recPane.dispose();
        }
        this.recPane = null;
        if (this.analPane != null) {
            this.analPane.dispose();
        }
        this.analPane = null;
        if (this.hSplitter != null) {
            this.hSplitter.dispose();
        }
        this.hSplitter = null;
        if (this.viewContainer != null && !this.viewContainer.isDisposed()) {
            this.viewContainer.dispose();
        }
        this.viewContainer = null;
        if (this.vSash != null) {
            this.vSash.dispose();
        }
        this.vSash = null;
        this.fTreeViewer = null;
        this.fPage = null;
    }

    public LogPaneTreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public void refresh() {
        if (this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed() && this.fTreeViewer.getControl().isVisible()) {
            this.fTreeViewer.refresh();
            this.refreshSelection();
        }
    }

    public void selectionChanged() {
    }

    public TraceViewerPage getFPage() {
        return this.fPage;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this && this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed()) {
            this.updateSelectionFromModel();
        }
    }

    public void updateSelectionFromModel() {
        Object selection = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
        if (selection != null && selection instanceof EObject) {
            this.revealObject((EObject)selection);
        }
    }

    public void revealObject(EObject selection) {
        if (((LogContentProvider)this.fTreeViewer.getContentProvider()).revealObject(selection)) {
            this.update();
        }
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
    }
}

