/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvironmentDialog;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class LaunchProcessUI
extends AbstractChangeable
implements SelectionListener {
    private Composite _classGroup;
    private Composite _paramGroup;
    private Text _classname;
    private Text _parameters;
    private Text _classpath;
    private Text _vmArgs;
    private Button _browseClass;
    private Button _browseDirPath;
    private Button _browseJarPath;
    private Button _envButton;
    private ArrayList _envData;
    private boolean _envEditEnable;
    private Shell shell;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            LaunchProcessUI.this.changed();
        }
    };

    public LaunchProcessUI() {
        this._envData = new ArrayList();
    }

    public Composite createArgumentsControl(Composite parent) {
        this._paramGroup = new Composite(parent, 0);
        this._paramGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        GridData gd = GridUtil.createFill();
        this._paramGroup.setLayoutData((Object)gd);
        this._paramGroup.setLayout((Layout)layout);
        Label label = new Label(this._paramGroup, 0);
        gd = new GridData();
        gd.verticalAlignment = 1;
        label.setText(UIPlugin.getResourceString("CLASSPATH"));
        label.setLayoutData((Object)gd);
        Composite pathGroup = new Composite(this._paramGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        gd = GridUtil.createHorizontalFill();
        pathGroup.setLayoutData((Object)gd);
        pathGroup.setLayout((Layout)layout);
        this._classpath = new Text(pathGroup, 2882);
        gd = GridUtil.createFill();
        gd.heightHint = 50;
        gd.widthHint = 90;
        this._classpath.setLayoutData((Object)gd);
        this._classpath.addListener(24, this._listener);
        Composite btnGroup = new Composite(pathGroup, 0);
        gd = GridUtil.createVerticalFill();
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayoutData((Object)gd);
        btnGroup.setLayout((Layout)layout);
        this._browseDirPath = new Button(btnGroup, 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this._browseDirPath.setLayoutData((Object)gd);
        this._browseDirPath.setText(UIPlugin.getResourceString("ADD_DIRECTORY"));
        this._browseJarPath = new Button(btnGroup, 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 2;
        this._browseJarPath.setLayoutData((Object)gd);
        this._browseJarPath.setText(UIPlugin.getResourceString("ADD_JAR"));
        label = new Label(btnGroup, 0);
        label = new Label(this._paramGroup, 0);
        label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PARAMETER"));
        this._parameters = new Text(this._paramGroup, 2052);
        gd = GridUtil.createHorizontalFill();
        gd.widthHint = 100;
        this._parameters.setLayoutData((Object)gd);
        this._parameters.addListener(24, this._listener);
        label = new Label(this._paramGroup, 0);
        label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_VM_ARGS"));
        this._vmArgs = new Text(this._paramGroup, 2052);
        gd = GridUtil.createHorizontalFill();
        gd.widthHint = 100;
        this._vmArgs.setLayoutData((Object)gd);
        this._vmArgs.addListener(24, this._listener);
        this._envButton = new Button(this._paramGroup, 0);
        gd = GridUtil.createHorizontalFill();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 3;
        this._envButton.setLayoutData((Object)gd);
        this._envButton.setText(UIPlugin.getResourceString("ENV_VARIABLE_BUTTON"));
        this._browseDirPath.addSelectionListener((SelectionListener)this);
        this._browseJarPath.addSelectionListener((SelectionListener)this);
        this._envButton.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._classpath, (String)(UIPlugin.getPluginId() + ".lpui0001"));
        WorkbenchHelp.setHelp((Control)this._parameters, (String)(UIPlugin.getPluginId() + ".lpui0005"));
        WorkbenchHelp.setHelp((Control)this._vmArgs, (String)(UIPlugin.getPluginId() + ".lpui0006"));
        return this._paramGroup;
    }

    public Composite createClassControl(Composite parent) {
        this._classGroup = new Composite(parent, 0);
        this._classGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        this._classGroup.setLayout((Layout)layout);
        Label label = new Label(this._classGroup, 0);
        label.setText(UIPlugin.getResourceString("CLASS_NAME"));
        this._classname = new Text(this._classGroup, 2052);
        this._classname.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._classname.addListener(24, this._listener);
        this._browseClass = new Button(this._classGroup, 0x1000008);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this._browseClass.setLayoutData((Object)gd);
        this._browseClass.setText(UIPlugin.getResourceString("BROWSE"));
        this._browseClass.addSelectionListener((SelectionListener)this);
        this._classname.setFocus();
        WorkbenchHelp.setHelp((Control)this._classname, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        return this._classGroup;
    }

    public Composite createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        gd.horizontalIndent = 20;
        content.setLayoutData((Object)gd);
        this.createClassControl(content);
        this.createArgumentsControl(content);
        this._classname.setFocus();
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        WorkbenchHelp.setHelp((Control)content, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        return content;
    }

    public void setLocalButtons(boolean local) {
        this.getBrowseClassButton().setEnabled(local);
        this.getBrowseDirButton().setEnabled(local);
        this.getBrowseJarButton().setEnabled(local);
    }

    public void enable(boolean enable) {
        this.enableButtons(enable);
        this.enableText(enable);
    }

    private void enableButtons(boolean enable) {
        this._browseClass.setEnabled(enable);
        this._browseDirPath.setEnabled(enable);
        this._browseJarPath.setEnabled(enable);
        this._envButton.setEnabled(enable);
        this._envEditEnable = enable;
    }

    private void enableText(boolean enable) {
        this._classname.setEnabled(enable);
        this._classname.setEditable(enable);
        this._parameters.setEnabled(enable);
        this._parameters.setEditable(enable);
        this._classpath.setEnabled(enable);
        this._classpath.setEditable(enable);
        this._vmArgs.setEnabled(enable);
        this._vmArgs.setEditable(enable);
    }

    public Composite getClassGroup() {
        return this._classGroup;
    }

    public String getClassName() {
        return this._classname.getText().trim();
    }

    public String getClassPath() {
        return this._classpath.getText().trim();
    }

    public Text getClassPathUI() {
        return this._classpath;
    }

    public Text getClassUI() {
        return this._classname;
    }

    public Control getBrowseClassButton() {
        return this._browseClass;
    }

    public Control getBrowseJarButton() {
        return this._browseJarPath;
    }

    public Control getBrowseDirButton() {
        return this._browseDirPath;
    }

    public Control getEnvButton() {
        return this._envButton;
    }

    public String getParameters() {
        return this._parameters.getText().trim();
    }

    public Text getParametersUI() {
        return this._parameters;
    }

    public String getVMArgs() {
        return this._vmArgs.getText().trim();
    }

    public Text getVMArgsUI() {
        return this._vmArgs;
    }

    public ArrayList getEnvData() {
        return this._envData;
    }

    public void setClassName(String name) {
        this._classname.setText(name);
    }

    public void setClassPath(String path) {
        this._classpath.setText(path);
    }

    public void setProgramArgs(String args) {
        this._parameters.setText(args);
    }

    public void setVMArgs(String args) {
        this._vmArgs.setText(args);
    }

    public void setEnvData(ArrayList envData) {
        this._envData = envData;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.shell == null) {
            this.shell = UIPlugin.getActiveWorkbenchWindow().getShell();
        }
        String osName = System.getProperty("os.name");
        if (e.widget == this._browseClass) {
            FileDialog dlg = new FileDialog(this.shell);
            dlg.setFilterExtensions(new String[]{"*.class"});
            dlg.open();
            String fileName = dlg.getFileName();
            if (fileName != null && !fileName.equals("")) {
                String oldClassPath;
                if (fileName.endsWith(".class")) {
                    fileName = fileName.substring(0, fileName.length() - 6);
                }
                this._classname.setText(fileName);
                String classpath = dlg.getFilterPath();
                if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                    classpath = classpath + "\\";
                }
                oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                this._classpath.setText(oldClassPath + classpath);
            }
        } else if (e.widget == this._browseDirPath) {
            DirectoryDialog dlg = new DirectoryDialog(this.shell);
            String classpath = dlg.open();
            if (classpath != null && !classpath.equals("")) {
                String oldClassPath;
                if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                    classpath = classpath + "\\";
                }
                oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                classpath = oldClassPath + classpath;
                this._classpath.setText(classpath);
                this._classpath.setFocus();
            }
        } else if (e.widget == this._browseJarPath) {
            FileDialog dlg = new FileDialog(this.shell);
            dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
            dlg.open();
            String classpath = dlg.getFileName();
            if (classpath != null && !classpath.equals("")) {
                classpath = dlg.getFilterPath() + File.separator + classpath;
                String oldClassPath = this._classpath.getText().trim();
                oldClassPath = oldClassPath.equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                classpath = oldClassPath + classpath;
                this._classpath.setText(classpath);
            }
        } else if (e.widget == this._envButton) {
            EnvironmentDialog dialog = new EnvironmentDialog(this._envButton.getShell(), UIPlugin.getResourceString("ENV_VARIABLE_TEXT"), this._envData, this._envEditEnable);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                if (this._envData == null) {
                    this._envData = new ArrayList();
                }
                this._envData.clear();
                this._envData.addAll(dialog.getData());
            }
        }
        this.changed();
    }
}

