/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceProfileOptionsUI
extends AbstractChangeable
implements SelectionListener,
ModifyListener {
    private Button _appHeapBtn;
    private Label _appHeapLabel;
    private Button _heapAdvanced;
    private Composite _detailsHeapGroup;
    private Button _showHeapInstance;
    private Button _appExecBtn;
    private Label _appExecLabel;
    private Button _boundary;
    private Label _traceDepthLabel;
    private Text _traceDepth;
    private Button _execAdvanced;
    private Composite _detailsExecGroup;
    private Button _showExecStatistic;
    private Button _showExecFlow;
    private Button _appCoverageBtn;
    private Label _appCoverageLabel;
    private boolean _enableHeap = false;
    private WizardPage wizardPage;
    private PreferencePage preferencePage;
    private String options;

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        GridData data = GridUtil.createFill();
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)data);
        Composite grp = new Composite(result, 0);
        data = GridUtil.createHorizontalFill();
        layout = new GridLayout();
        layout.numColumns = 1;
        grp.setLayout((Layout)layout);
        grp.setLayoutData((Object)data);
        this._appHeapBtn = new Button(grp, 32);
        this._appHeapBtn.setText(UIPlugin.getResourceString("STR_TOO_MUCH_MEMORY"));
        this._appHeapBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._appHeapLabel = new Label(grp, 64);
        this._appHeapLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
        data = new GridData();
        data.horizontalIndent = 20;
        data.widthHint = 375;
        this._appHeapLabel.setLayoutData((Object)data);
        this._heapAdvanced = new Button(grp, 0);
        this._heapAdvanced.setText(UIPlugin.getResourceString("SHOW_DET"));
        this.addHeapOption(grp);
        this._detailsHeapGroup.setVisible(false);
        this._heapAdvanced.addSelectionListener((SelectionListener)this);
        this._appExecBtn = new Button(grp, 32);
        this._appExecBtn.setText(UIPlugin.getResourceString("STR_APP_TOO_SLOW"));
        this._appExecBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._appExecLabel = new Label(grp, 64);
        this._appExecLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
        data = new GridData();
        data.horizontalIndent = 20;
        data.widthHint = 375;
        this._appExecLabel.setLayoutData((Object)data);
        this._execAdvanced = new Button(grp, 0);
        this._execAdvanced.setText(UIPlugin.getResourceString("SHOW_DET2"));
        this.addExecutionOption(grp);
        this._detailsExecGroup.setVisible(false);
        this._appCoverageBtn = new Button(grp, 32);
        this._appCoverageBtn.setText(UIPlugin.getResourceString("STR_APP_COVERAGE"));
        this._appCoverageBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._appCoverageLabel = new Label(grp, 64);
        this._appCoverageLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_COVERAGE"));
        data = new GridData();
        data.horizontalIndent = 20;
        data.widthHint = 375;
        this._appCoverageLabel.setLayoutData((Object)data);
        this._execAdvanced.addSelectionListener((SelectionListener)this);
        this._appHeapBtn.addSelectionListener((SelectionListener)this);
        this._appExecBtn.addSelectionListener((SelectionListener)this);
        return result;
    }

    private void addHeapOption(Composite parent) {
        this._detailsHeapGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 20;
        this._detailsHeapGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this._detailsHeapGroup.setLayout((Layout)layout);
        this._showHeapInstance = new Button(this._detailsHeapGroup, 32);
        this._showHeapInstance.setText(UIPlugin.getResourceString("STR_SHOW_INST_LEVEL_INFO"));
        WorkbenchHelp.setHelp((Control)this._showHeapInstance, (String)(UIPlugin.getPluginId() + ".topp0011"));
    }

    private void addExecutionOption(Composite parent) {
        this._detailsExecGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 20;
        this._detailsExecGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this._detailsExecGroup.setLayout((Layout)layout);
        this._boundary = new Button(this._detailsExecGroup, 32);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._boundary.setLayoutData((Object)data);
        this._boundary.setText(UIPlugin.getResourceString("AGENT_UI_BOUNDARY_CLASS"));
        this._traceDepthLabel = new Label(this._detailsExecGroup, 0);
        this._traceDepthLabel.setText(UIPlugin.getResourceString("STR_COLLECT_DEPTH"));
        this._traceDepth = new Text(this._detailsExecGroup, 2048);
        data = new GridData();
        data.widthHint = 70;
        this._traceDepth.setLayoutData((Object)data);
        Group _showExecGroup = new Group(this._detailsExecGroup, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        _showExecGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        _showExecGroup.setLayout((Layout)layout);
        this._showExecStatistic = new Button((Composite)_showExecGroup, 16);
        this._showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
        this._showExecFlow = new Button((Composite)_showExecGroup, 16);
        this._showExecFlow.setText(UIPlugin.getResourceString("DETAILED_DATA"));
        this._boundary.addSelectionListener((SelectionListener)this);
        this._traceDepth.addModifyListener((ModifyListener)this);
        WorkbenchHelp.setHelp((Control)this._boundary, (String)(UIPlugin.getPluginId() + ".topp0002"));
        WorkbenchHelp.setHelp((Control)this._traceDepth, (String)(UIPlugin.getPluginId() + ".topp0008"));
    }

    public void enable(boolean enable) {
        this._appHeapBtn.setEnabled(enable);
        this._appHeapLabel.setEnabled(this._appHeapBtn.getEnabled());
        this._appExecBtn.setEnabled(enable);
        this._appExecLabel.setEnabled(this._appExecBtn.getEnabled());
        this._appCoverageBtn.setEnabled(enable);
        this._appCoverageLabel.setEnabled(this._appCoverageBtn.getEnabled());
        this._showHeapInstance.setEnabled(this._appHeapBtn.getEnabled());
        this.enableExecutionButtons(this._appExecBtn.getEnabled());
    }

    public void enableExecutionButtons(boolean enable) {
        this._boundary.setEnabled(enable);
        this._traceDepth.setEnabled(enable);
        this._traceDepthLabel.setEnabled(enable);
        this._showExecStatistic.setEnabled(enable);
        this._showExecFlow.setEnabled(enable);
    }

    public void enableButtons() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this.setHeap(store.getBoolean("prof_heap_stat"));
        this.setHeapDetails(store.getBoolean("prof_heap_inst"));
        this.setExecution(store.getBoolean("prof_execution"));
        this.setExecutionBoundary(store.getBoolean("prof_execution_boundary"));
        this.setCollectionDepth(store.getString("collect_depth"));
        this.setExecutionStatistic(store.getBoolean("prof_exec_stat"));
        this.setExecutionFlow(!store.getBoolean("prof_exec_stat"));
        this.setCoverage(store.getBoolean("prof_coverage"));
        this.enableBtnGroup();
    }

    public void enableBtnGroup() {
        this.enableHeptBtnGroup();
        this.enableExecutionBtnGroup();
    }

    private void enableHeptBtnGroup() {
        this._showHeapInstance.setEnabled(this._appHeapBtn.getSelection());
    }

    private void enableExecutionBtnGroup() {
        if (this._appExecBtn.getSelection()) {
            this._boundary.setEnabled(true);
            this._showExecFlow.setEnabled(true);
            this._showExecStatistic.setEnabled(true);
        } else {
            this._boundary.setEnabled(false);
            this._boundary.setSelection(false);
            this._showExecFlow.setEnabled(false);
            this._showExecStatistic.setEnabled(false);
        }
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void enableHeapInfo(boolean enable) {
        this._enableHeap = enable;
        if (!enable) {
            this._appHeapBtn.setEnabled(false);
            this._showHeapInstance.setEnabled(false);
        }
    }

    public Vector getOptions() {
        AgentConfigurationEntry entry;
        int idx;
        String[][] execution;
        Vector<AgentConfigurationEntry> options = new Vector<AgentConfigurationEntry>();
        if (!this.getHeap()) {
            execution = Options.OPTIONS_ANALYZE_HEAP_NONE;
            for (idx = 0; idx < execution.length; ++idx) {
                entry = new AgentConfigurationEntry();
                entry.setName(execution[idx][0]);
                entry.setValue(execution[idx][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        } else {
            execution = Options.OPTIONS_ANALYZE_HEAP;
            for (idx = 0; idx < execution.length; ++idx) {
                entry = new AgentConfigurationEntry();
                entry.setName(execution[idx][0]);
                entry.setValue(execution[idx][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        }
        if (this.getHeap() && !this.getExecution()) {
            execution = Options.OPTIONS_EXECUTION_FLOW_NONE;
            for (idx = 0; idx < execution.length; ++idx) {
                entry = new AgentConfigurationEntry();
                entry.setName(execution[idx][0]);
                entry.setValue(execution[idx][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
            return options;
        }
        if (this.getExecutionBoundary()) {
            String[][] executionBoundary = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
            for (idx = 0; idx < executionBoundary.length; ++idx) {
                entry = new AgentConfigurationEntry();
                entry.setName(executionBoundary[idx][0]);
                entry.setValue(executionBoundary[idx][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
            AgentConfigurationEntry entry2 = new AgentConfigurationEntry();
            entry2.setName("BOUNDARY_DEPTH");
            entry2.setValue(String.valueOf(this.getCollectionDepth()));
            entry2.setType("SETOPTION");
            options.addElement(entry2);
        } else if (this.getExecution()) {
            execution = Options.OPTIONS_EXECUTION_FLOW;
            for (idx = 0; idx < execution.length; ++idx) {
                entry = new AgentConfigurationEntry();
                entry.setName(execution[idx][0]);
                entry.setValue(execution[idx][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        } else {
            execution = Options.OPTIONS_EXECUTION_FLOW_NONE;
            for (idx = 0; idx < execution.length; ++idx) {
                entry = new AgentConfigurationEntry();
                entry.setName(execution[idx][0]);
                entry.setValue(execution[idx][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        }
        if (this.getExecution() && !this.getHeap()) {
            String[][] heapInfo = Options.OPTIONS_NO_INSTANCE_INFORMATION;
            for (int idx2 = 0; idx2 < heapInfo.length; ++idx2) {
                entry = new AgentConfigurationEntry();
                entry.setName(heapInfo[idx2][0]);
                entry.setValue(heapInfo[idx2][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        }
        if (this.getCoverage()) {
            String[][] coverageInfo = Options.OPTIONS_COVERAGE_NO_FLOW;
            if (this.getExecution()) {
                coverageInfo = Options.OPTIONS_COVERAGE;
            }
            for (int idx3 = 0; idx3 < coverageInfo.length; ++idx3) {
                entry = new AgentConfigurationEntry();
                entry.setName(coverageInfo[idx3][0]);
                entry.setValue(coverageInfo[idx3][1]);
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        }
        return options;
    }

    private boolean checkValidTraceDepth() {
        if (this._boundary.getSelection()) {
            String text = this._traceDepth.getText().trim();
            try {
                if (Integer.parseInt(text) <= 0) {
                    return false;
                }
            }
            catch (Exception exc) {
                return false;
            }
        }
        return true;
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() == this._traceDepth) {
            this.checkNumbersAndPrintErrorMsg();
        }
    }

    public boolean getHeap() {
        return this._appHeapBtn.getSelection();
    }

    public boolean getHeapDetails() {
        return this._showHeapInstance.getSelection();
    }

    public boolean getExecution() {
        return this._appExecBtn.getSelection();
    }

    public boolean getExecutionStatistic() {
        return this._showExecStatistic.getSelection();
    }

    public boolean getExecutionFlow() {
        return this._showExecFlow.getSelection();
    }

    public boolean getExecutionBoundary() {
        return this._boundary.getSelection();
    }

    public int getCollectionDepth() {
        String text = this._traceDepth.getText().trim();
        try {
            int depth = Integer.parseInt(text);
            if (depth > 0) {
                return depth;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
        catch (Exception exc) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
    }

    public void setHeap(boolean setValue) {
        this._appHeapBtn.setSelection(setValue);
    }

    public void setHeapDetails(boolean setValue) {
        this._showHeapInstance.setSelection(setValue);
    }

    public void setExecution(boolean select) {
        this._appExecBtn.setSelection(select);
    }

    public void setExecutionStatistic(boolean select) {
        this._showExecStatistic.setSelection(select);
    }

    public void setExecutionFlow(boolean select) {
        this._showExecFlow.setSelection(select);
    }

    public void setExecutionBoundary(boolean setValue) {
        this._boundary.setSelection(setValue);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void setCollectionDepth(String value) {
        this._traceDepth.setText(value);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._appHeapBtn) {
            this._showHeapInstance.setEnabled(this._appHeapBtn.getSelection());
            if (!this._showHeapInstance.getEnabled()) {
                this._showHeapInstance.setSelection(false);
            }
        } else if (event.widget == this._appExecBtn) {
            this.enableExecutionBtnGroup();
        } else if (event.widget == this._boundary) {
            this._traceDepth.setEnabled(this._boundary.getSelection());
            this._traceDepthLabel.setEnabled(this._boundary.getSelection());
        } else if (event.widget == this._execAdvanced) {
            this._detailsExecGroup.setVisible(!this._detailsExecGroup.getVisible());
            if (this._detailsExecGroup.getVisible()) {
                this._execAdvanced.setText(UIPlugin.getResourceString("HIDE_DET2"));
            } else {
                this._execAdvanced.setText(UIPlugin.getResourceString("SHOW_DET2"));
            }
            this._execAdvanced.pack();
        } else if (event.widget == this._heapAdvanced) {
            this._detailsHeapGroup.setVisible(!this._detailsHeapGroup.getVisible());
            if (this._detailsHeapGroup.getVisible()) {
                this._heapAdvanced.setText(UIPlugin.getResourceString("HIDE_DET"));
            } else {
                this._heapAdvanced.setText(UIPlugin.getResourceString("SHOW_DET"));
            }
            this._heapAdvanced.pack();
        }
        this.checkNumbersAndPrintErrorMsg();
    }

    public void checkNumbersAndPrintErrorMsg() {
        if (this.wizardPage != null) {
            if (!this.checkValidTraceDepth()) {
                this.wizardPage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_BOUND_VALUE"));
                this.wizardPage.setPageComplete(false);
            } else {
                this.wizardPage.setErrorMessage(null);
                this.wizardPage.setPageComplete(true);
            }
        } else if (this.preferencePage != null) {
            if (!this.checkValidTraceDepth()) {
                this.preferencePage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_BOUND_VALUE"));
                this.preferencePage.setValid(false);
            } else {
                this.preferencePage.setErrorMessage(null);
                this.preferencePage.setValid(true);
            }
        }
    }

    public void storeValues() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        store.setValue("prof_heap_stat", this.getHeap());
        store.setValue("prof_heap_inst", this.getHeapDetails());
        store.setValue("prof_execution", this.getExecution());
        store.setValue("prof_execution_boundary", this.getExecutionBoundary());
        store.setValue("collect_depth", this.getCollectionDepth());
        store.setValue("prof_exec_stat", this.getExecutionStatistic());
        store.setValue("prof_coverage", this.getCoverage());
    }

    public void setWizardPage(WizardPage page) {
        this.wizardPage = page;
    }

    public void setPreferencePage(PreferencePage page) {
        this.preferencePage = page;
    }

    public boolean getCoverage() {
        return this._appCoverageBtn.getSelection();
    }

    public void setCoverage(boolean select) {
        this._appCoverageBtn.setSelection(select);
    }

    public String getOptionsElement() {
        return this.options;
    }
}

