/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileHostTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProfileMainTab
extends AbstractLaunchConfigurationTab {
    private LaunchProcessUI _ui;
    private ProfileHostTab _hostTab;

    public ProfileMainTab(ProfileHostTab hostTab) {
        this._hostTab = hostTab;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(content, 1);
        this._ui = new LaunchProcessUI();
        this._ui.createControl(content);
        this._ui.enable(true);
        this._ui.setLocalButtons(this._hostTab.isLocal());
        this._ui.addListener(new Listener(){

            public void handleEvent(Event event) {
                ProfileMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this._ui.enable(true);
        this._ui.setLocalButtons(this._hostTab.isLocal());
        try {
            String className = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, "");
            String programArgs = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            String vmArgs = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            ArrayList<EnvTableElement> env = new ArrayList<EnvTableElement>();
            Map map = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, (Map)null);
            if (map != null) {
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    env.add(new EnvTableElement(key, (String)map.get(key)));
                }
            }
            this._ui.setClassName(className);
            this._ui.setClassPath(classPath);
            this._ui.setProgramArgs(programArgs);
            this._ui.setVMArgs(vmArgs);
            this._ui.setEnvData(env);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this._ui.getClassName());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, this._ui.getClassPath());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this._ui.getParameters());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this._ui.getVMArgs());
        HashMap<String, String> env = new HashMap<String, String>();
        Iterator iter = this._ui.getEnvData().iterator();
        while (iter.hasNext()) {
            EnvTableElement e = (EnvTableElement)iter.next();
            env.put(e.name(), e.value());
        }
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, env);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._ui.getClassName().trim().length() == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_MAIN"));
            return false;
        }
        if (this._ui.getClassPath().trim().length() == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_CLASSPATH"));
            return false;
        }
        return true;
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_MAIN");
    }

    public Image getImage() {
        return PDPluginImages.getImage("class_obj.gif");
    }
}

