/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ProfileDetailNavigatorExtension
implements INavigatorContribution {
    protected static final String getProfilingTypesExtPoint = "profilingTypes";
    private static Map profilingTypes;
    private Map typeItems = new HashMap();

    public boolean hasChildren(Object item) {
        return item instanceof TRCAgentProxy;
    }

    public List getChildren(Object item) {
        if (item instanceof TRCAgentProxy) {
            return this.getProfileDetailItems((TRCAgentProxy)item);
        }
        return new ArrayList(0);
    }

    public Collection getModifiedItems() {
        return new ArrayList(0);
    }

    public void fillContextMenu(IMenuManager menu, IStructuredSelection selection) {
    }

    private List getProfileDetailItems(TRCAgentProxy agentProxy) {
        Vector<INavigatorItem> details = new Vector<INavigatorItem>();
        if (profilingTypes == null) {
            this.initializeProfilingTypes();
        }
        EList configs = agentProxy.getConfigurations();
        for (int i = 0; i < configs.size(); ++i) {
            TRCConfiguration config = (TRCConfiguration)configs.get(i);
            EList options = config.getOptions();
            for (int opt = 0; opt < options.size(); ++opt) {
                TRCOption option = (TRCOption)options.get(opt);
                if (!option.getKey().startsWith(UIPlugin.getPluginId() + ".type") || option.getValue().length() <= 0) continue;
                details.add(this.getProfileDetailItem(agentProxy, option.getValue()));
            }
            if (details.size() > 0) break;
        }
        return details;
    }

    private ProfileDetailItem createProfileDetailItem(TRCAgentProxy agentProxy, String id) {
        IConfigurationElement elem = (IConfigurationElement)profilingTypes.get(id);
        URL url = elem.getDeclaringExtension().getDeclaringPluginDescriptor().find((IPath)new Path(elem.getAttribute("icon")));
        if (elem == null) {
            return null;
        }
        return new ProfileDetailItem(agentProxy, elem.getAttribute("name"), elem.getAttribute("id"), url);
    }

    private void initializeProfilingTypes() {
        profilingTypes = new HashMap();
        IExtensionPoint point = UIPlugin.getDefault().getDescriptor().getExtensionPoint(getProfilingTypesExtPoint);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            for (int i = 0; i < elements.length; ++i) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                if (id.length() == 0) continue;
                profilingTypes.put(id, elem);
            }
        }
    }

    public void dispose() {
    }

    private INavigatorItem getProfileDetailItem(TRCAgentProxy agent, String typeID) {
        Map agentTypeItems;
        Object typeItem;
        Object obj = this.typeItems.get(agent);
        if (obj == null) {
            obj = new HashMap(5);
            this.typeItems.put(agent, obj);
        }
        if ((typeItem = (agentTypeItems = (Map)obj).get(typeID)) == null) {
            ProfileDetailItem item = this.createProfileDetailItem(agent, typeID);
            agentTypeItems.put(typeID, item);
            return item;
        }
        return (INavigatorItem)typeItem;
    }
}

