/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentPeerListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.StartTraceActionDelegate;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.launcher.ILauncherHandler;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PIProcessListener
implements ProcessListener,
AgentPeerListener {
    protected ArrayList _monitoredAgents = new ArrayList();
    protected ArrayList _processVariableList = new ArrayList();
    protected TRCNode fNode;
    protected TRCProcessProxy fProcess;
    protected boolean _autoMonitoring = true;
    protected boolean _monitor = false;
    protected int _launchMode = 0;
    protected static final String getLauncherHandlersExtPoint = "launcherHandler";
    private static Map launcherHandlers;

    public PIProcessListener(TRCNode node) {
        this.fNode = node;
    }

    public PIProcessListener(TRCNode node, TRCProcessProxy process) {
        this(node);
        this.fProcess = process;
    }

    public void setAutoMonitoring(boolean b) {
        this._autoMonitoring = b;
    }

    public void setLaunchMode(int mode) {
        this._launchMode = mode;
    }

    public ArrayList getProcessVariableList() {
        return this._processVariableList;
    }

    public synchronized void agentActive(Agent ag) {
        if (this.fProcess == null) {
            return;
        }
        if (this._monitoredAgents.contains(ag.getName())) {
            this._monitor = false;
        } else {
            this._monitoredAgents.add(ag.getName());
        }
        if (!this._monitor) {
            return;
        }
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent(this.fProcess, ag, false);
        if (agentProxy == null) {
            return;
        }
        agentProxy.setRuntimeId(ag.getUUID());
        LoadersUtils.registerAgentInstance((TRCAgentProxy)agentProxy, (Object)ag);
        agentProxy.setAttached(true);
        agentProxy.setProfileFile(ag.getProfileFile());
        this.giveControl(agentProxy, true, true);
        if (agentProxy.isActive()) {
            final TRCAgentProxy agentTemp = agentProxy;
            Display d = Display.getDefault();
            d.asyncExec(new Runnable(){

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource(agentTemp);
                    event.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            return;
        }
        agentProxy.setActive(true);
        try {
            ag.publishConfiguration();
            CustomCommand command = new CustomCommand();
            command.setData("APPLYFILTERS");
            ag.invokeCustomCommand(command);
            XMLTraceDataProcessor processor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agentProxy);
            if (processor == null) {
                processor = new XMLTraceDataProcessor(agentProxy);
                LoadersUtils.registerDataProcessor((TRCAgentProxy)agentProxy, (XMLLoader)processor);
            }
            if (agentProxy.isToProfileFile()) {
                processor.setProfileFileName(agentProxy.getProfileFile());
                processor.createWriter();
                if (processor.isNewProfileFile()) {
                    processor.writeXMLVersion(processor.getWriter());
                    processor.startTrace(processor.getWriter());
                }
            }
            agentProxy.setAttached(true);
            if (this._autoMonitoring) {
                ag.startMonitoring((DataProcessor)processor);
                agentProxy.setMonitored(true);
            }
            agentProxy.setCollectionData(true);
            command.setData("RESUME");
            ag.invokeCustomCommand(command);
            this.giveControl(agentProxy, false, true);
        }
        catch (InactiveAgentException exc) {
            exc.printStackTrace();
        }
        final TRCAgentProxy agentTemp = agentProxy;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(agentTemp);
                event.setType(1);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    public synchronized void agentInactive(Agent ag) {
        if (this.fProcess == null) {
            return;
        }
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent(this.fProcess, ag, true);
        if (agentProxy == null) {
            return;
        }
        agentProxy.setActive(false);
        agentProxy.setAttached(false);
        agentProxy.setMonitored(false);
        this.fProcess.setActive(false);
        this.giveControl(agentProxy, true, false);
        final TRCAgentProxy agentTemp = agentProxy;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(agentTemp);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    protected void giveControl(TRCAgentProxy agentProxy, boolean pre, boolean active) {
        if (launcherHandlers == null) {
            this.initializeLauncherHandlers();
        }
        Object[] launcherHandlersArray = launcherHandlers.values().toArray();
        for (int num = 0; num < launcherHandlersArray.length; ++num) {
            ILauncherHandler type = (ILauncherHandler)launcherHandlersArray[num];
            try {
                if (active) {
                    if (pre) {
                        type.handlePreAgentActive(agentProxy);
                        continue;
                    }
                    type.handlePostAgentActive(agentProxy);
                    continue;
                }
                type.handleAgentInactive(agentProxy);
                continue;
            }
            catch (Exception e) {
                if (e.getMessage() == null) continue;
                Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    protected void giveControl(TRCProcessProxy processProxy, boolean launched) {
        if (launcherHandlers == null) {
            this.initializeLauncherHandlers();
        }
        Object[] launcherHandlersArray = launcherHandlers.values().toArray();
        for (int num = 0; num < launcherHandlersArray.length; ++num) {
            ILauncherHandler type = (ILauncherHandler)launcherHandlersArray[num];
            try {
                if (launched) {
                    type.handleProcessLaunched(processProxy);
                    continue;
                }
                type.handleProcessExited(processProxy);
                continue;
            }
            catch (Exception e) {
                if (e.getMessage() == null) continue;
                Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private void initializeLauncherHandlers() {
        launcherHandlers = new HashMap();
        IExtensionPoint point = UIPlugin.getDefault().getDescriptor().getExtensionPoint(getLauncherHandlersExtPoint);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            for (int i = 0; i < elements.length; ++i) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                ILauncherHandler getControlType = null;
                try {
                    getControlType = (ILauncherHandler)elem.createExecutableExtension("class");
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    e.printStackTrace();
                }
                if (getControlType == null) continue;
                launcherHandlers.put(id, getControlType);
            }
        }
    }

    public void dispose() {
        this._monitoredAgents.clear();
        this.fNode = null;
        this.fProcess = null;
        this._processVariableList.clear();
    }

    public void error(Agent agent, String errorId, String errStr) {
        final String errorMsg = errStr;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                Status err = new Status(2, "org.eclipse.core.resources", 566, errorMsg, null);
                ErrorDialog.openError((Shell)new Shell(), (String)UIPlugin.getResourceString("LAUNCH_JAVA_PROBLEM_ERROR_"), (String)UIPlugin.getResourceString("PROBLEM_WHILE_PROCESS_WARN_"), (IStatus)err);
            }
        });
    }

    public void handleCommand(Agent agent, CommandElement command) {
    }

    public void monitor(boolean monitor) {
        this._monitor = monitor;
        this._monitoredAgents.clear();
    }

    public synchronized void peerWaiting(Agent agent, Agent peer) {
        if (!peer.isAttached() && this.fProcess != null && this.fNode != null) {
            IResource folder;
            TRCMonitor trcMonitor;
            TRCNode trcNode;
            TRCProcessProxy trcProcess;
            TRCAgentProxy trcAgent = null;
            Iterator iter = this.fProcess.getAgentProxies().iterator();
            while (iter.hasNext()) {
                TRCAgentProxy agentProxy = (TRCAgentProxy)iter.next();
                Object obj = LoadersUtils.locateAgentInstance((TRCAgentProxy)agentProxy);
                if (obj != agent) continue;
                trcAgent = agentProxy;
                break;
            }
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String projectName = store.getString("prj_name");
            String monitorName = store.getString("mon_name");
            if (trcAgent != null && (trcProcess = trcAgent.getProcessProxy()) != null && (trcNode = trcProcess.getNode()) != null && (trcMonitor = trcNode.getMonitor()) != null && (folder = HyadesUtil.getSelectionFolder(trcMonitor)) != null) {
                monitorName = trcMonitor.getName();
                projectName = folder.getName();
            }
            try {
                Object obj;
                Node node = peer.getProcess().getNode();
                String hostname = node.getName();
                String port = String.valueOf(node.getConnection().getPort());
                Vector<Agent> agents = new Vector<Agent>();
                agents.add(peer);
                Vector<AgentConfigurationEntry> options = new Vector<AgentConfigurationEntry>();
                AgentConfiguration conf = agent.getConfiguration();
                for (int i = 0; i < conf.size(); ++i) {
                    options.add(conf.getEntryAt(i));
                }
                PDCoreUtil.profileConnect(hostname, port);
                Vector trcAgents = PDCoreUtil.attach(hostname, agents, options, new ArrayList(), projectName, monitorName, port, null);
                if (trcAgents.size() == 1 && (obj = trcAgents.get(0)) instanceof TRCAgentProxy) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StartTraceActionDelegate delegate = new StartTraceActionDelegate();
                            delegate.run((TRCAgentProxy)obj, (INavigator)UIPlugin.getDefault().getViewer());
                        }
                    });
                }
            }
            catch (Exception e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
    }

    public synchronized void processExited(Process result) {
        if (this.fProcess != null) {
            this.fProcess.setActive(false);
            this.giveControl(this.fProcess, false);
        }
    }

    public synchronized void processLaunched(Process result) {
        try {
            if (result.getProcessId() == null || result.getProcessId().equals("-1")) {
                return;
            }
            this.fProcess = this.createProcess(result);
            if (this.fProcess == null) {
                return;
            }
            Enumeration agents = result.listAgents();
            while (agents.hasMoreElements()) {
                this.createAgent((Agent)agents.nextElement(), this.fProcess);
            }
            this.giveControl(this.fProcess, true);
        }
        catch (InactiveProcessException ex) {
            String text = UIPlugin.getResourceString("RAC_CONFIG_ERROR_");
            final String msg = TString.change(UIPlugin.getResourceString("LAUNCH_ERROR_"), "%1", result.getName());
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)UIPlugin.getDefault().getViewer().getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)msg, (IStatus)err);
                }
            });
            return;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public Agent sendConfigurationToAgent(TRCAgentProxy agent, String host, String processId) {
        try {
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
            if (node == null) {
                return null;
            }
            Process p = node.getProcess(processId);
            if (p != null) {
                Agent a = p.getAgent(agent.getName());
                PDCoreUtil.setAgentConfiguration(agent, a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
                return a;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    private void addEnvironment(TRCProcessProxy process) {
        for (int idx = 0; idx < this._processVariableList.size(); ++idx) {
            Variable var = (Variable)this._processVariableList.get(idx);
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            if (!var.getName().equals("UICLASSPATH")) {
                TRCEnvironmentVariable env = factory.createTRCEnvironmentVariable();
                env.setName(var.getName());
                env.setValue(var.getValue());
                process.getEnvironmentVariables().add((Object)env);
                continue;
            }
            process.setClasspath(var.getValue());
        }
    }

    private TRCAgentProxy createAgent(Agent a, TRCProcessProxy process) {
        if (process == null) {
            return null;
        }
        TRCAgentProxy agent = PDCoreUtil.createAgent(process, a);
        LoadersUtils.registerAgentListener((TRCAgentProxy)agent, (Object)this);
        return agent;
    }

    private TRCProcessProxy createProcess(Process p, TRCNode pNode) {
        try {
            String rId;
            String pName;
            TRCNode node = pNode;
            TRCMonitor monitor = node.getMonitor();
            String processId = p.getProcessId();
            if (processId == null) {
                processId = "-1";
            }
            if ((pName = p.getParameters()) == null) {
                pName = "unknown";
            }
            String params = "";
            String vmparam = "";
            if (p.getExecutable().startsWith("java")) {
                int idx;
                String exeName = p.getParameters();
                if (exeName == null) {
                    exeName = "unknown";
                }
                if (!exeName.startsWith("-X")) {
                    exeName = "-X " + exeName;
                }
                if ((idx = (exeName = exeName.trim()).indexOf(" ")) != -1 && idx < exeName.length() + 1) {
                    exeName = exeName.substring(idx + 1);
                }
                while (exeName.startsWith("-")) {
                    idx = this.findVMendIdx(exeName);
                    if (idx != -1) {
                        vmparam = vmparam + " " + exeName.substring(0, idx);
                        exeName = exeName.substring(idx + 1);
                        continue;
                    }
                    vmparam = exeName;
                    exeName = "";
                }
                idx = (exeName = exeName.trim()).indexOf(" ");
                if (idx != -1) {
                    params = exeName.substring(idx);
                    exeName = exeName.substring(0, idx);
                }
                pName = exeName;
            }
            if ((rId = ((ProcessImpl)p).getUUID()) == null) {
                rId = "";
            }
            String fileName = monitor.getName() + "_" + node.getName() + "_" + TString.change(pName, " ", "") + processId + "_" + rId + "." + "trcpxmi";
            String folderPath = node.eResource().getURI().toString();
            Path path = new Path(folderPath);
            if (path.segmentCount() > 1) {
                folderPath = path.removeLastSegments(1).toString();
            }
            IPath filePath = new Path(folderPath).append(fileName);
            URI uri = URI.createURI((String)filePath.toString());
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            pDoc.setModified(true);
            EList pExt = pDoc.getContents();
            UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
            TRCProcessProxy process = factory.createTRCProcessProxy();
            process.setPid(Integer.parseInt(processId));
            process.setRuntimeId(rId);
            process.setName(pName);
            process.setLocation(((ProcessImpl)p).getlocation());
            process.setNode(node);
            this.addEnvironment(process);
            process.setParameters(params.trim());
            process.setVmArguments(vmparam.trim());
            process.setLaunchMode(this._launchMode);
            process.setActive(true);
            pExt.add((Object)process);
            node.getProcessProxies().add((Object)process);
            Display d = Display.getDefault();
            d.asyncExec(new Runnable(){

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource(null);
                    event.setType(128);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            this._processVariableList.clear();
            return process;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private TRCProcessProxy createProcess(Process p) {
        return this.createProcess(p, this.fNode);
    }

    private int findVMendIdx(String vmargs) {
        int qIdx;
        String space = " ";
        String quote = "\"";
        int startIdx = 0;
        int endIdx = vmargs.indexOf(space);
        if (endIdx != -1 && (qIdx = vmargs.substring(startIdx, endIdx).indexOf(quote)) != -1) {
            startIdx = endIdx + vmargs.substring(endIdx + 1).indexOf(quote) + 1;
            endIdx = startIdx + this.findVMendIdx(vmargs.substring(startIdx + 1)) + 1;
        }
        return endIdx;
    }
}

