/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLogUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class LoggingAgentsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceLogUI _options;

    public LoggingAgentsPreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    private void addAgents(String agents) {
        if (agents != null && !agents.equals("")) {
            int idx = 0;
            while (idx != -1) {
                idx = agents.indexOf(",");
                if (idx != -1) {
                    String agent = agents.substring(0, idx);
                    this._options.addAgent(agent);
                    agents = agents.substring(idx + 1);
                    continue;
                }
                this._options.addAgent(agents);
            }
        }
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".lapp0000"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._options = new TraceLogUI();
        this._options.createControl(composite);
        this.initializeValues();
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this._options.reset();
        String agents = store.getDefaultString("log_agents");
        this.addAgents(agents);
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        String agents = store.getString("log_agents");
        this.addAgents(agents);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        String agents = "";
        String[] items = this._options.getAgents();
        for (int idx = 0; idx < items.length; ++idx) {
            agents = agents + "," + items[idx].trim();
        }
        if (agents.startsWith(",") && agents.length() > 1) {
            agents = agents.substring(1);
        }
        store.setValue("log_agents", agents);
    }
}

