/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.util.Enumeration;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public class JavaProcessExecutorStub
extends ExecutorStub {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws ExecutionComponentStateException {
        super.launch();
        int trialCount = 60;
        String pid = this.getPid();
        try {
            boolean found = false;
            Node node = ((SessionStub)this.getSessionContext()).getAgent().getProcess().getNode();
            while (!found && trialCount > 0) {
                Enumeration processes = node.listProcesses();
                while (processes.hasMoreElements()) {
                    Process proc = (Process)processes.nextElement();
                    if (proc.getProcessId().equals(pid)) {
                        found = true;
                        Process process = proc;
                        synchronized (process) {
                            Enumeration agents = proc.getAgentsByType("tester");
                            while (agents.hasMoreElements()) {
                                Agent agent = (Agent)agents.nextElement();
                                try {
                                    agent.addAgentListener(new AgentListener(){

                                        public void error(Agent agent, String errorId, String errorMessage) {
                                        }

                                        public void handleCommand(Agent agent, CommandElement command) {
                                            if (command instanceof CustomCommand) {
                                                String commandData = ((CustomCommand)command).getData();
                                                if (commandData.equals("STOP")) {
                                                    IRemoteHyadesComponent comp = JavaProcessExecutorStub.this.findRemoteHyadesComponent();
                                                    if (comp != null) {
                                                        comp.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)comp, 4));
                                                    }
                                                } else {
                                                    System.out.println("recieving message: " + commandData);
                                                }
                                            }
                                        }

                                        public void agentActive(Agent agent) {
                                        }

                                        public void agentInactive(Agent agent) {
                                        }
                                    });
                                    agent.attach();
                                    IExecutionComponent[] children = this.getChildren();
                                    for (int i = 0; i < children.length; ++i) {
                                        if (!(children[i] instanceof IRemoteHyadesComponent)) continue;
                                        ((JavaTaskRemoteHyadesComponentStub)children[i]).setAgent(agent);
                                    }
                                    try {
                                        String script;
                                        IExecutableObject executableObject = this.getExecutableObject();
                                        if (!(executableObject instanceof JavaProcessExecutableObjectStub) || (script = ((JavaProcessExecutableObjectStub)executableObject).getAgentData()) == null) continue;
                                        BinaryCustomCommand agentData = new BinaryCustomCommand();
                                        agentData.setData(script.getBytes("UTF-8"));
                                        agent.invokeCustomCommand(agentData);
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                catch (InactiveAgentException e) {}
                            }
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    --trialCount;
                }
            }
        }
        catch (InactiveProcessException e) {
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
        if (trialCount == 0) {
            throw new ExecutionComponentStateException(3, "Unable to find control agent.");
        }
        this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)this, 2));
    }

    public boolean supportsControlEvent(String controlEvent) {
        return true;
    }

    public String performControlEvent(String controlEvent, String[] params) {
        return "";
    }

    private IRemoteHyadesComponent findRemoteHyadesComponent() {
        IRemoteHyadesComponent comp = null;
        IExecutionComponent[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IRemoteHyadesComponent)) continue;
            comp = (IRemoteHyadesComponent)children[i];
        }
        return comp;
    }
}

