/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.execution.local.file.FileManagerImpl;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;

public class NodeImpl
implements INode {
    private String name;
    private Object sessionLock = new Object();
    private boolean connected = false;
    private static final boolean DEBUG = true;
    IFileManager fileManager;

    public NodeImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISession connect(String daemonType, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        Node node = null;
        try {
            node = principal == null ? NodeFactory.createNode(this.name) : NodeFactory.createNode(this.name, principal);
        }
        catch (DuplicateUserException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        try {
            node.connect(Integer.parseInt(daemonType));
        }
        catch (SecureConnectionRequiredException e) {
            throw e;
        }
        catch (LoginFailedException e) {
            throw e;
        }
        catch (AgentControllerUnavailableException e) {
            throw e;
        }
        node.getConnection().addConnectionListener(new ConnectionListener(){

            public void connectionClosed(Connection connection) {
            }
        });
        Process rprocess = ProcessFactory.createProcess(node, "HyadesTestingSession");
        this.captureConsoleOutput(rprocess);
        Agent ragent = AgentFactory.createAgent(rprocess, "RemoteSession", "HyadesSession");
        ragent.setAutoAttach(true);
        SessionStub sessionInstance = new SessionStub((IExecutionComponent)new SessionImpl(this, ragent));
        Marshaller.addInstanceToMap((Integer)sessionInstance.getUniqueId(), (Object)sessionInstance);
        try {
            rprocess.setParameters("org.eclipse.hyades.execution.remote.NodeImpl " + sessionInstance.getUniqueId().toString());
        }
        catch (ProcessActiveException e) {
            // empty catch block
        }
        ProcessListener processListener = new ProcessListener(){

            public void processLaunched(Process process) {
            }

            public void processExited(Process process) {
                NodeImpl.this.releaseSessionLock();
            }
        };
        rprocess.addProcessListener(processListener);
        IExecutionComponentStateChangeListener stateChangeListener = new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent event) {
                if (event.getState() == 2) {
                    NodeImpl.this.releaseSessionLock();
                }
            }
        };
        sessionInstance.addExecutionComponentStateChangeListener(stateChangeListener);
        try {
            rprocess.launch();
            rprocess.getProcessId();
        }
        catch (InactiveProcessException e) {
            this.cleanup(node, rprocess, sessionInstance, processListener, stateChangeListener);
            DaemonConnectException exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        catch (NoSuchApplicationException e) {
            this.cleanup(node, rprocess, sessionInstance, processListener, stateChangeListener);
            DaemonConnectException exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        catch (ProcessActiveException e) {
            this.cleanup(node, rprocess, sessionInstance, processListener, stateChangeListener);
            DaemonConnectException exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        catch (NotConnectedException e) {
            this.cleanup(node, rprocess, sessionInstance, processListener, stateChangeListener);
            DaemonConnectException exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        while (!this.connected) {
            Object object = this.sessionLock;
            synchronized (object) {
                try {
                    this.sessionLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        this.fileManager = new FileManagerImpl(node.getConnection());
        return sessionInstance;
    }

    private void cleanup(Node node, Process process, ISession sessionInstance, ProcessListener processListener, IExecutionComponentStateChangeListener stateChangeListener) {
        try {
            process.removeProcessListener(processListener);
            Marshaller.removeInstanceFromMap((Integer)((SessionStub)sessionInstance).getUniqueId());
            sessionInstance.removeExecutionComponentStateChangeListener(stateChangeListener);
            node.getConnection().disconnect();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSessionLock() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.connected = true;
            this.sessionLock.notify();
        }
    }

    private void captureConsoleOutput(Process process) {
        Console console = process.getConsole();
        console.setDataProcessor(new DataProcessor(){

            public void incommingData(byte[] buffer, int length, InetAddress peer) {
                System.out.print("====>");
                System.out.print(new String(buffer, 0, length));
                System.out.flush();
            }

            public void incommingData(char[] buffer, int length, InetAddress peer) {
                System.out.print("====>");
                System.out.print(new String(buffer, 0, length));
                System.out.flush();
            }

            public void invalidDataType(byte[] data, int length, InetAddress peer) {
            }

            public void waitingForData() {
            }
        });
    }

    public IFileManager getFileManager() {
        return this.fileManager;
    }
}

