/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXEventHandler
extends DefaultHandler {
    private HashMap elementMap = new HashMap();
    private HashMap featureMap = new HashMap();
    private int column = 0;
    private int line = 0;
    private StringBuffer anyElementXMLFragment = null;
    private StringBuffer charactersBuffer = null;
    private StringBuffer nameSpaceAttribute = null;
    private int anyElementNestingDepth = 0;
    private List commonBaseEvents = null;
    private List associationEngines = null;
    private List stack = null;
    private static final String SITUATION_TYPE_CLASS = EventPackage.eINSTANCE.getSituationType().getName();
    private static final String COMMON_BASE_EVENT_CLASS = EventPackage.eINSTANCE.getCommonBaseEvent().getName();
    private static final String OTHER_SITUATION_CLASS = EventPackage.eINSTANCE.getOtherSituation().getName();
    private static final String ASSOCIATION_ENGINE_CLASS = EventPackage.eINSTANCE.getAssociationEngine().getName();

    public SAXEventHandler() {
        this.init();
    }

    public void init() {
        this.reset();
        this.associationEngines = new ArrayList();
        this.commonBaseEvents = new ArrayList();
    }

    private void reset() {
        this.column = 0;
        this.line = 0;
        this.anyElementNestingDepth = 0;
        this.stack = new ArrayList();
        this.anyElementXMLFragment = new StringBuffer();
        this.charactersBuffer = new StringBuffer();
        this.nameSpaceAttribute = null;
        Iterator iterator = EventPackage.eINSTANCE.eContents().iterator();
        while (iterator.hasNext()) {
            EClass eClass = (EClass)iterator.next();
            this.elementMap.put(eClass.getName(), eClass);
            EList eList = eClass.getEAllStructuralFeatures();
            for (int i = 0; i < eList.size(); ++i) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(i);
                if (eStructuralFeature.getName().equals("any")) continue;
                HashMap<String, EStructuralFeature> hashMap = (HashMap<String, EStructuralFeature>)this.featureMap.get(eClass.getName());
                if (hashMap == null) {
                    hashMap = new HashMap<String, EStructuralFeature>();
                    this.featureMap.put(eClass.getName(), hashMap);
                }
                hashMap.put(eStructuralFeature.getName(), eStructuralFeature);
            }
        }
    }

    public CommonBaseEvent[] getCommonBaseEvents() {
        if (this.commonBaseEvents != null && !this.commonBaseEvents.isEmpty()) {
            return this.commonBaseEvents.toArray(new CommonBaseEvent[this.commonBaseEvents.size()]);
        }
        return null;
    }

    public AssociationEngine[] getAssociationEngines() {
        if (this.associationEngines != null && !this.associationEngines.isEmpty()) {
            return this.associationEngines.toArray(new AssociationEngine[this.associationEngines.size()]);
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.column = locator.getColumnNumber();
        this.line = locator.getLineNumber();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        this.charactersBuffer.append(new String(cArray, n, n2));
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        if (!string.equals("xmlns") && !string.equals("xml")) {
            this.nameSpaceAttribute = new StringBuffer("xmlns");
            if (string != null && string.trim().length() > 0) {
                this.nameSpaceAttribute.append(':');
                this.nameSpaceAttribute.append(string);
            }
            this.nameSpaceAttribute.append("=\"");
            this.nameSpaceAttribute.append(string2);
            this.nameSpaceAttribute.append('\"');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        String string4;
        Object object2;
        super.startElement(string, string2, string3, attributes);
        String string5 = this.getLocalElementName(string2, string3);
        if (this.isRestrictedElementName(string5)) return;
        EObject eObject = null;
        EClass eClass = null;
        if (this.stack.isEmpty()) {
            if (!string5.equals(COMMON_BASE_EVENT_CLASS) && !string5.equals(ASSOCIATION_ENGINE_CLASS)) {
                throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_", new String[]{COMMON_BASE_EVENT_CLASS, string5, String.valueOf(this.line), String.valueOf(this.column)}));
            }
            eClass = (EClass)this.elementMap.get(string5);
            eObject = EventFactory.eINSTANCE.create(eClass);
            this.stack.add(eObject);
        } else {
            object2 = (EObject)this.stack.get(this.stack.size() - 1);
            string4 = object2.eClass().getName();
            object = (HashMap)this.featureMap.get(string4);
            EStructuralFeature eStructuralFeature = (EStructuralFeature)((HashMap)object).get(string5);
            if (eStructuralFeature == null) {
                String string6;
                if (!string4.equals(COMMON_BASE_EVENT_CLASS) && !string4.equals(OTHER_SITUATION_CLASS)) throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_", new String[]{string5, String.valueOf(this.line), String.valueOf(this.column)}));
                if (this.anyElementNestingDepth > 0 && (string6 = this.charactersBuffer.toString()).trim().length() > 0) {
                    this.anyElementXMLFragment.append(XmlUtility.normalize((String)string6));
                }
                ++this.anyElementNestingDepth;
                this.anyElementXMLFragment.append('<');
                this.anyElementXMLFragment.append(this.getQualifiedElementName(string, string2, string3));
                if (this.nameSpaceAttribute != null) {
                    this.anyElementXMLFragment.append(' ');
                    this.anyElementXMLFragment.append(this.nameSpaceAttribute.toString());
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.anyElementXMLFragment.append(' ');
                    this.anyElementXMLFragment.append(this.getQualifiedElementName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i)));
                    this.anyElementXMLFragment.append("=\"");
                    this.anyElementXMLFragment.append(XmlUtility.normalize((String)attributes.getValue(i)));
                    this.anyElementXMLFragment.append("\"");
                }
                this.anyElementXMLFragment.append('>');
            } else {
                String string7 = eStructuralFeature.getEType().getName();
                if (string7.equals(SITUATION_TYPE_CLASS) && ((string7 = ((Situation)object2).getCategoryName()) == null || string7.trim().length() == 0)) {
                    throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", new String[]{"categoryName", "<empty>", "0", "0"}));
                }
                if (string7.equals("EString")) {
                    if (eStructuralFeature.isMany()) {
                        this.stack.add((List)object2.eGet(eStructuralFeature));
                    } else {
                        this.stack.add(eStructuralFeature);
                    }
                } else {
                    eClass = (EClass)this.elementMap.get(string7);
                    eObject = EventFactory.eINSTANCE.create(eClass);
                    if (eStructuralFeature.isMany()) {
                        ((List)object2.eGet(eStructuralFeature)).add(eObject);
                    } else {
                        object2.eSet(eStructuralFeature, (Object)eObject);
                    }
                    this.stack.add(eObject);
                }
            }
        }
        if (eObject != null) {
            object2 = (HashMap)this.featureMap.get(eClass.getName());
            string4 = null;
            object = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                string4 = (EAttribute)((HashMap)object2).get(this.getLocalElementName(attributes.getLocalName(i), attributes.getQName(i)));
                if (string4 == null) continue;
                object = string4.getEAttributeType().getName();
                if (((String)object).equals("ELong")) {
                    try {
                        eObject.eSet((EStructuralFeature)string4, (Object)Long.valueOf(attributes.getValue(i)));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (attributes.getValue(i).trim().length() <= 0) continue;
                        throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", new String[]{this.getQualifiedElementName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i)), attributes.getValue(i), String.valueOf(this.line), String.valueOf(this.column)}));
                    }
                }
                if (((String)object).equals("EShort")) {
                    try {
                        eObject.eSet((EStructuralFeature)string4, (Object)Short.valueOf(attributes.getValue(i)));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (attributes.getValue(i).trim().length() <= 0) continue;
                        throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", new String[]{this.getQualifiedElementName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i)), attributes.getValue(i), String.valueOf(this.line), String.valueOf(this.column)}));
                    }
                }
                eObject.eSet((EStructuralFeature)string4, (Object)attributes.getValue(i));
            }
        }
        this.charactersBuffer = new StringBuffer();
        this.nameSpaceAttribute = null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        String string4 = this.getLocalElementName(string2, string3);
        if (!this.isRestrictedElementName(string4)) {
            if (this.stack.isEmpty()) {
                throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_", new String[]{string4, String.valueOf(this.line), String.valueOf(this.column)}));
            }
            if (this.anyElementNestingDepth > 0) {
                String string5 = this.charactersBuffer.toString();
                if (string5.trim().length() > 0) {
                    this.anyElementXMLFragment.append(XmlUtility.normalize((String)string5));
                }
                this.anyElementXMLFragment.append("</");
                this.anyElementXMLFragment.append(this.getQualifiedElementName(string, string2, string3));
                this.anyElementXMLFragment.append('>');
                if (--this.anyElementNestingDepth == 0) {
                    Object e = this.stack.get(this.stack.size() - 1);
                    if (e instanceof CommonBaseEvent) {
                        ((CommonBaseEvent)e).addAny(this.anyElementXMLFragment.toString());
                    } else if (e instanceof OtherSituation) {
                        OtherSituation otherSituation = (OtherSituation)e;
                        String string6 = otherSituation.getAny();
                        if (string6 != null && string6.trim().length() > 0) {
                            otherSituation.setAny(string6.concat(this.anyElementXMLFragment.toString()));
                        } else {
                            otherSituation.setAny(this.anyElementXMLFragment.toString());
                        }
                    }
                    this.anyElementXMLFragment = new StringBuffer();
                }
            } else {
                Object e = this.stack.remove(this.stack.size() - 1);
                if (e instanceof CommonBaseEvent) {
                    String string7 = this.charactersBuffer.toString();
                    if (string7.trim().length() > 0) {
                        ((CommonBaseEvent)e).addAny(XmlUtility.normalize((String)string7));
                    }
                    this.commonBaseEvents.add((CommonBaseEvent)e);
                    this.reset();
                } else if (e instanceof OtherSituation) {
                    String string8 = this.charactersBuffer.toString();
                    if (string8.trim().length() > 0) {
                        OtherSituation otherSituation = (OtherSituation)e;
                        String string9 = otherSituation.getAny();
                        if (string9 != null && string9.trim().length() > 0) {
                            otherSituation.setAny(string9.concat(XmlUtility.normalize((String)string8)));
                        } else {
                            otherSituation.setAny(XmlUtility.normalize((String)string8));
                        }
                    }
                } else if (string4.equals(ASSOCIATION_ENGINE_CLASS) && e instanceof AssociationEngine) {
                    this.associationEngines.add((AssociationEngine)e);
                    this.reset();
                } else if (this.stack.size() > 1) {
                    if (e instanceof List) {
                        ((List)e).add(this.charactersBuffer.toString());
                    }
                    if (e instanceof EStructuralFeature) {
                        ((EObject)this.stack.get(this.stack.size() - 1)).eSet((EStructuralFeature)e, (Object)this.charactersBuffer.toString());
                    }
                }
            }
            this.charactersBuffer = new StringBuffer();
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private String getLocalElementName(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            if (string2 != null) {
                int n = string2.lastIndexOf(58);
                if (n != -1) {
                    return string2.substring(n + 1).trim();
                }
                return string2.trim();
            }
            return string2.trim();
        }
        return string.trim();
    }

    private String getQualifiedElementName(String string, String string2, String string3) {
        if (string3 == null || string3.trim().length() == 0) {
            if (string2 != null) {
                if (string != null && string.trim().length() > 0) {
                    return string.concat(":").concat(string2);
                }
                return string2.trim();
            }
            return string2.trim();
        }
        return string3.trim();
    }

    private boolean isRestrictedElementName(String string) {
        if (string != null) {
            String string2 = string.trim();
            return string2.equalsIgnoreCase("CommonBaseEvents") || string2.equalsIgnoreCase("TemplateEvent");
        }
        return false;
    }
}

