/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.swt.widgets.Display;

public class PerfmonGenericLoader
extends PerfmonLoader
implements DataProcessor,
ProcessListener,
AgentListener {
    private static final boolean PRINTXML = false;
    private boolean LOGXML = false;
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    long started;
    String tracename;
    Node node;
    Process process;
    Agent agent;
    TRCAgent trcagent;
    boolean running = false;
    XMLLoader xloader;
    ArrayList listeners = new ArrayList();
    ModelListener adapter = new ModelListener();
    OutputStream logfile;
    IProgressMonitor pmonitor;
    boolean first = true;

    public PerfmonGenericLoader(IProgressMonitor pmonitor, long started, TRCAgent tagent, String modelname, String host, int port, String remote_host, int freq) throws Exception {
        this.pmonitor = pmonitor;
        this.started = started;
        this.init(modelname, tagent, host, port, remote_host, freq);
    }

    public PerfmonGenericLoader(long started, TRCAgent tagent, String modelname, String host, String remote_host, int freq) throws Exception {
        this.started = started;
        this.init(modelname, tagent, host, 10002, remote_host, freq);
    }

    public void processLaunched(Process process) {
    }

    public void processExited(Process process) {
        TRCProcessProxy processProxy = this.trcagent.getAgentProxy().getProcessProxy();
        if (processProxy == null) {
            return;
        }
        TRCAgentProxy agentProxy = this.trcagent.getAgentProxy();
        if (agentProxy == null) {
            return;
        }
        agentProxy.setActive(false);
        agentProxy.setAttached(false);
        agentProxy.setMonitored(false);
        processProxy.setActive(false);
        final TRCAgentProxy agentTemp = agentProxy;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)agentTemp);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    public void agentActive(Agent agent) {
    }

    public void agentInactive(Agent agent) {
        this.processExited(this.process);
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
    }

    public void killProcess() throws Exception {
        this.node.killProcess(this.process);
    }

    public void setFrequency(int freq) throws IOException {
        this.setNVPair("var_int", "DC_WAITTIME", "" + freq);
    }

    public void setRemoteHost(String host) throws IOException {
        if (host.length() == 0) {
            host = "NULL";
        }
        PerfmonPlugin.DBG.info("Setting remote host to " + host);
        this.setNVPair("var_string", "PERFMON_REG_HOST", host);
    }

    public void getUpdatedTree() throws IOException {
        this.setNVPair("updatetree", "", "true");
    }

    public void getUpdatedTree(SDDescriptor update) throws IOException {
        if (update.getId() == null) {
            return;
        }
        PerfmonPlugin.DBG.info("Requesting tree update for descriptor " + update.getName() + " (" + update.getId() + ")");
        this.setNVPair("updatetree", update.getId(), "true");
    }

    public void counterON(SDDescriptor counter) throws IOException, NullPointerException {
        String id = counter.getId();
        if (id == null) {
            throw new NullPointerException(PerfmonPlugin.getString("ERROR_DESCRIPTOR_ID_NOT_FOUND"));
        }
        this.setNVPair("filter", id, "true");
    }

    public void counterOFF(SDDescriptor counter) throws IOException {
        String id = counter.getId();
        if (id == null) {
            throw new IOException(PerfmonPlugin.getString("ERROR_DESCRIPTOR_ID_NOT_FOUND"));
        }
        this.setNVPair("filter", id, "false");
    }

    public SDDescriptor getModel() {
        EList models = this.trcagent.getDescriptor();
        if (models.size() > 0) {
            return (SDDescriptor)models.get(0);
        }
        return null;
    }

    public void addLoaderListener(StatisticalLoaderListener listener) {
        this.listeners.add(listener);
    }

    public void removeLoaderListener(StatisticalLoaderListener listener) {
        this.listeners.add(listener);
    }

    private Agent findAgent(Node node) throws NotConnectedException {
        Agent agent = null;
        Enumeration processes = node.listProcesses();
        while (processes.hasMoreElements()) {
            Process p = (Process)processes.nextElement();
            PerfmonPlugin.DBG.info("checking RAC process " + p.getName());
            agent = this.findAgent(p);
            if (agent == null) continue;
            break;
        }
        return agent;
    }

    private Agent findAgent(Process p) {
        if (p == null) {
            return null;
        }
        Enumeration agents = p.listAgents();
        Agent the_agent = null;
        if (!agents.hasMoreElements()) {
            PerfmonPlugin.DBG.info("found no agents in this process");
        }
        while (agents.hasMoreElements()) {
            Agent a = (Agent)agents.nextElement();
            PerfmonPlugin.DBG.info("found RAC agent " + a.getName() + "/" + a.getType());
            if (!a.getName().startsWith("PerfmonAgent") && !a.getType().startsWith("PerfmonAgent")) continue;
            try {
                if (a.isAttached()) continue;
                this.process = p;
                the_agent = a;
                PerfmonPlugin.DBG.info("agent not attached - accepting");
                break;
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("error checking agent " + e);
            }
        }
        return the_agent;
    }

    private void init(String modelname, TRCAgent trcagent, String host, int port, String remote_host, int freq) throws Exception {
        block24: {
            this.trcagent = trcagent;
            SDView view = (SDView)trcagent.getView();
            if (view == null) {
                view = this.factory.createSDView();
                view.setAgent(trcagent);
                view.setName("view");
            }
            if (view.eContents().size() == 0) {
                SDSampleWindow window = this.factory.createSDSampleWindow();
                window.setView(view);
            }
            trcagent.eAdapters().add((Object)this.adapter);
            trcagent.getView().eAdapters().add((Object)this.adapter);
            EList windows = view.eContents();
            for (int k = 0; k < windows.size(); ++k) {
                SDSampleWindow window = (SDSampleWindow)windows.get(k);
                window.eAdapters().add((Object)this.adapter);
            }
            if (this.LOGXML) {
                try {
                    this.logfile = new FileOutputStream("C:\\temp\\XMLLOG.txt");
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.tracename = modelname;
            this.xloader = new XMLLoader(trcagent);
            PerfmonPlugin.DBG.warning("asked to connect to " + host + ":" + port);
            try {
                this.node = NodeFactory.createNode((String)host);
                PerfmonPlugin.DBG.info("connecting to RAC");
                if (this.pmonitor != null) {
                    this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONNECTING"));
                }
                this.node.connect(port);
                PerfmonPlugin.DBG.info("connected to RAC");
                if (this.pmonitor != null) {
                    this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CREATING"));
                }
                this.agent = this.findAgent(this.node);
                if (this.agent == null) {
                    PerfmonPlugin.DBG.info("Launching RAC PerfmonAgent");
                    Process process = ProcessFactory.createProcess((Node)this.node, (String)"PerfmonAgent");
                    if (process != null) {
                        ProcessAdapter adapter = new ProcessAdapter(process, null);
                        process.addProcessListener(new ProcessListener((IProcess)adapter){
                            private final /* synthetic */ IProcess val$adapter;
                            {
                                this.val$adapter = val$adapter;
                            }

                            public void processLaunched(Process p) {
                                UIPlugin.getDefault().registerLaunchProcess(this.val$adapter);
                            }

                            public void processExited(Process p) {
                                UIPlugin.getDefault().deregisterLaunchProcess(this.val$adapter);
                            }
                        });
                        ProcessLaunch launcher = new ProcessLaunch();
                        launcher.process = process;
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        display.syncExec((Runnable)launcher);
                        long t = System.currentTimeMillis() + 8000L;
                        while (!process.isActive() && System.currentTimeMillis() < t) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception e) {}
                        }
                        t = System.currentTimeMillis() + 25000L;
                        this.agent = this.findAgent(this.node);
                        while (this.agent == null && System.currentTimeMillis() < t) {
                            Thread.sleep(1250L);
                            this.agent = this.findAgent(this.node);
                        }
                    }
                }
                if (this.agent != null) {
                    if (this.pmonitor != null) {
                        this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));
                    }
                    this.agent.addAgentListener((AgentListener)this);
                    this.process.addProcessListener((ProcessListener)this);
                    PerfmonPlugin.DBG.info("attaching to perfmon agent " + this.agent.getName());
                    this.running = true;
                    try {
                        trcagent.getAgentProxy().getProcessProxy().setPid(Integer.parseInt(this.agent.getProcess().getProcessId()));
                    }
                    catch (Exception e) {
                        PerfmonPlugin.DBG.error("could not set process proxy PID");
                    }
                    trcagent.getAgentProxy().setRuntimeId(this.process.getUUID());
                    LoadersUtils.registerAgentInstance((TRCAgentProxy)trcagent.getAgentProxy(), (Object)this.agent);
                    this.agent.attach();
                    this.agent.startMonitoring((DataProcessor)this);
                    trcagent.setRuntimeId(this.agent.getUUID());
                    PerfmonPlugin.DBG.info("attached To & Monitoring Perfmon Agent");
                    this.setRemoteHost(remote_host);
                    this.setFrequency(freq);
                    this.getUpdatedTree();
                    long t = System.currentTimeMillis();
                    while (this.getModel() == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - t <= 10000L) continue;
                        t = Long.MAX_VALUE;
                        PerfmonPlugin.DBG.info("been waiting 10 seconds and still no model...");
                    }
                    break block24;
                }
                PerfmonPlugin.DBG.warning("no perfmon agent found");
                throw new Exception(PerfmonPlugin.getString("ERROR_CREATE_PERFMON_AGENT"));
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("problem initialising loader");
                throw e;
            }
        }
    }

    public void setNVPair(String type, String name, String value) throws IOException {
        ControlMessage message = new ControlMessage();
        SetNVPairCommand command = new SetNVPairCommand();
        try {
            command.setProcessId(Long.parseLong(this.process.getProcessId()));
        }
        catch (InactiveProcessException e) {
            throw new IOException(PerfmonPlugin.getString("ERROR_INACTIVE_PROCESS"));
        }
        command.setAgentName(this.agent.getName());
        command.setType(type);
        command.setName(name);
        command.setValue(value);
        message.appendCommand((CommandElement)command);
        this.node.getConnection().sendMessage(message, null);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        this.running = false;
        PerfmonPlugin.DBG.info("shutdown");
        if (this.agent != null) {
            try {
                PerfmonPlugin.DBG.info("detaching from agent");
                this.agent.stopMonitoring();
                this.agent.detach();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("failed to detach from agent", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public void incoming(String msg) {
    }

    private byte[] stringToBytes(String s) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            bout.write((byte)s.charAt(i));
        }
        return bout.toByteArray();
    }

    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        if (this.LOGXML) {
            try {
                this.logfile.write(buffer, 0, length);
            }
            catch (Throwable t) {
                this.LOGXML = false;
            }
        }
        if ((length = (buffer = new String(buffer, 0, length).trim().getBytes()).length) == 0) {
            return;
        }
        if (this.first) {
            byte[] ROOT_START = "<TRACE>".getBytes();
            this.xloader.loadEvent(ROOT_START, ROOT_START.length);
            this.first = false;
        }
        try {
            this.xloader.loadEvent(buffer, length);
        }
        catch (Throwable t) {
            PerfmonPlugin.DBG.error("unable to parse message " + new String(buffer, 0, 30) + "...", t);
        }
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
        PerfmonPlugin.DBG.warning("invalid datatype");
    }

    public void waitingForData() {
    }

    class ModelListener
    extends AdapterImpl {
        ModelListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                Object newValue = notification.getNewValue();
                boolean notify = false;
                SDDescriptor parent = null;
                if (newValue instanceof SDDescriptor) {
                    notify = true;
                    parent = ((SDDescriptor)newValue).getParent();
                } else if (newValue instanceof SDSnapshotObservation) {
                    notify = true;
                    parent = ((SDSnapshotObservation)newValue).getMemberDescriptor();
                }
                if (notify) {
                    for (int i = 0; i < PerfmonGenericLoader.this.listeners.size(); ++i) {
                        StatisticalLoaderListener listener = (StatisticalLoaderListener)PerfmonGenericLoader.this.listeners.get(i);
                        listener.modelChanged(parent);
                    }
                }
            }
        }
    }

    class ProcessLaunch
    implements Runnable {
        Process process;

        ProcessLaunch() {
        }

        public void run() {
            try {
                this.process.launch();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_LAUNCH_PERFMON"), true);
            }
        }
    }
}

