/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventException;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class CommonBaseEventImplTest
extends TestCase {
    private CommonBaseEvent cbe;

    public CommonBaseEventImplTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.cbe = Util.generateEvent();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCommonBaseEventTypes() throws Exception {
        this.cbe.setVersion("ABC");
        this.cbe.setGlobalInstanceId("Id01234567890123");
        this.cbe.setExtensionName("CBEEvent");
        this.cbe.setLocalInstanceId("MyId");
        this.cbe.setCreationTime("1999-05-31T13:20:00-05:00");
        this.cbe.setCreationTimeAsLong(987654321L);
        this.cbe.setSeverity((short)5);
        this.cbe.setMsg("ABC");
        this.cbe.setPriority((short)5);
        this.cbe.setSequenceNumber(5L);
        this.cbe.setRepeatCount((short)6);
        this.cbe.setRepeatCount((short)6);
        this.cbe.setElapsedTime(60L);
        ContextDataElement contextDataElement = EventFactory.eINSTANCE.createContextDataElement();
        this.cbe.getContextDataElements().add(contextDataElement);
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        this.cbe.getExtendedDataElements().add(extendedDataElement);
        AssociatedEvent associatedEvent = EventFactory.eINSTANCE.createAssociatedEvent();
        this.cbe.getAssociatedEvents().add(associatedEvent);
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        this.cbe.setReporterComponentId(componentIdentification);
        ComponentIdentification componentIdentification2 = EventFactory.eINSTANCE.createComponentIdentification();
        this.cbe.setSourceComponentId(componentIdentification2);
        MsgDataElement msgDataElement = EventFactory.eINSTANCE.createMsgDataElement();
        this.cbe.setMsgDataElement(msgDataElement);
        Assert.assertTrue((boolean)(this.cbe.getVersion() instanceof String));
        Assert.assertTrue((boolean)(this.cbe.getGlobalInstanceId() instanceof String));
        Assert.assertTrue((boolean)(this.cbe.getExtensionName() instanceof String));
        Assert.assertTrue((boolean)(this.cbe.getLocalInstanceId() instanceof String));
        Assert.assertTrue((boolean)(this.cbe.getCreationTime() instanceof String));
        Assert.assertTrue((this.cbe.getCreationTimeAsLong() == 987654321L ? 1 : 0) != 0);
        Assert.assertTrue((this.cbe.getSeverity() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(this.cbe.getMsg() instanceof String));
        Assert.assertTrue((this.cbe.getPriority() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((this.cbe.getSequenceNumber() == 5L ? 1 : 0) != 0);
        Assert.assertTrue((this.cbe.getRepeatCount() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((this.cbe.getElapsedTime() == 60L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(this.cbe.getContextDataElements().get(0) instanceof ContextDataElement));
        Assert.assertTrue((boolean)(this.cbe.getExtendedDataElements().get(0) instanceof ExtendedDataElement));
        Assert.assertTrue((boolean)(this.cbe.getAssociatedEvents().get(0) instanceof AssociatedEvent));
        Assert.assertTrue((boolean)(this.cbe.getReporterComponentId() instanceof ComponentIdentification));
        Assert.assertTrue((boolean)(this.cbe.getSourceComponentId() instanceof ComponentIdentification));
        Assert.assertTrue((boolean)(this.cbe.getMsgDataElement() instanceof MsgDataElement));
        Util.testSerialization(this.cbe);
    }

    public void testValidationRequiredPrimitives() throws ValidationException {
        CommonBaseEvent commonBaseEvent = Util.generateEventWithoutRequiredPrimitives();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.validate();
        commonBaseEvent = Util.generateEventWithoutRequiredPrimitives();
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        Util.assertMissingAttributes(commonBaseEvent, "creationTime");
        commonBaseEvent = Util.generateEventWithoutRequiredPrimitives();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        commonBaseEvent.validate();
        commonBaseEvent = Util.generateEventWithoutRequiredPrimitives();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        commonBaseEvent.setRepeatCount((short)1);
        Util.assertMissingAttributes(commonBaseEvent, "elapsedTime");
        commonBaseEvent.setRepeatCount((short)0);
        commonBaseEvent.validate();
        commonBaseEvent.setRepeatCount((short)33);
        commonBaseEvent.setElapsedTime(5000L);
        commonBaseEvent.validate();
    }

    public void testValidationRequiredSourceComponentId() throws ValidationException {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        Situation situation = EventFactory.eINSTANCE.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("NOT AVAILABLE");
        availableSituation.setOperationDisposition("STARTABLE");
        availableSituation.setProcessingDisposition("MGMTTASK_PROCESS");
        availableSituation.setReasoningScope("EXTERNAL");
        situation.setCategoryName("AvailableSituation");
        situation.setSituationType(availableSituation);
        commonBaseEvent.setSituation(situation);
        Util.assertMissingAttributes(commonBaseEvent, "sourceComponentId");
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setLocation("My Location 2");
        componentIdentification.setLocationType("FQHostname");
        componentIdentification.setComponent("My Component 2");
        componentIdentification.setSubComponent("My sub component 2");
        componentIdentification.setComponentIdType("My Component ID Type 2");
        componentIdentification.setComponentType("My Component Type 2");
        commonBaseEvent.setSourceComponentId(componentIdentification);
        commonBaseEvent.validate();
    }

    public void testValidationRequiredReporterComponentId() throws ValidationException {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        Situation situation = EventFactory.eINSTANCE.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("NOT AVAILABLE");
        availableSituation.setOperationDisposition("STARTABLE");
        availableSituation.setProcessingDisposition("MGMTTASK_PROCESS");
        availableSituation.setReasoningScope("EXTERNAL");
        situation.setCategoryName("AvailableSituation");
        situation.setSituationType(availableSituation);
        commonBaseEvent.setSituation(situation);
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setLocation("My Location");
        componentIdentification.setLocationType("Devicename");
        componentIdentification.setComponent("My Component");
        componentIdentification.setSubComponent("My sub component");
        componentIdentification.setComponentIdType("My Component ID Type");
        componentIdentification.setComponentType("My Component Type");
        commonBaseEvent.setReporterComponentId(componentIdentification);
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Can't have ReporterComponentId if you don't have SourceComponentId");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0203E", validationException);
        }
        ComponentIdentification componentIdentification2 = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification2.setLocation("My Location 2");
        componentIdentification2.setLocationType("Unknown");
        componentIdentification2.setComponent("My Component 2");
        componentIdentification2.setSubComponent("My sub component 2");
        componentIdentification2.setComponentIdType("My Component ID Type 2");
        componentIdentification2.setComponentType("My Component Type 2");
        commonBaseEvent.setSourceComponentId(componentIdentification2);
        commonBaseEvent.validate();
    }

    public void testValidationRequiredSituation() throws ValidationException {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setLocation("My Location");
        componentIdentification.setLocationType("OID-OSI");
        componentIdentification.setComponent("My Component");
        componentIdentification.setSubComponent("My sub component");
        componentIdentification.setComponentIdType("My Component ID Type");
        componentIdentification.setComponentType("My Component Type");
        commonBaseEvent.setReporterComponentId(componentIdentification);
        ComponentIdentification componentIdentification2 = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification2.setLocation("My Location 2");
        componentIdentification2.setLocationType("Dial");
        componentIdentification2.setComponent("My Component 2");
        componentIdentification2.setSubComponent("My sub component 2");
        componentIdentification2.setComponentIdType("My Component ID Type 2");
        componentIdentification2.setComponentType("My Component Type 2");
        commonBaseEvent.setSourceComponentId(componentIdentification2);
        Util.assertMissingAttributes(commonBaseEvent, "situation");
        Situation situation = EventFactory.eINSTANCE.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("NOT AVAILABLE");
        availableSituation.setOperationDisposition("STARTABLE");
        availableSituation.setProcessingDisposition("MGMTTASK_PROCESS");
        availableSituation.setReasoningScope("EXTERNAL");
        situation.setCategoryName("AvailableSituation");
        situation.setSituationType(availableSituation);
        commonBaseEvent.setSituation(situation);
        commonBaseEvent.validate();
    }

    public void testEquals() {
        CommonBaseEvent commonBaseEvent = null;
        this.cbe = Util.generateEvent();
        this.cbe.setVersion("1.0.1");
        this.cbe.setLocalInstanceId("local instance id");
        this.cbe.setSeverity((short)0);
        this.cbe.setPriority((short)10);
        this.cbe.setMsg("my msg");
        this.cbe.setRepeatCount((short)3);
        this.cbe.setElapsedTime(100L);
        this.cbe.setExtensionName("extension name");
        this.cbe.setSequenceNumber(987654321L);
        commonBaseEvent = Util.generateEvent();
        commonBaseEvent.setVersion("1.0.1");
        commonBaseEvent.setLocalInstanceId("local instance id");
        commonBaseEvent.setSeverity((short)0);
        commonBaseEvent.setPriority((short)10);
        commonBaseEvent.setMsg("my msg");
        commonBaseEvent.setRepeatCount((short)3);
        commonBaseEvent.setElapsedTime(100L);
        commonBaseEvent.setExtensionName("extension name");
        commonBaseEvent.setSequenceNumber(987654321L);
        Assert.assertEquals((Object)this.cbe, (Object)commonBaseEvent);
        commonBaseEvent.setSequenceNumber(123456789L);
        Assert.assertFalse((boolean)this.cbe.equals(commonBaseEvent));
        commonBaseEvent.setSequenceNumber(987654321L);
        Assert.assertEquals((Object)this.cbe, (Object)commonBaseEvent);
        commonBaseEvent.addExtendedDataElement("my ede", "value");
        Assert.assertFalse((boolean)this.cbe.equals(commonBaseEvent));
        this.cbe.addExtendedDataElement("my ede", "value");
        Assert.assertEquals((Object)this.cbe, (Object)commonBaseEvent);
        this.cbe.addExtendedDataElement("my ede", "value");
        commonBaseEvent.addExtendedDataElement("my ede", "value2");
        Assert.assertFalse((boolean)this.cbe.equals(commonBaseEvent));
    }

    public void testEquals1() {
        this.cbe = Util.generateEvent();
        this.cbe.setVersion("1.0.1");
        this.cbe.setLocalInstanceId("local instance id");
        this.cbe.setSeverity((short)0);
        this.cbe.setPriority((short)10);
        this.cbe.setMsg("my msg");
        this.cbe.setRepeatCount((short)3);
        this.cbe.setElapsedTime(100L);
        this.cbe.setExtensionName("extension name");
        this.cbe.setSequenceNumber(987654321L);
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        commonBaseEvent.setVersion("1.0.1");
        commonBaseEvent.setLocalInstanceId("local instance id");
        commonBaseEvent.setSeverity((short)0);
        commonBaseEvent.setPriority((short)10);
        commonBaseEvent.setMsg("my msg");
        commonBaseEvent.setRepeatCount((short)3);
        commonBaseEvent.setElapsedTime(100L);
        commonBaseEvent.setExtensionName("extension name");
        commonBaseEvent.setSequenceNumber(987654321L);
        Assert.assertEquals((Object)this.cbe, (Object)commonBaseEvent);
        commonBaseEvent.addExtendedDataElement("my ede", "value");
        Assert.assertFalse((boolean)this.cbe.equals(commonBaseEvent));
    }

    public void testSetCreationTime() throws ValidationException {
        this.cbe.setCreationTime("19999-05-31T13:20:00-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"year is too long to be accepted");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T13:20:00.123Q");
        try {
            this.cbe.validate();
            Assert.fail((String)"invalid UTC");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T13:20:00.123456789012345678Z");
        this.cbe.validate();
        this.cbe.setCreationTime("1999-5-138T13:20:00-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"may does not have that many days");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-ss-31T13:35:00-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"what kind of a month is ss");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T27:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"27 o'clock ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999999-05-31T13:20:00-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"year is too long to be accepted");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        try {
            this.cbe.validate();
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("7");
        try {
            this.cbe.validate();
            Assert.fail((String)"7 ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("ABC");
        try {
            this.cbe.validate();
            Assert.fail((String)"ABC ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09-05:00");
        this.cbe.validate();
        this.cbe.setCreationTime("1999,05,31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"commas ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999 5 31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"spaces ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999*05*31T21:20:09*05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"no dashes ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("i0000000000000000000000000000000Z");
        try {
            this.cbe.validate();
            Assert.fail((String)"looks like a global id ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("now is the time for all good men to come to the aid of their country");
        try {
            this.cbe.validate();
            Assert.fail((String)"sentence ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("19Q9-05-31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"Q ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-0R-31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"R ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-S1T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"S ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T2T:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"T ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:2U:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"U ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:V9-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"V ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09-0W:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"W ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09-05:0X");
        try {
            this.cbe.validate();
            Assert.fail((String)"X ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09-05:00.YZ");
        try {
            this.cbe.validate();
            Assert.fail((String)"YZ ???");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09-");
        try {
            this.cbe.validate();
            Assert.fail((String)"can't end in minus");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09+");
        try {
            this.cbe.validate();
            Assert.fail((String)"can't end in plus");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("Z1999-05-31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"can't start with Z");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("-1999-05-31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"can't start with -");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1968-05-31T21:20:09-05:00");
        try {
            this.cbe.validate();
            Assert.fail((String)"year 1968 is too old");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09.123");
        this.cbe.validate();
        this.cbe.setCreationTime("1999-05-31T21:20:09.xyz");
        try {
            this.cbe.validate();
            Assert.fail((String)"xyz is not valid subseconds");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0200E", validationException);
        }
        this.cbe.setCreationTime("1999-05-31T21:20:09.5");
        this.cbe.validate();
        long l = this.cbe.getCreationTimeAsLong();
        this.cbe.setCreationTime("1999-05-31T21:20:09.50");
        this.cbe.validate();
        long l2 = this.cbe.getCreationTimeAsLong();
        Assert.assertEquals((long)l, (long)l2);
        this.cbe.setCreationTime("1999-05-31T21:20:09.500");
        this.cbe.validate();
        l2 = this.cbe.getCreationTimeAsLong();
        Assert.assertEquals((long)l, (long)l2);
        this.cbe.setCreationTime("1999-05-31T21:20:09.5000");
        this.cbe.validate();
        l2 = this.cbe.getCreationTimeAsLong();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testGetCreationTime() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "2003-11-14T11:42:23.123-05:00";
        String string2 = this.cbe.getCreationTime();
        Assert.assertNull((Object)string2);
        this.cbe.setCreationTime(string);
        string2 = this.cbe.getCreationTime();
        Assert.assertEquals((String)string, (String)string2);
    }

    public void testGetGlobalInstanceId() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "aaa";
        String string2 = this.cbe.getGlobalInstanceId();
        Assert.assertNull((Object)string2);
        this.cbe.setGlobalInstanceId(string);
        string2 = this.cbe.getGlobalInstanceId();
        Assert.assertEquals((String)string, (String)string2);
    }

    public void testSetGlobalInstanceId() {
        String string = "a b";
        this.cbe.setGlobalInstanceId(string);
        String string2 = this.cbe.getGlobalInstanceId();
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.setGlobalInstanceId(null);
        string2 = this.cbe.getGlobalInstanceId();
        Assert.assertNull((Object)string2);
    }

    public void testGetElapsedTime() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        long l = 12345678L;
        long l2 = this.cbe.getElapsedTime();
        Assert.assertEquals((long)0L, (long)l2);
        this.cbe.setElapsedTime(l);
        l2 = this.cbe.getElapsedTime();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testSetElapsedTime() {
        long l = 87654321L;
        this.cbe.setElapsedTime(l);
        long l2 = this.cbe.getElapsedTime();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testUnsetElapsedTime() {
        long l = 99999999L;
        Assert.assertFalse((boolean)this.cbe.isSetElapsedTime());
        this.cbe.setElapsedTime(l);
        Assert.assertTrue((boolean)this.cbe.isSetElapsedTime());
        this.cbe.unsetElapsedTime();
        Assert.assertFalse((boolean)this.cbe.isSetElapsedTime());
    }

    public void testIsSetElapsedTime() {
        long l = 1L;
        Assert.assertFalse((boolean)this.cbe.isSetElapsedTime());
        this.cbe.setElapsedTime(l);
        Assert.assertTrue((boolean)this.cbe.isSetElapsedTime());
        this.cbe.unsetElapsedTime();
        Assert.assertFalse((boolean)this.cbe.isSetElapsedTime());
    }

    public void testIsSetCreationTime() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "abc";
        Assert.assertFalse((boolean)this.cbe.isSetCreationTime());
        this.cbe.setCreationTime(string);
        Assert.assertTrue((boolean)this.cbe.isSetCreationTime());
        this.cbe.unsetCreationTime();
        Assert.assertFalse((boolean)this.cbe.isSetCreationTime());
    }

    public void testGetExtensionName() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "aaa";
        String string2 = this.cbe.getExtensionName();
        Assert.assertNull((Object)string2);
        this.cbe.setExtensionName(string);
        string2 = this.cbe.getExtensionName();
        Assert.assertEquals((String)string, (String)string2);
    }

    public void testSetExtensionName() {
        String string = "a b";
        this.cbe.setExtensionName(string);
        String string2 = this.cbe.getExtensionName();
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.setExtensionName(null);
        string2 = this.cbe.getExtensionName();
        Assert.assertNull((Object)string2);
    }

    public void testGetLocalInstanceId() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "aaa";
        String string2 = this.cbe.getLocalInstanceId();
        Assert.assertNull((Object)string2);
        this.cbe.setLocalInstanceId(string);
        string2 = this.cbe.getLocalInstanceId();
        Assert.assertEquals((String)string, (String)string2);
    }

    public void testSetLocalInstanceId() {
        String string = "a b";
        this.cbe.setLocalInstanceId(string);
        String string2 = this.cbe.getLocalInstanceId();
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.setLocalInstanceId(null);
        string2 = this.cbe.getLocalInstanceId();
        Assert.assertNull((Object)string2);
    }

    public void testGetMsg() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "aaa";
        String string2 = this.cbe.getMsg();
        Assert.assertNull((Object)string2);
        this.cbe.setMsg(string);
        string2 = this.cbe.getMsg();
        Assert.assertEquals((String)string, (String)string2);
    }

    public void testSetMsg() {
        String string = "a b";
        this.cbe.setMsg(string);
        String string2 = this.cbe.getMsg();
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.setMsg(null);
        string2 = this.cbe.getMsg();
        Assert.assertNull((Object)string2);
    }

    public void testGetPriority() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        short s = 1;
        short s2 = this.cbe.getPriority();
        Assert.assertEquals((int)0, (int)s2);
        this.cbe.setPriority(s);
        s2 = this.cbe.getPriority();
        Assert.assertEquals((short)s, (short)s2);
    }

    public void testSetPriority() {
        short s = 8765;
        this.cbe.setPriority(s);
        short s2 = this.cbe.getPriority();
        Assert.assertEquals((short)s, (short)s2);
    }

    public void testUnsetPriority() {
        short s = 9999;
        Assert.assertFalse((boolean)this.cbe.isSetPriority());
        this.cbe.setPriority(s);
        Assert.assertTrue((boolean)this.cbe.isSetPriority());
        this.cbe.unsetPriority();
        Assert.assertFalse((boolean)this.cbe.isSetPriority());
    }

    public void testIsSetPriority() {
        short s = 1;
        Assert.assertFalse((boolean)this.cbe.isSetPriority());
        this.cbe.setPriority(s);
        Assert.assertTrue((boolean)this.cbe.isSetPriority());
        this.cbe.unsetPriority();
        Assert.assertFalse((boolean)this.cbe.isSetPriority());
    }

    public void testGetRepeatCount() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        short s = 1;
        short s2 = this.cbe.getRepeatCount();
        Assert.assertEquals((int)0, (int)s2);
        this.cbe.setRepeatCount(s);
        s2 = this.cbe.getRepeatCount();
        Assert.assertEquals((short)s, (short)s2);
    }

    public void testSetRepeatCount() {
        short s = 8765;
        this.cbe.setRepeatCount(s);
        short s2 = this.cbe.getRepeatCount();
        Assert.assertEquals((short)s, (short)s2);
    }

    public void testUnsetRepeatCount() {
        short s = 9999;
        Assert.assertFalse((boolean)this.cbe.isSetRepeatCount());
        this.cbe.setRepeatCount(s);
        Assert.assertTrue((boolean)this.cbe.isSetRepeatCount());
        this.cbe.unsetRepeatCount();
        Assert.assertFalse((boolean)this.cbe.isSetRepeatCount());
    }

    public void testIsSetRepeatCount() {
        short s = 1;
        Assert.assertFalse((boolean)this.cbe.isSetRepeatCount());
        this.cbe.setRepeatCount(s);
        Assert.assertTrue((boolean)this.cbe.isSetRepeatCount());
        this.cbe.unsetRepeatCount();
        Assert.assertFalse((boolean)this.cbe.isSetRepeatCount());
    }

    public void testGetSequenceNumber() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        long l = 12345678L;
        long l2 = this.cbe.getSequenceNumber();
        Assert.assertEquals((long)0L, (long)l2);
        this.cbe.setSequenceNumber(l);
        l2 = this.cbe.getSequenceNumber();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testSetSequenceNumber() {
        long l = 87654321L;
        this.cbe.setSequenceNumber(l);
        long l2 = this.cbe.getSequenceNumber();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testUnsetSequenceNumber() {
        long l = 99999999L;
        Assert.assertFalse((boolean)this.cbe.isSetSequenceNumber());
        this.cbe.setSequenceNumber(l);
        Assert.assertTrue((boolean)this.cbe.isSetSequenceNumber());
        this.cbe.unsetSequenceNumber();
        Assert.assertFalse((boolean)this.cbe.isSetSequenceNumber());
    }

    public void testIsSetSequenceNumber() {
        long l = 1L;
        Assert.assertFalse((boolean)this.cbe.isSetSequenceNumber());
        this.cbe.setSequenceNumber(l);
        Assert.assertTrue((boolean)this.cbe.isSetSequenceNumber());
        this.cbe.unsetSequenceNumber();
        Assert.assertFalse((boolean)this.cbe.isSetSequenceNumber());
    }

    public void testGetSeverity() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        short s = 1;
        short s2 = this.cbe.getSeverity();
        Assert.assertEquals((int)0, (int)s2);
        this.cbe.setSeverity(s);
        s2 = this.cbe.getSeverity();
        Assert.assertEquals((short)s, (short)s2);
    }

    public void testSetSeverity() {
        short s = 8765;
        this.cbe.setSeverity(s);
        short s2 = this.cbe.getSeverity();
        Assert.assertEquals((short)s, (short)s2);
    }

    public void testUnsetSeverity() {
        short s = 9999;
        Assert.assertFalse((boolean)this.cbe.isSetSeverity());
        this.cbe.setSeverity(s);
        Assert.assertTrue((boolean)this.cbe.isSetSeverity());
        this.cbe.unsetSeverity();
        Assert.assertFalse((boolean)this.cbe.isSetSeverity());
    }

    public void testIsSetSeverity() {
        short s = 1;
        Assert.assertFalse((boolean)this.cbe.isSetSeverity());
        this.cbe.setSeverity(s);
        Assert.assertTrue((boolean)this.cbe.isSetSeverity());
        this.cbe.unsetSeverity();
        Assert.assertFalse((boolean)this.cbe.isSetSeverity());
    }

    public void testGetVersion() {
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        String string = "1.2.3.4";
        String string2 = this.cbe.getVersion();
        Assert.assertEquals((String)"1.0.1", (String)string2);
        this.cbe.setVersion(string);
        string2 = this.cbe.getVersion();
        Assert.assertEquals((String)string, (String)string2);
    }

    public void testSetVersion() {
        String string = "1.0.1";
        this.cbe.setVersion(string);
        String string2 = this.cbe.getVersion();
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.setVersion(null);
        string2 = this.cbe.getVersion();
        Assert.assertNull((Object)string2);
    }

    public void testGetSituation() throws ValidationException {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Assert.assertEquals(null, (Object)commonBaseEvent.getSituation());
        Situation situation = EventFactory.eINSTANCE.createSituation();
        this.cbe.setSituation(situation);
        Assert.assertEquals((Object)situation, (Object)this.cbe.getSituation());
        Situation situation2 = EventFactory.eINSTANCE.createSituation();
        situation2.setCategoryName("AvailableSituation");
        situation2.setAvailableSituation("r", "NOT AVAILABLE", "STARTABLE", "MGMTTASK_PROCESS");
        this.cbe.setSituation(situation2);
        Assert.assertEquals((Object)situation2, (Object)this.cbe.getSituation());
    }

    public void testBasicSetSituation() {
    }

    public void testSetSituation() {
    }

    public void testGetAny() {
    }

    public void testGetAssociatedEvents() {
    }

    public void testGetContextDataElements() {
    }

    public void testGetExtendedDataElements() {
    }

    public void testGetMsgDataElement() throws ValidationException {
        Assert.assertEquals(null, (Object)this.cbe.getMsgDataElement());
        MsgDataElement msgDataElement = EventFactory.eINSTANCE.createMsgDataElement();
        this.cbe.setMsgDataElement(msgDataElement);
        Assert.assertEquals((Object)msgDataElement, (Object)this.cbe.getMsgDataElement());
        MsgDataElement msgDataElement2 = EventFactory.eINSTANCE.createMsgDataElement();
        msgDataElement2.setMsgId("123 456");
        msgDataElement2.setMsgIdType("type 1");
        this.cbe.setMsgDataElement(msgDataElement2);
        Assert.assertEquals((Object)msgDataElement2, (Object)this.cbe.getMsgDataElement());
    }

    public void testBasicSetMsgDataElement() {
    }

    public void testSetMsgDataElement() {
    }

    public void testGetReporterComponentId() {
    }

    public void testBasicSetReporterComponentId() {
    }

    public void testSetReporterComponentIdComponentIdentification() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Assert.assertEquals(null, (Object)commonBaseEvent.getReporterComponentId());
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        String string = "Reporter Component ID";
        String string2 = "OID-OSI";
        String string3 = "IBM DB2#7.1";
        String string4 = "My sub component";
        String string5 = "SystemName";
        String string6 = "My Component Type";
        componentIdentification.setLocation(string);
        componentIdentification.setLocationType(string2);
        componentIdentification.setComponent(string3);
        componentIdentification.setSubComponent(string4);
        componentIdentification.setComponentIdType(string5);
        componentIdentification.setComponentType(string6);
        this.cbe.setReporterComponentId(componentIdentification);
        Assert.assertNotNull((Object)this.cbe.getReporterComponentId());
        ComponentIdentification componentIdentification2 = this.cbe.getReporterComponentId();
        Assert.assertNotNull((Object)componentIdentification2);
        Assert.assertEquals((String)string, (String)componentIdentification2.getLocation());
        Assert.assertEquals((String)string2, (String)componentIdentification2.getLocationType());
        Assert.assertEquals((String)string3, (String)componentIdentification2.getComponent());
        Assert.assertEquals((String)string4, (String)componentIdentification2.getSubComponent());
        Assert.assertEquals((String)string5, (String)componentIdentification2.getComponentIdType());
        Assert.assertEquals((String)string6, (String)componentIdentification2.getComponentType());
    }

    public void testGetSourceComponentId() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Assert.assertEquals(null, (Object)commonBaseEvent.getSourceComponentId());
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        String string = "Source Component ID";
        String string2 = "OID-OSI";
        String string3 = "IBM DB2#7.1";
        String string4 = "My sub component";
        String string5 = "SystemName";
        String string6 = "My Component Type";
        componentIdentification.setLocation(string);
        componentIdentification.setLocationType(string2);
        componentIdentification.setComponent(string3);
        componentIdentification.setSubComponent(string4);
        componentIdentification.setComponentIdType(string5);
        componentIdentification.setComponentType(string6);
        this.cbe.setSourceComponentId(componentIdentification);
        Assert.assertNotNull((Object)this.cbe.getSourceComponentId());
        ComponentIdentification componentIdentification2 = this.cbe.getSourceComponentId();
        Assert.assertNotNull((Object)componentIdentification2);
        Assert.assertEquals((String)string, (String)componentIdentification2.getLocation());
        Assert.assertEquals((String)string2, (String)componentIdentification2.getLocationType());
        Assert.assertEquals((String)string3, (String)componentIdentification2.getComponent());
        Assert.assertEquals((String)string4, (String)componentIdentification2.getSubComponent());
        Assert.assertEquals((String)string5, (String)componentIdentification2.getComponentIdType());
        Assert.assertEquals((String)string6, (String)componentIdentification2.getComponentType());
    }

    public void testDuplicateAny() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();
        commonBaseEvent.getAny().add("1");
        commonBaseEvent.getAny().add("1");
        Assert.assertEquals((int)2, (int)commonBaseEvent.getAny().size());
    }

    public void testBasicSetSourceComponentId() {
    }

    public void testSetSourceComponentIdComponentIdentification() {
    }

    public void testEInverseRemoveInternalEObjectintClassNotificationChain() {
    }

    public void testEGetEStructuralFeatureboolean() {
    }

    public void testEIsSetEStructuralFeature() {
    }

    public void testESetEStructuralFeatureObject() {
    }

    public void testEUnsetEStructuralFeature() {
    }

    public void testToString() {
        Assert.assertNotNull((String)"cbe with soma data filled in", (Object)this.cbe.toString());
        this.cbe = EventFactory.eINSTANCE.createCommonBaseEvent();
        Assert.assertNotNull((String)"empty cbe", (Object)this.cbe.toString());
    }

    public void testComplete() throws EventException {
        ContentHandler contentHandler = new ContentHandler(){

            public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
                commonBaseEvent.setExtensionName("Example");
            }
        };
        EventFactory eventFactory = EventFactoryFactory.createEventFactory(contentHandler);
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();
        commonBaseEvent.complete();
        Assert.assertNotNull((Object)commonBaseEvent.getExtensionName());
        Assert.assertEquals((String)"Example", (String)commonBaseEvent.getExtensionName());
    }

    public void testFailedComplete() {
        ContentHandler contentHandler = new ContentHandler(){

            public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
                throw new CompletionException();
            }
        };
        EventFactory eventFactory = EventFactoryFactory.createEventFactory(contentHandler);
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();
        try {
            commonBaseEvent.complete();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EventException eventException) {
            // empty catch block
        }
    }

    public void testValidateThreaded() throws ValidationException {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        commonBaseEvent.validate();
    }

    public void testValidate() throws ValidationException {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        commonBaseEvent.validate();
        commonBaseEvent.setVersion("1.0.1.0");
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid version: 1.0.1.0");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0205E", validationException);
        }
        commonBaseEvent.setVersion("1.0.1");
        commonBaseEvent.validate();
        commonBaseEvent.setLocalInstanceId(Util.getPaddedString(129));
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid LocalInstanceId");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0207E", validationException);
        }
        commonBaseEvent.setLocalInstanceId("my id");
        commonBaseEvent.validate();
        commonBaseEvent.setGlobalInstanceId(Util.getAlphaString(31));
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid GlobalInstanceId");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0206E", validationException);
        }
        commonBaseEvent.setGlobalInstanceId(Util.getAlphaString(65));
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid GlobalInstanceId");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0206E", validationException);
        }
        commonBaseEvent.setGlobalInstanceId(Util.getPaddedString(42));
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid GlobalInstanceId - must start with alpha character");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0190E", validationException);
        }
        commonBaseEvent.setGlobalInstanceId(Util.getAlphaString(42));
        commonBaseEvent.validate();
        commonBaseEvent.setSeverity((short)71);
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid Severity");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0202E", validationException);
        }
        commonBaseEvent.setSeverity((short)-3);
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid Severity");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0202E", validationException);
        }
        commonBaseEvent.setSeverity((short)50);
        commonBaseEvent.validate();
        commonBaseEvent.setPriority((short)101);
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid Priority");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0202E", validationException);
        }
        commonBaseEvent.setPriority((short)-3);
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid Priority");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0202E", validationException);
        }
        commonBaseEvent.setPriority((short)0);
        commonBaseEvent.validate();
        commonBaseEvent.setPriority((short)100);
        commonBaseEvent.validate();
        commonBaseEvent.setMsg(Util.getPaddedString(1025));
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid Msg");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0207E", validationException);
        }
        commonBaseEvent.setMsg("howdy howdy");
        commonBaseEvent.validate();
        commonBaseEvent.setRepeatCount((short)5);
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"repeatCount is set, but elapsedTime is not yet set");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0203E", validationException);
        }
        commonBaseEvent.setElapsedTime(123L);
        commonBaseEvent.validate();
        commonBaseEvent.setExtensionName(Util.getAlphaString(65));
        try {
            commonBaseEvent.validate();
            Assert.fail((String)"Invalid extensionName");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0207E", validationException);
        }
        commonBaseEvent.setExtensionName("UnCommonBaseEvent");
        commonBaseEvent.validate();
        commonBaseEvent.setSequenceNumber(123L);
        commonBaseEvent.validate();
    }

    public void testGetCreationTimeAsLong() throws ValidationException {
        long l = new Long("1067528539452");
        String string = "2003-10-30T10:42:19.452-05:00";
        this.cbe.setCreationTime(string);
        this.cbe.validate();
        long l2 = this.cbe.getCreationTimeAsLong();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testSetCreationTimeAsLong() throws ValidationException {
        long l = new Long("1067528539452");
        String string = "2003-10-30T15:42:19.452Z";
        this.cbe.setCreationTimeAsLong(l);
        this.cbe.validate();
        String string2 = this.cbe.getCreationTime();
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.setCreationTime(string);
        this.cbe.validate();
        long l2 = this.cbe.getCreationTimeAsLong();
        Assert.assertEquals((long)l, (long)l2);
        string = "2003-10-30T17:42:19.452+02:00";
        this.cbe.setCreationTime(string);
        this.cbe.validate();
        l2 = this.cbe.getCreationTimeAsLong();
        Assert.assertEquals((long)l, (long)l2);
    }

    public void testAddAny() throws ValidationException {
        Assert.assertEquals((String)"list should be empty", (int)0, (int)this.cbe.getAny().size());
        String string = "sometext";
        this.cbe.addAny(string);
        Assert.assertEquals((int)1, (int)this.cbe.getAny().size());
        String string2 = (String)this.cbe.getAny().get(0);
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((String)string, (String)string2);
        string = "someothertext";
        this.cbe.addAny(string);
        Assert.assertEquals((int)2, (int)this.cbe.getAny().size());
        string2 = (String)this.cbe.getAny().get(1);
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((String)string, (String)string2);
        this.cbe.validate();
    }

    public void testAddAssociatedEvents() throws ValidationException {
        Assert.assertEquals((String)"list should be empty", (int)0, (int)this.cbe.getAssociatedEvents().size());
        String string = "ae name 1";
        String string2 = "ae type 1";
        String string3 = "CE123456789012345678901234567890";
        String[] stringArray = new String[]{"CE12345678901234567890123456789A", "CE12345678901234567890123456789B"};
        this.cbe.addAssociatedEvent(string, string2, string3, stringArray);
        Assert.assertEquals((int)1, (int)this.cbe.getAssociatedEvents().size());
        AssociatedEvent associatedEvent = (AssociatedEvent)this.cbe.getAssociatedEvents().get(0);
        Assert.assertNotNull((Object)associatedEvent);
        AssociationEngine associationEngine = associatedEvent.getAssociationEngineInfo();
        Assert.assertEquals((String)string, (String)associationEngine.getName());
        Assert.assertEquals((String)string2, (String)associationEngine.getType());
        Assert.assertEquals((String)string3, (String)associationEngine.getId());
        String[] stringArray2 = associatedEvent.getResolvedEventsAsArray();
        Assert.assertEquals((String)stringArray[0], (String)stringArray2[0]);
        Assert.assertEquals((String)stringArray[1], (String)stringArray2[1]);
        this.cbe.validate();
        String string4 = "ae name 1";
        String string5 = "ae type 1";
        String string6 = "CE123456789012345678901234567891";
        String[] stringArray3 = new String[]{"CE12345678901234567890123456789C", "CE12345678901234567890123456789D"};
        this.cbe.addAssociatedEvent(string4, string5, string6, stringArray3);
        Assert.assertEquals((int)2, (int)this.cbe.getAssociatedEvents().size());
        AssociatedEvent associatedEvent2 = (AssociatedEvent)this.cbe.getAssociatedEvents().get(1);
        Assert.assertNotNull((Object)associatedEvent2);
        AssociationEngine associationEngine2 = associatedEvent2.getAssociationEngineInfo();
        Assert.assertEquals((String)string4, (String)associationEngine2.getName());
        Assert.assertEquals((String)string5, (String)associationEngine2.getType());
        Assert.assertEquals((String)string6, (String)associationEngine2.getId());
        String[] stringArray4 = associatedEvent2.getResolvedEventsAsArray();
        Assert.assertEquals((String)stringArray3[0], (String)stringArray4[0]);
        Assert.assertEquals((String)stringArray3[1], (String)stringArray4[1]);
        this.cbe.validate();
    }

    public void testAddContextDataElement() throws ValidationException {
        Assert.assertEquals((String)"list should be empty", (int)0, (int)this.cbe.getContextDataElements().size());
        String string = Util.getAlphaString(32);
        String string2 = null;
        String string3 = "ce name 1";
        String string4 = "ce type 1";
        this.cbe.addContextDataElementWithId(string4, string3, string);
        Assert.assertEquals((int)1, (int)this.cbe.getContextDataElements().size());
        ContextDataElement contextDataElement = (ContextDataElement)this.cbe.getContextDataElements().get(0);
        Assert.assertNotNull((Object)contextDataElement);
        Assert.assertEquals((String)string, (String)contextDataElement.getContextId());
        Assert.assertEquals(string2, (String)contextDataElement.getContextValue());
        Assert.assertEquals((String)string3, (String)contextDataElement.getName());
        Assert.assertEquals((String)string4, (String)contextDataElement.getType());
        String string5 = null;
        String string6 = "ce value 2";
        String string7 = "ce name 2";
        String string8 = "ce type 2";
        this.cbe.addContextDataElementWithValue(string8, string7, string6);
        Assert.assertEquals((int)2, (int)this.cbe.getContextDataElements().size());
        ContextDataElement contextDataElement2 = (ContextDataElement)this.cbe.getContextDataElements().get(1);
        Assert.assertNotNull((Object)contextDataElement2);
        Assert.assertEquals(string5, (String)contextDataElement2.getContextId());
        Assert.assertEquals((String)string6, (String)contextDataElement2.getContextValue());
        Assert.assertEquals((String)string7, (String)contextDataElement2.getName());
        Assert.assertEquals((String)string8, (String)contextDataElement2.getType());
        this.cbe.addContextDataElementWithId(string4, string3, string);
        Assert.assertEquals((int)3, (int)this.cbe.getContextDataElements().size());
        ContextDataElement contextDataElement3 = (ContextDataElement)this.cbe.getContextDataElements().get(2);
        Assert.assertNotNull((Object)contextDataElement3);
        Assert.assertEquals((String)string, (String)contextDataElement3.getContextId());
        Assert.assertEquals(string2, (String)contextDataElement3.getContextValue());
        Assert.assertEquals((String)string3, (String)contextDataElement3.getName());
        Assert.assertEquals((String)string4, (String)contextDataElement3.getType());
        this.cbe.validate();
        contextDataElement = this.cbe.addContextDataElementWithValue("type", "name", "value");
        contextDataElement.setContextId(Util.getPaddedString(32));
        Assert.assertEquals((int)4, (int)this.cbe.getContextDataElements().size());
        ContextDataElement contextDataElement4 = (ContextDataElement)this.cbe.getContextDataElements().get(3);
        Assert.assertNotNull((Object)contextDataElement4);
        try {
            this.cbe.validate();
            Assert.fail((String)"Can't specify both ID and Value on a ContextDataElement");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0204E", validationException);
        }
    }

    public void testAddExtendedDataElementGenericWithHexBinary() throws ValidationException {
        String string = "abc123";
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement("AA", 19, string);
        Assert.assertEquals((int)1, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertEquals((String)"hexBinary", (String)extendedDataElement2.getType());
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement.getHexValue());
    }

    public void testAddExtendedDataElementWithHexBinaryString() throws ValidationException {
        String string = "abc123";
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithHexValue("AA", string);
        Assert.assertEquals((int)1, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertEquals((String)"hexBinary", (String)extendedDataElement2.getType());
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement.getHexValue());
    }

    public void testAddExtendedDataElementWithHexBinaryBytes() throws ValidationException {
        byte[] byArray = new byte[]{5, 6, 7};
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithHexValue("AA", byArray);
        Assert.assertEquals((int)1, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertEquals((String)"hexBinary", (String)extendedDataElement2.getType());
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        byte[] byArray2 = extendedDataElement2.getHexValueAsByteArray();
        Assert.assertEquals((int)byArray.length, (int)byArray2.length);
        int n = 0;
        while (n < byArray2.length) {
            Assert.assertEquals((String)("mismatch: " + n), (byte)byArray[n], (byte)byArray2[n]);
            ++n;
        }
    }

    public void testAddExtendedDataElementStringintString() throws ValidationException {
        String string = "Scott Brown";
        String string2 = "TEC Developer";
        Assert.assertEquals((int)0, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement(string, 7, string2);
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement2);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement2.getName());
        Assert.assertEquals((String)string2, (String)extendedDataElement2.getValuesAsString());
        Assert.assertEquals((String)"string", (String)extendedDataElement2.getType());
        this.cbe.validate();
        extendedDataElement = this.cbe.addExtendedDataElement(string, 3, "xxx xxx");
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(1);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement3);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement3);
        Assert.assertEquals((String)string, (String)extendedDataElement3.getName());
        try {
            this.cbe.validate();
            Assert.fail((String)"Created an ExtendedDataElement with a String value but set the type to INT");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
    }

    public void testAddExtendedDataElementStringintStringArray() throws ValidationException {
        String string = "Scott Brown";
        String[] stringArray = new String[]{"I am", "a", "TEC Developer"};
        Assert.assertEquals((int)0, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement(string, 16, stringArray);
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement2);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement2.getName());
        Assert.assertEquals((int)3, (int)extendedDataElement2.getValuesAsStringArray().length);
        Assert.assertEquals((String)stringArray[0], (String)extendedDataElement2.getValuesAsStringArray()[0]);
        Assert.assertEquals((String)stringArray[1], (String)extendedDataElement2.getValuesAsStringArray()[1]);
        Assert.assertEquals((String)stringArray[2], (String)extendedDataElement2.getValuesAsStringArray()[2]);
        Assert.assertEquals((String)"stringArray", (String)extendedDataElement2.getType());
        this.cbe.validate();
        extendedDataElement = this.cbe.addExtendedDataElement(string, 4, "123");
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(1);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement3);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement3);
        Assert.assertEquals((String)string, (String)extendedDataElement3.getName());
        Assert.assertEquals((long)123L, (long)extendedDataElement3.getValuesAsLong());
        Assert.assertEquals((String)"long", (String)extendedDataElement3.getType());
        extendedDataElement = this.cbe.addExtendedDataElement(string, 4, "xxx xxx");
        extendedDataElement3 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(2);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement3);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement3);
        Assert.assertEquals((String)string, (String)extendedDataElement3.getName());
        try {
            this.cbe.validate();
            Assert.fail((String)"Created an ExtendedDataElement with a String value but set the type to LONG");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
    }

    public void testAddExtendedDataElementStringString() throws ValidationException {
        String string = "Scott Brown";
        String string2 = "TEC Developer";
        Assert.assertEquals((int)0, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement(string, string2);
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement2);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement2.getName());
        Assert.assertEquals((String)string2, (String)extendedDataElement2.getValuesAsString());
        Assert.assertEquals((String)"string", (String)extendedDataElement2.getType());
        extendedDataElement = this.cbe.addExtendedDataElement(string, "xxx xxx");
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(1);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement3);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement3);
        Assert.assertEquals((String)string, (String)extendedDataElement3.getName());
        Assert.assertEquals((String)"xxx xxx", (String)extendedDataElement3.getValuesAsString());
        Assert.assertEquals((String)"string", (String)extendedDataElement3.getType());
        this.cbe.validate();
    }

    public void testAddExtendedDataElementStringStringArray() {
        String string = "Scott Brown";
        String[] stringArray = new String[]{"TEC Developer", "bike rider"};
        Assert.assertEquals((int)0, (int)this.cbe.getExtendedDataElements().size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement(string, stringArray);
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertNotNull((Object)extendedDataElement);
        Assert.assertNotNull((Object)extendedDataElement2);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement2.getName());
        Assert.assertEquals((String)stringArray[0], (String)extendedDataElement2.getValuesAsStringArray()[0]);
        Assert.assertEquals((String)stringArray[1], (String)extendedDataElement2.getValuesAsStringArray()[1]);
        Assert.assertEquals((String)"stringArray", (String)extendedDataElement2.getType());
    }

    public void testAddExtendedDataElementString() {
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement("Fred");
        EList eList = this.cbe.getExtendedDataElements("Fred");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals(eList.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"Fred", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"Fred", (String)extendedDataElement.getName());
        Assert.assertNull((Object)extendedDataElement.getType());
        Assert.assertTrue((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
    }

    public void testAddExtendedDataElementWithByteArrayValue() {
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        byte[] byArray = new byte[]{97, 98};
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithByteArrayValue("myede", byArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)10, (int)extendedDataElement3.getTypeAsInt());
        byte[] byArray2 = extendedDataElement3.getValuesAsByteArray();
        Assert.assertEquals((int)byArray.length, (int)byArray2.length);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertEquals((byte)byArray[n], (byte)byArray2[n]);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithByteValue() {
        byte by = 97;
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithByteValue("myede", by);
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)1, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertEquals((byte)by, (byte)extendedDataElement3.getValuesAsByte());
    }

    public void testAddExtendedDataElementWithDateArrayValue() {
        String[] stringArray = new String[]{"1896-12-31T11:00:00.000Z", "3001-12-31T11:00:00.000-05:00", "2007-12-31T11:00:00.000+11:00"};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithDateArrayValue("myede", stringArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)17, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertTrue((boolean)Arrays.asList(extendedDataElement3.getValuesAsDateArray()).containsAll(Arrays.asList(stringArray)));
    }

    public void testAddExtendedDataElementWithDateAsLongValue() {
        long l = System.currentTimeMillis();
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithDateAsLongValue("myede", l);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)8, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertEquals((long)l, (long)extendedDataElement3.getValuesAsDateAsLong());
    }

    public void testAddExtendedDataElementWithDatesAsLongValue() {
        long[] lArray = new long[]{System.currentTimeMillis(), System.currentTimeMillis() + 100000L};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithDatesAsLongValue("myede", lArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)17, (int)extendedDataElement3.getTypeAsInt());
        long[] lArray2 = extendedDataElement3.getValuesAsDateAsLongArray();
        Assert.assertEquals((int)lArray.length, (int)lArray2.length);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertEquals((long)lArray[n], (long)lArray2[n]);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithDateValue() {
        String string = "2003-11-10T12:00:00.000Z";
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithDateValue("myede", string);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)8, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertEquals((String)string, (String)extendedDataElement3.getValuesAsDate());
    }

    public void testAddExtendedDataElementWithDoubleArrayValue() {
        double[] dArray = new double[]{34.7, 65.8};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithDoubleArrayValue("myede", dArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)15, (int)extendedDataElement3.getTypeAsInt());
        double[] dArray2 = extendedDataElement3.getValuesAsDoubleArray();
        Assert.assertEquals((int)dArray.length, (int)dArray2.length);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertTrue((dArray[n] == dArray2[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithDoubleValue() {
        double d = 12.5;
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithDoubleValue("myede", d);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)6, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertTrue((extendedDataElement3.getValuesAsDouble() == d ? 1 : 0) != 0);
    }

    public void testAddExtendedDataElementWithFloatArrayValue() {
        float[] fArray = new float[]{2.1321312E8f, 1.2312414E8f};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithFloatArrayValue("myede", fArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)14, (int)extendedDataElement3.getTypeAsInt());
        float[] fArray2 = extendedDataElement3.getValuesAsFloatArray();
        Assert.assertEquals((int)fArray.length, (int)fArray2.length);
        int n = 0;
        while (n < fArray.length) {
            Assert.assertTrue((fArray[n] == fArray2[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithFloatValue() {
        float f = 97.0f;
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithFloatValue("myede", f);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)5, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertTrue((extendedDataElement3.getValuesAsFloat() == f ? 1 : 0) != 0);
    }

    public void testAddExtendedDataElementWithIntArrayValue() {
        int[] nArray = new int[]{10, 12};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithIntArrayValue("myede", nArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)12, (int)extendedDataElement3.getTypeAsInt());
        int[] nArray2 = extendedDataElement3.getValuesAsIntArray();
        Assert.assertEquals((int)nArray.length, (int)nArray2.length);
        int n = 0;
        while (n < nArray.length) {
            Assert.assertTrue((nArray[n] == nArray2[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithIntValue() {
        int n = 123;
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithIntValue("myede", n);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)3, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertEquals((int)n, (int)extendedDataElement3.getValuesAsInt());
    }

    public void testAddExtendedDataElementWithLongArrayValue() {
        long[] lArray = new long[]{10121416L, 12100806L};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithLongArrayValue("myede", lArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)13, (int)extendedDataElement3.getTypeAsInt());
        long[] lArray2 = extendedDataElement3.getValuesAsLongArray();
        Assert.assertEquals((int)lArray.length, (int)lArray2.length);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertTrue((lArray[n] == lArray2[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithLongValue() {
        long l = 123456789L;
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithLongValue("myede", l);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)4, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertEquals((long)l, (long)extendedDataElement3.getValuesAsLong());
    }

    public void testAddExtendedDataElementWithShortArrayValue() {
        short[] sArray = new short[]{10, 12};
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithShortArrayValue("myede", sArray);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)11, (int)extendedDataElement3.getTypeAsInt());
        short[] sArray2 = extendedDataElement3.getValuesAsShortArray();
        Assert.assertEquals((int)sArray.length, (int)sArray2.length);
        int n = 0;
        while (n < sArray.length) {
            Assert.assertEquals((short)sArray[n], (short)sArray2[n]);
            ++n;
        }
    }

    public void testAddExtendedDataElementWithShortValue() {
        short s = 4;
        EList eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)0, (int)eList.size());
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElementWithShortValue("myede", s);
        eList = this.cbe.getExtendedDataElements();
        Assert.assertEquals((int)1, (int)eList.size());
        EList eList2 = this.cbe.getExtendedDataElements("myede");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals(eList2.get(0), (Object)extendedDataElement);
        Assert.assertEquals((String)"myede", (String)extendedDataElement2.getName());
        Assert.assertEquals((String)"myede", (String)extendedDataElement.getName());
        Assert.assertNotNull((Object)extendedDataElement.getType());
        Assert.assertFalse((boolean)extendedDataElement.getValues().isEmpty());
        Assert.assertNull((Object)extendedDataElement.getHexValue());
        Assert.assertTrue((boolean)extendedDataElement.getChildren().isEmpty());
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList2.get(0);
        Assert.assertEquals((int)2, (int)extendedDataElement3.getTypeAsInt());
        Assert.assertEquals((short)s, (short)extendedDataElement3.getValuesAsShort());
    }

    public void testSetMsgDataElementStringStringMsgCatalogTokenArrayStringStringStringString() {
        String string = "msg catalog";
        String string2 = "msgcatalogid";
        String string3 = "msg catalog type";
        String string4 = "msg id";
        String string5 = "msg id type";
        String string6 = "msg locale";
        MsgCatalogToken msgCatalogToken = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken.setValue("test 1");
        MsgCatalogToken msgCatalogToken2 = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken2.setValue("test 2");
        MsgCatalogToken[] msgCatalogTokenArray = new MsgCatalogToken[]{msgCatalogToken, msgCatalogToken2};
        this.cbe.setMsgDataElement(string, string2, msgCatalogTokenArray, string3, string4, string5, string6);
        Assert.assertNotNull((Object)this.cbe.getMsgDataElement());
        MsgDataElement msgDataElement = this.cbe.getMsgDataElement();
        Assert.assertNotNull((Object)msgDataElement);
        Assert.assertEquals((String)string, (String)msgDataElement.getMsgCatalog());
        Assert.assertEquals((String)string2, (String)msgDataElement.getMsgCatalogId());
        MsgCatalogToken msgCatalogToken3 = (MsgCatalogToken)msgDataElement.getMsgCatalogTokens().get(0);
        Assert.assertEquals((String)"test 1", (String)msgCatalogToken3.getValue());
        msgCatalogToken3 = (MsgCatalogToken)msgDataElement.getMsgCatalogTokens().get(1);
        Assert.assertEquals((String)"test 2", (String)msgCatalogToken3.getValue());
        Assert.assertEquals((String)string3, (String)msgDataElement.getMsgCatalogType());
        Assert.assertEquals((String)string4, (String)msgDataElement.getMsgId());
        Assert.assertEquals((String)string5, (String)msgDataElement.getMsgIdType());
        Assert.assertEquals((String)string6, (String)msgDataElement.getMsgLocale());
    }

    public void testSetMsgDataElementStringStringStringArrayStringStringStringString() {
        String string = "msg catalog";
        String string2 = "msgcatalogid";
        String[] stringArray = new String[]{"token 1", "token 2"};
        String string3 = "msg catalog type";
        String string4 = "msg id";
        String string5 = "msg id type";
        String string6 = "msg locale";
        this.cbe.setMsgDataElement(string, string2, stringArray, string3, string4, string5, string6);
        Assert.assertNotNull((Object)this.cbe.getMsgDataElement());
        MsgDataElement msgDataElement = this.cbe.getMsgDataElement();
        Assert.assertNotNull((Object)msgDataElement);
        Assert.assertEquals((String)string, (String)msgDataElement.getMsgCatalog());
        Assert.assertEquals((String)string2, (String)msgDataElement.getMsgCatalogId());
        Assert.assertEquals((String)"token 1", (String)msgDataElement.getMsgCatalogTokensAsStrings()[0]);
        Assert.assertEquals((String)"token 2", (String)msgDataElement.getMsgCatalogTokensAsStrings()[1]);
        Assert.assertEquals((String)string3, (String)msgDataElement.getMsgCatalogType());
        Assert.assertEquals((String)string4, (String)msgDataElement.getMsgId());
        Assert.assertEquals((String)string5, (String)msgDataElement.getMsgIdType());
        Assert.assertEquals((String)string6, (String)msgDataElement.getMsgLocale());
    }

    public void testGetExtendedDataElementsString() {
        ExtendedDataElement extendedDataElement = this.cbe.addExtendedDataElement("myEDE", "value1");
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(0);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        ExtendedDataElement extendedDataElement3 = this.cbe.addExtendedDataElement("myOtherEDE", "value2");
        ExtendedDataElement extendedDataElement4 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(1);
        Assert.assertEquals((Object)extendedDataElement3, (Object)extendedDataElement4);
        ExtendedDataElement extendedDataElement5 = this.cbe.addExtendedDataElement("myEDE", "value3");
        ExtendedDataElement extendedDataElement6 = (ExtendedDataElement)this.cbe.getExtendedDataElements().get(2);
        Assert.assertEquals((Object)extendedDataElement5, (Object)extendedDataElement6);
        EList eList = this.cbe.getExtendedDataElements("myEDE");
        Assert.assertEquals((int)2, (int)eList.size());
        ExtendedDataElement extendedDataElement7 = (ExtendedDataElement)eList.get(0);
        ExtendedDataElement extendedDataElement8 = (ExtendedDataElement)eList.get(1);
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement7);
        Assert.assertEquals((Object)extendedDataElement5, (Object)extendedDataElement8);
    }

    public void testSetReporterComponentIdStringStringStringStringStringStringString() {
        String string = "my Application";
        String string2 = "my component";
        String string3 = "my comp type";
        String string4 = "my comp id type";
        String string5 = "My sub component";
        String string6 = "my loc";
        String string7 = "Unknown";
        this.cbe.setReporterComponentId(string, string2, string5, string3, string4, string6, string7);
        Assert.assertNotNull((Object)this.cbe.getReporterComponentId());
        ComponentIdentification componentIdentification = this.cbe.getReporterComponentId();
        Assert.assertNotNull((Object)componentIdentification);
        Assert.assertEquals((String)string, (String)componentIdentification.getApplication());
        Assert.assertEquals((String)string2, (String)componentIdentification.getComponent());
        Assert.assertEquals((String)string3, (String)componentIdentification.getComponentType());
        Assert.assertEquals((String)string4, (String)componentIdentification.getComponentIdType());
        Assert.assertEquals((String)string5, (String)componentIdentification.getSubComponent());
        Assert.assertEquals((String)string6, (String)componentIdentification.getLocation());
        Assert.assertEquals((String)string7, (String)componentIdentification.getLocationType());
    }

    public void testSetReporterComponentIdStringStringStringStringStringStringStringStringStringString() {
        String string = "my Application";
        String string2 = "my component";
        String string3 = "my comp type";
        String string4 = "my comp id type";
        String string5 = "My sub component";
        String string6 = "my loc";
        String string7 = "Unknown";
        String string8 = "my execution environment";
        String string9 = "my instance id";
        String string10 = "my process id";
        String string11 = "my thread id";
        this.cbe.setReporterComponentId(string, string2, string5, string3, string4, string8, string9, string6, string7, string10, string11);
        Assert.assertNotNull((Object)this.cbe.getReporterComponentId());
        ComponentIdentification componentIdentification = this.cbe.getReporterComponentId();
        Assert.assertNotNull((Object)componentIdentification);
        Assert.assertEquals((String)string, (String)componentIdentification.getApplication());
        Assert.assertEquals((String)string2, (String)componentIdentification.getComponent());
        Assert.assertEquals((String)string3, (String)componentIdentification.getComponentType());
        Assert.assertEquals((String)string4, (String)componentIdentification.getComponentIdType());
        Assert.assertEquals((String)string5, (String)componentIdentification.getSubComponent());
        Assert.assertEquals((String)string6, (String)componentIdentification.getLocation());
        Assert.assertEquals((String)string7, (String)componentIdentification.getLocationType());
        Assert.assertEquals((String)string8, (String)componentIdentification.getExecutionEnvironment());
        Assert.assertEquals((String)string9, (String)componentIdentification.getInstanceId());
        Assert.assertEquals((String)string10, (String)componentIdentification.getProcessId());
        Assert.assertEquals((String)string11, (String)componentIdentification.getThreadId());
    }

    public void testSetSourceComponentIdStringStringStringStringStringStringStringStringStringString() {
        String string = "my Application";
        String string2 = "my component";
        String string3 = "my comp type";
        String string4 = "my comp id type";
        String string5 = "My sub component";
        String string6 = "my loc";
        String string7 = "Unknown";
        String string8 = "my execution environment";
        String string9 = "my instance id";
        String string10 = "my process id";
        String string11 = "my thread id";
        this.cbe.setSourceComponentId(string, string2, string5, string3, string4, string8, string9, string6, string7, string10, string11);
        Assert.assertNotNull((Object)this.cbe.getSourceComponentId());
        ComponentIdentification componentIdentification = this.cbe.getSourceComponentId();
        Assert.assertNotNull((Object)componentIdentification);
        Assert.assertEquals((String)string, (String)componentIdentification.getApplication());
        Assert.assertEquals((String)string2, (String)componentIdentification.getComponent());
        Assert.assertEquals((String)string3, (String)componentIdentification.getComponentType());
        Assert.assertEquals((String)string4, (String)componentIdentification.getComponentIdType());
        Assert.assertEquals((String)string5, (String)componentIdentification.getSubComponent());
        Assert.assertEquals((String)string6, (String)componentIdentification.getLocation());
        Assert.assertEquals((String)string7, (String)componentIdentification.getLocationType());
        Assert.assertEquals((String)string8, (String)componentIdentification.getExecutionEnvironment());
        Assert.assertEquals((String)string9, (String)componentIdentification.getInstanceId());
        Assert.assertEquals((String)string10, (String)componentIdentification.getProcessId());
        Assert.assertEquals((String)string11, (String)componentIdentification.getThreadId());
    }

    public void testSetSourceComponentIdStringStringStringStringStringString() {
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        String string = "my Application";
        String string2 = "my component";
        String string3 = "my comp type";
        String string4 = "my comp id type";
        String string5 = "My sub component";
        String string6 = "my loc";
        String string7 = "Unknown";
        this.cbe.setSourceComponentId(string, string2, string5, string3, string4, string6, string7);
        Assert.assertNotNull((Object)this.cbe.getSourceComponentId());
        ComponentIdentification componentIdentification2 = this.cbe.getSourceComponentId();
        Assert.assertNotNull((Object)componentIdentification2);
        Assert.assertEquals((String)string, (String)componentIdentification2.getApplication());
        Assert.assertEquals((String)string2, (String)componentIdentification2.getComponent());
        Assert.assertEquals((String)string3, (String)componentIdentification2.getComponentType());
        Assert.assertEquals((String)string4, (String)componentIdentification2.getComponentIdType());
        Assert.assertEquals((String)string5, (String)componentIdentification2.getSubComponent());
        Assert.assertEquals((String)string6, (String)componentIdentification2.getLocation());
        Assert.assertEquals((String)string7, (String)componentIdentification2.getLocationType());
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.cbe);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.cbe);
    }

    public void testEqualsThreaded() throws ValidationException {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        CommonBaseEvent commonBaseEvent2 = Util.generateEvent();
        Assert.assertEquals((Object)commonBaseEvent2, (Object)commonBaseEvent);
    }

    public void testSerializationThreaded() throws IOException {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        Util.testSerialization(commonBaseEvent);
    }

    public void testJavadocSample() {
        EventFactory eventFactory = EventFactoryFactory.createEventFactory();
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent("CommonBaseEvent", System.currentTimeMillis());
        commonBaseEvent.setGlobalInstanceId(eventFactory.createGlobalInstanceId());
        commonBaseEvent.addContextDataElementWithValue("INTEGER", "business_tx", "123491279");
        String[] stringArray = new String[]{"CE1234567890123456789012345678901A", "CE1234567890123456789012345678901B"};
        commonBaseEvent.addAssociatedEvent("TEC", "summary", "CE1234567890123456789012345678901C", stringArray);
        commonBaseEvent.setSourceComponentId("app", "comp", "subComp", "compType", "compIdType", "loc", "Unknown");
        String[] stringArray2 = new String[]{"token 1", "token 2"};
        commonBaseEvent.setMsgDataElement("msgCat", "msgCatId", stringArray2, "msgCatType", "msgId", "msgIdType", "msgCatLoc");
        Situation situation = eventFactory.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("NOT AVAILABLE");
        availableSituation.setOperationDisposition("STARTABLE");
        availableSituation.setProcessingDisposition("MGMTTASK_PROCESS");
        availableSituation.setReasoningScope("EXTERNAL");
        situation.setCategoryName("AvailableSituation");
        situation.setSituationType(availableSituation);
        commonBaseEvent.setSituation(situation);
        try {
            commonBaseEvent.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"should not get an exception");
        }
    }
}

