/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class ReportSituationImplTest
extends TestCase {
    private ReportSituation sit;

    public ReportSituationImplTest(String string) {
        super(string);
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testInterface() {
        this.sit.getReportCategory();
        this.sit.getReasoningScope();
        Assert.assertTrue((boolean)(this.sit instanceof SituationType));
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() {
        ReportSituation reportSituation = (ReportSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)reportSituation);
        this.sit.setReportCategory("c");
        this.sit.setReasoningScope("r");
        reportSituation = (ReportSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)reportSituation);
        reportSituation.setReportCategory("difference");
        Assert.assertFalse((boolean)this.sit.equals(reportSituation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setReportCategory("c");
        this.sit.setReasoningScope("r");
        this.sit.validate();
        this.sit.setReportCategory(null);
        Util.assertMissingAttributes(this.sit, "reportCategory");
        this.sit.setReportCategory("c");
        this.sit.setReasoningScope(null);
        Util.assertMissingAttributes(this.sit, "reasoningScope");
    }

    public void testValidationInvalidLengths() {
        this.sit.setReportCategory(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        try {
            this.sit.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"Strings have correct length");
        }
        this.sit.setReportCategory(Util.getPaddedString(65));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "reportCategory");
        this.sit.setReportCategory(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.sit, "reasoningScope");
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.sit);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.sit = eventFactory.createReportSituation();
    }
}

