/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.util.HashMap;
import java.util.Iterator;

public class ECMAScriptGenerator {
    private StringBuffer script;
    private static final String eol = "";

    public String generateClientSnifferVariables() {
        this.script = new StringBuffer("var browserVersion = parseInt(parent.navigator.appVersion); ");
        this.script.append("var isNN = parent.navigator.appName.indexOf(\"Netscape\")!= -1; ").append(eol);
        this.script.append("var isIE = parent.navigator.appName.indexOf(\"Microsoft\")!= -1; ").append(eol);
        return this.script.toString();
    }

    public String generateNullClientSnifferVariables() {
        this.script = new StringBuffer("var browserVersion = null;");
        this.script.append("var isNN = false;").append(eol);
        this.script.append("var isIE = false; ").append(eol);
        return this.script.toString();
    }

    public String generateGlobalVariables() {
        this.script = new StringBuffer("var currentValues = null; ");
        this.script.append("var palettes = null; ").append(eol);
        this.script.append("var preferencePage = null;").append(eol);
        return this.script.toString();
    }

    public String generateInitFunction(String userPreferences, HashMap palettes, String currentPalette, String currentFont, String cookieName, String type, int sets, int gridXOffset, int gridYOffset, int xAxisLength, int yAxisLength) {
        this.script = new StringBuffer("function init(e){");
        this.script.append("var svgDocument = e.target.ownerDocument;").append(eol);
        this.script.append("if (svgDocument != null) {").append(eol);
        this.script.append("\tvar t = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
        this.script.append("\tvar bbox;").append(eol);
        this.script.append("\tif (t != null) {").append(eol);
        this.script.append("   bbox = t.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var hoverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
        this.script.append(" if (hoverBoxElement != null && bbox != null) {").append(eol);
        this.script.append("   hoverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   hoverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   hoverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   hoverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var hoverGroup = svgDocument.getElementById('preferencesHoverText');").append(eol);
        this.script.append(" if (hoverGroup != null) {").append(eol);
        this.script.append("  hoverGroup.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append("  var rectElement = null;").append(eol);
        this.script.append("  for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
        this.script.append("    var number = 0; ").append(eol);
        this.script.append("    while ((rectElement = svgDocument.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
        this.script.append("    var hoverBoxText = svgDocument.getElementById('textboxText' + i + number);").append(eol);
        this.script.append("    if (hoverBoxText != null) { ").append(eol);
        this.script.append("      hoverBoxText.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("      bbox = hoverBoxText.getBBox();").append(eol);
        this.script.append("      var originalBoxY = rectElement.getAttribute('y');").append(eol);
        this.script.append("      var originalBoxX = rectElement.getAttribute('x');").append(eol);
        this.script.append("      rectElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("      rectElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append("      rectElement.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("      hoverBoxText.setAttribute('x', parseFloat(rectElement.getAttribute('x')) + (bbox.width + 6) / 2);").append(eol);
        this.script.append("      hoverBoxText.setAttribute('y', parseFloat(rectElement.getAttribute('y')) + bbox.height + 3);").append(eol);
        this.script.append("      hoverBoxText.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("    number++;").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        if (palettes == null || palettes.isEmpty()) {
            this.script.append("} ").append(eol);
            return this.script.toString();
        }
        this.script.append("palettes = new Array();").append(eol);
        Iterator keys = palettes.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String[] codes = (String[])palettes.get(name);
            this.script.append("palettes[");
            this.script.append(i);
            this.script.append("] = [");
            for (int j = 0; j < codes.length; ++j) {
                this.script.append("\"");
                this.script.append(codes[j]);
                this.script.append("\", ");
            }
            this.script.append("\"");
            this.script.append(name);
            this.script.append("\"");
            this.script.append("];").append(eol);
            ++i;
        }
        if (cookieName != null) {
            this.script.append("currentValues = getPreferences();").append(eol);
        }
        this.script.append("if (currentValues != null) {").append(eol);
        this.script.append("updateStyles(currentValues, true);}").append(eol);
        if (userPreferences != null) {
            int numberOfPreferences = 6;
            int lastCommaIndex = 0;
            int nextCommaIndex = 0;
            String userPreference = null;
            this.script.append("else {currentValues = [\"");
            nextCommaIndex = userPreferences.indexOf(",", lastCommaIndex);
            userPreference = userPreferences.substring(lastCommaIndex, nextCommaIndex);
            this.script.append(userPreference);
            this.script.append("\",\"");
            for (int k = 0; k < numberOfPreferences - 2; ++k) {
                lastCommaIndex = nextCommaIndex;
                nextCommaIndex = userPreferences.indexOf(",", lastCommaIndex + 1);
                userPreference = userPreferences.substring(lastCommaIndex + 1, nextCommaIndex);
                this.script.append(userPreference);
                this.script.append("\",\"");
            }
            lastCommaIndex = nextCommaIndex;
            userPreference = userPreferences.substring(lastCommaIndex + 1, userPreferences.length());
            this.script.append(userPreference);
            this.script.append("\"];updateStyles(currentValues, true); }").append(eol);
        } else {
            String defaultFont = "font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;";
            String newDefaultFont = defaultFont.substring(0, defaultFont.indexOf("font-family") + "font-family".length() + 1) + currentFont + defaultFont.substring(defaultFont.indexOf("; fill"), defaultFont.length());
            this.script.append("else {currentValues = [\"");
            this.script.append(currentPalette);
            this.script.append("\",\"");
            this.script.append(8);
            this.script.append("\",\"");
            this.script.append(newDefaultFont);
            this.script.append("\",\"");
            this.script.append("1");
            this.script.append("\",\"");
            if (type == "pie") {
                this.script.append("1");
            } else {
                this.script.append("0");
            }
            this.script.append("\",\"");
            this.script.append("1");
            this.script.append("\"];updateStyles(currentValues, true);}").append(eol);
        }
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateOpenPreferencePageFunction(String url, String src, String name, String width, String height) {
        this.script = new StringBuffer("function openPreferencePage(){");
        if (src.indexOf("prefs_") == 0) {
            this.script.append("if (isNN) {useNetscapePreferencePage();}").append(eol);
            this.script.append("else {").append(eol);
        }
        this.script.append("if (preferencePage) {preferencePage = null;}").append(eol);
        this.script.append("preferencePage=open('");
        this.script.append(url + src);
        this.script.append("','");
        this.script.append(name);
        this.script.append("', 'width=");
        this.script.append(width);
        this.script.append(",height=");
        this.script.append(height);
        this.script.append("'); ").append(eol);
        this.script.append("preferencePage.opener=window;} ").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateUseNetscapePreferencePage(String url, String src, String name, String pageWidth, String pageHeight) {
        String height = null;
        String ns_src = "indexs.html";
        String width = "360";
        if (name.equals("line")) {
            height = "505";
        } else if (name.equals("area")) {
            height = "505";
        } else if (name.equals("scatter")) {
            height = "505";
        } else if (name.equals("bar")) {
            height = "445";
        } else if (name.equals("stack")) {
            height = "445";
        } else if (name.equals("group")) {
            height = "445";
        } else if (name.equals("pie")) {
            height = "465";
        } else if (name.equals("meter")) {
            height = "305";
        } else {
            width = pageWidth;
            height = pageHeight;
        }
        this.script = new StringBuffer("function useNetscapePreferencePage(){");
        this.script.append("if (preferencePage) {preferencePage = null;}").append(eol);
        this.script.append("preferencePage=open('");
        this.script.append(url + ns_src);
        this.script.append("','");
        this.script.append(name);
        this.script.append("','");
        this.script.append("width=");
        this.script.append(width);
        this.script.append(",");
        this.script.append("height=");
        this.script.append(height);
        this.script.append(",top=0,left=0,screenx=0,screeny=0,toolbar=no,scrollbar=no'); ").append(eol);
        this.script.append("preferencePage.prefType='");
        this.script.append(name);
        this.script.append("'; preferencePage.opener=window;");
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateGetPalettesFunction() {
        this.script = new StringBuffer("function getPalettes(){").append(eol);
        this.script.append("return palettes;").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateGetCurrentValuesFunction() {
        this.script = new StringBuffer("var current = new Array();").append(eol);
        this.script.append("function getCurrentValues() {").append(eol);
        this.script.append("for (var i = 0; i < 6; i++) {current[i] = currentValues[i];}").append(eol);
        this.script.append("for (var i = 0; i < palettes.length; i++) {").append(eol);
        this.script.append("if (palettes[i][palettes[i].length - 1] == current[0]) {").append(eol);
        this.script.append(" current[6] = palettes[i][0];}}").append(eol);
        this.script.append("return current;").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityFunction(int sets, String type) {
        this.script = new StringBuffer("var values=1, percents=1;var textboxState = new Array();");
        this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {textboxState[i] = 0;}").append(eol);
        if (type == "pie") {
            this.script.append("function toggleVisibility(id) {").append(eol);
            this.script.append("  setVisibility('tickline', 'hidden');").append(eol);
            this.script.append("  if (isVisible('bothValues')) {").append(eol);
            this.script.append("    setVisibility('bothValues', 'hidden');").append(eol);
            this.script.append("  } else if (isVisible('percentValues')) {").append(eol);
            this.script.append("\t   setVisibility('percentValues', 'hidden');").append(eol);
            this.script.append("  } else if (isVisible('exactValues')) {").append(eol);
            this.script.append("\t   setVisibility('exactValues', 'hidden');").append(eol);
            this.script.append("  } else {").append(eol);
            this.script.append("    setVisibility('tickline', 'visible');").append(eol);
            this.script.append("    if ((values == 1 && percents == 1) || (values == 0 && percents == 0)) { ").append(eol);
            this.script.append("      setVisibility('bothValues', 'visible');").append(eol);
            this.script.append("    } else if (values == 1) {").append(eol);
            this.script.append("\t     setVisibility('exactValues', 'visible');").append(eol);
            this.script.append("    } else if (percents == 1) {").append(eol);
            this.script.append("\t     setVisibility('percentValues', 'visible');").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("}").append(eol);
        } else if (type == "line" || type == "area" || type == "scatter") {
            this.script.append("var noShapes = true;").append(eol);
            this.script.append("function changeAllTextBoxes(state) {").append(eol);
            this.script.append("  for (var i = 0; i < ").append(sets).append("; i++) {");
            this.script.append("    var boxId = \"textbox\" + i;").append(eol);
            this.script.append("    if (document.getElementById(boxId) != null) {").append(eol);
            this.script.append("      if (isVisible('dataColour'+i)){").append(eol);
            this.script.append("        setVisibility(boxId, state);").append(eol);
            this.script.append("        var number = 0;").append(eol);
            this.script.append("        while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
            this.script.append("          setVisibility('textboxText' + i + number, state);").append(eol);
            this.script.append("          setVisibility('textboxRect' + i + number, state);").append(eol);
            this.script.append("          number++;").append(eol);
            this.script.append("        }").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("      if (state == 'hidden') {textboxState[i] = 0;}").append(eol);
            this.script.append("      else if (state == 'visible') {textboxState[i] = 1;}").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("}").append(eol);
            this.script.append("function toggleVisibility(id) {").append(eol);
            this.script.append("  if (id.substring(0,10) == 'dataColour') {").append(eol);
            this.script.append("\t   var lineId = id.substring(10,id.length);").append(eol);
            this.script.append("    if (isVisible(\"dataColour\" + lineId) ) {").append(eol);
            this.script.append(" \t setVisibility(\"dataColour\" + lineId, 'hidden');").append(eol);
            this.script.append("\t\t setVisibility(\"textbox\" + lineId, 'hidden');").append(eol);
            this.script.append("      var number = 0;").append(eol);
            this.script.append("      while (svgDocument.getElementById('textboxText' + lineId + number) != null) {").append(eol);
            this.script.append("        setVisibility('textboxText' + lineId + number, 'hidden');").append(eol);
            this.script.append("        setVisibility('textboxRect' + lineId + number, 'hidden');").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("\t   } else if (!isVisible(\"dataColour\" + lineId)) {").append(eol);
            this.script.append("\t     setVisibility(\"dataColour\" + lineId, 'visible');").append(eol);
            this.script.append("\t\t var state = textboxState[lineId] == 0 ? 'hidden' : 'visible';\t").append(eol);
            this.script.append("\t\t setVisibility(\"textbox\" + lineId, state);").append(eol);
            this.script.append("      var number = 0;").append(eol);
            this.script.append("      while (svgDocument.getElementById('textboxText' + lineId + number) != null) {").append(eol);
            this.script.append("        setVisibility('textboxText' + lineId + number, state);").append(eol);
            this.script.append("        setVisibility('textboxRect' + lineId + number, state);").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("\t   }").append(eol);
            this.script.append("    var group = document.getElementById(id);").append(eol);
            this.script.append("    if (group != null) {").append(eol);
            this.script.append("      var useElementGroup = group.getElementsByTagName('use');").append(eol);
            this.script.append("      if (useElementGroup != null) {").append(eol);
            this.script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
            if (type == "scatter") {
                this.script.append("          useElementGroup.item(j).setAttribute('visibility', (isVisible(id) ? 'visible':'hidden') );").append(eol);
            } else {
                this.script.append("          useElementGroup.item(j).setAttribute('visibility', (isVisible(id) && noShapes == false ? 'visible':'hidden') );").append(eol);
            }
            this.script.append("        }").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  } else if (id.substring(0,7) == 'textbox') {").append(eol);
            this.script.append("    if (isVisible(\"dataColour\" + id.substring(7,id.length))) {").append(eol);
            this.script.append("      changeAllTextBoxes(isVisible(id) ? 'hidden':'visible');").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("}").append(eol);
        } else if (type == "stack") {
            this.script.append("function toggleVisibility(id) {").append(eol);
            this.script.append("  setVisibility('exactValues', isVisible('exactValues')?'hidden':'visible');").append(eol);
            this.script.append("  for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
            this.script.append("    var textBoxSet = document.getElementById(\"textbox\" + i);").append(eol);
            this.script.append("    var state = isVisible('exactValues')?'visible':'hidden';").append(eol);
            this.script.append("    if (textBoxSet != null) { ").append(eol);
            this.script.append("      textBoxSet.setAttribute('visibility', isVisible('exactValues')?'visible':'hidden');").append(eol);
            this.script.append("      var number = 0;").append(eol);
            this.script.append("      while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
            this.script.append("        setVisibility('textboxText' + i + number, state);").append(eol);
            this.script.append("        setVisibility('textboxRect' + i + number, state);").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("\t   }").append(eol);
            this.script.append("\t }").append(eol);
            this.script.append("}").append(eol);
        } else {
            this.script.append("function toggleVisibility(id) {").append(eol);
            this.script.append(" if(isVisible(id)){setVisibility(id,'hidden');}").append(eol);
            this.script.append(" else{setVisibility(id,'visible');}").append(eol);
            this.script.append("}").append(eol);
        }
        this.script.append("function isVisible(id) {").append(eol);
        this.script.append(" if (document.getElementById(id).getAttribute(\"visibility\") == \"visible\") {return true;}").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function setVisibility(id, value) {").append(eol);
        this.script.append(" document.getElementById(id).setAttribute(\"visibility\",value);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateXYChartHelperFunctions() {
        this.script = new StringBuffer("function resizeAndRepositionTextBox(textBox, newX, newY, newWidth, newHeight) {");
        this.script.append(" textBox.setAttribute('x', newX);").append(eol);
        this.script.append(" textBox.setAttribute('y', newY);").append(eol);
        this.script.append("\ttextBox.setAttribute('width', newWidth);").append(eol);
        this.script.append("\ttextBox.setAttribute('height', newHeight);").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function resizeTextBox(textBox, newWidth, newHeight) {").append(eol);
        this.script.append("\ttextBox.setAttribute('width', newWidth);").append(eol);
        this.script.append("\ttextBox.setAttribute('height', newHeight);").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function repositionText(text, newX, newY) {").append(eol);
        this.script.append("\ttext.setAttribute('x', newX);").append(eol);
        this.script.append("\ttext.setAttribute('y', newY);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generatePieChartHelperFunctions() {
        this.script = new StringBuffer(eol);
        this.script.append("function changeTextColour(bothElement, percentTextElement, exactTextElement, palette) {").append(eol);
        this.script.append("  for (var i = 0, j = palette.length - 1; i < percentTextElement.length; i++, j = palette.length - 1) {").append(eol);
        this.script.append("    if (((i+1) % j) == 0) {j = palette.length - 2;} else {j=((i+1)%j)-1;}").append(eol);
        this.script.append("    bothElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
        this.script.append("\t   percentTextElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
        this.script.append("\t   exactTextElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateResetStylesFunction() {
        this.script = new StringBuffer("function resetStyles(){");
        this.script.append("updateStyles(currentValues, true);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateUpdateLegendStylesFunction(int sets, String type) {
        this.script = new StringBuffer();
        this.script.append("function updateLegendStyles(newStyles, preview) {").append(eol);
        this.script.append("var fontSize=parseInt(newStyles[1]);").append(eol);
        this.script.append("var group = document.getElementById(\"legendTitle\");").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize + 2) + \"pt; \" + newStyles[2]);}").append(eol);
        this.script.append("var group = document.getElementById(\"legendData\");").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
        if (type == "line" || type == "area" || type == "scatter") {
            this.script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
            this.script.append("  var squareshape = document.getElementById('legendsquareshapeWithoutLine' + i);").append(eol);
            this.script.append("  var shape = document.getElementById('shape' + i);").append(eol);
            this.script.append("  shape.setAttribute('visibility', (newStyles[3] == '0' ? 'hidden' : 'visible'));").append(eol);
            this.script.append("  squareshape.setAttribute('visibility', (newStyles[3] == '0' ? 'visible' : 'hidden'));").append(eol);
            this.script.append("}").append(eol);
        }
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateUpdateStylesFunction(int sets, String cookieName, String type, boolean hasLegend, String updatedUserPrefsVarName, int gridXOffset, int gridYOffset, int xAxisLength, int yAxisLength) {
        this.script = new StringBuffer();
        this.script.append("function getTextElement(myGroup) { return myGroup.getElementsByTagName('text'); }").append(eol);
        this.script.append("function updateStyles(newStyles, preview) {").append(eol);
        this.script.append("if (newStyles == null || newStyles.length < 6) {return;}").append(eol);
        this.script.append("var paletteName=newStyles[0];").append(eol);
        this.script.append("var palette= palettes[0];").append(eol);
        this.script.append("for (var i = 0; i < palettes.length; i++) {").append(eol);
        this.script.append("if (palettes[i][palettes[i].length-1] == paletteName) {").append(eol);
        this.script.append(" palette = palettes[i];}}").append(eol);
        this.script.append("for (var i=0, j=palette.length-1; i<" + sets + ";i++, j=palette.length-1) {").append(eol);
        this.script.append("  if (((i+1) % j) == 0) {j = palette.length - 2;} else {j=((i+1)%j)-1;}").append(eol);
        this.script.append("  var group = document.getElementById(\"dataColour\" + i);").append(eol);
        this.script.append("  if (group != null){").append(eol);
        this.script.append("    group.setAttribute(\"style\",\"stroke:\" + palette[j] + \"; fill:\" + palette[j]);}").append(eol);
        this.script.append("  group = document.getElementById(\"legendsquareshapeWithoutLine\" + i);").append(eol);
        this.script.append("  if (group != null){").append(eol);
        this.script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
        if (type == "line" || type == "area" || type == "scatter") {
            this.script.append("  group = document.getElementById(\"shape\" + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
        }
        this.script.append("  group = document.getElementById(\"pieColour\" + i);").append(eol);
        this.script.append("  if (group != null){").append(eol);
        this.script.append("    group.setAttribute(\"style\", \"stroke:\" + \"black\" + \"; fill: \" + palette[j]);}").append(eol);
        this.script.append("  group = document.getElementById(\"percentValues\" + i);").append(eol);
        this.script.append("  if (group != null){").append(eol);
        this.script.append("    group.setAttribute(\"style\", \"stroke:\" + \"black\" + \"; fill: \" + palette[j]);}").append(eol);
        this.script.append("  group = document.getElementById(\"bothValues\" + i);").append(eol);
        this.script.append("  if (group != null){").append(eol);
        this.script.append("    group.setAttribute(\"style\", \"stroke:\" + palette[j] + \"; fill: \" + palette[j]);}").append(eol);
        this.script.append("  group = document.getElementById(\"line\" + i);").append(eol);
        this.script.append("  if (group != null){").append(eol);
        this.script.append("    group.setAttribute(\"style\", \"fill: \" + palette[j]);}").append(eol);
        this.script.append("}").append(eol);
        this.script.append("var fontSize=parseInt(newStyles[1]);").append(eol);
        this.script.append("var group = document.getElementById(\"graphTitle\");").append(eol);
        this.script.append("var graphTitleStyle = 'font-weight:bold; ' + newStyles[2].substring(newStyles[2].indexOf('font-style'), newStyles[2].length);").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+3) + \"pt; \" + graphTitleStyle);}").append(eol);
        this.script.append("var group = document.getElementById(\"timeStamp\");").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");").append(eol);
        this.script.append(" group.setAttribute(\"y\", fontSize + 5);}").append(eol);
        if (type != "meter") {
            if (hasLegend && type != "bar") {
                this.script.append("updateLegendStyles(newStyles, preview);").append(eol);
            }
            if (type != "pie") {
                this.script.append("var group = document.getElementById(\"dataValues0\");").append(eol);
                this.script.append("if (group != null){").append(eol);
                this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
                this.script.append("var group = document.getElementById(\"dataValues1\");").append(eol);
                this.script.append("if (group != null){").append(eol);
                this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
                this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
                this.script.append("var number = 0; var rectElement = null; var textElement = null;").append(eol);
                this.script.append("while ((rectElement = document.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
                this.script.append("  textElement = document.getElementById(\"textboxText\" + i + number);").append(eol);
                this.script.append("    if (textElement != null) {").append(eol);
                this.script.append("      textElement.setAttribute('style', 'font-size:' + fontSize + 'pt');").append(eol);
                this.script.append("      textElement.setAttribute('visibility', 'visible');").append(eol);
                this.script.append("      rectElement.setAttribute('visibility', 'visible');").append(eol);
                this.script.append("      var bbox = textElement.getBBox(); ").append(eol);
                this.script.append("      var originalBoxY = rectElement.getAttribute('y');").append(eol);
                this.script.append("      var originalBoxX = rectElement.getAttribute('x');");
                this.script.append("      if ( (parseFloat(originalBoxY) + bbox.height + 6) > ").append(gridYOffset + yAxisLength).append(") {");
                this.script.append("        rectElement.setAttribute('y', (originalBoxY - bbox.height - 6));").append(eol);
                this.script.append("      }").append(eol);
                this.script.append("      rectElement.setAttribute('width', bbox.width + 6);").append(eol);
                this.script.append("      rectElement.setAttribute('height', bbox.height + 6);").append(eol);
                this.script.append("      textElement.setAttribute('x', parseFloat(rectElement.getAttribute('x')) + (bbox.width + 6) / 2.0);").append(eol);
                this.script.append("      textElement.setAttribute('y', parseFloat(rectElement.getAttribute('y')) + bbox.height + 3);").append(eol);
                this.script.append("      if (newStyles[4] == '0' || !isVisible('dataColour' + i)) {").append(eol);
                this.script.append("        textElement.setAttribute('visibility', 'hidden');").append(eol);
                this.script.append("        rectElement.setAttribute('visibility', 'hidden');").append(eol);
                this.script.append("      }").append(eol);
                this.script.append("    }").append(eol);
                this.script.append("    ++number;").append(eol);
                this.script.append("  }").append(eol);
                this.script.append("}").append(eol);
            } else {
                this.script.append("var group = document.getElementById(\"percentValues\");").append(eol);
                this.script.append("if (group != null){").append(eol);
                this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
                this.script.append("var bothGroup = document.getElementById(\"bothValues\");").append(eol);
                this.script.append("if (bothGroup != null){").append(eol);
                this.script.append(" bothGroup.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
            }
            this.script.append("var group = document.getElementById(\"labelsValues0\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"text-anchor:middle; font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
            this.script.append("var group = document.getElementById(\"labelsValues1\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
            this.script.append("var group = document.getElementById(\"exactValues\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
        } else {
            this.script.append("var group = document.getElementById(\"minmaxRate\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \");}").append(eol);
            this.script.append("var group = document.getElementById(\"rateDefinition\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \");}").append(eol);
            this.script.append("var group = document.getElementById(\"critDiv\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \");}").append(eol);
            this.script.append("var group = document.getElementById(\"meterLabel\");").append(eol);
            this.script.append("if (group != null){ ").append(eol);
            this.script.append("   var tmpText = group.getElementsByTagName('text');").append(eol);
            this.script.append("   for (var i = 0; i < tmpText.length; i++) {").append(eol);
            this.script.append("     tmpText.item(i).setAttribute('style', 'font-size: ' + (fontSize) + 'pt; ');").append(eol);
            this.script.append("   }").append(eol);
            this.script.append("}").append(eol);
        }
        if (type == "line" || type == "area" || type == "scatter") {
            this.script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
            this.script.append("  var group = document.getElementById('dataColour' + i);").append(eol);
            this.script.append("  if (group != null) {").append(eol);
            this.script.append("    var useElementGroup = group.getElementsByTagName('use');").append(eol);
            this.script.append("    if (useElementGroup != null) {").append(eol);
            this.script.append("      for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
            if (type == "scatter") {
                this.script.append("        useElementGroup.item(j).setAttribute('visibility', (newStyles[3] == '1' && isVisible('dataColour'+i) ? 'visible' : 'visible') );").append(eol);
            } else {
                this.script.append("        useElementGroup.item(j).setAttribute('visibility', (newStyles[3] == '1' && isVisible('dataColour'+i) ? 'visible' : 'hidden') );").append(eol);
            }
            this.script.append("      }").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("  noShapes = newStyles[3] == '0' ? true : false;").append(eol);
            this.script.append("}").append(eol);
        }
        if (type == "pie") {
            this.script.append("var bothGroup=document.getElementById('bothValues');var perGroup=document.getElementById('percentValues');var eGroup=document.getElementById('exactValues');").append(eol);
            this.script.append("changeTextColour(getTextElement(bothGroup), getTextElement(perGroup), getTextElement(eGroup), palette);").append(eol);
            this.script.append("values = (newStyles[4] == '0' ? 0 : 1);").append(eol);
            this.script.append("percents = (newStyles[5] == '0' ? 0 : 1);").append(eol);
            this.script.append("setVisibility('tickline', (values==0 && percents==0 ? 'hidden':'visible'));").append(eol);
            this.script.append("eGroup.setAttribute('visibility', (values==1 && percents==0 ? 'visible':'hidden'));").append(eol);
            this.script.append("perGroup.setAttribute('visibility', (values==0 && percents==1 ? 'visible':'hidden'));").append(eol);
            this.script.append("bothGroup.setAttribute('visibility', (values==1 && percents==1 ? 'visible':'hidden'));").append(eol);
        } else if (type == "line" || type == "area" || type == "scatter") {
            this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
            this.script.append("  if (document.getElementById(\"textbox\" + i) != null) {").append(eol);
            this.script.append("    textboxState[i] = parseInt(newStyles[4]);").append(eol);
            this.script.append("    if (isVisible('dataColour'+i)) {").append(eol);
            this.script.append("      setVisibility(\"textbox\"+i, newStyles[4]=='0' ? 'hidden':'visible');").append(eol);
            this.script.append("      var number = 0; ").append(eol);
            this.script.append("      while ((hoverBoxElement = svgDocument.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
            this.script.append("        var hoverBoxText = svgDocument.getElementById('textboxText' + i + number);").append(eol);
            this.script.append("        if (hoverBoxText != null) {").append(eol);
            this.script.append("          hoverBoxText.setAttribute('visibility', (parseInt(newStyles[4]) == 0 ? 'hidden':'visible') );").append(eol);
            this.script.append("          hoverBoxElement.setAttribute('visibility', (parseInt(newStyles[4]) == 0 ? 'hidden':'visible') );").append(eol);
            this.script.append("        }").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("\t }").append(eol);
            this.script.append("}").append(eol);
        } else if (type == "stack") {
            this.script.append("var showAllState = newStyles[4]=='0' ? 'hidden':'visible';").append(eol);
            this.script.append("var eGroup = document.getElementById('exactValues');").append(eol);
            this.script.append("if (eGroup!=null) {eGroup.setAttribute('visibility',showAllState);}").append(eol);
            this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
            this.script.append("  if (document.getElementById(\"textbox\" + i) != null) {").append(eol);
            this.script.append("    setVisibility(\"textbox\"+i, showAllState);").append(eol);
            this.script.append("      var number = 0;").append(eol);
            this.script.append("      while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
            this.script.append("        setVisibility('textboxText' + i + number, showAllState);").append(eol);
            this.script.append("        setVisibility('textboxRect' + i + number, showAllState);").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("}").append(eol);
        } else if (type != "meter") {
            this.script.append("var eGroup = document.getElementById(\"exactValues\");").append(eol);
            this.script.append("if (eGroup != null){").append(eol);
            this.script.append("eGroup.setAttribute('visibility', (newStyles[4]=='0'? 'hidden':'visible') );").append(eol);
            this.script.append("}").append(eol);
        }
        this.script.append("if (!preview) {for(var i=0; i<6; i++) {currentValues[i] = newStyles[i];}").append(eol);
        if (cookieName != null) {
            this.script.append("storePreferences(currentValues);").append(eol);
        }
        if (updatedUserPrefsVarName != null) {
            this.script.append("\tparent.").append(eol);
            this.script.append(updatedUserPrefsVarName).append(eol);
            this.script.append(" = getUserPreferences();").append(eol);
        }
        this.script.append("} }").append(eol);
        return this.script.toString();
    }

    public String generateGetPreferencesFunction(String name) {
        String cookie = name;
        this.script = new StringBuffer("function getPreferences() {");
        this.script.append("var value = get_Cookie(\"");
        this.script.append(cookie);
        this.script.append("\");").append(eol);
        this.script.append("if (value != null) {").append(eol);
        this.script.append("return value.split(\"&\");").append(eol);
        this.script.append("} else {").append(eol);
        this.script.append("return null;}").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateStorePreferencesFunction(String name) {
        String cookie = name;
        this.script = new StringBuffer("function storePreferences(storevalues) {");
        this.script.append("var value = '';").append(eol);
        this.script.append("for (var i = 0; i < storevalues.length -1; i++) {").append(eol);
        this.script.append("  value += storevalues[i] + \"&\";").append(eol);
        this.script.append("}").append(eol);
        this.script.append("value += storevalues[storevalues.length-1];").append(eol);
        this.script.append("set_Cookie('");
        this.script.append(cookie);
        this.script.append("', value, expires_date, '/');").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateGetUserPreferencesFunction() {
        this.script = new StringBuffer("function getUserPreferences()");
        this.script.append("{var value = '';").append(eol);
        this.script.append("for (var i = 0; i < currentValues.length -1; i++) {").append(eol);
        this.script.append("  value += currentValues[i] + \",\";").append(eol);
        this.script.append("}").append(eol);
        this.script.append("value += currentValues[currentValues.length-1];").append(eol);
        this.script.append("return value;").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateInspectFunction() {
        this.script = new StringBuffer("function inspect(obj)");
        this.script.append("{var output=\"\";").append(eol);
        this.script.append("if(obj==null){").append(eol);
        this.script.append("return null;} ").append(eol);
        this.script.append("else{").append(eol);
        this.script.append("for(var i in obj){").append(eol);
        this.script.append(" output += i + \" : \" + obj[i] + \"\\n\";}").append(eol);
        this.script.append("return output;}").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateCookieFunctions() {
        this.script = new StringBuffer("var today= new Date();");
        this.script.append("var expires_date= new Date(today.getTime() + (365 * 24 * 60 * 60 * 1000));").append(eol);
        this.script.append("function get_Cookie(name){").append(eol);
        this.script.append("if (isNN && hasSVGCookieSupport) {").append(eol);
        this.script.append(" return get_NNCookie(name);").append(eol);
        this.script.append("} else if (isIE && top.document.cookie != null) {").append(eol);
        this.script.append("\tvar start = top.document.cookie.indexOf(name+\"=\");").append(eol);
        this.script.append("\tvar len = start+name.length+1;").append(eol);
        this.script.append("\tif ((!start) && (name != top.document.cookie.substring(0,name.length))) return null;").append(eol);
        this.script.append("\tif (start == -1) return null;").append(eol);
        this.script.append("\tvar end = top.document.cookie.indexOf(\";\",len);").append(eol);
        this.script.append("\tif (end == -1) end = top.document.cookie.length;").append(eol);
        this.script.append("\treturn unescape(top.document.cookie.substring(len,end));").append(eol);
        this.script.append("} else {").append(eol);
        this.script.append(" return null;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function set_Cookie(name,value,expires,path,domain,secure){").append(eol);
        this.script.append("if (isNN && hasSVGCookieSupport) {").append(eol);
        this.script.append(" set_NNCookie(name,value,expires,path,domain,secure);").append(eol);
        this.script.append("} else if (isIE) { ").append(eol);
        this.script.append("top.document.cookie = name + \"=\" +escape(value) + ").append(eol);
        this.script.append("((expires) ? \";expires=\" + expires.toGMTString() : \"\") +").append(eol);
        this.script.append("((path) ? \";path=\" + path : \"\") + ").append(eol);
        this.script.append("((domain) ? \";domain=\" + domain : \"\") + ").append(eol);
        this.script.append("((secure) ? \";secure\" : \"\");").append(eol);
        this.script.append("}").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateChangeOpacity() {
        this.script = new StringBuffer("function ChangeOpacity(id,NewOpacity){").append(eol);
        this.script.append(" var group = 'fill-opacity:'+ NewOpacity + '; stroke: black; stroke-width: 0;';").append(eol);
        this.script.append(" if (group != null) {").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" document.getElementById(id).setAttribute(\"style\", group);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateFunctionFlyOver() {
        this.script = new StringBuffer("function FlyOver(id){");
        this.script.append("var flyOverTest = svgDocument.getElementById(\"flyOverText\" + id);").append(eol);
        this.script.append("flyOverTest.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (flyOverTest != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = flyOverTest.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"flyOverBox\"  + id);").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"flyOverGroup\" + id);").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'visible');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        this.script.append("function FlyOut(id){");
        this.script.append("var flyOverTest = svgDocument.getElementById(\"flyOverText\" + id);").append(eol);
        this.script.append("flyOverTest.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (flyOverTest != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = flyOverTest.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"flyOverBox\"  + id);").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"flyOverGroup\" + id);").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        return this.script.toString();
    }

    public String generateFunctionPrefFlyOver() {
        this.script = new StringBuffer("function PrefFlyOver(){");
        this.script.append("var flyOverText = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
        this.script.append("flyOverText.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (flyOverText != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = flyOverText.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"preferencesHoverText\");").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'visible');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        this.script.append("function PrefFlyOut(){");
        this.script.append("var flyOverText = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
        this.script.append("flyOverText.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (flyOverText != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = flyOverText.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"preferencesHoverText\");").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        return this.script.toString();
    }
}

