/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentDefaults;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.IUserPreferencesConstants;
import org.w3c.dom.Document;

public class GraphicAttributes
implements IGraphicDocumentStyle,
IUserPreferencesConstants,
IGraphicDocumentDefaults,
Serializable {
    private String browserCookieName;
    private Document configDocument;
    private Document dataDocument;
    private String graphicType;
    private String resourcesFolder;
    private String graphicTitle;
    private String graphicTimestampPrefix;
    private boolean legendSuppressed = false;
    private String graphicLegendTitle;
    private String graphicFont = "Arial, sans-serif";
    private String graphicColorPaletteName = "ZZ1";
    private HashMap graphicColorPalette;
    private short graphicWidth = 0;
    private short graphicHeight = 0;
    Locale locale = Locale.getDefault();
    private boolean outlineSuppressed = false;
    private String preferencesPage;
    private String preferencesPageWidth;
    private String preferencesPageHeight;
    private String preferencesIconText;
    private boolean svgFormatOnly = true;
    private boolean timestampSuppressed = false;
    private boolean titlebarSuppressed = false;
    private String userPreferences;
    private boolean userPreferencesSuppressed = false;
    private String userPreferencesUpdateVariableName;
    private DecimalFormat numberFormatter = null;
    private DecimalFormat bigNumberFormatter = null;
    private NumberFormat percentFormatter = null;
    private DateFormat dateFormatter = null;

    public GraphicAttributes() {
        this.setGraphicWidth("365");
        this.setGraphicHeight("320");
        this.setFormatter();
    }

    public void setAttributesFrom(GraphicDocumentProperties input) {
        this.configDocument = input.getConfigDocument();
        this.dataDocument = input.getDataDocument();
        this.setBrowserCookieName(input.getBrowserCookieName());
        this.setResourcesFolder(input.getResourcesFolder());
        this.setGraphicTitle(input.getGraphicTitle());
        this.setGraphicTimestampPrefix(input.getGraphicTimestampPrefix());
        this.setLegendSuppressed(input.getLegendSuppressed());
        this.setGraphicLegendTitle(input.getGraphicLegendTitle());
        this.setGraphicFont(input.getGraphicFont());
        this.setPreferencesPage(input.getPreferencesPage());
        this.setPreferencesPageWidth(input.getPreferencesPageWidth());
        this.setPreferencesPageHeight(input.getPreferencesPageHeight());
        this.setPreferencesIconText(input.getPreferencesIconText());
        this.setSvgFormatOnly(input.getSvgFormatOnly());
        this.setUserPreferences(input.getUserPreferences());
        this.setUserPreferencesSuppressed(input.getUserPreferencesSuppressed());
        this.setUserPreferencesUpdateVariableName(input.getUserPreferencesUpdateVariableName());
        this.setTitlebarSuppressed(input.getTitlebarSuppressed());
        this.setTimestampSuppressed(input.getTimestampSuppressed());
        this.setOutlineSuppressed(input.getOutlineSuppressed());
        this.setGraphicHeight(input.getGraphicHeight());
        this.setGraphicWidth(input.getGraphicWidth());
        this.setLocale(input.getLocale());
        this.createGraphicColorPalettes(input.getGraphicColorPalettes());
        this.setGraphicColorPaletteName(input.getGraphicColorPaletteName());
    }

    public String getBrowserCookieName() {
        return this.browserCookieName;
    }

    public Document getConfigDocument() {
        return this.configDocument;
    }

    public Document getDataDocument() {
        return this.dataDocument;
    }

    public String getGraphicType() {
        return this.graphicType;
    }

    public short getGraphicHeight() {
        return this.graphicHeight;
    }

    public short getGraphicWidth() {
        return this.graphicWidth;
    }

    public String getGraphicFont() {
        return this.graphicFont;
    }

    public String getGraphicColorPaletteName() {
        return this.graphicColorPaletteName;
    }

    public HashMap getGraphicColorPalette() {
        return this.graphicColorPalette;
    }

    public String getGraphicTitle() {
        return this.graphicTitle;
    }

    public boolean isLegendSuppressed() {
        return this.legendSuppressed;
    }

    public String getGraphicTimestampPrefix() {
        return this.graphicTimestampPrefix;
    }

    public String getGraphicLegendTitle() {
        return this.graphicLegendTitle;
    }

    public boolean isOutlineSuppressed() {
        return this.outlineSuppressed;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPreferencesPage() {
        return this.preferencesPage;
    }

    public String getPreferencesPageWidth() {
        return this.preferencesPageWidth;
    }

    public String getPreferencesPageHeight() {
        return this.preferencesPageHeight;
    }

    public String getPreferencesIconText() {
        return this.preferencesIconText;
    }

    public boolean getSvgFormatOnly() {
        return this.svgFormatOnly;
    }

    public boolean isTimestampSuppressed() {
        return this.timestampSuppressed;
    }

    public boolean isTitlebarSuppressed() {
        return this.titlebarSuppressed;
    }

    public boolean isUserPreferencesSuppressed() {
        return this.userPreferencesSuppressed;
    }

    public String getUserPreferencesUpdateVariableName() {
        return this.userPreferencesUpdateVariableName;
    }

    public String getUserPreferences() {
        return this.userPreferences;
    }

    public String getResourcesFolder() {
        return this.resourcesFolder;
    }

    public void setBrowserCookieName(String newBrowserCookieName) {
        if (newBrowserCookieName != null) {
            this.browserCookieName = newBrowserCookieName.trim();
        }
    }

    public void setConfigDocument(Document newConfigDocument) throws DataInputProcessingException {
        this.configDocument = newConfigDocument;
    }

    public void setDataDocument(Document newDataDocument) throws DataInputProcessingException {
        this.dataDocument = newDataDocument;
    }

    public void setGraphicHeight(String newGraphicHeight) {
        try {
            this.graphicHeight = Short.parseShort(newGraphicHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphicWidth(String newGraphicWidth) {
        try {
            this.graphicWidth = Short.parseShort(newGraphicWidth);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphicTitle(String newGraphicTitle) {
        if (newGraphicTitle != null) {
            this.graphicTitle = newGraphicTitle.trim();
        }
    }

    public void setLegendSuppressed(String newLegendSuppressed) {
        if (newLegendSuppressed != null) {
            this.legendSuppressed = Boolean.valueOf(newLegendSuppressed);
        }
    }

    public void setGraphicTimestampPrefix(String newGraphicTimestampPrefix) {
        if (newGraphicTimestampPrefix != null) {
            this.graphicTimestampPrefix = newGraphicTimestampPrefix.trim();
        }
    }

    public void setGraphicLegendTitle(String newGraphicLegendTitle) {
        if (newGraphicLegendTitle != null) {
            this.graphicLegendTitle = newGraphicLegendTitle.trim();
        }
    }

    public void setGraphicFont(String newGraphicFont) {
        if (newGraphicFont != null) {
            this.graphicFont = newGraphicFont + ", " + "Arial, sans-serif";
        }
    }

    public boolean setGraphicColorPaletteName(String newGraphicColorPaletteName) {
        String name;
        boolean validName = false;
        if (newGraphicColorPaletteName != null && (validName = this.graphicColorPalette.containsKey(name = newGraphicColorPaletteName.trim()))) {
            this.graphicColorPaletteName = name;
        }
        return validName;
    }

    public void setOutlineSuppressed(String newOutlineSuppressed) {
        if (newOutlineSuppressed != null) {
            this.outlineSuppressed = Boolean.valueOf(newOutlineSuppressed);
        }
    }

    private void setFormatter() {
        NumberFormat nf = NumberFormat.getInstance(this.locale);
        if (nf instanceof DecimalFormat) {
            this.numberFormatter = (DecimalFormat)nf;
            this.numberFormatter.applyPattern("#,##0.##");
        }
        if ((nf = NumberFormat.getInstance(this.locale)) instanceof DecimalFormat) {
            this.bigNumberFormatter = (DecimalFormat)nf;
            this.bigNumberFormatter.applyPattern("0.##E0");
        }
        this.percentFormatter = NumberFormat.getPercentInstance(this.locale);
        this.dateFormatter = DateFormat.getDateTimeInstance(1, 1, this.locale);
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale == null ? Locale.getDefault() : newLocale;
        this.setFormatter();
    }

    public void setPreferencesPage(String newPreferencesPage) {
        if (newPreferencesPage != null) {
            this.preferencesPage = newPreferencesPage.trim();
        }
    }

    public void setPreferencesPageWidth(String newPreferencesPageWidth) {
        if (newPreferencesPageWidth != null) {
            this.preferencesPageWidth = newPreferencesPageWidth;
        }
    }

    public void setPreferencesPageHeight(String newPreferencesPageHeight) {
        if (newPreferencesPageHeight != null) {
            this.preferencesPageHeight = newPreferencesPageHeight;
        }
    }

    public void setPreferencesIconText(String newPreferencesIconText) {
        if (newPreferencesIconText != null) {
            this.preferencesIconText = newPreferencesIconText.trim();
        }
    }

    public void setResourcesFolder(String newResourcesFolder) {
        if (newResourcesFolder != null) {
            this.resourcesFolder = newResourcesFolder.trim();
        }
    }

    public void setSvgFormatOnly(String newSvgFormatOnly) {
        if (newSvgFormatOnly != null) {
            this.svgFormatOnly = Boolean.valueOf(newSvgFormatOnly);
        }
    }

    public void setTimestampSuppressed(String newTimestampSuppressed) {
        if (newTimestampSuppressed != null) {
            this.timestampSuppressed = Boolean.valueOf(newTimestampSuppressed);
        }
    }

    public void setTitlebarSuppressed(String newTitlebarSuppressed) {
        if (newTitlebarSuppressed != null) {
            this.titlebarSuppressed = Boolean.valueOf(newTitlebarSuppressed);
        }
    }

    public void setUserPreferences(String newUserPreferences) {
        if (newUserPreferences != null) {
            this.userPreferences = newUserPreferences;
        }
    }

    public void setUserPreferencesSuppressed(String newUserPreferencesSuppressed) {
        if (newUserPreferencesSuppressed != null) {
            this.userPreferencesSuppressed = Boolean.valueOf(newUserPreferencesSuppressed);
        }
    }

    public void setUserPreferencesUpdateVariableName(String newUserPreferencesUpdateVariableName) {
        if (newUserPreferencesUpdateVariableName != null) {
            this.userPreferencesUpdateVariableName = newUserPreferencesUpdateVariableName;
        }
    }

    private void createGraphicColorPalettes(HashMap userPalettes) {
        this.graphicColorPalette = userPalettes != null ? new HashMap(userPalettes) : new HashMap();
        this.graphicColorPalette.put("ZZ1", IGraphicDocumentStyle.SEASIDE_PALETTE);
        this.graphicColorPalette.put("ZZ2", IGraphicDocumentStyle.SUMMER_PALETTE);
        this.graphicColorPalette.put("ZZ3", IGraphicDocumentStyle.EARTH_PALETTE);
        this.graphicColorPalette.put("ZZ4", IGraphicDocumentStyle.SPRING_PALETTE);
        this.graphicColorPalette.put("ZZ5", IGraphicDocumentStyle.HARVEST_PALETTE);
        this.graphicColorPalette.put("ZZ6", IGraphicDocumentStyle.PASTEL_PALETTE);
    }

    public String formatNumber(double d) {
        DecimalFormat df = d > 100000.0 || d < -100000.0 ? this.bigNumberFormatter : this.numberFormatter;
        return df.format(d);
    }

    public String formatPercentage(double d) {
        return this.percentFormatter.format(d);
    }

    public String formatDate(Date d) {
        return this.dateFormatter.format(d);
    }

    public static Date parseISO8601Date(String s) {
        if (s == null) {
            return null;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hrs = 0;
        int min = 0;
        int sec = 0;
        try {
            int len = s.length();
            if (len >= 4) {
                year = Integer.parseInt(s.substring(0, 4));
            }
            if (len >= 7) {
                month = Integer.parseInt(s.substring(5, 7)) - 1;
            }
            if (len >= 10) {
                day = Integer.parseInt(s.substring(8, 10));
            }
            if (len >= 13) {
                hrs = Integer.parseInt(s.substring(11, 13));
            }
            if (len >= 16) {
                min = Integer.parseInt(s.substring(14, 16));
            }
            if (len >= 19) {
                sec = Integer.parseInt(s.substring(17, 19));
            }
            return new GregorianCalendar(year, month, day, hrs, min, sec).getTime();
        }
        catch (Exception e) {
            return null;
        }
    }
}

