/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.RuleAttributeTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RuleAttributeSection
extends Composite
implements IDetails,
SelectionListener,
INotifyChangedListener,
ModifyListener {
    protected Label nameText;
    protected Label uniqueId;
    protected Button usePreviuos;
    protected Label indexText;
    protected Text defaultValue;
    protected boolean isDisplaying;
    protected RuleAttributeType currentSelection;
    protected RuleAttributeTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();

    public RuleAttributeSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME"), 0);
        this.nameText = factory.createLabel(this, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_ID"), 0);
        this.uniqueId = factory.createLabel(this, "unspecified");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_INDEX"), 0);
        this.indexText = factory.createLabel(this, "");
        this.indexText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.usePreviuos = factory.createButton(this, AcadEditorPlugin.getDefault().getString("STR_USE_PREV_ATTR"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.usePreviuos.setLayoutData((Object)data);
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_DEFAULT_VALUE"), 0);
        this.defaultValue = factory.createText(this, "");
        this.defaultValue.setLayoutData((Object)new GridData(768));
        this.defaultValue.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.itemProvider = (RuleAttributeTypeItemProvider)this.itemFactory.createRuleAttributeTypeAdapter();
        this.itemProvider.addListener(this);
        this.usePreviuos.addSelectionListener((SelectionListener)this);
        this.defaultValue.addModifyListener((ModifyListener)this);
    }

    public void display(EObject object) {
        if (this.currentSelection == object) {
            return;
        }
        this.currentSelection = (RuleAttributeType)object;
        this.isDisplaying = true;
        this.nameText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.uniqueId.setText(this.currentSelection.getId() == null ? "unspecified" : this.currentSelection.getId().toString());
        this.indexText.setText(this.currentSelection.getIndex() == null ? "" : this.currentSelection.getIndex());
        this.defaultValue.setText(this.currentSelection.getDefaultValue() == null ? "" : this.currentSelection.getDefaultValue());
        this.usePreviuos.setSelection(this.currentSelection.isUsePreviousMatchSubstitutionAsDefault());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (RuleAttributeType)currentSelection;
        this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(this.usePreviuos.getSelection());
        this.currentSelection.setDefaultValue(this.defaultValue.getText());
        return false;
    }

    public void setFocusToText() {
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent e) {
        IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleAttributeTypeItemProvider.USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT);
        this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(this.usePreviuos.getSelection());
        Boolean oldValue = this.currentSelection.isSetUsePreviousMatchSubstitutionAsDefault();
        if (descriptor != null) {
            descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.defaultValue && !(text = this.defaultValue.getText()).equals(this.currentSelection.getDefaultValue())) {
            if (text.length() == 0 && this.currentSelection.getDefaultValue() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleAttributeTypeItemProvider.DEFAULT_VALUE);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }
}

