/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IExtractor;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueue;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.hyades.logging.adapter.ui.internal.views.LogView;
import org.eclipse.swt.widgets.Display;

public class TestContextListener
implements IContextListener {
    private int extractorIndex = 0;
    private int formatterIndex = 0;
    private boolean firstRecord = true;
    protected ContextInstanceType context;
    private ResultQueue queue;

    public void preProcessEventItems(IComponent component, Object[] msgs) {
    }

    public void postProcessEventItems(IComponent component, Object[] results) {
        block10: {
            AcadGuiModel model;
            block9: {
                model = AcadGuiModelManager.getModel(this.context);
                if (model == null) {
                    return;
                }
                if (this.queue == null) {
                    this.queue = model.getResultQueue();
                }
                if (!(component instanceof ISensor)) break block9;
                if (results == null) break block10;
                StringBuffer buffer = new StringBuffer();
                for (int idx = 0; idx < results.length; ++idx) {
                    if (results[idx] == null) continue;
                    buffer.append(results[idx]).append("\n");
                }
                if (model == null) break block10;
                model.setLogContent(model.getLogContent() + buffer.toString());
                break block10;
            }
            if (component instanceof IExtractor) {
                if (results != null && model != null) {
                    for (int idx = 0; idx < results.length; ++idx) {
                        if (results[idx] == null || ++this.extractorIndex < model.getStartRecord()) continue;
                        this.queue.insertExtractorResult(results[idx]);
                        if (!this.firstRecord) continue;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                LogView log = LogView.getLogView(false);
                                if (log != null) {
                                    log.enableActions();
                                }
                            }
                        });
                        this.firstRecord = false;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            model.updateTemplateLog();
                        }
                    });
                }
            } else if (component instanceof IFormatter && results != null && model != null) {
                for (int idx = 0; idx < results.length; ++idx) {
                    if (results[idx] == null || ++this.formatterIndex < model.getStartRecord()) continue;
                    this.queue.insertFormatterResult(results[idx]);
                }
            }
        }
    }

    public String[] getTargetContextUniqueIds() {
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        if (model == null || model.getContextInstance() == null) {
            this.context = null;
            return new String[0];
        }
        this.context = model.getContextInstance();
        model.setContextListener(this);
        return new String[]{this.context.getUniqueID()};
    }

    public ContextInstanceType getContext() {
        return this.context;
    }

    public void setContext(ContextInstanceType type) {
        this.context = type;
    }
}

