/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;

public class ParseMonitorOwner {
    private Hashtable _idents = null;
    private ThreadDump _threadDump = null;
    private Hashtable _threads = null;
    private Hashtable _monitors = null;
    private Hashtable _ownedMonitors = null;
    private Hashtable _tid = null;
    private Vector deadlockResults = null;
    public static final String FLATLOCKMSG = "Flat locked by thread ident ";
    public static final String FLATLOCKMSG_WITHIDENTASDIGIT = "Flat locked by threadIdent ";
    public static final int FLATLOCKMSG_WITHIDENTASDIGIT_LEN = "Flat locked by threadIdent ".length();
    public static final String FLATLOCKOWNER = "(Flat locked) owner ";
    public static final int FLATLOCKMSG_LEN = "Flat locked by thread ident ".length();
    public static final String OWNERMSG = "owner ";

    public ParseMonitorOwner(Hashtable i, Hashtable t, Hashtable m, Hashtable tid, ThreadDump td) {
        this._idents = i;
        this._threadDump = td;
        this._threads = t;
        this._monitors = m;
        this._ownedMonitors = new Hashtable();
        this._tid = tid;
    }

    public void doIt(int monIndex) {
        Vector tdVector = this._threadDump.getThreadDumpVector();
        String line = null;
        int size = tdVector.size();
        int sIndex = -1;
        String s = null;
        Object monitor = null;
        while (size >= ++monIndex && (sIndex = (line = (String)tdVector.elementAt(monIndex)).indexOf("JVM System Monitor Dump (registered monitors):")) < 0) {
            sIndex = line.indexOf("unowned");
            if (sIndex >= 0) {
                this.setMonOwner(line);
                continue;
            }
            sIndex = line.indexOf(FLATLOCKMSG);
            if (sIndex >= 0) {
                s = line.substring(sIndex + FLATLOCKMSG_LEN, sIndex + FLATLOCKMSG_LEN + 4);
                s = (String)this._idents.get(s);
                this.setMonOwner(line, s);
                continue;
            }
            sIndex = line.indexOf(FLATLOCKMSG_WITHIDENTASDIGIT);
            if (sIndex >= 0) {
                s = line.substring(sIndex + FLATLOCKMSG_WITHIDENTASDIGIT_LEN, line.indexOf(" ", sIndex + FLATLOCKMSG_WITHIDENTASDIGIT_LEN + 1));
                s = (String)this._idents.get(s);
                this.setMonOwner(line, s);
            }
            if ((sIndex = line.indexOf(OWNERMSG)) < 0) continue;
            s = line.substring(line.indexOf("(", sIndex + OWNERMSG.length()) + 1, line.indexOf(")", sIndex + OWNERMSG.length()));
            this.setMonOwner(line, s);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this._ownedMonitors.keySet().iterator();
        sb.append("Owned Monitor Dump\n");
        while (i.hasNext()) {
            sb.append("Monitor=\n");
            String name = (String)i.next();
            Monitor m = (Monitor)this._monitors.get(name);
            sb.append(m.getName()).append("\n");
            sb.append(m._owner._threadId).append("\n");
            if (m._waiters.size() > 0) {
                sb.append("Waiting sys_thread_t\n");
                for (int j = 0; j < m._waiters.size(); ++j) {
                    sb.append(((Thd)m._waiters.get((int)j))._threadId).append("\n");
                }
                continue;
            }
            sb.append("No Waiters\n");
        }
        return sb.toString();
    }

    public void addOwnedMonitor(String key, Monitor value) {
        this._ownedMonitors.put(key, value);
    }

    public Iterator getOwnedMonitorIterator() {
        return this._ownedMonitors.keySet().iterator();
    }

    public void setMonOwner(String line, String t) {
        Thd thread;
        Monitor monitor = this.getMonitor(line);
        if (monitor != null && (thread = (Thd)this._threads.get(t)) != null) {
            monitor.setOwner(thread);
            this.addOwnedMonitor(monitor._name, monitor);
        }
    }

    public void setMonOwner(String line) {
        Thd thread;
        String systhreadt;
        Monitor monitor = this.getMonitor(line);
        if (monitor != null && (systhreadt = (String)this._tid.get(this.getMonitorStartAddress(monitor._name))) != null && (thread = (Thd)this._threads.get(systhreadt)) != null) {
            monitor.setOwner(thread);
            this.addOwnedMonitor(monitor._name, monitor);
        }
    }

    public Monitor getMonitor(String line) {
        int sIndex = line.indexOf(":", line.indexOf(":") + 1);
        String s = line.substring(0, sIndex);
        s = s.substring(s.lastIndexOf(" ") + 1);
        return (Monitor)this._monitors.get(s);
    }

    public String getMonitorStartAddress(String monitorName) {
        int sIndex = monitorName.indexOf("@");
        int fIndex = monitorName.indexOf("/", sIndex + 1);
        String addr = monitorName.substring(sIndex + 1, fIndex);
        return "0x" + addr;
    }

    public Hashtable getOwnedMonitors() {
        return this._ownedMonitors;
    }
}

