/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IEclipseExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.harness.ExecutionHarnessDataProcessorFactory;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor2;
import org.eclipse.hyades.execution.harness.util.ExecutionAdapterUtilities;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;
import org.eclipse.hyades.execution.harness.util.StandaloneExecutionUtilities;
import org.eclipse.hyades.execution.harness.util.StandaloneSystemUtility;
import org.eclipse.hyades.execution.local.EclipseExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutableObjectStub;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.HyadesTestNodeImpl;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.SessionContext;
import org.eclipse.hyades.execution.local.SessionContextToSessionMap;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.DatapoolFacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class TestExecutionHarness {
    private Object agentLock = new Object();
    private boolean bAgentReady = false;
    private static HashMap testTypeMap = null;
    private boolean bFactoryInitialized = false;
    private static boolean bStandalone = false;
    private IExecutionComponentFactory factory;
    private ISession session;
    private INode node;
    private IExecutionEnvironment exeEnvironment;
    private IExecutor executor;
    private String[] standaloneConfigurationFiles;
    private ISystemUtility systemUtility;
    private ExecutionHarnessDataProcessorFactory dpFactory;

    public static void main(String[] args) {
        StringBuffer bufError;
        boolean overwriteExistingResult;
        String resultName;
        String resultsLocation;
        String hostName;
        String deploymentPath;
        String testSuitePath;
        String versionString;
        String eclipseHome;
        TestExecutionHarness harness;
        IExecutor executor;
        if (args.length != 8) {
            System.err.println("Usage: TestExecutionHarness <eclipseHomePath> <versionString> <testSuitePath> <deploymentPath> <hostname> <resultLocation> <resultName> <overwriteExistingResult>");
            System.exit(-1);
        }
        if ((executor = (harness = new TestExecutionHarness(eclipseHome = args[0], versionString = args[1])).launchTest(testSuitePath = args[2], deploymentPath = args[3], null, hostName = args[4], "10002", resultsLocation = args[5], resultName = args[6], overwriteExistingResult = Boolean.valueOf(args[7]).booleanValue(), true, true, bufError = new StringBuffer())) != null) {
            TestExecutionHarness.waitForDataProcessorExit(executor);
        } else {
            System.out.println(bufError.toString());
        }
    }

    private static IRemoteHyadesComponent findRemoteHyadesComponent(IExecutor executor) {
        IRemoteHyadesComponent comp = null;
        IExecutionComponent[] children = executor.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IRemoteHyadesComponent)) continue;
            comp = (IRemoteHyadesComponent)children[i];
        }
        return comp;
    }

    public TestExecutionHarness() {
        try {
            Class<?> tmp = Class.forName("org.eclipse.core.boot.BootLoader");
            bStandalone = false;
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException("Standalone execution requires that a configuration file directory is passed to the TestExecutionHarness constructor!");
        }
    }

    public TestExecutionHarness(String configurationFileDir, String versionString) {
        try {
            Class<?> tmp = Class.forName("org.eclipse.core.boot.BootLoader");
            bStandalone = false;
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException exc) {
            bStandalone = true;
            String[] plugins = StandaloneExecutionUtilities.getConfigFilesFromConfigDir(configurationFileDir);
            this.setStandaloneConfigurationFiles(plugins);
            String harnessDir = StandaloneExecutionUtilities.getHarnessDir(configurationFileDir, versionString);
            this.systemUtility = new StandaloneSystemUtility(harnessDir);
            RegistryReader.standaloneConfiguration = new RegistryReader.StandaloneConfiguration();
            RegistryReader.standaloneConfiguration.setEclipseFolder(configurationFileDir);
            this.init();
        }
    }

    private void init() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("testsuite", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("deploy", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("execution", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("artifact", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("location", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("datapool", new DatapoolFacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("sut", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("testcomponent", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new FacadeResourceFactoryImpl());
        Common_TestprofilePackageImpl.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAgentLock() {
        Object object = this.agentLock;
        synchronized (object) {
            this.bAgentReady = true;
            this.agentLock.notify();
        }
    }

    protected void initializeRegisteredExecutionComponents(IExecutionComponentFactory factory, boolean bStandalone, ExecutionHarnessDataProcessorFactory dpFactory) throws ClassNotFoundException, FileNotFoundException {
        testTypeMap = new HashMap();
        if (!bStandalone) {
            IEclipseExecutionComponentFactory eclipseFactory = (IEclipseExecutionComponentFactory)factory;
            IPluginRegistry reg = Platform.getPluginRegistry();
            IConfigurationElement[] execComps = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl");
            for (int i = 0; i < execComps.length; ++i) {
                String type = execComps[i].getAttribute("type");
                String executionComponentName = execComps[i].getAttribute("name");
                eclipseFactory.addExecutionComponent(execComps[i]);
                Object map = testTypeMap.get(type);
                if (map == null) {
                    map = new HashMap();
                    testTypeMap.put(type, map);
                }
                HashMap execCompMap = (HashMap)map;
                IConfigurationElement[] supportedTestTypes = execComps[i].getChildren("SupportedTestType");
                for (int j = 0; j < supportedTestTypes.length; ++j) {
                    execCompMap.put(supportedTestTypes[j].getAttribute("name"), executionComponentName);
                }
            }
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter", "EXECUTION_ENVIRONMENT_ADAPTER", bStandalone);
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter", "EXECUTABLE_OBJECT_ADAPTER", bStandalone);
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutionDeploymentAdapter", "EXECUTION_DEPLOYMENT_ADAPTER", bStandalone);
        } else {
            StandaloneExecutionUtilities.initializeRegisteredExecutionComponents(this.standaloneConfigurationFiles, testTypeMap, factory, dpFactory);
        }
    }

    private void mapAdapterClasses(String configElements, String type, boolean bStandalone) {
        if (!bStandalone) {
            IConfigurationElement[] execEnvAdapters = Platform.getPluginRegistry().getConfigurationElementsFor(configElements);
            for (int i = 0; i < execEnvAdapters.length; ++i) {
                String adapterClass = execEnvAdapters[i].getAttribute("class");
                Object map = testTypeMap.get(type);
                if (map == null) {
                    map = new HashMap();
                    testTypeMap.put(type, map);
                }
                HashMap execCompMap = (HashMap)map;
                IConfigurationElement[] supportedTestTypes = execEnvAdapters[i].getChildren("SupportedTestType");
                for (int j = 0; j < supportedTestTypes.length; ++j) {
                    execCompMap.put(supportedTestTypes[j].getAttribute("name"), execEnvAdapters[i]);
                }
            }
        }
    }

    protected String getExecutionComponentForTestType(String executionComponentType, String testType, boolean bStandalone) throws ClassNotFoundException {
        HashMap execCompMap;
        Object temp = testTypeMap.get(executionComponentType);
        if (temp != null && temp instanceof HashMap && (temp = (execCompMap = (HashMap)temp).get(testType)) != null && temp instanceof String) {
            return (String)temp;
        }
        String msg = this.systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        msg = StringUtil.change((String)msg, (String)"%1", (String)executionComponentType);
        msg = StringUtil.change((String)msg, (String)"%2", (String)testType);
        throw new ClassNotFoundException(msg);
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        ArrayList<String> dpIDs = null;
        if (bMonitor) {
            dpIDs = new ArrayList<String>();
            dpIDs.add("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        }
        IImplementor theImplementor = this.getImplementor(suite, theTest);
        return this.launchTest(theImplementor, null, machineName, null, port, executionResultLocation, executionResultName, bStandalone, dpIDs, bufError);
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(suite, theTest, deployment, port, executionResultLocation, executionResultName, false, bMonitor, bStandalone, bufError);
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean overrideExisting, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        ArrayList<String> dpIDs = null;
        if (bMonitor) {
            dpIDs = new ArrayList<String>();
            dpIDs.add("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        }
        IImplementor theImplementor = this.getImplementor(suite, theTest);
        return this.launchTest(theImplementor, null, null, deployment, port, executionResultLocation, executionResultName, overrideExisting, bStandalone, dpIDs, bufError);
    }

    public IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        IImplementor theImplementor = this.getImplementor(suite, theTest);
        return this.launchTest(theImplementor, null, null, deployment, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError);
    }

    public IExecutor launchTest(ITestSuite suite, ITest theTest, String overrideTestType, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        IImplementor theImplementor = this.getImplementor(suite, theTest);
        return this.launchTest(theImplementor, overrideTestType, null, deployment, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError);
    }

    public IExecutor launchTest(ITestSuite suite, ITest theTest, String hostName, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        IImplementor theImplementor = this.getImplementor(suite, theTest);
        return this.launchTest(theImplementor, null, hostName, null, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError);
    }

    public IExecutor launchTest(String rootSuitePath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        Object theTest = null;
        ITestSuite suite = null;
        TPFDeployment deployment = null;
        bufError.setLength(0);
        try {
            suite = HyadesFactory.INSTANCE.loadTestSuite(rootSuitePath);
        }
        catch (Exception exc) {
            this.systemUtility.logError(exc);
            bufError.append(StringUtil.change((String)this.systemUtility.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)rootSuitePath));
            return null;
        }
        if (suite instanceof CFGClass) {
            deployment = ConfigurationUtil.createDeploymentWithPair((String)machineName, null, (CFGClass)((CFGClass)suite), (String)machineName);
        }
        theTest = testID != null && testID.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(suite, testID) : suite;
        return this.launchTest(suite, (ITest)theTest, deployment, port, executionResultLocation, executionResultName, bMonitor, bStandalone, bufError);
    }

    public IExecutor launchTest(String rootSuitePath, String deploymentPath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(rootSuitePath, deploymentPath, testID, machineName, port, executionResultLocation, executionResultName, false, bMonitor, bStandalone, bufError);
    }

    public IExecutor launchTest(String rootSuitePath, String deploymentPath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean overwriteExistingResult, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        Object theTest = null;
        ITestSuite suite = null;
        TPFDeployment deployment = null;
        bufError.setLength(0);
        try {
            suite = HyadesFactory.INSTANCE.loadTestSuite(rootSuitePath);
        }
        catch (Exception exc) {
            this.systemUtility.logError(exc);
            bufError.append(StringUtil.change((String)this.systemUtility.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)rootSuitePath));
            return null;
        }
        try {
            if (deploymentPath != null && deploymentPath.length() > 0) {
                deployment = HyadesFactory.INSTANCE.loadDeployment(deploymentPath);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (deployment == null && suite instanceof CFGClass) {
            deployment = ConfigurationUtil.createDeploymentWithPair((String)machineName, null, (CFGClass)((CFGClass)suite), (String)machineName);
        }
        theTest = testID != null && testID.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(suite, testID) : suite;
        return this.launchTest(suite, (ITest)theTest, deployment, port, executionResultLocation, executionResultName, overwriteExistingResult, bMonitor, bStandalone, bufError);
    }

    private synchronized IExecutor launchTest(IImplementor theImplementor, String overrideTestType, String machineName, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        return this.launchTest(theImplementor, overrideTestType, machineName, deployment, port, executionResultLocation, executionResultName, false, bStandalone, activeDataProcessorIDs, bufError);
    }

    private synchronized IExecutor launchTest(IImplementor theImplementor, String overrideTestType, String machineName, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean overrideExistingResult, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        this.factory = null;
        this.session = null;
        this.exeEnvironment = null;
        this.executor = null;
        this.node = null;
        bufError.setLength(0);
        Object rootResource = null;
        TPFTestComponent owningComponent = null;
        ITest owningTest = theImplementor.getOwner();
        if (owningTest != null) {
            rootResource = owningTest instanceof ITestSuite ? (CFGClass)owningTest : (CFGClass)((ITestCase)owningTest).getOwner();
        } else {
            TPFTestComponent component;
            owningComponent = component = ((TPFBehavior)theImplementor).getTestComponent();
            rootResource = component.eContainer() == null ? component : (CFGClass)component.eContainer();
        }
        try {
            String testType = overrideTestType != null && overrideTestType.length() > 0 ? overrideTestType : owningTest.getType();
            String machine = machineName;
            if (deployment == null) {
                deployment = ConfigurationUtil.createDeploymentWithPair(null, null, (CFGClass)rootResource, (String)machineName);
            } else {
                machine = ConfigurationUtil.getHostNameForTestAsset((CFGClass)rootResource, (TPFDeployment)deployment);
                if (machine == null) {
                    machine = machineName;
                }
            }
            if (machine == null) {
                return null;
            }
            this.session = this.sessionConnect(port, this.session, machine, bufError);
            if (this.session == null) {
                return null;
            }
            this.factory = bStandalone ? ExecutionComponentFactoryImpl.getInstance((ISession)this.session) : EclipseExecutionComponentFactoryImpl.getInstance((ISession)this.session);
            if (!this.bFactoryInitialized) {
                this.dpFactory = new ExecutionHarnessDataProcessorFactory(bStandalone);
                this.initializeRegisteredExecutionComponents(this.factory, bStandalone, this.dpFactory);
                this.bFactoryInitialized = true;
            }
            String envType = this.getExecutionComponentForTestType("ENVIRONMENT", testType, bStandalone);
            this.exeEnvironment = (IExecutionEnvironment)this.factory.createExecutionComponentByType(envType);
            this.session.addChild((IExecutionComponent)this.exeEnvironment);
            if (!ExecutionAdapterUtilities.adaptExecutionDeployment(this.session.getNode(), deployment, bStandalone, testType, bufError, this.systemUtility, testTypeMap)) {
                return null;
            }
            if (!ExecutionAdapterUtilities.adaptExecutionEnvironment(this.exeEnvironment, rootResource, theImplementor, bStandalone, testType, deployment, bufError, this.systemUtility, testTypeMap)) {
                return null;
            }
            String executorType = this.getExecutionComponentForTestType("EXECUTOR", testType, bStandalone);
            this.executor = (IExecutor)this.factory.createExecutionComponentByType(executorType);
            this.exeEnvironment.addChild((IExecutionComponent)this.executor);
            String execObjType = this.getExecutionComponentForTestType("EXECUTABLEOBJECT", testType, bStandalone);
            IExecutableObject executableObject = this.executor.getCompatibleExecutableObject(execObjType);
            if (!ExecutionAdapterUtilities.adaptExecutableObject(executableObject, rootResource, theImplementor, bStandalone, testType, deployment, bufError, this.systemUtility, testTypeMap)) {
                return null;
            }
            if (executableObject != null) {
                this.executor.setExecutableObject(executableObject);
                if (this.executor instanceof ExecutorStub) {
                    ((ExecutorStub)this.executor).setExecutionResultLocation(executionResultLocation);
                    ((ExecutorStub)this.executor).setExecutionResultName(executionResultName);
                    ((ExecutorStub)this.executor).setCommunicationPort(port);
                }
            }
            String agentType = this.getExecutionComponentForTestType("AGENT", testType, bStandalone);
            if (activeDataProcessorIDs != null && activeDataProcessorIDs.size() > 0 && this.executor instanceof ExecutorStub) {
                ArrayList activeDataProcessors = this.initValidDataProcessors(owningTest, machine, agentType, executionResultName, executionResultLocation, overrideExistingResult, port, activeDataProcessorIDs);
                IExecutionHarnessDataProcessor[] dpArray = this.convertListToArray(activeDataProcessors);
                this.setAgentData((CFGClass)rootResource, executableObject, (IDataProcessor[])dpArray);
                ((ExecutorStub)this.executor).setDataProcessors((IDataProcessor[])dpArray);
            } else {
                this.initializeRemoteHyadesComponent(agentType, null);
            }
            this.executor.launch();
        }
        catch (ClassNotFoundException e) {
            this.systemUtility.logError(e);
            bufError.append(StringUtil.change((String)this.systemUtility.getString("CLASS_NOT_FOUND_ERR_"), (String)"%1", (String)e.getMessage()));
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            bufError.append(t.getMessage());
        }
        return this.executor;
    }

    private IExecutionHarnessDataProcessor[] convertListToArray(ArrayList registeredDataProcessorsForTestType) {
        IExecutionHarnessDataProcessor[] dp = new IExecutionHarnessDataProcessor[registeredDataProcessorsForTestType.size()];
        for (int i = 0; i < registeredDataProcessorsForTestType.size(); ++i) {
            dp[i] = (IExecutionHarnessDataProcessor)registeredDataProcessorsForTestType.get(i);
        }
        return dp;
    }

    private void setAgentData(CFGClass rootResource, IExecutableObject executableObject, IDataProcessor[] dataProcessors) throws CoreException {
        if (executableObject instanceof JavaProcessExecutableObjectStub && dataProcessors != null && dataProcessors.length > 1) {
            String dpString = "AgentIDs:";
            for (int i = 1; i < dataProcessors.length; ++i) {
                dpString = dpString + ((IExecutionHarnessDataProcessor)dataProcessors[i]).getID();
                if (i >= dataProcessors.length - 1) continue;
                dpString = dpString + ",";
            }
            ((JavaProcessExecutableObjectStub)executableObject).setAgentData(dpString);
        }
    }

    private void initializeRemoteHyadesComponent(String agentType, IExecutionHarnessDataProcessor dp) {
        IRemoteHyadesComponent remoteComponent = (IRemoteHyadesComponent)this.factory.createExecutionComponentByType(agentType);
        this.executor.addChild((IExecutionComponent)remoteComponent);
        remoteComponent.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent event) {
                if (event.getState() == 2) {
                    TestExecutionHarness.this.releaseAgentLock();
                }
            }
        });
        if (dp != null) {
            remoteComponent.startMonitoring((IDataProcessor)dp);
        }
        this.waitForActiveAgent(remoteComponent);
    }

    private ArrayList loadDataProcessors(ISystemUtility systemUtility) {
        IConfigurationElement[] dataProcessors = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.Dataprocessor");
        ArrayList<IExecutionHarnessDataProcessor> retList = new ArrayList<IExecutionHarnessDataProcessor>();
        for (int i = 0; i < dataProcessors.length; ++i) {
            try {
                IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dataProcessors[i].createExecutableExtension("class");
                retList.add(dataProcessor);
                continue;
            }
            catch (CoreException e) {
                systemUtility.logError(e);
            }
        }
        return retList;
    }

    private ArrayList initValidDataProcessors(ITest theTest, String hostName, String agentType, String executionResultName, String executionResultLocation, boolean overrideExisting, String port, ArrayList validDPIds) throws CoreException {
        int i;
        ArrayList<IExecutionHarnessDataProcessor> retList = new ArrayList<IExecutionHarnessDataProcessor>();
        ArrayList dpList = this.dpFactory.getDataProcessors();
        for (i = 0; i < dpList.size(); ++i) {
            IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dpList.get(i);
            if (!validDPIds.contains(dataProcessor.getID())) continue;
            if (dataProcessor instanceof IExecutionHarnessDataProcessor2) {
                ((IExecutionHarnessDataProcessor2)dataProcessor).setInitData(theTest, hostName, executionResultName, executionResultLocation, overrideExisting, port);
            } else {
                dataProcessor.setInitData(theTest, hostName, executionResultName, executionResultLocation, port);
            }
            if (dataProcessor.getID().equalsIgnoreCase("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor")) {
                retList.add(0, dataProcessor);
                continue;
            }
            retList.add(dataProcessor);
        }
        for (i = 0; i < retList.size(); ++i) {
            IExecutionHarnessDataProcessor dp = (IExecutionHarnessDataProcessor)retList.get(i);
            if (i == 0 && dp.getID().compareToIgnoreCase("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor") != 0) {
                this.initializeRemoteHyadesComponent(agentType, null);
                continue;
            }
            this.initializeRemoteHyadesComponent(agentType, dp);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForActiveAgent(IRemoteHyadesComponent agent) {
        if (agent.getState() == 3) {
            while (!this.bAgentReady) {
                Object object = this.agentLock;
                synchronized (object) {
                    try {
                        this.agentLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private ISession sessionConnect(String port, ISession session, String machine, StringBuffer bufError) {
        bufError.setLength(0);
        try {
            HyadesTestNodeImpl node = new HyadesTestNodeImpl(machine);
            session = node.connect(port, null);
        }
        catch (UnknownHostException e) {
            bufError.append(StringUtil.change((String)this.systemUtility.getString("TIMEOUT_NODE_ERROR_"), (String)"%1", (String)machine));
        }
        catch (AgentControllerUnavailableException e) {
            bufError.append(StringUtil.change((String)this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)machine));
        }
        catch (UnknownDaemonException e) {
            bufError.append(StringUtil.change((String)this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)machine));
        }
        catch (Exception e) {
            this.systemUtility.logError(e);
            bufError.append(StringUtil.change((String)this.systemUtility.getString("RUN_FAILED_ERR_"), (String)"%1", (String)machine));
        }
        return session;
    }

    private ISession getSession(String port, ISession session, String machine, StringBuffer bufError) {
        bufError.setLength(0);
        SessionContext ctx = new SessionContext(machine, port, null);
        return SessionContextToSessionMap.getSession((SessionContext)ctx);
    }

    private String[] getStandaloneConfigurationFiles() {
        return this.standaloneConfigurationFiles;
    }

    private void setStandaloneConfigurationFiles(String[] standaloneConfigurationFiles) {
        this.standaloneConfigurationFiles = standaloneConfigurationFiles;
    }

    public synchronized String stopTest(ITestSuite suite, ITest theTest, CFGLocation location, String port, TPFExecutionResult execResult) {
        String machine = ((CFGMachineConstraint)location).getHostname();
        StringBuffer bufError = new StringBuffer();
        this.session = this.getSession(port, this.session, machine, bufError);
        if (this.session == null) {
            return StringUtil.change((String)this.systemUtility.getString("NO_SESSION_FOUND_ERROR"), (String)"%1", (String)machine);
        }
        try {
            boolean testStopped = false;
            boolean testFound = false;
            ArrayList<IExecutionComponent> componentstoremove = new ArrayList<IExecutionComponent>();
            IExecutionComponent[] exeEnvironments = this.session.getChildren();
            for (int i = 0; i < exeEnvironments.length; ++i) {
                if (!(exeEnvironments[i] instanceof IExecutionEnvironment)) continue;
                IExecutionComponent[] executors = exeEnvironments[i].getChildren();
                for (int j = 0; j < executors.length; ++j) {
                    ExecutableObjectStub exeobj;
                    if (!(executors[j] instanceof ExecutorStub) || !(exeobj = (ExecutableObjectStub)((IExecutor)executors[j]).getExecutableObject()).getTestID().equals(theTest.getId()) || !exeobj.getSuiteID().equals(suite.getId()) || !((ExecutorStub)executors[j]).getExecutionResultName().equals(execResult.getName())) continue;
                    testFound = true;
                    IExecutionComponent[] agents = executors[j].getChildren();
                    for (int k = 0; k < agents.length; ++k) {
                        if (!(agents[k] instanceof IRemoteHyadesComponent)) continue;
                        this.stopMonitoringAndWait((IRemoteHyadesComponent)agents[k]);
                        componentstoremove.add(agents[k]);
                    }
                    ((IExecutor)executors[j]).kill();
                    this.removeChildComponents(componentstoremove, executors[j]);
                    componentstoremove.clear();
                    testStopped = true;
                    if (executors[j].getChildren().length != 0) continue;
                    componentstoremove.add(executors[j]);
                }
                this.removeChildComponents(componentstoremove, exeEnvironments[i]);
                componentstoremove.clear();
                if (exeEnvironments[i].getChildren().length != 0) continue;
                componentstoremove.add(exeEnvironments[i]);
            }
            this.removeChildComponents(componentstoremove, (IExecutionComponent)this.session);
            if (!testStopped) {
                if (!testFound) {
                    return this.systemUtility.getString("NO_TEST_TO_STOP_ERROR_");
                }
                return this.systemUtility.getString("TEST_STOP_ERROR_");
            }
            this.logStopEvents(execResult);
            execResult.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            return t.getMessage();
        }
        return null;
    }

    public synchronized String stopTest(IExecutor executor, TPFExecutionResult execResult) {
        try {
            if (!this.stopTest(executor)) {
                return this.systemUtility.getString("TEST_STOP_ERROR_");
            }
            this.logStopEvents(execResult);
            execResult.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            return t.getMessage();
        }
        return null;
    }

    private boolean stopTest(IExecutor executor) {
        IExecutionComponent[] agents = executor.getChildren();
        ArrayList<IExecutionComponent> componentsToRemove = new ArrayList<IExecutionComponent>();
        for (int i = 0; i < agents.length; ++i) {
            if (!(agents[i] instanceof IRemoteHyadesComponent)) continue;
            try {
                this.stopMonitoringAndWait((IRemoteHyadesComponent)agents[i]);
                componentsToRemove.add(agents[i]);
                continue;
            }
            catch (InterruptedException e) {
                this.systemUtility.logError(e);
            }
        }
        this.removeChildComponents(componentsToRemove, (IExecutionComponent)executor);
        componentsToRemove.clear();
        executor.kill();
        return true;
    }

    private void logStopEvents(TPFExecutionResult result) {
        String msg = this.systemUtility.getString("TEST_ABORTED_MESSAGE_");
        TPFVerdictEvent verdict = Common_TestprofileFactory.eINSTANCE.createTPFVerdictEvent();
        verdict.setVerdict(TPFVerdict.INCONCLUSIVE_LITERAL);
        verdict.setReason(TPFVerdictReason.ABORT_LITERAL);
        verdict.setText(msg);
        verdict.setExecutionHistory(result.getExecutionHistory());
        TPFTypedEvent stopEvent = Common_TestprofileFactory.eINSTANCE.createTPFTypedEvent();
        stopEvent.setType(TPFExecutionType.STOP_LITERAL);
        stopEvent.setText(msg);
        stopEvent.setTimestamp(System.currentTimeMillis());
        stopEvent.setExecutionHistory(result.getExecutionHistory());
        result.setVerdict(TPFVerdict.INCONCLUSIVE_LITERAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInactiveAgent(IRemoteHyadesComponent agent) {
        if (agent.getState() == 2) {
            while (!this.bAgentReady) {
                Object object = this.agentLock;
                synchronized (object) {
                    try {
                        this.agentLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void stopMonitoringAndWait(IRemoteHyadesComponent agent) throws InterruptedException {
        agent.stopMonitoring();
        Thread.sleep(3000L);
    }

    private void removeChildComponents(ArrayList children, IExecutionComponent parent) {
        for (int i = 0; i < children.size(); ++i) {
            parent.removeChild((IExecutionComponent)children.get(i));
        }
    }

    public synchronized String performControlEvent(ITestSuite suite, ITest theTest, CFGLocation location, String port, TPFExecutionResult execResult, String controlEvent, String[] params) {
        String machine = ((CFGMachineConstraint)location).getHostname();
        StringBuffer bufError = new StringBuffer();
        if (!this.canSupportControlEvent(suite, theTest, location, port, execResult, controlEvent)) {
            return StringUtil.change((String)this.systemUtility.getString("CANNOT_SUPPORT_MSG_"), (String)"%1", (String)controlEvent);
        }
        this.session = this.getSession(port, this.session, machine, bufError);
        if (this.session == null) {
            return StringUtil.change((String)this.systemUtility.getString("NO_SESSION_FOUND_ERROR"), (String)"%1", (String)machine);
        }
        String error = null;
        try {
            boolean controlEventPerformed = false;
            IExecutionComponent[] exeEnvironments = this.session.getChildren();
            for (int i = 0; i < exeEnvironments.length; ++i) {
                if (!(exeEnvironments[i] instanceof IExecutionEnvironment)) continue;
                IExecutionComponent[] executors = exeEnvironments[i].getChildren();
                for (int j = 0; j < executors.length; ++j) {
                    ExecutableObjectStub exeobj;
                    if (!(executors[j] instanceof ExecutorStub) || !(exeobj = (ExecutableObjectStub)((IExecutor)executors[j]).getExecutableObject()).getTestID().equals(theTest.getId()) || !exeobj.getSuiteID().equals(suite.getId()) || !((ExecutorStub)executors[j]).getExecutionResultName().equals(execResult.getName()) || (error = ((IExecutor)executors[j]).performControlEvent("CONTROL_EVENT_SUSPEND", params)) != null) continue;
                    controlEventPerformed = true;
                }
            }
            if (!controlEventPerformed) {
                if (error == null) {
                    return StringUtil.change((String)this.systemUtility.getString("CANNOT_PERFORM_MSG_"), (String)"%1", (String)controlEvent);
                }
                return error;
            }
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            return t.getMessage();
        }
        return null;
    }

    public synchronized boolean canSupportControlEvent(ITestSuite suite, ITest theTest, CFGLocation location, String port, TPFExecutionResult execResult, String controlEvent) {
        String machine = ((CFGMachineConstraint)location).getHostname();
        StringBuffer bufError = new StringBuffer();
        this.session = this.getSession(port, this.session, machine, bufError);
        if (this.session == null) {
            return false;
        }
        boolean canSupport = false;
        IExecutionComponent[] exeEnvironments = this.session.getChildren();
        for (int i = 0; i < exeEnvironments.length; ++i) {
            if (!(exeEnvironments[i] instanceof IExecutionEnvironment)) continue;
            IExecutionComponent[] executors = exeEnvironments[i].getChildren();
            for (int j = 0; j < executors.length; ++j) {
                ExecutableObjectStub exeobj;
                if (!(executors[j] instanceof ExecutorStub) || !(exeobj = (ExecutableObjectStub)((IExecutor)executors[j]).getExecutableObject()).getTestID().equals(theTest.getId()) || !exeobj.getSuiteID().equals(suite.getId()) || !((ExecutorStub)executors[j]).getExecutionResultName().equals(execResult.getName())) continue;
                if (((IExecutor)executors[j]).supportsControlEvent(controlEvent)) {
                    canSupport = true;
                    continue;
                }
                return false;
            }
        }
        return canSupport;
    }

    private IImplementor getImplementor(ITestSuite suite, ITest theTest) {
        IImplementor theImplementor = null;
        theImplementor = theTest != null ? theTest.getImplementor() : suite.getImplementor();
        return theImplementor;
    }

    public static void waitForDataProcessorExit(IExecutor executor) {
        IRemoteHyadesComponent remoteComponent = TestExecutionHarness.findRemoteHyadesComponent(executor);
        if (remoteComponent != null) {
            while (remoteComponent.isActive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

