/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.hyades.execution.harness.util.BaseString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static String useXMLSymbols(String string) {
        if (string != null) {
            string = BaseString.replace(string, "&", "&amp;");
            string = BaseString.replace(string, "<", "&lt;");
            string = BaseString.replace(string, ">", "&gt;");
            string = BaseString.replace(string, "\"", "&quot;");
            string = BaseString.replace(string, "'", "&apos;");
            string = BaseString.replace(string, "\t", "&#x9;");
            string = BaseString.replace(string, "\n", "&#xA;");
            string = BaseString.replace(string, "\r", "&#xD;");
        }
        return string;
    }

    public static String removeXMLSymbols(String xml) {
        if (xml != null) {
            xml = BaseString.replace(xml, "&amp;", "&");
            xml = BaseString.replace(xml, "&lt;", "<");
            xml = BaseString.replace(xml, "&gt;", ">");
            xml = BaseString.replace(xml, "&quot;", "\"");
            xml = BaseString.replace(xml, "&apos;", "'");
            xml = BaseString.replace(xml, "&#x9;", "\t");
            xml = BaseString.replace(xml, "&#xA;", "\n");
            xml = BaseString.replace(xml, "&#xD;", "\r");
        }
        return xml;
    }

    public static StringBuffer createXMLAttribute(String attribute, String value, boolean asChild) {
        if (value == null) {
            return new StringBuffer(0);
        }
        value = XMLUtil.useXMLSymbols(value);
        if (asChild) {
            return new StringBuffer("<").append(attribute).append(">").append(value).append("</").append(attribute).append(">");
        }
        return new StringBuffer(" ").append(attribute).append("=\"").append(value).append("\"");
    }

    public static Element loadDom(InputStream inputStream, String name) {
        if (inputStream == null || name == null) {
            return null;
        }
        Node doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setValidating(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(XMLUtil.createErrorHandler(false));
            doc = docBuilder.parse(inputStream);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        if (name != null) {
            NodeList list = doc.getElementsByTagName(name);
            if (list.getLength() > 0 && list.item(0) instanceof Element) {
                return (Element)list.item(0);
            }
            return null;
        }
        return (Element)doc.getFirstChild();
    }

    public static Element loadDom(String xml, String name) {
        if (xml == null || name == null) {
            return null;
        }
        return XMLUtil.loadDom(new ByteArrayInputStream(xml.getBytes()), name);
    }

    public static String getValue(Element element, String name) {
        if (element == null || name == null) {
            return null;
        }
        String value = element.getAttribute(name);
        if (value == null || value.length() == 0) {
            NodeList list = element.getElementsByTagName(name);
            int max = list.getLength();
            for (int i = 0; i < max; ++i) {
                String auxValue;
                Node textNode = list.item(i);
                Node firstChild = list.item(0).getFirstChild();
                if (firstChild == null || (auxValue = firstChild.getNodeValue()) == null || !textNode.getParentNode().equals(element)) continue;
                value = auxValue;
                break;
            }
        }
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    public static NodeList getChildrenByName(Element element, String name) {
        if (element == null || name == null) {
            return null;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            if (!(children.item(i) instanceof Element) || !name.equals(((Element)children.item(i)).getTagName())) continue;
            list.add(children.item(i));
        }
        return XMLUtil.createNodeList(list);
    }

    public static NodeList createNodeList(final List nodes) {
        if (nodes == null) {
            return null;
        }
        NodeList nodeList = new NodeList(){

            public int getLength() {
                return nodes.size();
            }

            public Node item(int index) {
                return (Node)nodes.get(index);
            }
        };
        return nodeList;
    }

    public static Document getXmlDom(String filePath) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setValidating(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            File xmlFile = new File(filePath);
            docBuilder.setErrorHandler(XMLUtil.createErrorHandler(false));
            return docBuilder.parse(xmlFile);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ErrorHandler createErrorHandler(final boolean logMessages) {
        ErrorHandler errorHandler = new ErrorHandler(){

            public void error(SAXParseException exception) {
                if (logMessages) {
                    exception.printStackTrace();
                }
            }

            public void fatalError(SAXParseException exception) {
                if (logMessages) {
                    exception.printStackTrace();
                }
            }

            public void warning(SAXParseException exception) {
                if (logMessages) {
                    exception.printStackTrace();
                }
            }
        };
        return errorHandler;
    }

    public static int getIntValue(Element element, String tagName) {
        try {
            return Integer.parseInt(XMLUtil.getValue(element, tagName));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String xmlVariable(String name, String value) {
        return XMLUtil.createXMLAttribute(name, value, false).toString();
    }

    public static String adjustXMLValue(String value) {
        return XMLUtil.useXMLSymbols(value);
    }
}

