/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.probekit.Compiler;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitPlugin;

public class CompilerFactory {
    private static final String extensionPointID = "org.eclipse.hyades.probekit.probeCompiler";
    public static CompilerFactory INSTANCE = new CompilerFactory();
    private boolean alreadyReportedErrors;

    private CompilerFactory() {
    }

    public IProbeCompiler createCompiler() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(extensionPointID);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IExtension iExtension = iExtensionArray[i];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                boolean bl = false;
                for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                    Object object;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[j];
                    if (!iConfigurationElement.getName().equals("compiler")) continue;
                    bl = true;
                    try {
                        object = iConfigurationElement.createExecutableExtension("class");
                    }
                    catch (CoreException coreException) {
                        object = null;
                    }
                    if (object == null) continue;
                    if (object instanceof IProbeCompiler) {
                        this.alreadyReportedErrors = true;
                        return (IProbeCompiler)object;
                    }
                    if (this.alreadyReportedErrors) continue;
                    Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("CompilerFactory.ExtenderError") + this.getPrintableExtenderName(iExtension) + ProbekitPlugin.getString("CompilerFactory.DoesNotImplementIProbeCompiler"), null);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                }
                if (bl || this.alreadyReportedErrors) continue;
                Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("CompilerFactory.ExtenderError") + this.getPrintableExtenderName(iExtension) + ProbekitPlugin.getString("CompilerFactory.NoCompilerElements"), null);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
            }
            this.alreadyReportedErrors = true;
        }
        return this.createDefaultCompiler();
    }

    private String getPrintableExtenderName(IExtension iExtension) {
        String string = iExtension.getDeclaringPluginDescriptor().getLabel();
        String string2 = iExtension.getDeclaringPluginDescriptor().getUniqueIdentifier();
        String string3 = "\"" + string + "\" (" + string2 + ")";
        return string3;
    }

    public IProbeCompiler createDefaultCompiler() {
        return new Compiler();
    }
}

