/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class BasicEList
extends AbstractList
implements EList,
Cloneable,
Serializable {
    protected int size;
    protected transient Object[] data;

    public BasicEList() {
    }

    public BasicEList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.data = this.newData(initialCapacity);
    }

    public BasicEList(Collection collection) {
        this.size = collection.size();
        if (this.size > 0) {
            this.data = this.newData(this.size + this.size / 8 + 1);
            collection.toArray(this.data);
        }
    }

    protected BasicEList(int size, Object[] data) {
        this.size = size;
        this.data = data;
    }

    protected Object[] newData(int capacity) {
        return new Object[capacity];
    }

    protected boolean useEquals() {
        return true;
    }

    protected boolean equalObjects(Object firstObject, Object secondObject) {
        return this.useEquals() && firstObject != null ? firstObject.equals(secondObject) : firstObject == secondObject;
    }

    protected boolean canContainNull() {
        return true;
    }

    protected boolean isUnique() {
        return false;
    }

    protected Object validate(int index, Object object) {
        if (!this.canContainNull() && object == null) {
            throw new IllegalArgumentException("The 'no null' constraint is violated");
        }
        return object;
    }

    protected Object assign(int index, Object object) {
        this.data[index] = object;
        return this.data[index];
    }

    protected Object resolve(int index, Object object) {
        return object;
    }

    protected void didSet(int index, Object newObject, Object oldObject) {
    }

    protected void didAdd(int index, Object newObject) {
    }

    protected void didRemove(int index, Object oldObject) {
    }

    protected void didClear(int size, Object[] oldObjects) {
        if (oldObjects != null) {
            int i = 0;
            while (i < size) {
                this.didRemove(i, oldObjects[i]);
                ++i;
            }
        }
    }

    protected void didMove(int index, Object movedObject, int oldIndex) {
    }

    protected void didChange() {
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object object) {
        if (this.useEquals() && object != null) {
            int i = 0;
            while (i < this.size) {
                if (object.equals(this.data[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.data[i] == object) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        if (this.useEquals() && object != null) {
            int i = 0;
            while (i < this.size) {
                if (object.equals(this.data[i])) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.data[i] == object) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (this.useEquals() && object != null) {
            int i = this.size - 1;
            while (i >= 0) {
                if (object.equals(this.data[i])) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.data[i] == object) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object[] toArray() {
        Object[] result = this.newData(this.size);
        if (this.size > 0) {
            System.arraycopy(this.data, 0, result, 0, this.size);
        }
        return result;
    }

    public Object[] toArray(Object[] array) {
        if (this.size > 0) {
            if (array.length < this.size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
            }
            System.arraycopy(this.data, 0, array, 0, this.size);
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    public Object[] data() {
        return this.data;
    }

    public void setData(int size, Object[] data) {
        this.size = size;
        this.data = data;
        ++this.modCount;
    }

    public Object get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
        return this.resolve(index, this.data[index]);
    }

    public Object basicGet(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
        return this.data[index];
    }

    public Object set(int index, Object object) {
        int currentIndex;
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
        if (this.isUnique() && (currentIndex = this.indexOf(object)) >= 0 && currentIndex != index) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        return this.setUnique(index, object);
    }

    public Object setUnique(int index, Object object) {
        Object oldObject = this.data[index];
        this.assign(index, this.validate(index, object));
        this.didSet(index, object, oldObject);
        this.didChange();
        return oldObject;
    }

    public boolean add(Object object) {
        if (this.isUnique() && this.contains(object)) {
            return false;
        }
        this.addUnique(object);
        return true;
    }

    public void addUnique(Object object) {
        this.grow(this.size + 1);
        this.assign(this.size, this.validate(this.size, object));
        this.didAdd(this.size++, object);
        this.didChange();
    }

    public void add(int index, Object object) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
        if (this.isUnique() && this.contains(object)) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        this.addUnique(index, object);
    }

    public void addUnique(int index, Object object) {
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.assign(index, this.validate(index, object));
        ++this.size;
        this.didAdd(index, object);
        this.didChange();
    }

    public boolean addAll(Collection collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(collection);
    }

    public boolean addAllUnique(Collection collection) {
        int growth = collection.size();
        this.grow(this.size + growth);
        Iterator objects = collection.iterator();
        int oldSize = this.size;
        this.size += growth;
        int i = oldSize;
        while (i < this.size) {
            Object object = objects.next();
            this.assign(i, this.validate(i, object));
            this.didAdd(i, object);
            this.didChange();
            ++i;
        }
        return growth != 0;
    }

    public boolean addAll(int index, Collection collection) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(index, collection);
    }

    public boolean addAllUnique(int index, Collection collection) {
        int growth = collection.size();
        this.grow(this.size + growth);
        int shifted = this.size - index;
        if (shifted > 0) {
            System.arraycopy(this.data, index, this.data, index + growth, shifted);
        }
        Iterator objects = collection.iterator();
        int oldSize = this.size;
        this.size += growth;
        int i = 0;
        while (i < growth) {
            Object object = objects.next();
            this.assign(index, this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++index;
            ++i;
        }
        return growth != 0;
    }

    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean modified = false;
        int i = this.size;
        while (--i >= 0) {
            if (!collection.contains(this.data[i])) continue;
            this.remove(i);
            modified = true;
        }
        return modified;
    }

    public Object remove(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        ++this.modCount;
        Object oldObject = this.data[index];
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, shifted);
        }
        this.data[--this.size] = null;
        this.didRemove(index, oldObject);
        this.didChange();
        return oldObject;
    }

    public boolean retainAll(Collection collection) {
        boolean modified = false;
        int i = this.size;
        while (--i >= 0) {
            if (collection.contains(this.data[i])) continue;
            this.remove(i);
            modified = true;
        }
        return modified;
    }

    public void clear() {
        ++this.modCount;
        Object[] oldData = this.data;
        int oldSize = this.size;
        this.data = null;
        this.size = 0;
        this.didClear(oldSize, oldData);
        this.didChange();
    }

    public void move(int index, Object object) {
        this.move(index, this.indexOf(object));
    }

    public Object move(int targetIndex, int sourceIndex) {
        ++this.modCount;
        if (targetIndex >= this.size || targetIndex < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + this.size);
        }
        if (sourceIndex >= this.size || sourceIndex < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + this.size);
        }
        Object object = this.data[sourceIndex];
        if (targetIndex != sourceIndex) {
            if (targetIndex < sourceIndex) {
                System.arraycopy(this.data, targetIndex, this.data, targetIndex + 1, sourceIndex - targetIndex);
            } else {
                System.arraycopy(this.data, sourceIndex + 1, this.data, sourceIndex, targetIndex - sourceIndex);
            }
            this.assign(targetIndex, object);
            this.didMove(targetIndex, object, sourceIndex);
            this.didChange();
        }
        return object;
    }

    public void shrink() {
        ++this.modCount;
        if (this.size == 0) {
            this.data = null;
        } else if (this.size < this.data.length) {
            Object[] oldData = this.data;
            this.data = this.newData(this.size);
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public void grow(int minimumCapacity) {
        int oldCapacity;
        ++this.modCount;
        int n = oldCapacity = this.data == null ? 0 : this.data.length;
        if (minimumCapacity > oldCapacity) {
            Object[] oldData = this.data;
            int newCapacity = oldCapacity + oldCapacity / 2 + 4;
            if (newCapacity < minimumCapacity) {
                newCapacity = minimumCapacity;
            }
            this.data = this.newData(newCapacity);
            if (oldData != null) {
                System.arraycopy(oldData, 0, this.data, 0, this.size);
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.data.length);
        int i = 0;
        while (i < this.size) {
            objectOutputStream.writeObject(this.data[i]);
            ++i;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int arrayLength = objectInputStream.readInt();
        this.data = this.newData(arrayLength);
        int i = 0;
        while (i < this.size) {
            this.didAdd(i, this.assign(i, objectInputStream.readObject()));
            ++i;
        }
    }

    public Object clone() {
        try {
            BasicEList clone = (BasicEList)super.clone();
            if (this.size > 0) {
                clone.size = this.size;
                clone.data = this.newData(this.size);
                System.arraycopy(this.data, 0, clone.data, 0, this.size);
            }
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size) {
            return false;
        }
        Iterator objects = ((List)object).iterator();
        if (this.useEquals()) {
            int i = 0;
            while (i < this.size) {
                Object o1 = this.data[i];
                Object o2 = objects.next();
                boolean bl = o1 == null ? o2 != null : !o1.equals(o2);
                if (bl) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                Object o1 = this.data[i];
                Object o2 = objects.next();
                if (o1 != o2) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < this.size) {
            Object object = this.data[i];
            hashCode = 31 * hashCode + (object == null ? 0 : object.hashCode());
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int i = 0;
        while (i < this.size) {
            stringBuffer.append(String.valueOf(this.data[i]));
            if (++i >= this.size) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new EIterator();
    }

    protected Iterator basicIterator() {
        return new NonResolvingEIterator();
    }

    public ListIterator listIterator() {
        return new EListIterator();
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
        return new EListIterator(index);
    }

    protected ListIterator basicListIterator() {
        return new NonResolvingEListIterator();
    }

    protected ListIterator basicListIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
        return new NonResolvingEListIterator(index);
    }

    protected List basicList() {
        if (this.size == 0) {
            return ECollections.EMPTY_ELIST;
        }
        return new UnmodifiableEList(this.size, this.data);
    }

    protected Collection getDuplicates(Collection collection) {
        Collection result = collection;
        Collection filteredResult = null;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (this.contains(object)) continue;
            if (filteredResult == null) {
                result = filteredResult = new BasicEList(collection);
            }
            filteredResult.remove(object);
        }
        return result;
    }

    protected Collection getNonDuplicates(Collection collection) {
        UniqueEList result = new UniqueEList(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (this.contains(object)) continue;
            result.add(object);
        }
        return result;
    }

    static /* synthetic */ int access$001(BasicEList x0) {
        return x0.modCount;
    }

    public static class UnmodifiableEList
    extends BasicEList {
        public UnmodifiableEList(int size, Object[] data) {
            this.size = size;
            this.data = data;
        }

        public Object set(int index, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void move(int index, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int targetIndex, int sourceIndex) {
            throw new UnsupportedOperationException();
        }

        public void shrink() {
            throw new UnsupportedOperationException();
        }

        public void grow(int minimumCapacity) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return this.basicIterator();
        }

        public ListIterator listIterator() {
            return this.basicListIterator();
        }

        public ListIterator listIterator(int index) {
            return this.basicListIterator(index);
        }
    }

    protected class NonResolvingEListIterator
    extends EListIterator {
        public NonResolvingEListIterator() {
        }

        public NonResolvingEListIterator(int index) {
            super(index);
        }

        public Object next() {
            try {
                Object next = BasicEList.this.data[this.cursor];
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException exception) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                Object previous = BasicEList.this.data[--this.cursor];
                this.checkModCount();
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException exception) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    protected class EListIterator
    extends EIterator
    implements ListIterator {
        public EListIterator() {
        }

        public EListIterator(int index) {
            this.cursor = index;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = BasicEList.this.get(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException exception) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                BasicEList.this.set(this.lastCursor, object);
            }
            catch (IndexOutOfBoundsException exception) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkModCount();
            try {
                BasicEList.this.add(this.cursor++, object);
                this.expectedModCount = BasicEList.this.modCount;
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class NonResolvingEIterator
    extends EIterator {
        protected NonResolvingEIterator() {
        }

        public Object next() {
            try {
                Object next = BasicEList.this.data[this.cursor];
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException exception) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class EIterator
    implements Iterator {
        protected int cursor = 0;
        protected int lastCursor = -1;
        protected int expectedModCount = BasicEList.access$001(BasicEList.this);

        protected EIterator() {
        }

        public boolean hasNext() {
            return this.cursor != BasicEList.this.size();
        }

        public Object next() {
            try {
                Object next = BasicEList.this.get(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException exception) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                BasicEList.this.remove(this.lastCursor);
                this.expectedModCount = BasicEList.this.modCount;
                if (this.lastCursor < this.cursor) {
                    --this.cursor;
                }
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new ConcurrentModificationException();
            }
        }

        protected void checkModCount() {
            if (BasicEList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

