/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;

public class LogThreadInteractions
extends LogInteractions {
    private List threadIDs = new UniqueEList();

    protected void loadEventsXMI() {
        if (!this.isDisplayingOnlyCorrelations()) {
            this.loadThreadIdsFromAgentList(true);
        } else {
            this.loadThreadIdsFromAgentList(false);
            this.loadEventsFromCorrelationsXMI();
        }
    }

    private void loadThreadIdsFromAgentList(boolean addEvents) {
        Iterator iter = this.agentsList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
            if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
            this.loadThreadIdsFromAgent(trcAgentProxy);
            if (!addEvents) continue;
            this.addEvents(trcAgentProxy);
        }
    }

    private void loadThreadIdsFromAgent(TRCAgentProxy agentProxy) {
        EList events = agentProxy.getAgent().getDefaultEvents();
        CBECommonBaseEvent artifact = null;
        String threadID = null;
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            artifact = (CBECommonBaseEvent)iter.next();
            threadID = artifact.getSourceComponentId().getThreadId();
            if (threadID == null) {
                threadID = "-1";
            }
            this.threadIDs.add(agentProxy.getName() + " - " + "TID:" + threadID);
        }
    }

    protected void generateLifelines() {
        String id = null;
        Iterator iter = this.getLifelineArtifactsList().iterator();
        while (iter.hasNext()) {
            id = (String)iter.next();
            LogInteractions.TraceLifeline lifeLine = new LogInteractions.TraceLifeline();
            lifeLine.setName(id);
            lifeLine.setCategory(0);
            this.frame.addLifeLine(lifeLine);
            this.lifelinesMap.put(id, lifeLine);
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent element) {
        String threadID = element.getSourceComponentId().getThreadId();
        if (threadID == null) {
            threadID = "-1";
        }
        return element.getAgent().getAgentProxy().getName() + " - " + "TID:" + threadID;
    }

    public String getTitleString() {
        String title = SDLogcPlugin.getString("STR_VIEW_TITLE") + ": " + SDLogcPlugin.getString("STR_MENU_LOT");
        if (this.correlationContainerProxy != null) {
            title = title + " <" + this.correlationContainerProxy.getCorrelationEngine().getName() + "> ";
        }
        return title;
    }

    protected List getLifelineArtifactsList() {
        return this.threadIDs;
    }

    protected void clearDiagramCaches() {
        this.threadIDs.clear();
        super.clearDiagramCaches();
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOT") + ":      " + this.getFrameName();
    }

    protected void loadEventsSQL() {
        this.loadThreadIDsSQL();
        super.loadEventsSQL();
    }

    private void loadThreadIDsSQL() {
        ArrayList<TRCAgent> aList = new ArrayList<TRCAgent>();
        for (int i = 0; i < this.agentsList.size(); ++i) {
            aList.add(((TRCAgentProxy)this.agentsList.get(i)).getAgent());
        }
        SimpleSearchQuery threadsQuery = (SimpleSearchQuery)LogQueryBuilder.createQuery((List)this.agentsList, (ILogFilterCriteria)this.getFilterCriteria(), (EAttribute)CBEPackage.eINSTANCE.getCBEComponentIdentification_ThreadId());
        threadsQuery.getOrderByExpresions().clear();
        SimpleBinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createSimpleBinaryExpression();
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
        binaryExpression.setOperand(leftOperand);
        binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
        binaryExpression.setRightOperand((Object)HierarchyPackage.eINSTANCE.getAbstractDefaultEvent_Agent());
        threadsQuery.getWhereExpressions().add((Object)binaryExpression);
        binaryExpression = ExtensionsFactory.eINSTANCE.createSimpleBinaryExpression();
        leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
        binaryExpression.setOperand(leftOperand);
        binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
        binaryExpression.setRightOperand((Object)CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        threadsQuery.getWhereExpressions().add((Object)binaryExpression);
        binaryExpression = ExtensionsFactory.eINSTANCE.createSimpleBinaryExpression();
        leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(CBEPackage.eINSTANCE.getCBEComponentIdentification());
        binaryExpression.setOperand(leftOperand);
        binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
        binaryExpression.setRightOperand((Object)CBEPackage.eINSTANCE.getCBECommonBaseEvent_SourceComponentId());
        threadsQuery.getWhereExpressions().add((Object)binaryExpression);
        threadsQuery.setDistinct(true);
        QueryResult queryResult = LogQueryBuilder.executeQuery((Query)threadsQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
        if (queryResult != null) {
            ResultEntry resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
            EList agents = resultEntry.getObjects();
            resultEntry = (ResultEntry)queryResult.getResultEntries().get(1);
            EList threads = resultEntry.getObjects();
            if (agents != null && agents.size() > 0) {
                int s = agents.size();
                String threadId = null;
                TRCAgent agent = null;
                for (int i = 0; i < s; ++i) {
                    agent = (TRCAgent)agents.get(i);
                    threadId = (String)threads.get(i);
                    if (agent == null) continue;
                    if (threadId == null) {
                        threadId = "-1";
                    }
                    this.threadIDs.add(agent.getAgentProxy().getName() + " - " + "TID:" + threadId);
                }
            }
        }
    }

    static {
        traceCategories = new LifelineCategories[1];
        LogThreadInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName("");
        image = SDLogcPluginImages.getImage("thread_obj.gif");
        traceCategories[0].setImage(image);
    }
}

