/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.util;

import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;

public class GraphNodeSelectionDialog
extends Dialog
implements ISelectionChangedListener {
    private int type;
    private List graphNodeList;
    private Table eventsTable;
    private TableViewer fTableViewer;
    private CBECommonBaseEvent selection;
    public static final int SOURCE_EVENTS = 0;
    public static final int TARGET_EVENTS = 1;

    public GraphNodeSelectionDialog(Shell shell, int type) {
        super(shell);
        this.type = type;
    }

    public void setInput(List input) {
        this.graphNodeList = input;
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Label lblMessage = new Label(parent, 0);
        lblMessage.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.getShell().setText(SDLogcPlugin.getString("STR_SELECT_DIALOG_TITLE"));
        String message = "";
        if (this.type == 0) {
            message = SDLogcPlugin.getString("STR_SELECT_SOURCE_EVENT");
        } else if (this.type == 1) {
            message = SDLogcPlugin.getString("STR_SELECT_TARGET_EVENT");
        }
        lblMessage.setText(message);
        this.eventsTable = new Table(parent, 68354);
        GridData tblData = GridUtil.createFill();
        tblData.heightHint = 75;
        tblData.widthHint = 350;
        this.eventsTable.setLayoutData((Object)tblData);
        TableColumn tc = new TableColumn(this.eventsTable, 0);
        tc = new TableColumn(this.eventsTable, 0);
        ColumnWeightData c0Layout = new ColumnWeightData(150, true);
        ColumnWeightData c1Layout = new ColumnWeightData(200, true);
        TableLayout tblLayout = new TableLayout();
        tblLayout.addColumnData((ColumnLayoutData)c0Layout);
        tblLayout.addColumnData((ColumnLayoutData)c1Layout);
        this.eventsTable.setLayout((Layout)tblLayout);
        this.eventsTable.setHeaderVisible(true);
        this.eventsTable.setLinesVisible(true);
        this.fTableViewer = new TableViewer(this.eventsTable);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTableViewer.setInput((Object)this.graphNodeList);
        WorkbenchHelp.setHelp((Control)this.eventsTable, (String)ContextIds.EVENT_SELECTION_DIALOG);
        return super.createContents(parent);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.selection = sel.size() > 0 ? (CBECommonBaseEvent)sel.getFirstElement() : null;
    }

    public EObject getSelection() {
        return this.selection;
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return CBEUtils.formatCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)element), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat());
            }
            if (columnIndex == 1) {
                if (((CBECommonBaseEvent)element).getMsg() == null) {
                    return "";
                }
                return ((CBECommonBaseEvent)element).getMsg();
            }
            return "";
        }

        public void dispose() {
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return GraphNodeSelectionDialog.this.graphNodeList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

