/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class ClassQuery
extends QueryStatement {
    protected ClassMetadata metadata;
    protected int[] ids;
    protected boolean getAllObjects;
    protected boolean includeContainment;

    public ClassQuery(DatabaseType dbType, EClass eClass, ClassMetadata metadata, int[] ids, DBMap map, boolean getAllObjects, boolean includeContainment) {
        super(dbType, map, (EModelElement)eClass);
        this.metadata = metadata;
        this.ids = ids;
        this.getAllObjects = getAllObjects;
        this.includeContainment = includeContainment;
    }

    protected void createSelectFrom() {
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.getIdColumnName()));
        this.statement.append(", ");
        this.statement.append(this.addQuotes("Is_EMF_Proxy"));
        List attributeColumns = this.metadata.getClassTableColumns();
        int l = attributeColumns.size();
        for (int i = 0; i < l; ++i) {
            Column column = (Column)attributeColumns.get(i);
            this.statement.append(", ");
            this.statement.append(this.addQuotes(column.getName()));
        }
        if (this.getAllObjects) {
            List columns = this.metadata.getReferenceClassTableColumns();
            int l2 = columns.size();
            for (int i = 0; i < l2; ++i) {
                Column column = (Column)columns.get(i);
                EReference reference = this.dbMap.getReference(column);
                if (reference != null && reference.isContainment() && !this.includeContainment) {
                    if (!reference.isMany()) continue;
                    ++i;
                    continue;
                }
                this.statement.append(", ");
                this.statement.append(this.addQuotes(column.getName()));
            }
        }
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
    }

    protected String getIdColumnName() {
        return this.metadata.getPrimaryKey().getName();
    }

    protected void createWhereClause(int begin) {
        this.statement.append(" WHERE ");
        this.statement.append(this.addQuotes(this.getIdColumnName()));
        this.statement.append(" IN (");
        for (int i = begin; i < this.ids.length; ++i) {
            String id = "" + this.ids[i];
            if (this.statement.length() + id.length() > this.dbType.getMaximumSQLLength()) {
                this.initial = i;
                break;
            }
            if (i != begin) {
                this.statement.append(", ");
            }
            this.statement.append(this.ids[i]);
        }
        this.statement.append(")");
    }
}

