/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.DeleteStatement;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;

public class DeleteObjects
extends DBCommand {
    protected DatabaseType type;
    protected EReference reference;
    protected List classesAndIds;
    protected Map classesToIds;
    protected Map classesToMetadata;

    public DeleteObjects(JDBCHelper helper, DBMap map, List classesAndIds) {
        super(helper, map);
        this.type = helper.getDatabaseType();
        this.classesAndIds = classesAndIds;
    }

    public Object execute() throws Exception {
        try {
            PerfUtil p = new PerfUtil("DeleteObjects.execute()", true);
            this.computeObjectsToDelete();
            this.deleteObjects();
            p.stopAndPrintStatus();
            this.helper.commitTransaction();
        }
        catch (Exception e) {
            this.helper.rollbackTransaction();
            throw e;
        }
        return null;
    }

    protected void computeObjectsToDelete() throws Exception {
        HashMap classesToIds = new HashMap();
        int l = this.classesAndIds.size();
        for (int i = 0; i < l; i += 2) {
            EClass eClass = (EClass)this.classesAndIds.get(i);
            List ids = (List)this.classesAndIds.get(i + 1);
            this.addToMap(eClass, ids);
            this.computeObjectsToDelete(eClass, ids);
        }
    }

    protected void addToMap(EClass eClass, List ids) {
        ArrayList classIds;
        if (ids.isEmpty()) {
            return;
        }
        if (this.classesToIds == null) {
            this.classesToIds = new HashMap();
        }
        if ((classIds = (ArrayList)this.classesToIds.get(eClass)) == null) {
            classIds = new ArrayList();
            this.classesToIds.put(eClass, classIds);
        }
        classIds.addAll(ids);
    }

    protected void computeObjectsToDelete(EClass eClass, List ids) throws Exception {
        if (ids.isEmpty()) {
            return;
        }
        ClassMetadata metadata = this.getMetadata(eClass);
        EReference[] containments = metadata.getContainmentReferences();
        int[] sourceIds = this.getArray(ids);
        int l = containments.length;
        for (int i = 0; i < l; ++i) {
            EReference reference = containments[i];
            DBCommand getIds = DBCommandFactory.INSTANCE.createGetIdsOfReferencedObjects(this.helper, this.dbMap, this.type, sourceIds, reference, false);
            List containedIds = (List)getIds.execute();
            EClass referenceType = reference.getEReferenceType();
            this.addToMap(referenceType, containedIds);
            this.computeObjectsToDelete(referenceType, containedIds);
        }
    }

    protected ClassMetadata getMetadata(EClass eClass) {
        ClassMetadata metadata;
        if (this.classesToMetadata == null) {
            this.classesToMetadata = new HashMap();
        }
        if ((metadata = (ClassMetadata)this.classesToMetadata.get(eClass)) == null) {
            metadata = new ClassMetadata(eClass, this.dbMap, new RDBHelper());
            this.classesToMetadata.put(eClass, metadata);
        }
        return metadata;
    }

    protected int[] getArray(List integers) {
        int[] ints = new int[integers.size()];
        int l = integers.size();
        for (int i = 0; i < l; ++i) {
            ints[i] = (Integer)integers.get(i);
        }
        return ints;
    }

    protected void deleteObjects() throws Exception {
        Iterator entries = this.classesToIds.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            EClass eClass = (EClass)entry.getKey();
            List ids = (List)entry.getValue();
            this.deleteObjectsFromClassTables(eClass, ids);
        }
    }

    protected void deleteObjectsFromClassTables(EClass eClass, List ids) throws Exception {
        this.deleteObjectsFromClassTable(eClass, ids);
        ClassMetadata metadata = this.getMetadata(eClass);
        EClass[] superClasses = metadata.getAllSuperclasses();
        for (int i = 0; i < superClasses.length; ++i) {
            this.deleteObjectsFromClassTable(superClasses[i], ids);
        }
        EClass[] subClasses = metadata.getAllSubclasses();
        for (int i = 0; i < subClasses.length; ++i) {
            this.deleteObjectsFromClassTable(subClasses[i], ids);
        }
    }

    protected void deleteObjectsFromClassTable(EClass eClass, List ids) throws Exception {
        SQLStatement delete = StatementFactory.INSTANCE.createDeleteStatement(this.dbType, this.dbMap, eClass, ids, this.type);
        String statement = delete.getStatement();
        String[] statements = statement == null ? ((DeleteStatement)delete).getStatements() : new String[]{statement};
        for (int i = 0; i < statements.length; ++i) {
            if (debug) {
                System.out.println(statements[i]);
            }
            this.helper.executeUpdateStatement(statements[i]);
        }
    }
}

