/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.NoResourceTableException;
import org.eclipse.hyades.resources.database.internal.ResourceNotFoundException;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;

public class GetTopLevelObjects
extends DBCommand {
    protected URI uri;
    protected Map classesToIds;

    public GetTopLevelObjects(JDBCHelper helper, DBMap map, URI uri) {
        super(helper, map);
        this.uri = uri;
    }

    public Object execute() throws Exception {
        Table resourceTable = this.dbMap.getResourceTable();
        if (resourceTable == null) {
            throw new NoResourceTableException();
        }
        String query = this.createResourceTableQuery(resourceTable);
        this.executeResourceTableQuery(query);
        return this.createTopLevelList();
    }

    protected String createResourceTableQuery(Table resourceTable) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append(this.addQuotes("Table_Name"));
        query.append(", ");
        query.append(this.addQuotes("Id"));
        query.append(" FROM ");
        query.append(this.addQuotes(resourceTable.getName()));
        query.append(" WHERE ");
        query.append(this.addQuotes("URI"));
        query.append(" = '");
        query.append(this.uri.toString());
        query.append("'");
        return query.toString();
    }

    protected void executeResourceTableQuery(String query) throws Exception {
        Statement statement = this.helper.createStatement();
        ResultSet rs = this.helper.executeQuery(statement, query);
        this.classesToIds = new HashMap();
        while (rs.next()) {
            String table = rs.getString(1);
            String id = rs.getString(2);
            this.addToClassesToIds(table, id);
        }
        rs.close();
        statement.close();
        if (this.classesToIds.isEmpty()) {
            throw new ResourceNotFoundException(this.uri);
        }
    }

    protected void addToClassesToIds(String tableName, String id) throws Exception {
        Table table = this.getTable(tableName);
        EClass eClass = this.dbMap.getClass(table);
        ArrayList<Integer> ids = (ArrayList<Integer>)this.classesToIds.get(eClass);
        if (ids == null) {
            ids = new ArrayList<Integer>();
            this.classesToIds.put(eClass, ids);
        }
        ids.add(new Integer(Integer.parseInt(id)));
    }

    protected Table getTable(String name) {
        List tables = this.dbMap.getClassTables();
        int l = tables.size();
        for (int i = 0; i < l; ++i) {
            Table table = (Table)tables.get(i);
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    protected List createTopLevelList() {
        ArrayList<Object> topLevel = new ArrayList<Object>();
        Iterator entries = this.classesToIds.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            topLevel.add(entry.getKey());
            topLevel.add(entry.getValue());
        }
        return topLevel;
    }
}

