/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.hyades.resources.database.internal.TypeMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelFactory;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.StringType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;

public class RDBHelper {
    protected static final int COLUMN_NAME_LENGTH = 30;
    protected static final String PRIMARY_KEY_TYPE = "PRIMARYKEY";
    protected static final String FOREIGN_KEY_TYPE = "FOREIGNKEY";
    protected static final String INDEX_TYPE = "INDEX";
    protected static final char[] vowels = new char[]{'a', 'e', 'i', 'o', 'u'};
    protected DbmodelFactory dbFactory;

    public Table createTable(Database database, String name) {
        Table table = this.getFactory().createTable();
        table.setName(name);
        database.getTables().add((Object)table);
        return table;
    }

    protected DbmodelFactory getFactory() {
        if (this.dbFactory == null) {
            this.dbFactory = DbmodelFactory.eINSTANCE;
        }
        return this.dbFactory;
    }

    public Column addColumnToTable(Table table, String name) {
        Column column = this.getFactory().createColumn();
        column.setName(this.getLegalColumnName(name));
        column.setAllowNull(true);
        table.getColumns().add((Object)column);
        return column;
    }

    protected String getLegalColumnName(String name) {
        if (name.equals("iD")) {
            name = "emf_" + name;
        }
        if (name.length() <= 30) {
            return name;
        }
        int excess = name.length() - 30;
        StringBuffer newName = new StringBuffer(name);
        int index = newName.length() - 1;
        while (newName.length() > 30 && index > 0) {
            char c = newName.charAt(index);
            if (this.isVowel(c)) {
                newName.delete(index, index + 1);
                continue;
            }
            --index;
        }
        return newName.toString();
    }

    protected boolean isVowel(char c) {
        for (int i = 0; i < vowels.length; ++i) {
            if (c != vowels[i]) continue;
            return true;
        }
        return false;
    }

    public void setColumnType(Column column, String typeName, TypeMap typeMap) {
        int sqlType = typeMap.getSQLType(typeName);
        if (sqlType == -999) {
            sqlType = 12;
        }
        this.setColumnTypeToSQLType(column, sqlType, typeMap);
    }

    protected void setColumnTypeToSQLType(Column column, int sqlType, TypeMap typeMap) {
        switch (sqlType) {
            case 4: {
                SQLType type1 = this.dbFactory.createSQLType();
                type1.setSqlType(4);
                column.setType(type1);
                break;
            }
            case 5: {
                SQLType type2 = this.dbFactory.createSQLType();
                type2.setSqlType(5);
                column.setType(type2);
                break;
            }
            case -5: {
                SQLType type3 = this.dbFactory.createSQLType();
                type3.setSqlType(-5);
                column.setType(type3);
                break;
            }
            case 1: {
                StringType type4 = this.dbFactory.createStringType();
                type4.setLength(1);
                type4.setSqlType(1);
                column.setType(type4);
                break;
            }
            case 8: {
                SQLType type5 = this.dbFactory.createSQLType();
                type5.setSqlType(8);
                column.setType(type5);
                break;
            }
            case -1: {
                StringType type7 = this.dbFactory.createStringType();
                type7.setSqlType(-1);
                column.setType(type7);
                break;
            }
            default: {
                StringType type6 = this.dbFactory.createStringType();
                type6.setLength(typeMap.getVarCharLength());
                type6.setSqlType(12);
                column.setType(type6);
            }
        }
    }

    public void setColumnType(Column column, EAttribute attribute, TypeMap typeMap) {
        Object type = typeMap.getSQLType(attribute);
        if (type == null) {
            this.setColumnType(column, attribute.getEType().getName(), typeMap);
        } else if (type instanceof Integer) {
            this.setColumnTypeToSQLType(column, (Integer)type, typeMap);
        } else if (type instanceof StringType) {
            column.setType((StringType)type);
        }
    }

    public void addPrimaryKeyToTable(Table table, Column primaryKey, String name) {
        Constraint constraint = this.addConstraintToTable(table, name);
        primaryKey.getConstraints().add((Object)constraint);
    }

    protected Constraint addConstraintToTable(Table table, String name) {
        Constraint constraint = this.getFactory().createConstraint();
        constraint.setName(name);
        constraint.setType(PRIMARY_KEY_TYPE);
        table.getConstraints().add((Object)constraint);
        return constraint;
    }

    public Constraint addIndexToTable(Table table, String name) {
        Constraint constraint = this.getFactory().createConstraint();
        constraint.setName(name);
        constraint.setType(INDEX_TYPE);
        table.getConstraints().add((Object)constraint);
        return constraint;
    }

    public Column getPrimaryKey(Table table) {
        EList columns = table.getColumns();
        int l = columns.size();
        for (int i = 0; i < l; ++i) {
            Column column = (Column)columns.get(i);
            EList constraints = column.getConstraints();
            if (constraints.isEmpty()) continue;
            int l2 = constraints.size();
            for (int j = 0; j < l2; ++j) {
                Constraint constraint = (Constraint)constraints.get(j);
                if (!constraint.getType().equals(PRIMARY_KEY_TYPE)) continue;
                return column;
            }
        }
        return null;
    }

    public Column getColumnByName(Table table, String columnName) {
        EList columns = table.getColumns();
        int l = columns.size();
        for (int i = 0; i < l; ++i) {
            Column column = (Column)columns.get(i);
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public Constraint getPrimaryKeyConstraint(Table table) {
        EList constraints = table.getConstraints();
        int l = constraints.size();
        for (int i = 0; i < l; ++i) {
            Constraint constraint = (Constraint)constraints.get(i);
            if (!constraint.getType().equals(PRIMARY_KEY_TYPE)) continue;
            return constraint;
        }
        return null;
    }
}

