/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.InternalDatabase;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class UpdateCommand
extends DBCommand {
    protected InternalDatabase database;
    protected List updates;
    protected List delayed;
    protected Set addedObjects;
    protected WeakObjectCache cache;

    public UpdateCommand(InternalDatabase database, List updates, WeakObjectCache cache) {
        super(database.getJDBCHelper(), database.getDBMap());
        this.database = database;
        this.updates = updates;
        this.cache = cache;
        this.delayed = new ArrayList();
    }

    public Object execute() throws Exception {
        if (this.updates == null || this.updates.isEmpty()) {
            return null;
        }
        try {
            PerfUtil p = new PerfUtil("UpdateCommand.execute() 1", true);
            this.addObjects();
            p.stopAndPrintStatus();
            p.setMessageAndStart("UpdateCommand.execute() 2");
            this.setReferences();
            p.stopAndPrintStatus();
            p.setMessageAndStart("UpdateCommand.execute() 3");
            this.setAttributes();
            p.stopAndPrintStatus();
            this.updates.clear();
            this.updates.addAll(this.delayed);
            this.helper.commitTransaction();
        }
        catch (Exception e) {
            this.helper.rollbackTransaction();
            throw e;
        }
        return null;
    }

    protected void addObjects() throws Exception {
        this.addedObjects = new HashSet();
        PerfUtil p = new PerfUtil("UpdateCommand.addObjects() 1 size=" + this.updates.size(), true);
        int l = this.updates.size();
        for (int i = 0; i < l; ++i) {
            Notification notification = (Notification)this.updates.get(i);
            if (!this.addObject(notification)) continue;
            EObject addedObject = (EObject)notification.getNewValue();
            Integer id = null;
            if (this.cache != null && !this.addedObjects.contains(addedObject)) {
                id = this.cache.getId(addedObject);
            }
            if (id != null) continue;
            this.addedObjects.add(addedObject);
        }
        p.stopAndPrintStatus();
        if (!this.addedObjects.isEmpty()) {
            p.setMessageAndStart("UpdateCommand.addObjects() 2 size=" + this.updates.size());
            this.database.add(new ArrayList(this.addedObjects));
            p.stopAndPrintStatus();
        }
    }

    protected boolean addObject(Notification notification) {
        if (notification.getEventType() != 3) {
            return false;
        }
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (!(feature instanceof EReference)) {
            return false;
        }
        return ((EReference)feature).isContainment();
    }

    protected void setReferences() throws Exception {
        this.setReferencesFromAddedObjects();
        this.setReferencesFromUpdates();
    }

    protected void setReferencesFromAddedObjects() throws Exception {
        PerfUtil p = new PerfUtil("UpdateCommand.setReferencesFromAddedObjects 1 addedObjects.size=" + this.addedObjects.size(), true);
        Iterator i = this.addedObjects.iterator();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            List setReferences = this.getSetReferences(object);
            this.setReferencesIfNeeded(object, setReferences);
        }
        p.stopAndPrintStatus();
    }

    protected List getSetReferences(EObject object) {
        ArrayList<EReference> setReferences = new ArrayList<EReference>();
        EList allReferences = object.eClass().getEAllReferences();
        int l = allReferences.size();
        for (int i = 0; i < l; ++i) {
            EReference reference = (EReference)allReferences.get(i);
            if (reference.isContainment() || reference.isContainer() || !object.eIsSet((EStructuralFeature)reference)) continue;
            setReferences.add(reference);
        }
        return setReferences;
    }

    protected void setReferencesIfNeeded(EObject object, List references) throws Exception {
        int l = references.size();
        for (int i = 0; i < l; ++i) {
            EReference reference = (EReference)references.get(i);
            if (reference.isMany()) {
                this.setManyValuedReference(object, reference);
                continue;
            }
            this.setSingleValuedReference(object, reference);
        }
    }

    protected void setManyValuedReference(EObject object, EReference reference) throws Exception {
        Integer sourceId = this.getObjectId(object);
        if (sourceId == null) {
            return;
        }
        List values = (List)object.eGet((EStructuralFeature)reference, false);
        ArrayList<Integer> targets = new ArrayList<Integer>();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        PerfUtil p = new PerfUtil("UpdateCommand.setManyValuedReference() 1 size=" + values.size(), true);
        int l2 = values.size();
        for (int j = 0; j < l2; ++j) {
            EObject value = (EObject)values.get(j);
            if (this.addedObjects.contains(value)) continue;
            if (this.usePreparedStatement) {
                Integer targetId = this.getObjectId(value);
                if (targetId == null) continue;
                targets.add(targetId);
                indexes.add(new Integer(j));
                continue;
            }
            this.database.setReference(object, reference, value, j);
        }
        p.stopAndPrintStatus();
        if (this.usePreparedStatement && indexes.size() > 0) {
            p.setMessageAndStart("UpdateCommand.setManyValuedReference() 2 size=" + indexes.size());
            this.database.setReference(sourceId, reference, targets, indexes);
            p.stopAndPrintStatus();
        }
    }

    protected void setSingleValuedReference(EObject object, EReference reference) throws Exception {
        EObject value = (EObject)object.eGet((EStructuralFeature)reference, false);
        if (!this.addedObjects.contains(value)) {
            PerfUtil p = new PerfUtil("UpdateCommand.setSingleValuedReference()", true);
            this.database.setReference(object, reference, value, -1);
            p.stopAndPrintStatus();
        }
    }

    protected Integer getObjectId(EObject object) throws Exception {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getId(object);
    }

    protected void setReferencesFromUpdates() throws Exception {
        HashMap objToReferences = new HashMap();
        PerfUtil p = new PerfUtil("UpdateCommand.setReferencesFromUpdates() 1 size=" + this.updates.size(), true);
        int l = this.updates.size();
        for (int i = 0; i < l; ++i) {
            List[] targetInfos;
            Notification notification = (Notification)this.updates.get(i);
            if (!(notification.getFeature() instanceof EReference) || notification.getEventType() != 3 && notification.getEventType() != 1) continue;
            EObject source = (EObject)notification.getNotifier();
            EReference reference = (EReference)notification.getFeature();
            EObject target = (EObject)notification.getNewValue();
            int position = notification.getPosition();
            if (!this.usePreparedStatement) {
                boolean set = this.database.setReference(source, reference, target, position);
                if (set) continue;
                this.delayed.add(notification);
                continue;
            }
            Integer sourceId = this.getObjectId(source);
            Integer targetId = this.getObjectId(target);
            if (sourceId == null || targetId == null) {
                this.delayed.add(notification);
                continue;
            }
            HashMap<EReference, List[]> referenceToValues = (HashMap<EReference, List[]>)objToReferences.get(sourceId);
            if (referenceToValues == null) {
                referenceToValues = new HashMap<EReference, List[]>();
                objToReferences.put(sourceId, referenceToValues);
            }
            if ((targetInfos = (List[])referenceToValues.get(reference)) == null) {
                targetInfos = new List[]{new ArrayList(), new ArrayList()};
                referenceToValues.put(reference, targetInfos);
            }
            if (targetInfos[0].contains(targetId)) continue;
            targetInfos[0].add(targetId);
            targetInfos[1].add(new Integer(position));
        }
        p.stopAndPrintStatus();
        if (this.usePreparedStatement && !objToReferences.isEmpty()) {
            p.setMessageAndStart("UpdateCommand.setReferencesFromUpdates() 2 size=" + objToReferences.size());
            try {
                Iterator iter = objToReferences.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Integer sourceId = (Integer)entry.getKey();
                    Iterator iterator = ((Map)entry.getValue()).entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry refs = iterator.next();
                        EReference reference = (EReference)refs.getKey();
                        List targets = ((List[])refs.getValue())[0];
                        List positions = ((List[])refs.getValue())[1];
                        this.database.setReference(sourceId, reference, targets, positions);
                    }
                }
            }
            catch (Exception e) {
                p.stopAndPrintStatus(e.getLocalizedMessage());
                throw e;
            }
            p.stopAndPrintStatus();
        }
    }

    protected void setAttributes() throws Exception {
        int l = this.updates.size();
        for (int i = 0; i < l; ++i) {
            Notification notification = (Notification)this.updates.get(i);
            if (notification.getFeature() == null || !(notification.getFeature() instanceof EAttribute)) continue;
            EObject owner = (EObject)notification.getNotifier();
            EAttribute attribute = (EAttribute)notification.getFeature();
            this.database.set(owner, attribute);
        }
    }
}

