/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class DatapoolClipboard {
    private static final String SEPERATOR = "\t";
    private static final String LINEFEED = "\n";
    private static final String CARRIAGERETURN = "\r";
    private static final String CRLF = "\r\n";
    private Vector recordData = new Vector();
    private Vector recordStringData = new Vector();
    private Object cellData = null;
    private Object cellStringData = null;
    private Clipboard clipboard = null;
    private static final DatapoolClipboard instance = new DatapoolClipboard();

    public static DatapoolClipboard getInstance() {
        return instance;
    }

    protected DatapoolClipboard() {
    }

    public void addRecordData(IDatapoolRecord record) {
        if (record == null) {
            return;
        }
        int cellCount = record.getCellCount();
        Object[] valueContent = new Object[cellCount];
        String[] stringContent = new String[cellCount];
        for (int i = 0; i < cellCount; ++i) {
            String cellValue;
            IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
            valueContent[i] = cell.getClonedCellValue();
            stringContent[i] = cellValue = cell.getPersistedRepresentation();
        }
        this.recordData.add(valueContent);
        this.recordStringData.add(stringContent);
        this.clearCellData();
    }

    public void addCellData(IDatapoolCell cell) {
        this.cellData = cell.getClonedCellValue();
        this.cellStringData = cell.getPersistedRepresentation();
        this.clearRecordData();
    }

    public Object getCellData() {
        if (this.cellData == null) {
            return null;
        }
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)this.clipboard.getContents((Transfer)transfer);
        if (data.equals(this.cellStringData)) {
            return this.cellData;
        }
        return data;
    }

    public Object[] getRecordDataSet() {
        if (this.recordData.size() == 0) {
            return null;
        }
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)this.clipboard.getContents((Transfer)transfer);
        StringTokenizer dataTokenizer = new StringTokenizer(data, LINEFEED);
        int count = 0;
        boolean isDatapoolData = true;
        while (dataTokenizer.hasMoreTokens()) {
            Object[] messageElements;
            String line = dataTokenizer.nextToken();
            if (line.endsWith(CARRIAGERETURN)) {
                line = line.replaceAll(CARRIAGERETURN, new String());
            }
            if (!(line = MessageFormat.format("{0}{1}", messageElements = new Object[]{line, LINEFEED})).equals(this.constructClipboardData()[count])) {
                isDatapoolData = false;
                break;
            }
            ++count;
        }
        if (isDatapoolData) {
            return this.recordData.toArray();
        }
        Vector<String[]> dataSet = new Vector<String[]>();
        StringTokenizer lfTokenizer = new StringTokenizer(data, LINEFEED);
        while (lfTokenizer.hasMoreTokens()) {
            String line = lfTokenizer.nextToken();
            if (line.endsWith(CARRIAGERETURN)) {
                line = line.replaceAll(CARRIAGERETURN, new String());
            }
            int index = line.indexOf(SEPERATOR);
            int numTokens = 1;
            while (index != -1) {
                ++numTokens;
                index = line.indexOf(SEPERATOR, index + 1);
            }
            String[] cellContents = new String[numTokens];
            count = 0;
            index = line.indexOf(SEPERATOR);
            while (index != -1) {
                cellContents[count] = line.substring(0, index);
                line = line.substring(index + 1);
                index = line.indexOf(SEPERATOR);
                ++count;
            }
            cellContents[count] = line;
            dataSet.add(cellContents);
        }
        return dataSet.toArray();
    }

    public void update() {
        TextTransfer transfer = TextTransfer.getInstance();
        if (this.recordStringData.size() > 0) {
            int recordCount = this.recordStringData.size();
            Transfer[] transfers = new Transfer[recordCount];
            Object[] data = this.constructClipboardData();
            for (int i = 0; i < recordCount; ++i) {
                transfers[i] = transfer;
            }
            this.clipboard.setContents(data, transfers);
        } else {
            Object[] data = new Object[]{this.cellStringData};
            Transfer[] transfers = new Transfer[]{transfer};
            this.clipboard.setContents(data, transfers);
        }
    }

    public boolean isEmpty() {
        String data;
        if (this.recordData != null && !this.recordData.isEmpty()) {
            return false;
        }
        if (this.cellData != null) {
            return false;
        }
        TextTransfer transfer = TextTransfer.getInstance();
        return this.clipboard == null || transfer == null || this.clipboard.isDisposed() || (data = (String)this.clipboard.getContents((Transfer)transfer)) == null;
    }

    public void clear() {
        this.clearRecordData();
        this.clearCellData();
    }

    private void clearRecordData() {
        this.recordData.clear();
        this.recordStringData.clear();
    }

    private void clearCellData() {
        this.cellData = null;
        this.cellStringData = null;
    }

    public void setClipboard(Clipboard clipboard) {
        if (this.clipboard == null || this.clipboard.isDisposed()) {
            this.clipboard = clipboard;
        }
    }

    private String[] constructClipboardData() {
        if (this.recordStringData.size() > 0) {
            int recordCount = this.recordStringData.size();
            String[] data = new String[recordCount];
            for (int i = 0; i < recordCount; ++i) {
                Object[] rawRecordData = (Object[])this.recordStringData.get(i);
                String processedRecordData = new String();
                for (int j = 0; j < rawRecordData.length; ++j) {
                    if (j == 0) {
                        processedRecordData = (String)rawRecordData[j];
                        continue;
                    }
                    Object[] messageElements = new Object[]{processedRecordData, SEPERATOR, (String)rawRecordData[j]};
                    processedRecordData = MessageFormat.format("{0}{1}{2}", messageElements);
                }
                Object[] messageElements = new Object[]{processedRecordData, LINEFEED};
                data[i] = processedRecordData = MessageFormat.format("{0}{1}", messageElements);
            }
            return data;
        }
        String[] data = new String[]{new String()};
        return data;
    }
}

