/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DatapoolRowGroupDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final int HEIGHT = 80;
    private static final int WIDTH = 300;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private IDatapoolEquivalenceClass selectedEquivalenceClass = null;
    private IDatapoolEquivalenceClass previousEquivalenceClass = null;
    private Text nameField = null;
    private Color nameFieldForeground = null;
    private Combo equivalenceClassCombo = null;
    private Label errorLabel = null;
    private String name = null;
    private int insertionIndex = -1;
    private int defaultNameCounter = 1;

    public DatapoolRowGroupDialog(Shell parentShell, IDatapool datapool, Table table, IDatapoolEquivalenceClass selectedEquivalenceClassItem, IDatapoolEquivalenceClass previousEquivalenceClassItem, String title) {
        super(parentShell);
        this.shell = parentShell;
        this.datapool = datapool;
        this.title = title;
        this.table = table;
        this.previousEquivalenceClass = previousEquivalenceClassItem;
        this.selectedEquivalenceClass = selectedEquivalenceClassItem;
        if (title.equals(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        superComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        superComposite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(superComposite, 0);
        nameLabel.setText(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_NAME"));
        this.nameField = new Text(superComposite, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        if (this.selectedEquivalenceClass != null) {
            this.name = this.selectedEquivalenceClass.getName();
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        }
        Label equivalenceClassComboLabel = new Label(superComposite, 0);
        if (this.insertionMode) {
            equivalenceClassComboLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_INS"));
            this.name = this.createDefaultName();
            while (!DatapoolUtil.getInstance().isEquivalenceClassNameUnique(this.datapool, this.name, null)) {
                this.name = this.createDefaultName();
            }
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        } else {
            equivalenceClassComboLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_MOVE"));
        }
        this.equivalenceClassCombo = new Combo(superComposite, 12);
        IDatapoolEquivalenceClass[] equivalenceClasses = null;
        equivalenceClasses = DatapoolUtil.getInstance().getEquivalenceClasses(this.datapool, null);
        String[] equivalenceClassLabels = this.getEquivalenceClassLabels(equivalenceClasses);
        this.equivalenceClassCombo.setItems(equivalenceClassLabels);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)equivalenceClasses);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 250;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener((SelectionListener)this);
        if (this.previousEquivalenceClass != null) {
            int previousEquivalenceClassIndex = this.datapool.getEquivalenceClassIndex(this.previousEquivalenceClass.getName());
            if (previousEquivalenceClassIndex != -1) {
                this.equivalenceClassCombo.select(previousEquivalenceClassIndex + 1);
                this.insertionIndex = previousEquivalenceClassIndex;
            }
        } else {
            this.equivalenceClassCombo.select(0);
            this.insertionIndex = -1;
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(superComposite, 0);
        this.errorLabel.setLayoutData((Object)gridData);
        superComposite.pack();
        return superComposite;
    }

    private boolean enableOK() {
        boolean enableButton = true;
        String nameErrorText = new String();
        Display display = Display.getDefault();
        Color color = display.getSystemColor(3);
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            this.getButton(0).setEnabled(false);
            return false;
        }
        if (name != null && name.length() > 0) {
            boolean isNameUnique = DatapoolUtil.getInstance().isEquivalenceClassNameUnique(this.datapool, name, this.selectedEquivalenceClass);
            boolean isNameValid = DatapoolUtil.getInstance().isEquivalenceClassNameValid(name);
            if (isNameUnique && isNameValid) {
                this.nameField.setForeground(this.nameFieldForeground);
            } else {
                this.nameField.setForeground(color);
                if (!isNameUnique) {
                    nameErrorText = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_UNIQUE");
                } else if (!isNameValid) {
                    nameErrorText = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_VALID");
                }
                enableButton = false;
            }
        }
        if (enableButton) {
            this.getButton(0).setEnabled(true);
            this.errorLabel.setText(new String());
            return true;
        }
        String errorText = DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR") + nameErrorText;
        this.errorLabel.setText(errorText);
        this.errorLabel.setForeground(color);
        this.getButton(0).setEnabled(false);
        return false;
    }

    private String[] getEquivalenceClassLabels(IDatapoolEquivalenceClass[] equivalenceClasses) {
        int listSize = 0;
        if (equivalenceClasses != null) {
            listSize = equivalenceClasses.length;
        }
        if (equivalenceClasses.length == 1 && equivalenceClasses[0].getRecordCount() == 0) {
            listSize = 0;
        }
        String[] returnList = new String[listSize + 1];
        String insertFormat = DatapoolPlugin.getResourceString("DATA_DLG_INSERT_VARIABLE_FORMAT");
        for (int i = 0; i < listSize; ++i) {
            Object[] messageElements;
            IDatapoolEquivalenceClass equivalenceClass = equivalenceClasses[i];
            String name = equivalenceClass.getName();
            if (i == 0) {
                messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_BEFORE"), name};
                returnList[i] = MessageFormat.format(insertFormat, messageElements);
            }
            messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_AFTER"), name};
            returnList[i + 1] = MessageFormat.format(insertFormat, messageElements);
        }
        if (listSize == 0) {
            returnList[0] = DatapoolPlugin.getResourceString("DATA_DLG_FIRST_ELEMENT");
        }
        return returnList;
    }

    private String[] getRecordIndexLabels(IDatapoolEquivalenceClass equivalenceClass) {
        if (equivalenceClass == null) {
            return null;
        }
        int listSize = equivalenceClass.getRecordCount();
        String[] returnList = new String[listSize];
        for (int i = 0; i < listSize; ++i) {
            returnList[i] = String.valueOf(i);
        }
        return returnList;
    }

    private int findEquivalenceClassIndexInCombo(IDatapoolEquivalenceClass[] equivalenceClasses, IDatapoolEquivalenceClass equivalenceClass) {
        if (equivalenceClasses == null || equivalenceClass == null) {
            return -1;
        }
        for (int i = 0; i < equivalenceClasses.length; ++i) {
            if (!equivalenceClasses[i].equals(equivalenceClass)) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public void widgetSelected(SelectionEvent e) {
        IDatapoolEquivalenceClass equivalenceClass = null;
        Combo combo = (Combo)e.widget;
        if (combo.getSelectionIndex() != 0) {
            int selectionIndex = combo.getSelectionIndex();
            IDatapoolEquivalenceClass[] equivalenceClasses = (IDatapoolEquivalenceClass[])combo.getData(TAG_EQUIVALENCE_CLASSES);
            equivalenceClass = equivalenceClasses[selectionIndex - 1];
            this.insertionIndex = this.datapool.getEquivalenceClassIndex(equivalenceClass.getName());
        } else {
            this.insertionIndex = -1;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        this.enableOK();
    }

    private String createDefaultName() {
        Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_EC_NAME"), NumberFormat.getInstance().format(this.defaultNameCounter)};
        ++this.defaultNameCounter;
        return MessageFormat.format("{0}{1}", messageElements);
    }
}

