/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SDViewerPlugin
extends AbstractUIPlugin {
    public static final String LOADER_TAG = "uml2SDLoader";
    private static SDViewerPlugin plugin;
    private ResourceBundle resourceBundle;
    private static URL BASIC_URL;

    public SDViewerPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = descriptor.getResourceBundle();
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        this.createLastLoaderIfAny();
    }

    public final void createLastLoaderIfAny() {
        IPluginDescriptor descriptor = SDViewerPlugin.getDefault().getDescriptor();
        IExtensionPoint iep = descriptor.getExtensionPoint(LOADER_TAG);
        IExtension[] ie = iep.getExtensions();
        Preferences p = this.getPluginPreferences();
        String lastLoader = p.getString(LOADER_TAG);
        if (ie == null || lastLoader == null || lastLoader.length() == 0) {
            return;
        }
        for (int i = 0; i < ie.length; ++i) {
            IExtension e = ie[i];
            IConfigurationElement[] c = e.getConfigurationElements();
            for (int j = 0; j < c.length; ++j) {
                String attr_class;
                if (!c[j].getName().equals(LOADER_TAG) || !lastLoader.equals(attr_class = c[j].getAttribute("class"))) continue;
                try {
                    Object obj = c[j].createExecutableExtension("class");
                    IUml2SDLoader l = (IUml2SDLoader)obj;
                    LoadersManager.getLoadersManager().setCurrentLoader(l);
                }
                catch (CoreException e4) {
                    System.err.println("Error 'uml2SDLoader' Extension point :" + (Object)((Object)e4));
                }
                catch (Exception e5) {
                    System.err.println("Error 'uml2SDLoader' Extension point :" + e5);
                }
                return;
            }
        }
    }

    public void setLastLoader(String id) {
        Preferences p = this.getPluginPreferences();
        p.setValue(LOADER_TAG, id);
    }

    public void shutdown() throws CoreException {
        BackgroundLoader.shutdown();
        super.shutdown();
    }

    public static SDViewerPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SDViewerPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static ImageDescriptor getResourceImage(String _name) {
        try {
            URL url = new URL(BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/" + _name);
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)url);
            return img;
        }
        catch (Exception E) {
            System.err.println(E);
            return null;
        }
    }

    public static String getId() {
        return SDViewerPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static boolean debugIndex() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/updateindex").equalsIgnoreCase("true");
    }

    public static boolean debugDisplay() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/display").equalsIgnoreCase("true");
    }

    public static boolean debugDoubleBuffer() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/doublebuffer").equalsIgnoreCase("true");
    }

    public static boolean debugSorting() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/sorting").equalsIgnoreCase("true");
    }

    public static boolean debug() {
        return Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/debug") != null && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/debug").equalsIgnoreCase("true");
    }

    static {
        BASIC_URL = null;
        try {
            BASIC_URL = new URL("platform", "localhost", "plugin");
        }
        catch (Exception E) {
            System.err.println(E);
        }
    }
}

