/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.adapter.ResourceSetFileAdaptable;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.ui.adapter.HyadesWorkbenchAdapter;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestWorkbenchAdapter
extends HyadesWorkbenchAdapter {
    public static final String TEST_SUITE_LOGICAL_FOLDER_NAME = TestUIPlugin.getString("LOG_FLD_TST_SUITES_NME");
    public static final String DEPLOYMENT_LOGICAL_FOLDER_NAME = TestUIPlugin.getString("LOG_FLD_DEPLOYS_NME");
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;
    static /* synthetic */ Class class$org$eclipse$hyades$models$common$common$CMNNamedElement;

    private static LogicalFolder createTestSuitesFolder() {
        LogicalFolder logicalFolder = new LogicalFolder(TEST_SUITE_LOGICAL_FOLDER_NAME){

            protected List createChildren() {
                return new UniqueEList();
            }
        };
        logicalFolder.setDescription(TestUIPlugin.getString("LOG_FLD_TST_SUITES_DSC"));
        return logicalFolder;
    }

    private static LogicalFolder createDeploymentsFolder() {
        LogicalFolder logicalFolder = new LogicalFolder(DEPLOYMENT_LOGICAL_FOLDER_NAME){

            protected List createChildren() {
                return new UniqueEList();
            }
        };
        logicalFolder.setDescription(TestUIPlugin.getString("LOG_FLD_DEPLOYS_DSC"));
        return logicalFolder;
    }

    protected TestNavigator findTestNavigator() {
        if (PlatformUI.getWorkbench() != null) {
            return TestNavigator.getTestNavigator(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        return null;
    }

    public String getDescription(Object object) {
        if (object instanceof Resource) {
            return "";
        }
        return super.getDescription(object);
    }

    public String getLabel(Object object) {
        if (object instanceof Resource) {
            IFile file = EMFUtil.getWorkspaceFile((Resource)object);
            if (file != null) {
                return ((IWorkbenchAdapter)file.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestWorkbenchAdapter.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)).getLabel((Object)file);
            }
            return "";
        }
        if (object instanceof TPFExecutionEvent) {
            if (object instanceof TPFTypedEvent) {
                TPFTypedEvent typedEvent = (TPFTypedEvent)object;
                if (typedEvent.getType() == null) {
                    return TestUIPlugin.getString("W_EVT_TYPED");
                }
                return typedEvent.getType().getLabel();
            }
            if (object instanceof TPFMessageEvent) {
                return TestUIPlugin.getString("W_EVT_MSG");
            }
            if (object instanceof TPFVerdictEvent) {
                TPFVerdictEvent verdictEvent = (TPFVerdictEvent)object;
                if (verdictEvent.getVerdict() == null) {
                    return TestUIPlugin.getString("W_EVT_VER");
                }
                return verdictEvent.getVerdict().getLabel();
            }
            if (object instanceof TPFInvocationEvent) {
                return TestUIPlugin.getString("W_EVT_INV");
            }
            if (object instanceof TPFLoopEvent) {
                TPFLoopEvent loopEvent = null;
                BVRInteractionFragment interactionFragment = null;
                loopEvent = (TPFLoopEvent)object;
                interactionFragment = loopEvent.getInteractionFragment();
                if (interactionFragment != null && interactionFragment.getName() != null && interactionFragment.getName().length() > 0) {
                    return interactionFragment.getName();
                }
                return TestUIPlugin.getString("W_EVT_LOOP");
            }
            return TestUIPlugin.getString("W_EVT_EXEC");
        }
        if (object instanceof TPFExecutionResult && ((TPFExecutionResult)object).getName() == null) {
            return TestUIPlugin.getString("W_TST_EXE");
        }
        return super.getLabel(object);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof Resource) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }
        if (object instanceof EObject) {
            if (object instanceof TPFTestSuite) {
                IAssociationMapping mapping;
                IAssociationDescriptor descriptor;
                ImageDescriptor imageDescriptor = null;
                TPFTestSuite testSuite = (TPFTestSuite)object;
                String type = testSuite.getType();
                if (type != null && (descriptor = (mapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions")).getDefaultAssociationDescriptor(type)) != null) {
                    imageDescriptor = descriptor.getImageDescriptor();
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                return imageDescriptor;
            }
            if (object instanceof TPFTestCase) {
                ImageDescriptor imageDescriptor = null;
                TPFTestCase testCase = (TPFTestCase)object;
                String type = testCase.getType();
                if (type != null) {
                    IAssociationMapping mapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("typeDescriptions");
                    IAssociationDescriptor descriptor = mapping.getDefaultAssociationDescriptor(type);
                    if (descriptor != null) {
                        imageDescriptor = descriptor.getImageDescriptor();
                    }
                    if (imageDescriptor == null && (descriptor = (mapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards")).getDefaultAssociationDescriptor(type)) != null) {
                        imageDescriptor = descriptor.getImageDescriptor();
                    }
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                return imageDescriptor;
            }
            if (object instanceof TPFExecutionResult) {
                return TestUIImages.INSTANCE.getImageDescriptor("execution_obj.gif");
            }
            if (object instanceof TPFExecutionEvent) {
                if (object instanceof TPFTypedEvent) {
                    TPFExecutionType exeType = null;
                    exeType = ((TPFTypedEvent)object).getType();
                    if (exeType != null) {
                        if (exeType.getValue() == 0) {
                            return TestUIImages.INSTANCE.getImageDescriptor("evetypedstart_obj.gif");
                        }
                        if (exeType.getValue() == 1) {
                            return TestUIImages.INSTANCE.getImageDescriptor("evetypedstop_obj.gif");
                        }
                    }
                    return TestUIImages.INSTANCE.getImageDescriptor("evetyped_obj.gif");
                }
                if (object instanceof TPFLoopEvent) {
                    return TestUIImages.INSTANCE.getImageDescriptor("eveloop_obj.gif");
                }
                if (object instanceof TPFMessageEvent) {
                    return TestUIImages.INSTANCE.getImageDescriptor("evemessage_obj.gif");
                }
                if (object instanceof TPFVerdictEvent) {
                    TPFVerdict verdict = null;
                    verdict = ((TPFVerdictEvent)object).getVerdict();
                    if (verdict != null) {
                        if (verdict.getValue() == 1) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveverdictpass_obj.gif");
                        }
                        if (verdict.getValue() == 2) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveverdictfail_obj.gif");
                        }
                        if (verdict.getValue() == 0) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveverdictinc_obj.gif");
                        }
                        if (verdict.getValue() == 3) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveverdicterror_obj.gif");
                        }
                    }
                    return TestUIImages.INSTANCE.getImageDescriptor("eveverdictpass_obj.gif");
                }
                if (object instanceof TPFInvocationEvent) {
                    TPFExecutionResult exeResult = null;
                    TPFExecutionHistory exeHistory = null;
                    EList eventList = null;
                    exeResult = ((TPFInvocationEvent)object).getInvokedExecutionResult();
                    if (exeResult != null) {
                        exeHistory = exeResult.getExecutionHistory();
                    }
                    if (exeHistory != null) {
                        eventList = exeHistory.getExecutionEvents();
                    }
                    if (eventList != null & !eventList.isEmpty()) {
                        TPFVerdict curVerdict = null;
                        int rollupVerdict = 1;
                        int i = 0;
                        boolean bRollupVerFound = false;
                        Object curObject = null;
                        for (i = eventList.size() - 1; i >= 0 && !bRollupVerFound; --i) {
                            curObject = eventList.get(i);
                            if (!(curObject instanceof EObject) || !(curObject instanceof TPFVerdictEvent)) continue;
                            curVerdict = ((TPFVerdictEvent)curObject).getVerdict();
                            if (curVerdict.getValue() != 1) {
                                rollupVerdict = curVerdict.getValue();
                            }
                            bRollupVerFound = true;
                        }
                        if (rollupVerdict == 1) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveinvocationpass_obj.gif");
                        }
                        if (rollupVerdict == 2) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveinvocationfail_obj.gif");
                        }
                        if (rollupVerdict == 3) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveinvocationerror_obj.gif");
                        }
                        if (rollupVerdict == 0) {
                            return TestUIImages.INSTANCE.getImageDescriptor("eveinvocationinc_obj.gif");
                        }
                    }
                    return TestUIImages.INSTANCE.getImageDescriptor("eveinvocation_obj.gif");
                }
                return TestUIImages.INSTANCE.getImageDescriptor("eveexecution_obj.gif");
            }
            if (object instanceof TPFTestComponent) {
                return TestUIImages.INSTANCE.getImageDescriptor("testcomponent_obj.gif");
            }
            if (object instanceof TPFBehavior) {
                return TestUIImages.INSTANCE.getImageDescriptor("behavior_obj.gif");
            }
            if (object instanceof TPFSUT) {
                return TestUIImages.INSTANCE.getImageDescriptor("sut_obj.gif");
            }
            if (object instanceof TPFDeployment) {
                return TestUIImages.INSTANCE.getImageDescriptor("deployment_obj.gif");
            }
            if (object instanceof DPLDatapool) {
                return TestUIImages.INSTANCE.getImageDescriptor("datapool_obj.gif");
            }
            if (object instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImageDescriptor("location_obj.gif");
            }
            if (object instanceof CFGArtifact) {
                return TestUIImages.INSTANCE.getImageDescriptor("artifact_obj.gif");
            }
            if (object instanceof CFGPropertyGroup) {
                return TestUIImages.INSTANCE.getImageDescriptor("propertyGroup_obj.gif");
            }
            if (object instanceof CFGComparableProperty) {
                return TestUIImages.INSTANCE.getImageDescriptor("property_obj.gif");
            }
        }
        return super.getImageDescriptor(object);
    }

    public Object getParent(Object object) {
        if (object instanceof EObject) {
            return this.getEObjectParent((EObject)object);
        }
        if (object instanceof IWorkspaceRoot) {
            return null;
        }
        return super.getParent(object);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof EObject) {
            TestNavigator testNavigator = this.findTestNavigator();
            if (testNavigator == null || !testNavigator.isShowingEObjectChildren()) {
                return false;
            }
            if (element instanceof TPFTestSuite) {
                return true;
            }
            return element instanceof TPFDeployment;
        }
        if (element instanceof IWorkspaceRoot) {
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof EObject) {
            return this.getEObjectChildren((EObject)object);
        }
        if (object instanceof IWorkspaceRoot) {
            return this.getWorkspaceRootChildren((IWorkspaceRoot)object);
        }
        return this.adjustChildren(super.getChildren(object));
    }

    protected Object[] adjustChildren(Object[] children) {
        TestNavigator testNavigator = this.findTestNavigator();
        if (testNavigator == null) {
            return children;
        }
        ArrayList<Object> validChildren = new ArrayList<Object>(children.length);
        int maxi = children.length;
        for (int i = 0; i < maxi; ++i) {
            if (children[i] instanceof IFile) {
                IFile file = (IFile)children[i];
                if (!TestUI.isSupportedFileExtension(file.getFileExtension())) continue;
                EObject[] eObjects = EMFUtil.load(null, file);
                int maxj = eObjects.length;
                for (int j = 0; j < maxj; ++j) {
                    if (!(eObjects[j] instanceof TPFTestSuite) && !(eObjects[j] instanceof TPFDeployment)) continue;
                    validChildren.add(eObjects[j]);
                }
                continue;
            }
            validChildren.add(children[i]);
        }
        return validChildren.toArray();
    }

    protected Object[] getWorkspaceRootChildren(IWorkspaceRoot root) {
        TestNavigator testNavigator = this.findTestNavigator();
        if (testNavigator == null) {
            return new Object[0];
        }
        if (testNavigator.isShowingFolders()) {
            return this.getProjects(root);
        }
        return this.getLogicalFolders(root);
    }

    protected IProject[] getProjects(IWorkspaceRoot root) {
        return root.getProjects();
    }

    protected LogicalFolder[] getLogicalFolders(IWorkspaceRoot root) {
        LogicalFolder[] logicalFolders;
        TestNavigator testNavigator = this.findTestNavigator();
        if (testNavigator == null) {
            return new LogicalFolder[0];
        }
        if (!EMFUtil.getResourceSet().getResources().isEmpty() && (logicalFolders = this.getLogicalFolders(testNavigator)).length != 0) {
            return logicalFolders;
        }
        ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

            public Object visit(IFile file) {
                return new ResourceSetFileAdaptable(EMFUtil.getResourceSet(), file);
            }
        };
        Map filesByExtensions = ResourceUtil.getFiles((IWorkspaceRoot)root, (String[])new String[]{"testsuite", "deploy"}, (ResourceUtil.IGetFilesVisitor)visitor);
        List testSuiteResources = (List)filesByExtensions.get("testsuite");
        List deploymentResources = (List)filesByExtensions.get("deploy");
        LogicalFolder[] logicalFolders2 = new LogicalFolder[2];
        logicalFolders2[0] = testNavigator.getRootLogicalFolder(TEST_SUITE_LOGICAL_FOLDER_NAME);
        if (logicalFolders2[0] == null) {
            logicalFolders2[0] = TestWorkbenchAdapter.createTestSuitesFolder();
            testNavigator.registerRootLogcalFolder(logicalFolders2[0]);
        } else if (!logicalFolders2[0].isLinked()) {
            logicalFolders2[0].getChildren().clear();
        }
        logicalFolders2[0].getChildren().addAll(ResourceUtil.getValidAdapters((List)testSuiteResources, (Class)(class$org$eclipse$hyades$models$common$common$CMNNamedElement == null ? (class$org$eclipse$hyades$models$common$common$CMNNamedElement = TestWorkbenchAdapter.class$("org.eclipse.hyades.models.common.common.CMNNamedElement")) : class$org$eclipse$hyades$models$common$common$CMNNamedElement)));
        logicalFolders2[1] = testNavigator.getRootLogicalFolder(DEPLOYMENT_LOGICAL_FOLDER_NAME);
        if (logicalFolders2[1] == null) {
            logicalFolders2[1] = TestWorkbenchAdapter.createDeploymentsFolder();
            testNavigator.registerRootLogcalFolder(logicalFolders2[1]);
        } else {
            logicalFolders2[1].getChildren().clear();
        }
        logicalFolders2[1].getChildren().addAll(ResourceUtil.getValidAdapters((List)deploymentResources, (Class)(class$org$eclipse$hyades$models$common$common$CMNNamedElement == null ? (class$org$eclipse$hyades$models$common$common$CMNNamedElement = TestWorkbenchAdapter.class$("org.eclipse.hyades.models.common.common.CMNNamedElement")) : class$org$eclipse$hyades$models$common$common$CMNNamedElement)));
        testSuiteResources.clear();
        deploymentResources.clear();
        filesByExtensions.clear();
        return logicalFolders2;
    }

    protected LogicalFolder[] getLogicalFolders(TestNavigator testNavigator) {
        LogicalFolder[] logicalFolders = new LogicalFolder[]{testNavigator.getRootLogicalFolder(TEST_SUITE_LOGICAL_FOLDER_NAME), testNavigator.getRootLogicalFolder(DEPLOYMENT_LOGICAL_FOLDER_NAME)};
        if (logicalFolders[0] == null || logicalFolders[1] == null) {
            return new LogicalFolder[0];
        }
        ResourceSet resourceSet = EMFUtil.getResourceSet();
        Iterator i = resourceSet.getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            logicalFolders[0].getChildren().addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite()));
            logicalFolders[1].getChildren().addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)Common_TestprofilePackage.eINSTANCE.getTPFDeployment()));
        }
        return logicalFolders;
    }

    protected Object getEObjectParent(EObject eObject) {
        if (eObject instanceof TPFTestCase) {
            TPFTestCase testCase = (TPFTestCase)eObject;
            TPFTestSuite testSuite = testCase.getTestSuite();
            if (testSuite == null) {
                return null;
            }
            return this.getEObjectChildren((EObject)testSuite)[0];
        }
        TestNavigator testNavigator = this.findTestNavigator();
        if (testNavigator != null && !testNavigator.isShowingFolders()) {
            if (eObject instanceof TPFTestSuite) {
                return testNavigator.getRootLogicalFolder(TEST_SUITE_LOGICAL_FOLDER_NAME);
            }
            if (eObject instanceof TPFDeployment) {
                return testNavigator.getRootLogicalFolder(DEPLOYMENT_LOGICAL_FOLDER_NAME);
            }
            return null;
        }
        IFile file = EMFUtil.getWorkspaceFile(eObject);
        if (file != null) {
            return file.getParent();
        }
        return null;
    }

    protected LogicalFolder[] getEObjectChildren(EObject eObject) {
        TestNavigator testNavigator = this.findTestNavigator();
        if (testNavigator == null || !testNavigator.isShowingEObjectChildren()) {
            return new LogicalFolder[0];
        }
        if (eObject instanceof TPFTestSuite) {
            TPFTestSuite testSuite = (TPFTestSuite)eObject;
            LogicalFolder[] logicalFolders = new LogicalFolder[3];
            logicalFolders[0] = new LogicalFolder((Object)eObject, TestUIPlugin.getString("LOG_FLD_TST_CASES_NME"));
            logicalFolders[0].setDescription(TestUIPlugin.getString("LOG_FLD_TST_CASES_DSC"));
            logicalFolders[0].linkChildren((List)testSuite.getTestCases());
            logicalFolders[1] = new LogicalFolder((Object)eObject, TestUIPlugin.getString("LOG_FLD_TST_COMP_NME"));
            logicalFolders[1].setDescription(TestUIPlugin.getString("LOG_FLD_TST_COMP_DSC"));
            logicalFolders[1].linkChildren((List)testSuite.getTestComponents());
            logicalFolders[2] = new LogicalFolder((Object)eObject, TestUIPlugin.getString("LOG_FLD_SUT_NME"));
            logicalFolders[2].setDescription(TestUIPlugin.getString("LOG_FLD_SUT_DSC"));
            logicalFolders[2].linkChildren((List)testSuite.getSUTs());
            return logicalFolders;
        }
        if (eObject instanceof TPFDeployment) {
            TPFDeployment deployment = (TPFDeployment)eObject;
            LogicalFolder[] logicalFolders = new LogicalFolder[2];
            logicalFolders[0] = new LogicalFolder((Object)eObject, TestUIPlugin.getString("LOG_FLD_LOCS_NME"));
            logicalFolders[0].setDescription(TestUIPlugin.getString("LOG_FLD_LOCS_DSC"));
            logicalFolders[0].linkChildren((List)deployment.getLocations());
            logicalFolders[1] = new LogicalFolder((Object)eObject, TestUIPlugin.getString("LOG_FLD_DEPLY_SPEC_NME"));
            logicalFolders[1].setDescription(TestUIPlugin.getString("LOG_FLD_DEPLY_SPEC_DSC"));
            logicalFolders[1].linkChildren((List)deployment.getPropertyGroups());
            return logicalFolders;
        }
        return new LogicalFolder[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

