/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ResourceSelectionDialog
extends Dialog
implements SelectionListener {
    private String fileExtension;
    private String title;
    private Button filterButton;
    private TreeViewer hostViewer;
    private HostsContentProvider contentProvider;
    private Image fileImage;
    private EObject[] selectedEObjects;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public ResourceSelectionDialog(Shell parentShell, String title, String fileExtension, Image fileImage) {
        super(parentShell);
        this.title = title;
        this.fileExtension = fileExtension;
        this.fileImage = fileImage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 250;
        composite.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite);
        this.hostViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.hostViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.hostViewer.expandToLevel(2);
        return composite;
    }

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 67586);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new HostsContentProvider();
        this.hostViewer = new TreeViewer(tree);
        this.hostViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new HostsLabelProvider(true, this.fileImage));
        this.contentProvider.setFilter(2);
        ViewerSorter sorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0) {
                    super.sort(viewer, elements);
                }
            }

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.hostViewer.setSorter(sorter);
        return this.hostViewer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection selection = this.hostViewer.getSelection();
            this.hostViewer.refresh();
            if (!selection.isEmpty()) {
                this.hostViewer.setSelection(selection, true);
            }
        }
        if (e.widget == this.hostViewer.getControl()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        ISelection selection = this.hostViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            Vector<EObject> objects = new Vector<EObject>();
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof EObject)) continue;
                objects.add((EObject)element);
            }
            this.selectedEObjects = new EObject[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                this.selectedEObjects[i] = (EObject)objects.get(i);
            }
        }
    }

    public EObject[] getSelectedObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }

    public IFile[] getSelectedFiles() {
        if (this.selectedEObjects == null) {
            return new IFile[0];
        }
        IFile[] selectedFiles = new IFile[this.selectedEObjects.length];
        for (int i = 0; i < this.selectedEObjects.length; ++i) {
            selectedFiles[i] = EMFUtil.getWorkspaceFile(this.selectedEObjects[i]);
        }
        return selectedFiles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HostsLabelProvider
    extends LabelProvider {
        private Hashtable ovelayCache;
        private boolean useImages;
        private Image image;

        public HostsLabelProvider(boolean useImages, Image image) {
            this.useImages = useImages;
            this.image = image;
            this.ovelayCache = new Hashtable();
        }

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            if (!this.useImages || element == null) {
                return null;
            }
            if (this.image != null) {
                return this.image;
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ResourceSelectionDialog.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                return adapter.getImageDescriptor(element).createImage();
            }
            return null;
        }

        public String getText(Object element) {
            IWorkbenchAdapter adapter;
            if (element == null) {
                return "";
            }
            String text = null;
            if (element instanceof EObject) {
                IFile file = EMFUtil.getWorkspaceFile((EObject)element);
                text = file.getName();
            } else if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ResourceSelectionDialog.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                text = adapter.getLabel(element);
            }
            if (text == null) {
                text = element.toString();
            }
            return text;
        }

        public void dispose() {
            if (this.ovelayCache != null) {
                Iterator i = this.ovelayCache.values().iterator();
                while (i.hasNext()) {
                    Image image = (Image)i.next();
                    image.dispose();
                }
                this.ovelayCache.clear();
            }
            super.dispose();
        }
    }

    private class HostsContentProvider
    implements ITreeContentProvider {
        public static final int FILTER_FOLDERS = 2;
        public static final int SHOW_ALL = 4;
        private int filter;
        private ArrayList list = new ArrayList();

        public int getFilter() {
            return this.filter;
        }

        public void setFilter(int filter) {
            this.filter = filter;
        }

        public void dispose() {
            this.list.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                switch (this.filter) {
                    case 4: {
                        IFile file = EMFUtil.getWorkspaceFile(eObject);
                        if (file == null) break;
                        return file.getParent();
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkspaceRoot) {
                if (this.getFilter() == 2) {
                    this.list.clear();
                    IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
                    for (int idx = 0; idx < projects.length; ++idx) {
                        Object[] children = this.getChildren(projects[idx]);
                        for (int i = 0; i < children.length; ++i) {
                            this.list.add(children[i]);
                        }
                    }
                    return this.list.toArray();
                }
                return ((IWorkspaceRoot)inputElement).getProjects();
            }
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContainer) {
                UniqueEList children = new UniqueEList();
                IResource[] resources = null;
                try {
                    resources = ((IContainer)parentElement).members();
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    return new Object[0];
                }
                int maxi = resources.length;
                for (int i = 0; i < maxi; ++i) {
                    if (resources[i].getType() != 1) {
                        if (this.filter == 2) {
                            Object[] tmpArray = this.getChildren(resources[i]);
                            for (int k = 0; k < tmpArray.length; ++k) {
                                children.add(tmpArray[k]);
                            }
                            continue;
                        }
                        children.add(resources[i]);
                        continue;
                    }
                    IFile file = (IFile)resources[i];
                    if (!file.getFileExtension().equals(ResourceSelectionDialog.this.fileExtension)) continue;
                    EObject[] eObjects = EMFUtil.load(null, (IFile)resources[i]);
                    for (int idx = 0; idx < eObjects.length; ++idx) {
                        EObject eObject = eObjects[idx];
                        children.add(eObject);
                    }
                }
                return children.toArray();
            }
            if (parentElement instanceof Resource) {
                return ((Resource)parentElement).getContents().toArray();
            }
            return new Object[0];
        }
    }
}

