/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.util.RCPFileEditorInput;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.editor.HyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;

public abstract class BaseEditorPart
extends HyadesEditorPart {
    private ResourceSet resourceSet;
    private Class editoObjectClass;

    public BaseEditorPart(Class editoObjectClass) {
        this.editoObjectClass = editoObjectClass;
    }

    public void dispose() {
        if (this.resourceSet != null) {
            EMFUtil.removeAdapters((Iterator)this.resourceSet.getAllContents());
            this.resourceSet.eAdapters().clear();
            Iterator iterator = this.getResourceSet().getResources().iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (!(resource instanceof FacadeResourceImpl)) continue;
                ((FacadeResourceImpl)resource).cleanup();
            }
            this.resourceSet.getResources().clear();
            this.resourceSet = null;
        }
        super.dispose();
    }

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected IAssociationDescriptor identifyEditorDescriptor(IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException(HyadesUIPlugin.getString((String)"_ERROR_EDT_INPUT"));
        }
        IAssociationDescriptor editorDescriptor = null;
        if (input instanceof IFileEditorInput) {
            EObject eObject = null;
            eObject = input instanceof RCPFileEditorInput ? this.getFileContent(((RCPFileEditorInput)input).getIOFile()) : this.getFileContent(((IFileEditorInput)input).getFile());
            if (eObject == null) {
                throw new PartInitException(HyadesUIPlugin.getString((String)"_ERROR_EDT_INPUT"));
            }
            this.setEditorObject(eObject);
            editorDescriptor = this.identifyEditorDescriptor(eObject);
        }
        return editorDescriptor;
    }

    protected abstract IAssociationDescriptor identifyEditorDescriptor(EObject var1);

    protected EObject getFileContent(IFile file) {
        this.resourceSet = new ResourceSetImpl();
        AdapterImpl adapterImpl = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                switch (msg.getEventType()) {
                    case 3: {
                        if (!(msg.getNewValue() instanceof Resource)) break;
                        ((Resource)msg.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)msg.getNewValue();
                        Iterator i = collection.iterator();
                        while (i.hasNext()) {
                            Object element = i.next();
                            if (!(element instanceof Resource)) continue;
                            ((Resource)element).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        this.resourceSet.eAdapters().add((Object)adapterImpl);
        EObject[] eObjects = EMFUtil.load(this.resourceSet, file);
        if (eObjects.length == 1 && this.editoObjectClass.isInstance(eObjects[0])) {
            return eObjects[0];
        }
        return null;
    }

    protected EObject getFileContent(File file) {
        this.resourceSet = new ResourceSetImpl();
        AdapterImpl adapterImpl = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                switch (msg.getEventType()) {
                    case 3: {
                        if (!(msg.getNewValue() instanceof Resource)) break;
                        ((Resource)msg.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)msg.getNewValue();
                        Iterator i = collection.iterator();
                        while (i.hasNext()) {
                            Object element = i.next();
                            if (!(element instanceof Resource)) continue;
                            ((Resource)element).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        this.resourceSet.eAdapters().add((Object)adapterImpl);
        EObject[] eObjects = EMFUtil.load(this.resourceSet, URI.createFileURI((String)file.getAbsolutePath()));
        if (eObjects.length == 1 && this.editoObjectClass.isInstance(eObjects[0])) {
            return eObjects[0];
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        if (!(selection = this.adjustSelection(selection)).isEmpty()) {
            super.setSelection(selection);
        }
    }

    public ISelection adjustSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int maxi = objects.length;
            for (int i = 0; i < maxi; ++i) {
                EObject adjusted = null;
                if (objects[i] instanceof EObject) {
                    adjusted = EMFUtil.getEObject(this.getResourceSet(), (EObject)objects[i], false);
                } else if (objects[i] instanceof Resource) {
                    adjusted = this.getResourceSet().getResource(((Resource)objects[i]).getURI(), false);
                }
                if (adjusted == null) {
                    return StructuredSelection.EMPTY;
                }
                objects[i] = adjusted;
            }
            selection = new StructuredSelection(objects);
        }
        return selection;
    }
}

