/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

public class CommonEventSection
extends EditorSection
implements IHyperlinkListener {
    private StyledText timeText;
    private SelectableFormLabel modelElementLink;
    private StyledText messageText;
    private TPFExecutionEvent executionEvent;

    public CommonEventSection(EditorForm editorForm) {
        super(editorForm);
        this.setCollapsable(true);
    }

    public void dispose() {
        this.executionEvent = null;
        super.dispose();
    }

    protected TPFExecutionEvent getExecutionEvent() {
        return this.executionEvent;
    }

    public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        this.modelElementLink = widgetFactory.createSelectableLabel(composite, "");
        this.modelElementLink.setText(TestUIPlugin.getString("NO_INTF_TO_INV"));
        this.modelElementLink.setToolTipText(TestUIPlugin.getString("TIP_EXE_ELEM"));
        widgetFactory.turnIntoHyperlink((Control)this.modelElementLink, this);
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_TIME"));
        this.timeText = widgetFactory.createStyledText(composite, 65540);
        this.timeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.timeText.setEditable(false);
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_TEXT"));
        this.messageText = widgetFactory.createStyledText(composite, 66114);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.heightHint = 4 * this.messageText.getLineHeight();
        this.messageText.setLayoutData((Object)gridData);
        this.messageText.setEditable(false);
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.executionEvent = null;
        this.timeText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.messageText.removeVerifyKeyListener((VerifyKeyListener)this);
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof TPFExecutionEvent) {
            BVRInteractionFragment interactionFragment;
            this.executionEvent = (TPFExecutionEvent)object;
            this.timeText.setText(EventUtil.getTime(this.getExecutionEvent().getTimestamp()));
            String value = this.getExecutionEvent().getText();
            if (value != null) {
                this.messageText.setText(value);
            } else {
                this.messageText.setText("");
            }
            TPFTest test = null;
            if (this.executionEvent.getExecutionHistory() != null && this.executionEvent.getExecutionHistory().getExecutionResult() != null) {
                test = this.executionEvent.getExecutionHistory().getExecutionResult().getTest();
            }
            if ((interactionFragment = this.executionEvent.getInteractionFragment()) != null) {
                if (interactionFragment.getName() != null) {
                    this.modelElementLink.setText(interactionFragment.getName());
                } else {
                    this.modelElementLink.setText(TestUIPlugin.getString("W_ELEMENT"));
                }
                this.modelElementLink.setData(interactionFragment);
            } else if (test != null) {
                if (test.getName() != null) {
                    this.modelElementLink.setText(test.getName());
                } else {
                    this.modelElementLink.setText(TestUIPlugin.getString("W_TEST"));
                }
                this.modelElementLink.setData(test);
            } else {
                this.modelElementLink.setText(TestUIPlugin.getString("NO_INTF_TO_INV"));
                this.modelElementLink.setData(null);
            }
        } else {
            this.timeText.setText("");
            this.messageText.setText("");
            this.modelElementLink.setText(TestUIPlugin.getString("NO_INTF_TO_INV"));
            this.timeText.setEditable(false);
            this.messageText.setEditable(false);
        }
        this.modelElementLink.pack(true);
        this.modelElementLink.redraw();
        this.timeText.addVerifyKeyListener((VerifyKeyListener)this);
        this.messageText.addVerifyKeyListener((VerifyKeyListener)this);
    }

    public Object getInput() {
        return this.getExecutionEvent();
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getExecutionEvent() == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.getExecutionEvent());
    }

    public void selectReveal(ISelection selection) {
    }

    public void linkActivated(Control linkLabel) {
        EObject eObject;
        IFile file;
        Object data = linkLabel.getData();
        if (data != null && (file = EMFUtil.getWorkspaceFile(eObject = (EObject)data)) != null) {
            IEditorPart editorPart = UIUtil.openEditor((IFile)file, null, (boolean)false);
            if (editorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(TestUIPlugin.getString("_ERROR_MSG_UN_OPEN_OBJ"));
        }
    }

    public void linkEntered(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(((SelectableFormLabel)linkLabel).getText());
        }
    }

    public void linkExited(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }
}

