/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.remote.PeekServerSocket;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderFileSelectPage;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderNoProjectsPage;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderRegistryInfo;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class HttpRecorderLaunchWizard
extends RecorderWizard {
    private HttpRecorderFileSelectPage fileSelectPage;
    private HttpRecorderNoProjectsPage newProjectPage;
    private boolean hasNoProjects = false;
    static /* synthetic */ Class class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage;

    protected boolean verifyRecorderData() {
        if (this.hasNoProjects) {
            return true;
        }
        String string = this.fileSelectPage.getSelectedFilePath();
        int n = string.lastIndexOf(".rec");
        if (n == -1) {
            n = string.length();
        }
        String string2 = string.substring(0, string.lastIndexOf(".rec")) + ".testsuite";
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
        boolean bl = iFile.exists();
        boolean bl2 = false;
        if (!TestgenPlugin.getPreference((String)"default_test_generator").equals("-1")) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
            bl2 = iFile.exists();
        }
        if (bl && bl2) {
            return MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.BOTH_EXIST"));
        }
        if (bl) {
            return MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.REC_EXISTS"));
        }
        if (bl2) {
            return MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.TESTSUITE_EXISTS"));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (RecorderFactory.getInstance().getActiveRecorder() != null) {
            RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_ERROR"));
            return;
        }
        Recorder recorder = null;
        try {
            String string;
            File file;
            RecorderRegistryInfo recorderRegistryInfo = null;
            recorder = HttpRecorderPlugin.getDefault().getRecorder();
            int n = 0;
            String string2 = HttpRecorderPlugin.getPreference("default_proxy_port");
            n = this.findAvailableClientPort(string2);
            String string3 = "port," + n;
            String string4 = HttpRecorderPlugin.getPreference("application_under_test");
            if (!string4.equalsIgnoreCase("-1")) {
                recorderRegistryInfo = new RecorderRegistryInfo();
                this.handleInvalidProxySettings(recorderRegistryInfo);
                string3 = recorderRegistryInfo.isProxyEnabled() ? string3 + ";proxyInfo," + recorderRegistryInfo.getProxyType() + "=" + recorderRegistryInfo.getProxyAddr() + ":" + recorderRegistryInfo.getProxyPort() : string3 + ";proxyInfo,socks";
            } else {
                string3 = string3 + ";proxyInfo,socks";
            }
            URL uRL = Platform.resolve((URL)new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
            String string5 = uRL.toString();
            if (uRL.getProtocol().equals("file")) {
                string5 = uRL.getFile();
            }
            if ((file = new File(string5)).exists()) {
                string3 = string3 + ";sslkeyfile," + file.getAbsolutePath();
            }
            String string6 = string3 + ";startupURL," + this.getStartupURL();
            recorder.setApplicationAdapterID(string4);
            if (recorderRegistryInfo != null && recorderRegistryInfo.isSSLProxyEnabled()) {
                string3 = string3 + ";sslProxyInfo," + "https=" + recorderRegistryInfo.getSslProxyAddr() + ":" + recorderRegistryInfo.getSslProxyPort();
            }
            if (!string4.equalsIgnoreCase("-1")) {
                RecorderAppAdapterFactory.getInstance().getClient(HttpRecorderPlugin.getPreference("application_under_test")).setInitString(string6);
            }
            if (this.hasNoProjects) {
                IProject iProject = this.newProjectPage.createJavaProject(this.monitor);
                if (iProject == null) throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.JAVA_PROJECT_NOT_CREATED_ERROR"));
                string = iProject.getFullPath().toString() + "/" + this.newProjectPage.getRecFile();
            } else {
                string = this.fileSelectPage.getSelectedFilePath();
            }
            String string7 = string.substring(0, string.lastIndexOf(46)) + ".testsuite";
            HttpRecorderPlugin.storePreference("recording_path", string);
            recorder.setConfigParams(string3);
            recorder.setRecordingPath(string);
            recorder.setScriptgenID(TestgenPlugin.getPreference((String)"default_test_generator"));
            recorder.setTestPath(string7);
            recorder.Record();
            return;
        }
        catch (Exception exception) {
            if (recorder != null) {
                recorder.setActive(false);
            }
            exception.printStackTrace();
            RecorderControlView.getInstance().addMessage(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE") + exception.getMessage());
        }
    }

    private void handleInvalidProxySettings(RecorderRegistryInfo recorderRegistryInfo) throws RecorderException {
        if (recorderRegistryInfo.isBadProxySettings()) {
            int n = recorderRegistryInfo.getProxyError();
            recorderRegistryInfo.getClass();
            if (n == -1) {
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"));
            }
            recorderRegistryInfo.getClass();
            if (n == -2) {
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"));
            }
            recorderRegistryInfo.getClass();
            if (n == -3) {
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"));
            }
            recorderRegistryInfo.getClass();
            if (n == -4) {
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"));
            }
            recorderRegistryInfo.getClass();
            if (n == -5) {
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"));
            }
            recorderRegistryInfo.getClass();
            if (n == -7) {
                String string = HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE") + "\n ";
                string = string + HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)string, (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_AUTO_CONFIG_MESSAGE"));
            }
            recorderRegistryInfo.getClass();
            if (n == -6) {
                String string = HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE") + "\n ";
                string = string + HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_SUPPORTED_CONFIG_MESSAGE");
                RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)string, (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));
                throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_PROXY_OVERRIDE_MESSAGE"));
            }
        }
    }

    public void addPages() {
        this.setWindowTitle(HttpRecorderPlugin.getResourceString("NAME"));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        boolean bl = false;
        for (int i = 0; !bl && i < iProjectArray.length; ++i) {
            if (!iProjectArray[i].isOpen()) continue;
            bl = true;
        }
        if (!bl) {
            this.hasNoProjects = true;
            this.newProjectPage = new HttpRecorderNoProjectsPage((class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage == null ? (class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage = HttpRecorderLaunchWizard.class$("org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderNoProjectsPage")) : class$org$eclipse$hyades$execution$recorder$http$ui$wizards$HttpRecorderNoProjectsPage).getName());
            this.addPage((IWizardPage)this.newProjectPage);
            this.newProjectPage.setInitialProjectName(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.DEFAULT_PROJECT_NAME"));
        } else {
            this.fileSelectPage = new HttpRecorderFileSelectPage();
            this.addPage((IWizardPage)this.fileSelectPage);
        }
    }

    protected String getStartupURL() throws IOException {
        String string;
        File file;
        String string2 = "readme";
        String string3 = ".html";
        URL uRL = Platform.resolve((URL)HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL());
        String string4 = null;
        if (uRL.getProtocol().equals("file")) {
            string4 = uRL.getFile() + string2;
        }
        if (!((file = new File(string = string4 + "_" + Locale.getDefault().toString() + string3)).exists() || (file = new File(string = string4 + "_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + string3)).exists() || (file = new File(string = string4 + "_" + Locale.getDefault().getLanguage() + string3)).exists() || (file = new File(string = string4 + string3)).exists())) {
            return "about:blank";
        }
        return "file://" + string;
    }

    int findAvailableClientPort(String string) {
        int n = 0;
        int n2 = 0;
        Integer n3 = Integer.decode(string);
        n2 = n = n3.intValue();
        PeekServerSocket peekServerSocket = null;
        try {
            peekServerSocket = new PeekServerSocket(n2);
            peekServerSocket.close();
        }
        catch (IOException iOException) {
            try {
                peekServerSocket = new PeekServerSocket(0);
                n2 = peekServerSocket.getLocalPort();
                peekServerSocket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        if (n2 != n) {
            String string2 = String.valueOf(n2);
            Object[] objectArray = new String[]{string, string2};
            String string3 = HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_CHANGE_PORT_MESSAGE");
            RecorderControlView.getInstance().addMessage(MessageFormat.format(string3, objectArray));
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

