/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.launch.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.launch.HttpTestLaunchConfigurationFacade;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LoadTestUserTab
extends AbstractLaunchConfigurationTab {
    private String title = TestHttpPlugin.getString("LoadTestUserTab.Title");
    private Text _numUsers = null;
    private Listener modifyListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget == LoadTestUserTab.this._numUsers) {
                LoadTestUserTab.this.updateLaunchConfigurationDialog();
            }
        }
    };

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 25;
        gridLayout.verticalSpacing = 25;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(TestHttpPlugin.getString("LoadTestUserTab.Users"));
        this._numUsers = new Text(composite2, 2048);
        this._numUsers.addListener(24, this.modifyListener);
        this._numUsers.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite2);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        HttpTestLaunchConfigurationFacade.setNumberOfUsers(iLaunchConfigurationWorkingCopy, 1);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            int n = HttpTestLaunchConfigurationFacade.getNumberOfUsers(iLaunchConfiguration);
            String string = n == -1 ? "" : Integer.toString(n);
            if (this._numUsers != null) {
                this._numUsers.removeListener(24, this.modifyListener);
                this._numUsers.setText(string);
                this._numUsers.addListener(24, this.modifyListener);
            }
        }
        catch (CoreException coreException) {
            TestHttpPlugin.logError(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        HttpTestLaunchConfigurationFacade.setNumberOfUsers(iLaunchConfigurationWorkingCopy, this.get_nUsers());
    }

    public String getName() {
        return this.title;
    }

    public int get_nUsers() {
        try {
            int n = Integer.parseInt(this._numUsers.getText());
            if (n > 0) {
                return n;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void set_nUsers(int n) {
    }

    public Image getImage() {
        return TestHttpImages.INSTANCE.getImage("request.gif");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        if (this.get_nUsers() < 1) {
            this.setErrorMessage(TestHttpPlugin.getString("LoadTestUserTab.InvalidUsers"));
            return false;
        }
        return true;
    }
}

