/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.io.File;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.sample.HyadesSamplePlugin;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class LogAnalyzerSamplePage
extends CreationWizardPage
implements Listener {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean useDefaults = true;
    private boolean useDBDefaults = true;
    private boolean useErrorLogDefaults = true;
    private boolean analyzeLog = true;
    private boolean correlateLog = true;
    protected Text logfileFieldText;
    protected Text symptomDBFieldText;
    protected Text errorLogFieldText;
    protected String initialLogFileValue;
    protected String initialSymptomDBValue;
    protected String initialErrorLogValue;
    private Label symptomDBLocationLabel;
    private Label errorLogLocationLabel;
    private Label logfileLocationLabel;
    private Button browseButton;
    private Button symptomDBBrowseButton;
    private Button errorLogBrowseButton;
    private LogAnalyzerCreationPage firstPage;
    private Button analyzeLogButton;
    private Button correlateLogButton;
    private static final String APACHE_DEFAULT_LOG_FILE = "access.log";
    private static final String APACHE_DEFAULT_ERROR_LOG_FILE = "error.log";
    private static final String APACHE_DEFAULT_SYMPTOMDB_FILE = "symptomdb.trcdbxmi";
    private String customLocationFieldValue = "";
    private String customSymptomDBLocationFieldValue = "";
    private String customErrorLogLocationFieldValue = "";
    private Text sdbFileNameText;
    private Label importSDBFileLabel;
    private Listener logfileModifyListener = new Listener(){

        public void handleEvent(Event e) {
            LogAnalyzerSamplePage.this.setPageComplete(LogAnalyzerSamplePage.this.validatePage());
        }
    };
    private Listener errorLogModifyListener = new Listener(){

        public void handleEvent(Event e) {
            LogAnalyzerSamplePage.this.setPageComplete(LogAnalyzerSamplePage.this.validatePage());
        }
    };
    private Listener symptomDBModifyListener = new Listener(){

        public void handleEvent(Event e) {
            LogAnalyzerSamplePage.this.setPageComplete(LogAnalyzerSamplePage.this.validatePage());
        }
    };

    public String getErrorLogPath() {
        return this.errorLogFieldText.getText().trim();
    }

    public String getLogPath() {
        return this.logfileFieldText.getText().trim();
    }

    public String getSymptomDBFilePath() {
        if (this.useDBDefaults) {
            return this.symptomDBFieldText.getText().trim();
        }
        return "/" + this.getProjectName() + "/" + this.sdbFileNameText.getText().trim();
    }

    public LogAnalyzerSamplePage(CreationWizard creationWizard, String pageName, IConfigurationElement configurationElement, LogAnalyzerCreationPage firstPage) {
        super(creationWizard, pageName, configurationElement);
        this.initialLogFileValue = this.getValue(configurationElement, "name");
        this.initialSymptomDBValue = this.getValue(configurationElement, "name");
        this.initialErrorLogValue = this.getValue(configurationElement, "name");
        this.setInitialSymptomDB(this.initialSymptomDBValue);
        this.setInitialErrorLog(this.initialErrorLogValue);
        this.setInitialLogFile(this.initialLogFileValue);
        this.firstPage = firstPage;
    }

    public void handleEvent(Event e) {
        this.setLogFileForSelection();
        this.setSymptomDBForSelection();
        this.setErrorLogForSelection();
    }

    private void setLogFileForSelection() {
        if (this.useDefaults) {
            this.logfileFieldText.setText(this.getDefaultLogFileForName(this.getProjectFieldValue()));
        }
    }

    private void setSymptomDBForSelection() {
        if (this.useDBDefaults) {
            this.symptomDBFieldText.setText(this.getDefaultSymptomDBForName(this.getProjectFieldValue()));
        }
    }

    private void setErrorLogForSelection() {
        if (this.useErrorLogDefaults) {
            this.errorLogFieldText.setText(this.getDefaultErrorLogForName(this.getProjectFieldValue()));
        }
    }

    private String getProjectFieldValue() {
        if (this.firstPage == null) {
            return "";
        }
        String projectName = this.firstPage.getProjectName();
        if (projectName == null) {
            return "";
        }
        return projectName.trim();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createLogFileControls(composite);
        this.createErrorLogControls(composite);
        this.createSymptomDBControls(composite);
        this.createLogFileOptions(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.firstPage.getProjectText().addListener(24, (Listener)this);
    }

    private final void createLogFileOptions(Composite parent) {
        Font font = parent.getFont();
        Group logOptionGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        logOptionGroup.setLayout((Layout)layout);
        logOptionGroup.setLayoutData((Object)new GridData(768));
        logOptionGroup.setFont(font);
        logOptionGroup.setText(HyadesSamplePlugin.getString("OPTIONS"));
        this.analyzeLogButton = new Button((Composite)logOptionGroup, 131104);
        this.analyzeLogButton.setText(HyadesSamplePlugin.getString("ANALYZE_LOG_LABEL"));
        this.analyzeLogButton.setSelection(true);
        this.analyzeLogButton.setFont(font);
        this.correlateLogButton = new Button((Composite)logOptionGroup, 131104);
        this.correlateLogButton.setText(HyadesSamplePlugin.getString("CORRELATE_LOG_LABEL"));
        this.correlateLogButton.setSelection(true);
        this.correlateLogButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        this.analyzeLogButton.setLayoutData((Object)buttonData);
        buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        this.correlateLogButton.setLayoutData((Object)buttonData);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerSamplePage.this.analyzeLog = LogAnalyzerSamplePage.this.analyzeLogButton.getSelection();
            }
        };
        this.analyzeLogButton.addSelectionListener((SelectionListener)listener);
        SelectionAdapter correlateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerSamplePage.this.correlateLog = LogAnalyzerSamplePage.this.correlateLogButton.getSelection();
            }
        };
        this.correlateLogButton.addSelectionListener((SelectionListener)correlateListener);
    }

    private final void createLogFileControls(Composite parent) {
        Font font = parent.getFont();
        Group logFileGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        logFileGroup.setLayout((Layout)layout);
        logFileGroup.setLayoutData((Object)new GridData(768));
        logFileGroup.setFont(font);
        logFileGroup.setText(HyadesSamplePlugin.getString("LOG_FILE_LABEL"));
        final Button useDefaultsButton = new Button((Composite)logFileGroup, 131104);
        useDefaultsButton.setText(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup((Composite)logFileGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerSamplePage.this.useDefaults = useDefaultsButton.getSelection();
                LogAnalyzerSamplePage.this.browseButton.setEnabled(!LogAnalyzerSamplePage.this.useDefaults);
                LogAnalyzerSamplePage.this.logfileFieldText.setEnabled(!LogAnalyzerSamplePage.this.useDefaults);
                LogAnalyzerSamplePage.this.logfileLocationLabel.setEnabled(!LogAnalyzerSamplePage.this.useDefaults);
                if (LogAnalyzerSamplePage.this.useDefaults) {
                    LogAnalyzerSamplePage.this.customLocationFieldValue = LogAnalyzerSamplePage.this.logfileFieldText.getText();
                    LogAnalyzerSamplePage.this.setLogFileForSelection();
                } else {
                    LogAnalyzerSamplePage.this.logfileFieldText.setText(LogAnalyzerSamplePage.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createErrorLogControls(Composite parent) {
        Font font = parent.getFont();
        Group errorLogGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        errorLogGroup.setLayout((Layout)layout);
        errorLogGroup.setLayoutData((Object)new GridData(768));
        errorLogGroup.setFont(font);
        errorLogGroup.setText(HyadesSamplePlugin.getString("ERRORLOG_FILE_LABEL"));
        final Button useDefaultsButton = new Button((Composite)errorLogGroup, 131104);
        useDefaultsButton.setText(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useErrorLogDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedErrorLogLocationGroup((Composite)errorLogGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerSamplePage.this.useErrorLogDefaults = useDefaultsButton.getSelection();
                LogAnalyzerSamplePage.this.errorLogBrowseButton.setEnabled(!LogAnalyzerSamplePage.this.useErrorLogDefaults);
                LogAnalyzerSamplePage.this.errorLogFieldText.setEnabled(!LogAnalyzerSamplePage.this.useErrorLogDefaults);
                LogAnalyzerSamplePage.this.errorLogLocationLabel.setEnabled(!LogAnalyzerSamplePage.this.useErrorLogDefaults);
                if (LogAnalyzerSamplePage.this.useErrorLogDefaults) {
                    LogAnalyzerSamplePage.this.customErrorLogLocationFieldValue = LogAnalyzerSamplePage.this.errorLogFieldText.getText();
                    LogAnalyzerSamplePage.this.setErrorLogForSelection();
                } else {
                    LogAnalyzerSamplePage.this.errorLogFieldText.setText(LogAnalyzerSamplePage.this.customErrorLogLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createSymptomDBControls(Composite parent) {
        Font font = parent.getFont();
        Group symptomDBGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        symptomDBGroup.setLayout((Layout)layout);
        symptomDBGroup.setLayoutData((Object)new GridData(768));
        symptomDBGroup.setFont(font);
        symptomDBGroup.setText(HyadesSamplePlugin.getString("SYMPTOMDB_FILE_LABEL"));
        final Button useDefaultsButton = new Button((Composite)symptomDBGroup, 131104);
        useDefaultsButton.setText(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDBDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        this.importSDBFileLabel = new Label((Composite)symptomDBGroup, 0);
        this.importSDBFileLabel.setText(HyadesSamplePlugin.getString("IMPORT_SYMPTOM_DB"));
        this.importSDBFileLabel.setFont(font);
        this.importSDBFileLabel.setLayoutData((Object)labelData);
        if (this.useDefaults) {
            this.importSDBFileLabel.setVisible(false);
        }
        this.createUserSpecifiedSymptomDBLocationGroup((Composite)symptomDBGroup, !this.useDefaults);
        this.createSDBFileNameControls(parent);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerSamplePage.this.useDBDefaults = useDefaultsButton.getSelection();
                LogAnalyzerSamplePage.this.symptomDBBrowseButton.setEnabled(!LogAnalyzerSamplePage.this.useDBDefaults);
                LogAnalyzerSamplePage.this.symptomDBFieldText.setEnabled(!LogAnalyzerSamplePage.this.useDBDefaults);
                LogAnalyzerSamplePage.this.symptomDBLocationLabel.setEnabled(!LogAnalyzerSamplePage.this.useDBDefaults);
                LogAnalyzerSamplePage.this.importSDBFileLabel.setVisible(!LogAnalyzerSamplePage.this.useDBDefaults);
                if (LogAnalyzerSamplePage.this.useDBDefaults) {
                    LogAnalyzerSamplePage.this.customSymptomDBLocationFieldValue = LogAnalyzerSamplePage.this.symptomDBFieldText.getText();
                    LogAnalyzerSamplePage.this.setSymptomDBForSelection();
                } else {
                    LogAnalyzerSamplePage.this.symptomDBFieldText.setText(LogAnalyzerSamplePage.this.customSymptomDBLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.logfileLocationLabel = new Label(projectGroup, 0);
        this.logfileLocationLabel.setText(HyadesSamplePlugin.getString("LOG_FILE_TEXT_LABEL"));
        this.logfileLocationLabel.setEnabled(enabled);
        this.logfileLocationLabel.setFont(font);
        this.logfileFieldText = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.logfileFieldText.setLayoutData((Object)data);
        this.logfileFieldText.setEnabled(enabled);
        this.logfileFieldText.setFont(font);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LogAnalyzerSamplePage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.browseButton.setFont(font);
        this.setButtonLayoutData(this.browseButton);
        if (this.initialLogFileValue == null) {
            this.logfileFieldText.setText(Platform.getLocation().toOSString());
        } else {
            this.logfileFieldText.setText(this.initialLogFileValue);
        }
        this.logfileFieldText.addListener(24, this.logfileModifyListener);
    }

    private void createUserSpecifiedSymptomDBLocationGroup(Composite symptomDBGroup, boolean enabled) {
        Font font = symptomDBGroup.getFont();
        this.symptomDBLocationLabel = new Label(symptomDBGroup, 0);
        this.symptomDBLocationLabel.setText(HyadesSamplePlugin.getString("LOG_FILE_TEXT_LABEL"));
        this.symptomDBLocationLabel.setEnabled(enabled);
        this.symptomDBLocationLabel.setFont(font);
        this.symptomDBFieldText = new Text(symptomDBGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.symptomDBFieldText.setLayoutData((Object)data);
        this.symptomDBFieldText.setEnabled(enabled);
        this.symptomDBFieldText.setFont(font);
        this.symptomDBBrowseButton = new Button(symptomDBGroup, 8);
        this.symptomDBBrowseButton.setText(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.symptomDBBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LogAnalyzerSamplePage.this.handleSymptomDBLocationBrowseButtonPressed();
            }
        });
        this.symptomDBBrowseButton.setEnabled(enabled);
        this.symptomDBBrowseButton.setFont(font);
        this.setButtonLayoutData(this.symptomDBBrowseButton);
        if (this.initialSymptomDBValue == null) {
            this.symptomDBFieldText.setText(Platform.getLocation().toOSString());
        } else {
            this.symptomDBFieldText.setText(this.initialSymptomDBValue);
        }
        this.symptomDBFieldText.addListener(24, this.logfileModifyListener);
    }

    private final void createSDBFileNameControls(Composite parent) {
        this.sdbFileNameText = new Text(parent, 2048);
        int i = this.initialSymptomDBValue.lastIndexOf("/") + 1;
        this.sdbFileNameText.setText(this.initialSymptomDBValue.substring(i, this.initialSymptomDBValue.length()));
        this.sdbFileNameText.setVisible(false);
    }

    private void createUserSpecifiedErrorLogLocationGroup(Composite errorLogGroup, boolean enabled) {
        Font font = errorLogGroup.getFont();
        this.errorLogLocationLabel = new Label(errorLogGroup, 0);
        this.errorLogLocationLabel.setText(HyadesSamplePlugin.getString("LOG_FILE_TEXT_LABEL"));
        this.errorLogLocationLabel.setEnabled(enabled);
        this.errorLogLocationLabel.setFont(font);
        this.errorLogFieldText = new Text(errorLogGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.errorLogFieldText.setLayoutData((Object)data);
        this.errorLogFieldText.setEnabled(enabled);
        this.errorLogFieldText.setFont(font);
        this.errorLogBrowseButton = new Button(errorLogGroup, 8);
        this.errorLogBrowseButton.setText(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.errorLogBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LogAnalyzerSamplePage.this.handleErrorLogLocationBrowseButtonPressed();
            }
        });
        this.errorLogBrowseButton.setEnabled(enabled);
        this.errorLogBrowseButton.setFont(font);
        this.setButtonLayoutData(this.errorLogBrowseButton);
        if (this.initialErrorLogValue == null) {
            this.errorLogFieldText.setText(Platform.getLocation().toOSString());
        } else {
            this.errorLogFieldText.setText(this.initialErrorLogValue);
        }
        this.errorLogFieldText.addListener(24, this.logfileModifyListener);
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedFile;
        File path;
        FileDialog dialog = new FileDialog(this.logfileFieldText.getShell());
        dialog.setFileName(this.logfileFieldText.getText());
        String dirName = this.getProjectFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.customLocationFieldValue = selectedFile;
            this.logfileFieldText.setText(this.customLocationFieldValue);
        }
    }

    private void handleErrorLogLocationBrowseButtonPressed() {
        String selectedFile;
        File path;
        FileDialog dialog = new FileDialog(this.errorLogFieldText.getShell());
        dialog.setFileName(this.errorLogFieldText.getText());
        String dirName = this.getProjectFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.customErrorLogLocationFieldValue = selectedFile;
            this.errorLogFieldText.setText(this.customErrorLogLocationFieldValue);
        }
    }

    private void handleSymptomDBLocationBrowseButtonPressed() {
        String selectedFile;
        File path;
        FileDialog dialog = new FileDialog(this.symptomDBFieldText.getShell());
        dialog.setFileName(this.symptomDBFieldText.getText());
        String dirName = this.getProjectFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.customSymptomDBLocationFieldValue = selectedFile;
            this.symptomDBFieldText.setText(this.customSymptomDBLocationFieldValue);
        }
    }

    public void setInitialLogFile(String name) {
        if (name == null) {
            this.initialLogFileValue = null;
        } else {
            this.initialLogFileValue = name.trim();
            this.initialLogFileValue = this.getDefaultLogFileForName(this.initialLogFileValue);
        }
    }

    public void setAccessLog(String name) {
        String temp = name + File.separator + APACHE_DEFAULT_LOG_FILE;
        if (this.logfileFieldText != null) {
            this.logfileFieldText.setText(new Path(temp).toString());
        }
    }

    public void setInitialErrorLog(String name) {
        if (name == null) {
            this.initialErrorLogValue = null;
        } else {
            this.initialErrorLogValue = name.trim();
            this.initialErrorLogValue = this.getDefaultErrorLogForName(this.initialErrorLogValue);
        }
    }

    public void setErrorLog(String name) {
        String temp = name + File.separator + APACHE_DEFAULT_ERROR_LOG_FILE;
        if (this.errorLogFieldText != null) {
            this.errorLogFieldText.setText(new Path(temp).toString());
        }
    }

    public void setInitialSymptomDB(String name) {
        if (name == null) {
            this.initialSymptomDBValue = null;
        } else {
            this.initialSymptomDBValue = name.trim();
            this.initialSymptomDBValue = this.getDefaultSymptomDBForName(this.initialSymptomDBValue);
        }
    }

    private String getDefaultLogFileForName(String nameValue) {
        IPath defaultPath = Platform.getLocation().append(nameValue);
        return defaultPath.toOSString() + File.separator + APACHE_DEFAULT_LOG_FILE;
    }

    private String getDefaultSymptomDBForName(String nameValue) {
        IPath defaultPath = Platform.getLocation().append(nameValue);
        String projectVal = this.getProjectFieldValue();
        if (projectVal.equals("")) {
            projectVal = nameValue;
        }
        return "/" + projectVal + "/" + APACHE_DEFAULT_SYMPTOMDB_FILE;
    }

    private String getDefaultErrorLogForName(String nameValue) {
        IPath defaultPath = Platform.getLocation().append(nameValue);
        return defaultPath.toOSString() + File.separator + APACHE_DEFAULT_ERROR_LOG_FILE;
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
    }

    private String getValue(IConfigurationElement configurationElement, String attribute) {
        String value = configurationElement.getAttribute(attribute);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected boolean validatePage() {
        File sfile;
        String errorLogFieldString;
        File file;
        String logFieldText = this.logfileFieldText.getText().trim();
        if (logFieldText.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(HyadesSamplePlugin.getString("_ERROR_LOG_FILE_IS_EMPTY"));
            return false;
        }
        if (!this.useDefaults && !(file = new File(logFieldText)).isFile()) {
            this.setErrorMessage(HyadesSamplePlugin.getString("_ERROR_LOG_FILE_IS_INVALID"));
            return false;
        }
        String symptomDBFieldString = this.symptomDBFieldText.getText().trim();
        if (symptomDBFieldString.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(HyadesSamplePlugin.getString("_ERROR_SYMPTOMDB_IS_EMPTY"));
            return false;
        }
        if (!this.useDBDefaults) {
            if (!symptomDBFieldString.endsWith(".xml")) {
                this.setErrorMessage(null);
                this.setMessage(HyadesSamplePlugin.getString("_ERROR_ERRORSDB_FILE_IS_INVALID"));
                return false;
            }
            File sfile2 = new File(symptomDBFieldString);
            if (!sfile2.isFile()) {
                this.setErrorMessage(HyadesSamplePlugin.getString("_ERROR_SYMPTOMDB_IS_INVALID"));
                return false;
            }
        }
        if ((errorLogFieldString = this.errorLogFieldText.getText().trim()).equals("")) {
            this.setErrorMessage(null);
            this.setMessage(HyadesSamplePlugin.getString("_ERROR_ERRORLOG_FILE_IS_EMPTY"));
            return false;
        }
        if (!this.useErrorLogDefaults && !(sfile = new File(errorLogFieldString)).isFile()) {
            this.setErrorMessage(HyadesSamplePlugin.getString("_ERROR_ERRORLOG_FILE_IS_INVALID"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public Button getAnalyzeLogButton() {
        return this.analyzeLogButton;
    }

    public Button getCorrelateLogButton() {
        return this.correlateLogButton;
    }

    public String getProjectName() {
        return this.firstPage.getProjectName();
    }

    public String getInitialProjectName() {
        return this.firstPage.getProjectName();
    }

    public String getSDBFileName() {
        if (this.useDBDefaults) {
            return "";
        }
        return this.symptomDBFieldText.getText().trim();
    }
}

