/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestGenerator;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;


/**
 * wizard which prompts the user for the test generator to use with test generation and also prompts for the location of the generated
 * test suite.
 * @author Ernest Jessee
 */
public class RunTestGenWizard extends HyadesNewWizard
implements INewWizard, IRunnableWithProgress
{
	private TestSuiteLocationSelectionPage testFileSelectionPage;

	private TestGeneratorSelectorPage generatorSelectorPage;

	private IFile selectedRecModelFile;
	
	public RunTestGenWizard(IFile recModelFile)
	{
		super();
		this.selectedRecModelFile = recModelFile;
	}

	public void run(IProgressMonitor monitor)
		throws InvocationTargetException, InterruptedException
	{
			
				
	}
	
	protected boolean createObject(IFile file) throws Exception
	{
		return false;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		saveSettings();
		String generatorID = generatorSelectorPage.getSelectedGeneratorID();
				
		IConfigurationElement generatorElement = TestGeneratorFactory.getInstance().getGeneratorConfigElement(generatorID);
		if(generatorElement == null)	
		{
			System.out.println(TestgenPlugin.getResourceString("RunTestGenWizard.UNABLE_TO_LOAD_SELECTED_GENERATOR_ERROR_MSG")); //$NON-NLS-1$
			return false;
		}
		String tsName = testFileSelectionPage.getSelectedFilePath();
		IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(tsName));
		if(file.exists())
		{
			boolean b = MessageDialog.openConfirm(getWorkbench().getActiveWorkbenchWindow().getShell(), 
					TestgenPlugin.getResourceString("RunTestGenWizard.TESTSUITE_EXISTS_TITLE"),
					TestgenPlugin.getResourceString("RunTestGenWizard.TESTSUITE_EXISTS")
					);
			if (!b)
				return b;
		}
		
		try
		{
			TestGenerator testgenerator = (TestGenerator)generatorElement.createExecutableExtension("class"); //$NON-NLS-1$
			testgenerator.initialize(selectedRecModelFile,testFileSelectionPage.getSelectedFilePath());
			Display.getDefault().asyncExec(testgenerator);
			return true;
		}
		catch (CoreException e)
		{
			e.printStackTrace();
			return false;
		} 
		
	}
	
	private void saveSettings()
	{
		IWizardPage pages[] = getPages();
		for(int i=0; i<pages.length; i++)
		{
			((ITestGenWizardPage)pages[i]).saveSettings();
		}
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		addPage(generatorSelectorPage = new TestGeneratorSelectorPage());
		
		addPage(testFileSelectionPage = new TestSuiteLocationSelectionPage());
				
	}

	

	/**
	 * @see org.eclipse.jface.wizard.IWizard#dispose()
	 */
	public void dispose()
	{
		
	}

}
