/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.impl.TraceFactoryImpl;
/**
 * @author amathur
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TestGenFileUtil {
	
	public static IFile createTraceFile(String filepath) {
		
		String recFilePath = filepath;
		byte[] b = new byte[1];
		IFile file = null;
		try {
			if (!recFilePath.endsWith(".rec")) { //$NON-NLS-1$
				recFilePath += ".rec"; //$NON-NLS-1$
			}
			
			file =
				ResourcesPlugin.getWorkspace().getRoot().getFile(
					new Path(recFilePath));
			if (!file.exists()) {
				try {
					file.create(new ByteArrayInputStream(new byte[] {}), true, new NullProgressMonitor());
				}
				catch (CoreException e1) {
					e1.printStackTrace();
				}
			}
		}
		catch (RuntimeException e) {
			e.printStackTrace();
		}

		return file;
	}
	
	public static IFile createTraceModel(String recModelPath, String recFilePath) {
		Map RESOURCE_OPTIONS = new HashMap();
		RESOURCE_OPTIONS.put(XMIResource.OPTION_DECLARE_XML, Boolean.TRUE);
		RESOURCE_OPTIONS.put(XMIResource.OPTION_SKIP_ESCAPE, Boolean.FALSE);
		RESOURCE_OPTIONS.put(XMIResource.OPTION_ENCODING, "UTF-8");
		TRCSourceInfo si = TraceFactoryImpl.eINSTANCE.createTRCSourceInfo();
		//URI testSuiteURI = EcoreUtil.getURI(tpfSuite);
		//URI uri = tpfSuite.eResource().getURI().trimFileExtension();
		
		if (recModelPath.endsWith(".rec")) { //$NON-NLS-1$
			recModelPath += "model"; //$NON-NLS-1$
		}
		else if (!recModelPath.endsWith(".recmodel")) { //$NON-NLS-1$
			recModelPath += ".recmodel"; //$NON-NLS-1$
		}
		

		URI modelURI = URI.createPlatformResourceURI(recModelPath);
		si.setLocation(recFilePath);
		ResourceSet rs = new ResourceSetImpl();
		Resource resource = rs.createResource(modelURI);
		resource.getContents().add(si);
		try {
			resource.save(RESOURCE_OPTIONS);
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		
		return ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recModelPath));

		
	}
	public static EObject[] loadResource(IFile file) {
		// Create a resource set before loading anything
		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource =
			resourceSet.getResource(
				URI.createPlatformResourceURI(file.getFullPath().toString()),
				true);
		if (resource == null) {
			System.out.println(TestgenPlugin.getResourceString("TestGenFileUtil.FAILED_TO_GET_RESOURCE_ERROR_MESSAGE")); //$NON-NLS-1$
			return null;
		}
		// Retrieve an array of root elements in this file. In this case, there is really only 
		// one TRCSourceInfo element.
		EObject[] elements =
			(EObject[]) resource.getContents().toArray(
				new EObject[resource.getContents().size()]);
		return elements;
	}
	/**
	 * @param file
	 */
	public static IFile getTraceFile(IFile file) {
		EObject[] elements = TestGenFileUtil.loadResource(file);
		TRCSourceInfo tsi = (TRCSourceInfo) elements[0];
		// Get the location attribute
		String location = tsi.getLocation();
		System.out.println(TestgenPlugin.getResourceString("TestGenFileUtil.TRACE_FILE_LOCATION_STATUS_MESSAGE") + location); //$NON-NLS-1$
		// Find and open the trace file
		IFile traceFile =
			(IFile) ResourcesPlugin.getWorkspace().getRoot().findMember(
				location);
		return traceFile;
	}
	
}
